/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.jgoodies.forms.layout.CellConstraints;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.crm.CrmActivityField;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class CrmActivityRelationPanel
extends AbstractPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmActivityRelationPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmActivityRelationPanel.class);
    private long currentActivityId = 0L;
    private JXTitledSeparator formTitle;
    private JLabel activityLabel;
    private CrmActivityField activityField;
    private JPanel activityFieldPanel;
    private JComboBox<DbCrmActivity.Type> activityTypeField;
    private JLabel notesLabel;
    private DefaultTextArea notesField;

    public CrmActivityRelationPanel(boolean bl) {
        this.build(bl);
    }

    private void build(boolean bl) {
        this.activityLabel = new JLabel();
        this.activityField = new CrmActivityField();
        this.activityFieldPanel = new JPanel(new BorderLayout());
        this.activityFieldPanel.add((Component)((Object)this.activityField), "Center");
        this.activityTypeField = new JComboBox();
        this.activityTypeField.setRenderer((ListCellRenderer<DbCrmActivity.Type>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
        this.activityTypeField.addItem(null);
        for (DbCrmActivity.Type type : DbCrmActivity.Type.values()) {
            this.activityTypeField.addItem(type);
        }
        this.activityTypeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CrmActivityRelationPanel.this.activityTypeField.isEnabled()) {
                    return;
                }
                DbCrmActivity.Type type = (DbCrmActivity.Type)((Object)CrmActivityRelationPanel.this.activityTypeField.getSelectedItem());
                DbCrmActivity dbCrmActivity = CrmActivityRelationPanel.this.activityField.getCrmActivity();
                if (type == null) {
                    CrmActivityRelationPanel.this.activityField.setCrmActivity(null);
                    CrmActivityRelationPanel.this.activityField.setCrmActivityType(null);
                    CrmActivityRelationPanel.this.activityField.setEnabled(false);
                } else {
                    if (dbCrmActivity != null && dbCrmActivity.type != type) {
                        CrmActivityRelationPanel.this.activityField.setCrmActivity(null);
                    }
                    CrmActivityRelationPanel.this.activityField.setCrmActivityType(type);
                    CrmActivityRelationPanel.this.activityField.setEnabled(true);
                }
            }
        });
        this.notesLabel = null;
        this.notesField = null;
        Object object = null;
        if (bl) {
            this.notesLabel = new JLabel();
            this.notesField = new DefaultTextArea();
            object = this.notesField.createScrollPane();
            ((JComponent)object).setPreferredSize(new Dimension(100, 100));
        }
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.formTitle, (Action[])new Action[]{new RelationSubmitAction(), new RelationCloseAction()});
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, pref, 3dlu, 30dlu:grow", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.activityLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.activityTypeField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.activityFieldPanel).xy(5, defaultFormBuilder.row());
        if (object != null) {
            defaultFormBuilder.add((Component)this.notesLabel).xy(1, defaultFormBuilder.nextRow(), CellConstraints.DEFAULT, CellConstraints.TOP);
            defaultFormBuilder.addRaw((Component)object).xyw(3, defaultFormBuilder.row(), 3);
        }
        this.updateLocalization();
    }

    protected abstract void close();

    private void doRelationClose() {
        this.unselectRelation();
        this.close();
    }

    private void doRelationSubmit() {
        String string;
        DbCrmActivity dbCrmActivity = this.activityField.getCrmActivity();
        String string2 = string = this.notesField != null ? this.notesField.getText().trim() : null;
        if (dbCrmActivity == null) {
            return;
        }
        if (this.submit(dbCrmActivity, string)) {
            this.unselectRelation();
        }
    }

    public long getCurrentCrmActivityId() {
        return this.currentActivityId;
    }

    public void selectEmptyRelation() {
        this.selectRelation(new DbCrmActivity(), null);
    }

    public void selectRelation(DbCrmActivity dbCrmActivity, String string) {
        if (dbCrmActivity == null) {
            this.setVisible(false);
            return;
        }
        this.currentActivityId = dbCrmActivity.id;
        if (this.notesField != null) {
            this.notesField.setText(StringUtils.trimToEmpty((String)string));
            this.notesField.setCaretPosition(0);
        }
        this.activityTypeField.setEnabled(false);
        this.activityTypeField.setSelectedItem(null);
        this.activityField.setEnabled(false);
        if (dbCrmActivity.type == null) {
            this.activityTypeField.setEnabled(true);
            this.activityField.setCrmActivityType(null);
            this.activityField.setCrmActivity(null);
        } else {
            this.activityTypeField.setSelectedItem((Object)dbCrmActivity.type);
            this.activityTypeField.setEnabled(true);
            this.activityField.setCrmActivityType(dbCrmActivity.type);
            this.activityField.setCrmActivity(dbCrmActivity);
            this.activityField.setCaretPosition(0);
            this.activityField.setEnabled(true);
        }
        this.updateLocalization();
        this.setVisible(true);
    }

    public abstract boolean submit(DbCrmActivity var1, String var2);

    public void unselectRelation() {
        this.selectRelation(null, null);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(this.currentActivityId > 0L ? StringUtils.capitalize((String)I18N.tr("edit assignment")) : StringUtils.capitalize((String)I18N.tr("add assignment")));
        this.activityLabel.setText(StringUtils.capitalize((String)I18N.tr("activity")) + ":");
        if (this.notesLabel != null) {
            this.notesLabel.setText(StringUtils.capitalize((String)I18N.tr("notes")) + ":");
        }
    }

    private class RelationSubmitAction
    extends AbstractI18nAction {
        private RelationSubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityRelationPanel.this.doRelationSubmit();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Submit assignment."));
        }
    }

    private class RelationCloseAction
    extends AbstractI18nAction {
        private RelationCloseAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityRelationPanel.this.doRelationClose();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close assignment."));
        }
    }
}

