/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.crm.CrmMarketingField;
import com.openindex.openestate.tool.crm.db.DbCrmMarketing;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingFeedback;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class CrmMarketingRelationPanel
extends AbstractPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmMarketingRelationPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmMarketingRelationPanel.class);
    private long currentMarketingId = 0L;
    private JXTitledSeparator formTitle;
    private JLabel marketingLabel;
    private CrmMarketingField marketingField;
    private JPanel marketingFieldPanel;
    private JLabel feedbackTimeLabel;
    private JSpinner feedbackTimeField;
    private JCheckBox feedbackPositiveField;

    public CrmMarketingRelationPanel() {
        this.build();
    }

    private void build() {
        this.marketingLabel = new JLabel();
        this.marketingField = new CrmMarketingField();
        this.marketingFieldPanel = new JPanel(new BorderLayout());
        this.marketingFieldPanel.add((Component)((Object)this.marketingField), "Center");
        this.feedbackTimeLabel = new JLabel();
        this.feedbackTimeField = new JSpinner(new SpinnerDateModel());
        this.feedbackTimeField.setEditor(new JSpinner.DateEditor(this.feedbackTimeField));
        this.feedbackTimeField.setValue(new Date());
        this.feedbackPositiveField = new JCheckBox();
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.formTitle, (Action[])new Action[]{new RelationSubmitAction(), new RelationCloseAction()});
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, pref, 3dlu, 30dlu:grow", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.marketingLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.marketingFieldPanel).xyw(3, defaultFormBuilder.row(), 3);
        defaultFormBuilder.add((Component)this.feedbackTimeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.feedbackTimeField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.feedbackPositiveField).xy(5, defaultFormBuilder.row());
        this.updateLocalization();
    }

    protected abstract void close();

    private void doRelationClose() {
        this.unselectRelation();
        this.close();
    }

    private void doRelationSubmit() {
        DbCrmMarketing dbCrmMarketing = this.marketingField.getCrmMarketing();
        if (dbCrmMarketing == null) {
            return;
        }
        DbCrmMarketingFeedback dbCrmMarketingFeedback = new DbCrmMarketingFeedback();
        dbCrmMarketingFeedback.marketingId = dbCrmMarketing.id;
        dbCrmMarketingFeedback.isPositive = this.feedbackPositiveField.isSelected();
        try {
            this.feedbackTimeField.commitEdit();
            dbCrmMarketingFeedback.time = (Date)this.feedbackTimeField.getValue();
        }
        catch (Exception exception) {
            dbCrmMarketingFeedback.time = new Date();
            LOGGER.warn("Can't read feedback time!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        if (this.submit(dbCrmMarketing, dbCrmMarketingFeedback)) {
            this.unselectRelation();
        }
    }

    public long getCurrentCrmMarketingId() {
        return this.currentMarketingId;
    }

    public void selectEmptyRelation() {
        this.selectRelation(new DbCrmMarketing(), null);
    }

    public void selectRelation(DbCrmMarketing dbCrmMarketing, DbCrmMarketingFeedback dbCrmMarketingFeedback) {
        if (dbCrmMarketing == null) {
            this.setVisible(false);
            return;
        }
        this.currentMarketingId = dbCrmMarketing.id;
        this.feedbackPositiveField.setSelected(dbCrmMarketingFeedback != null ? dbCrmMarketingFeedback.isPositive : true);
        this.feedbackTimeField.setValue(dbCrmMarketingFeedback != null && dbCrmMarketingFeedback.time != null ? dbCrmMarketingFeedback.time : new Date());
        this.marketingField.setEnabled(false);
        this.marketingField.setCrmMarketing(dbCrmMarketing);
        this.marketingField.setCaretPosition(0);
        this.marketingField.setEnabled(true);
        this.updateLocalization();
        this.setVisible(true);
    }

    public abstract boolean submit(DbCrmMarketing var1, DbCrmMarketingFeedback var2);

    public void unselectRelation() {
        this.selectRelation(null, null);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(this.currentMarketingId > 0L ? StringUtils.capitalize((String)I18N.tr("edit assignment")) : StringUtils.capitalize((String)I18N.tr("add assignment")));
        this.marketingLabel.setText(StringUtils.capitalize((String)I18N.tr("marketing action")) + ":");
        this.feedbackTimeLabel.setText(StringUtils.capitalize((String)I18N.tr("time")) + ":");
        this.feedbackPositiveField.setText(I18N.tr("Feedback is positive."));
    }

    private class RelationSubmitAction
    extends AbstractI18nAction {
        public RelationSubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmMarketingRelationPanel.this.doRelationSubmit();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Submit assignment."));
        }
    }

    private class RelationCloseAction
    extends AbstractI18nAction {
        public RelationCloseAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmMarketingRelationPanel.this.doRelationClose();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close assignment."));
        }
    }
}

