/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.mail.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.crm.addons.mail.db.DbCrmActivityMailMessage;
import com.openindex.openestate.tool.crm.addons.mail.db.DbCrmMailsHandlerImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbCrmMailsHandler
extends DbCrmMailsHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbCrmMailsHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbCrmMailsHandler.class);
    public static final String VIEW_CRM_ACTIVITIES_MAILS_MESSAGES = "view_immotool_crm_activities_mails_messages";
    public static final String PROC_REMOVE_CRM_ACTIVITIES_MAILS_MESSAGES = "remove_immotool_crm_activities_mails_messages";
    public static final String PROC_SAVE_CRM_ACTIVITIES_MAILS_MESSAGES = "save_immotool_crm_activities_mails_messages";
    private static final String FIELD_CRM_ACTIVITY_ID = "activity_id";
    private static final String FIELD_MAILS_MESSAGE_ID = "mails_message_id";

    private DbCrmActivityMailMessage createRelation(ResultSet resultSet) throws SQLException {
        DbCrmActivityMailMessage dbCrmActivityMailMessage = this.buildRelation();
        dbCrmActivityMailMessage.crmActivityId = resultSet.getLong(FIELD_CRM_ACTIVITY_ID);
        dbCrmActivityMailMessage.mailMessageId = resultSet.getLong(FIELD_MAILS_MESSAGE_ID);
        return dbCrmActivityMailMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbCrmActivityMailMessage[] getRelationsForActivity(Connection connection, long[] lArray) throws SQLException {
        DbCrmActivityMailMessage[] dbCrmActivityMailMessageArray;
        if (ArrayUtils.isEmpty((long[])lArray)) {
            return new DbCrmActivityMailMessage[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_activities_mails_messages WHERE activity_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ")ORDER BY " + FIELD_CRM_ACTIVITY_ID + " ASC, " + FIELD_MAILS_MESSAGE_ID + " ASC LIMIT " + lArray.length + ";");
            int n = 0;
            for (long l : lArray) {
                preparedStatement.setLong(++n, l);
            }
            resultSet = preparedStatement.executeQuery();
            Object object = new ArrayList();
            while (resultSet.next()) {
                object.add(this.createRelation(resultSet));
            }
            dbCrmActivityMailMessageArray = object.toArray(new DbCrmActivityMailMessage[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCrmActivityMailMessageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbCrmActivityMailMessage[] getRelationsForFolder(Connection connection, long[] lArray) throws SQLException {
        DbCrmActivityMailMessage[] dbCrmActivityMailMessageArray;
        if (ArrayUtils.isEmpty((long[])lArray)) {
            return new DbCrmActivityMailMessage[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_activities_mails_messages WHERE mails_message_id IN ( SELECT message_id FROM view_immotool_mails_messages WHERE folder_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ) ORDER BY " + FIELD_CRM_ACTIVITY_ID + " ASC, " + FIELD_MAILS_MESSAGE_ID + " ASC;");
            int n = 0;
            for (long l : lArray) {
                preparedStatement.setLong(++n, l);
            }
            resultSet = preparedStatement.executeQuery();
            Object object = new ArrayList();
            while (resultSet.next()) {
                object.add(this.createRelation(resultSet));
            }
            dbCrmActivityMailMessageArray = object.toArray(new DbCrmActivityMailMessage[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCrmActivityMailMessageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbCrmActivityMailMessage[] getRelationsForMessage(Connection connection, long[] lArray) throws SQLException {
        DbCrmActivityMailMessage[] dbCrmActivityMailMessageArray;
        if (ArrayUtils.isEmpty((long[])lArray)) {
            return new DbCrmActivityMailMessage[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_activities_mails_messages WHERE mails_message_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ")ORDER BY " + FIELD_CRM_ACTIVITY_ID + " ASC, " + FIELD_MAILS_MESSAGE_ID + " ASC LIMIT " + lArray.length + ";");
            int n = 0;
            for (long l : lArray) {
                preparedStatement.setLong(++n, l);
            }
            resultSet = preparedStatement.executeQuery();
            Object object = new ArrayList();
            while (resultSet.next()) {
                object.add(this.createRelation(resultSet));
            }
            dbCrmActivityMailMessageArray = object.toArray(new DbCrmActivityMailMessage[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCrmActivityMailMessageArray;
    }

    @Override
    public void removeRelations(Connection connection, DbCrmActivityMailMessage[] dbCrmActivityMailMessageArray) throws SQLException {
        if (dbCrmActivityMailMessageArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL remove_immotool_crm_activities_mails_messages(:activity_id, :mails_message_id);");
            for (DbCrmActivityMailMessage dbCrmActivityMailMessage : dbCrmActivityMailMessageArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_CRM_ACTIVITY_ID, dbCrmActivityMailMessage.crmActivityId);
                namedCallableStatement.setLong(FIELD_MAILS_MESSAGE_ID, dbCrmActivityMailMessage.mailMessageId);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveRelation(Connection connection, DbCrmActivityMailMessage dbCrmActivityMailMessage) throws SQLException {
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_crm_activities_mails_messages(:activity_id, :mails_message_id);");
            namedCallableStatement.setLong(FIELD_CRM_ACTIVITY_ID, dbCrmActivityMailMessage.crmActivityId);
            namedCallableStatement.setLong(FIELD_MAILS_MESSAGE_ID, dbCrmActivityMailMessage.mailMessageId);
            namedCallableStatement.execute();
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

