/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.crm.db.DbCrmActivityHandler;
import com.openindex.openestate.tool.crm.gui.ActivityRenderer;
import com.openindex.openestate.tool.gui.DefaultAutoCompleteField;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.Dimension;
import java.net.URL;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmActivityField
extends DefaultAutoCompleteField<DbCrmActivity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmActivityField.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmActivityField.class);
    private DbCrmActivity.Type activityType = null;

    public CrmActivityField() {
        this.setCustomValueAllowed(false);
        this.setMultipleSelectionAllowed(false);
        this.setAutoCompleteItemRenderer((ListCellRenderer)new DefaultListCellRenderer((Renderer)new ActivityRenderer("-")));
        this.setAutoCompleteHandler(new Handler());
        DbCrmActivity dbCrmActivity = new DbCrmActivity();
        dbCrmActivity.subject = "example activity";
        this.setCrmActivity(dbCrmActivity);
    }

    public DbCrmActivity getCrmActivity() {
        return (DbCrmActivity)this.getValue();
    }

    public DbCrmActivity.Type getCrmActivityType() {
        return this.activityType;
    }

    public void setCrmActivity(DbCrmActivity dbCrmActivity) {
        this.setValue(dbCrmActivity);
    }

    public void setCrmActivityType(DbCrmActivity.Type type) {
        this.activityType = type;
    }

    private final class Handler
    implements DefaultAutoCompleteField.AutoCompleteHandler<DbCrmActivity> {
        private Handler() {
        }

        public Dimension getOptionIconSize() {
            return new Dimension(16, 16);
        }

        public String getOptionText(DbCrmActivity dbCrmActivity) {
            if (dbCrmActivity instanceof DbCrmActivity) {
                return dbCrmActivity.print();
            }
            return "-";
        }

        public URL getOptionIconUrl(DbCrmActivity dbCrmActivity) {
            if (dbCrmActivity instanceof DbCrmActivity) {
                DbCrmActivity.Type type = dbCrmActivity.type;
                return type != null ? type.getImageURL(16) : CrmPlugin.getResourceImageURL("crm.png", 16);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<DbCrmActivity> search(String string) throws Exception {
            DbCrmActivityHandler dbCrmActivityHandler = CrmPlugin.getDbCrmExtension().getCrmActivityHandler();
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                DbCrmActivity[] dbCrmActivityArray = dbCrmActivityHandler.getActivitiesByKeyword(connection, string, CrmActivityField.this.getCrmActivityType(), 100);
                List<DbCrmActivity> list = Arrays.asList(dbCrmActivityArray);
                return list;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }
}

