/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.crm.CrmActivityViewPanel;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.crm.db.DbCrmActivityHandler;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import java.awt.Component;
import java.awt.Window;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmActivityViewTask
extends ImmoToolTask<CrmActivityViewPanel, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmActivityViewTask.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmActivityViewTask.class);
    private final long activityId;
    private final boolean selectCreatedTab;
    private final CrmActivityViewPanel viewTab;
    private final AbstractDbDriver dbDriver;

    public CrmActivityViewTask(AbstractDbDriver abstractDbDriver, long l) {
        this(abstractDbDriver, l, true);
    }

    public CrmActivityViewTask(AbstractDbDriver abstractDbDriver, long l, boolean bl) {
        super(I18N.tr("Loading activity {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.activityId = l;
        this.selectCreatedTab = bl;
        this.viewTab = null;
    }

    public CrmActivityViewTask(AbstractDbDriver abstractDbDriver, long l, CrmActivityViewPanel crmActivityViewPanel) {
        super(I18N.tr("Loading activity {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.activityId = l;
        this.selectCreatedTab = true;
        this.viewTab = crmActivityViewPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CrmActivityViewPanel doInBackground() throws Exception {
        Connection connection2;
        Object object;
        block8: {
            DbCrmActivityHandler dbCrmActivityHandler = CrmPlugin.getDbCrmExtension().getCrmActivityHandler();
            if (this.viewTab == null) {
                object = ImmoToolAppUtils.getTabs(CrmActivityViewPanel.class);
                for (AbstractMainTab abstractMainTab : object) {
                    CrmActivityViewPanel crmActivityViewPanel = (CrmActivityViewPanel)abstractMainTab;
                    if (this.activityId < 1L && crmActivityViewPanel.getCurrentActivityId() < 1L) {
                        if (!this.selectCreatedTab) return null;
                        ImmoToolAppUtils.selectTab((Component)((Object)crmActivityViewPanel));
                        return null;
                    }
                    if (this.activityId <= 0L || crmActivityViewPanel.getCurrentActivityId() != this.activityId) continue;
                    if (!this.selectCreatedTab) return null;
                    ImmoToolAppUtils.selectTab((Component)((Object)crmActivityViewPanel));
                    return null;
                }
            }
            if (this.activityId < 1L) {
                return this.viewTab != null ? this.viewTab : CrmActivityViewPanel.createTab();
            }
            Connection connection = null;
            try {
                connection2 = this.dbDriver.getConnection();
                DbCrmActivity dbCrmActivity = dbCrmActivityHandler.getActivity(connection2, this.activityId);
                if (dbCrmActivity == null) {
                    throw new Exception("Can't find activity #" + this.activityId + "!");
                }
                dbCrmActivityHandler.loadContactEntries(connection2, dbCrmActivity);
                if (this.viewTab == null) {
                    object = CrmActivityViewPanel.createTab(dbCrmActivity);
                    break block8;
                }
                object = this.viewTab;
                ((CrmActivityViewPanel)((Object)object)).setActivity(dbCrmActivity);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Connection)connection2);
        return object;
    }

    protected void failed(Throwable throwable) {
        super.failed(throwable);
        ImmoToolUtils.showMessageErrorDialog((String)"Can't load activity!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
    }

    protected void succeeded(CrmActivityViewPanel crmActivityViewPanel) {
        super.succeeded((Object)crmActivityViewPanel);
        if (crmActivityViewPanel != null) {
            ImmoToolAppUtils.showTab((AbstractMainTab)crmActivityViewPanel, (boolean)this.selectCreatedTab);
            crmActivityViewPanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
        }
    }
}

