/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntryViewPanel;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.crm.CrmMarketingRelationPanel;
import com.openindex.openestate.tool.crm.CrmMarketingTable;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.db.DbCrmMarketing;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingFeedback;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingHandler;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.BooleanRenderer;
import com.openindex.openestate.tool.gui.DateRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmContactsEntryMarketingsPanel
extends ContactsEntryViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmContactsEntryMarketingsPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmContactsEntryMarketingsPanel.class);
    private static final String RELATION_TABLE_ID = "CrmContactsEntryMarketingsPanel.RelationTable";
    private DbContactsEntry currentContactsEntry = null;
    private JXTitledSeparator marketingsTitle;
    private RelationTable marketingsTable;
    private RelationForm relationForm;
    private AbstractI18nAction relationAddAction;
    private AbstractI18nAction refreshAction;
    private AbstractI18nAction showActionsAction;

    public CrmContactsEntryMarketingsPanel() {
        this.build();
    }

    private void build() {
        this.marketingsTable = new RelationTable();
        this.marketingsTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.showActionsAction = new ShowActionsAction();
        this.relationAddAction = new RelationAddAction();
        this.refreshAction = new RefreshAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.marketingsTitle, (Action[])new Action[]{this.refreshAction, this.relationAddAction, this.showActionsAction});
        this.relationForm = new RelationForm();
        this.setLayout(new BorderLayout(5, 5));
        this.add(jPanel, "North");
        this.add(this.marketingsTable.createScrollPane(), "Center");
        this.add((Component)((Object)this.relationForm), "South");
        this.updateLocalization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        this.marketingsTable.setEnabled(false);
        this.marketingsTable.clearRows();
        ArrayList<DbCrmMarketing> arrayList = new ArrayList<DbCrmMarketing>();
        try {
            DbCrmMarketingHandler dbCrmMarketingHandler = CrmPlugin.getDbCrmExtension().getCrmMarketingHandler();
            DbCrmMarketing[] dbCrmMarketingArray = dbCrmMarketingHandler.getMarketingsForContact(connection, this.currentContactsEntry.id);
            dbCrmMarketingHandler.loadFeedbacks(connection, dbCrmMarketingArray);
            arrayList.addAll(Arrays.asList(dbCrmMarketingArray));
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList){
                final /* synthetic */ List val$marketingsList;
                {
                    this.val$marketingsList = list;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        long l = ((CrmContactsEntryMarketingsPanel)CrmContactsEntryMarketingsPanel.this).currentContactsEntry.id;
                        for (DbCrmMarketing dbCrmMarketing : this.val$marketingsList) {
                            DbCrmMarketingFeedback dbCrmMarketingFeedback = dbCrmMarketing.feedback.containsKey(l) ? dbCrmMarketing.feedback.get(((CrmContactsEntryMarketingsPanel)CrmContactsEntryMarketingsPanel.this).currentContactsEntry.id) : new DbCrmMarketingFeedback();
                            CrmContactsEntryMarketingsPanel.this.marketingsTable.addRow(new RelationTableRow(dbCrmMarketing, dbCrmMarketingFeedback));
                        }
                    }
                    finally {
                        CrmContactsEntryMarketingsPanel.this.marketingsTable.setEnabled(true);
                        CrmContactsEntryMarketingsPanel.this.updateTitle();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void doMarketingView() {
        int n = this.marketingsTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        long l = this.marketingsTable.getMarketingIdAt(this.marketingsTable.convertRowIndexToModel(n));
        new CrmPlugin.MarketingFormAction(l).actionPerformed(null);
    }

    private void doRefresh() {
        if (this.currentContactsEntry != null && this.currentContactsEntry.id > 0L) {
            try {
                this.load(this.currentContactsEntry);
                if (this.isLoadedInBackground()) {
                    ImmoToolUtils.executeTask((ImmoToolTask)new RefreshTask());
                }
            }
            catch (Exception exception) {
                LOGGER.error("Can't load address into panel!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    private void doRelationAdd() {
        this.relationForm.selectEmptyRelation();
    }

    private void doRelationRemove() {
        if (this.marketingsTable.removeSelectedRows()) {
            this.relationForm.unselectRelation();
            this.updateTitle();
        }
    }

    private void doShowActions(Component component, int n, int n2) {
        if (this.marketingsTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem((Action)((Object)new RelationRemoveAction())));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem((Action)((Object)new MarketingViewAction())));
        jPopupMenu.show(component, n, n2);
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("marketing actions"));
    }

    public boolean isLoadedInBackground() {
        return this.currentContactsEntry != null && this.currentContactsEntry.id > 0L;
    }

    public void load(DbContactsEntry dbContactsEntry) {
        this.currentContactsEntry = dbContactsEntry;
        this.relationForm.unselectRelation();
        this.marketingsTable.setEnabled(false);
        this.marketingsTable.clearRows();
        this.showActionsAction.setEnabled(false);
        this.updateTitle();
    }

    public void save(DbContactsEntry dbContactsEntry) {
    }

    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbContactsEntry dbContactsEntry) throws SQLException {
        DbCrmMarketingHandler dbCrmMarketingHandler = CrmPlugin.getDbCrmExtension().getCrmMarketingHandler();
        HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
        Object[] objectArray = dbCrmMarketingHandler.getMarketingsForContact(connection, this.currentContactsEntry.id);
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            dbCrmMarketingHandler.loadFeedbacks(connection, (DbCrmMarketing[])objectArray);
            for (Object object : objectArray) {
                hashMap.put(((DbCrmMarketing)object).id, object);
            }
        }
        Object[] objectArray2 = new ArrayList();
        for (int i = 0; i < this.marketingsTable.getRowCount(); ++i) {
            Object object;
            Long l = this.marketingsTable.getMarketingIdAt(i);
            object = (DbCrmMarketing)hashMap.get(l);
            DbCrmMarketingFeedback dbCrmMarketingFeedback = object == null ? new DbCrmMarketingFeedback() : (((DbCrmMarketing)object).feedback != null && ((DbCrmMarketing)object).feedback.containsKey(dbContactsEntry.id) ? ((DbCrmMarketing)object).feedback.get(dbContactsEntry.id) : new DbCrmMarketingFeedback());
            dbCrmMarketingFeedback.contactEntryId = dbContactsEntry.id;
            dbCrmMarketingFeedback.marketingId = l;
            dbCrmMarketingFeedback.isPositive = this.marketingsTable.isPositiveAt(i);
            dbCrmMarketingFeedback.time = this.marketingsTable.getTimeAt(i);
            dbCrmMarketingHandler.saveMarketingFeedback(connection, dbCrmMarketingFeedback);
            objectArray2.add(l);
        }
        for (Long l : hashMap.keySet()) {
            if (objectArray2.contains(l)) continue;
            dbCrmMarketingHandler.removeMarketingFeedback(connection, l, dbContactsEntry.id);
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.updateTitle();
    }

    private void updateTitle() {
        int n;
        String string = StringUtils.capitalize((String)I18N.tr("marketing actions for the address"));
        int n2 = n = this.marketingsTable != null ? this.marketingsTable.getRowCount() : 0;
        if (n > 0) {
            string = string + " / ";
            string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        this.marketingsTitle.setTitle(string);
    }

    private class ShowActionsAction
    extends AbstractI18nAction {
        private ShowActionsAction() {
            this.setSmallIcon(CrmPlugin.getResourceIcon("crm.png", 16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            CrmContactsEntryMarketingsPanel.this.doShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected assignments."));
        }
    }

    private class RelationRemoveAction
    extends AbstractI18nAction {
        private RelationRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmContactsEntryMarketingsPanel.this.doRelationRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove assignment")));
            this.setShortDescription(I18N.tr("Remove the selected assignments."));
        }
    }

    private class RelationAddAction
    extends AbstractI18nAction {
        private RelationAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmContactsEntryMarketingsPanel.this.doRelationAdd();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new assignment")));
            this.setShortDescription(I18N.tr("Add an assignment."));
        }
    }

    private class RefreshTask
    extends ImmoToolTask<Boolean, Void> {
        private RefreshTask() {
        }

        protected Boolean doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                CrmContactsEntryMarketingsPanel.this.doLoadInBackground(connection);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }

    private class RefreshAction
    extends AbstractI18nAction {
        private RefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmContactsEntryMarketingsPanel.this.doRefresh();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Reload assignments from database."));
        }
    }

    private class MarketingViewAction
    extends AbstractI18nAction {
        private MarketingViewAction() {
            this.setSmallIcon(CrmPlugin.getResourceIcon("crm.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmContactsEntryMarketingsPanel.this.doMarketingView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show activity")));
            this.setShortDescription(I18N.tr("Show details about the activity."));
        }
    }

    public static class RelationTableRow
    extends CrmMarketingTable.Row {
        private final DbCrmMarketingFeedback feedback;

        private RelationTableRow(DbCrmMarketing dbCrmMarketing, DbCrmMarketingFeedback dbCrmMarketingFeedback) {
            super(dbCrmMarketing);
            this.feedback = dbCrmMarketingFeedback;
        }

        public DbCrmMarketingFeedback getFeedback() {
            return this.feedback;
        }

        public Date getTime() {
            return this.feedback.time;
        }

        @Override
        public Object getValue(AbstractTable.Column column) {
            if (column instanceof RelationTableColumn) {
                return this.getValueForFeedback((RelationTableColumn)column);
            }
            return super.getValue(column);
        }

        public Object getValueForFeedback(RelationTableColumn relationTableColumn) {
            if (this.feedback == null) {
                return null;
            }
            switch (relationTableColumn) {
                case FEEDBACK_POSITIVE: {
                    return this.feedback.isPositive;
                }
                case FEEDBACK_TIME: {
                    return this.feedback.time;
                }
            }
            return null;
        }

        public boolean isPositive() {
            return this.feedback.isPositive;
        }
    }

    public static enum RelationTableColumn implements AbstractTable.Column
    {
        FEEDBACK_TIME,
        FEEDBACK_POSITIVE;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case FEEDBACK_TIME: {
                    return new DefaultTableCellRenderer((Renderer)new DateRenderer(DateFormat.getDateTimeInstance(2, 3)));
                }
                case FEEDBACK_POSITIVE: {
                    return new DefaultTableCellRenderer((Renderer)new BooleanRenderer());
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case FEEDBACK_TIME: {
                    return Date.class;
                }
                case FEEDBACK_POSITIVE: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case FEEDBACK_TIME: {
                    return StringUtils.capitalize((String)I18N.tr("time"));
                }
                case FEEDBACK_POSITIVE: {
                    return I18N.tr("positive");
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }

    private final class RelationTable
    extends CrmMarketingTable<RelationTableRow> {
        private RelationTable() {
            super(CrmContactsEntryMarketingsPanel.RELATION_TABLE_ID);
        }

        protected void doRemove() {
            CrmContactsEntryMarketingsPanel.this.doRelationRemove();
        }

        protected void doSelect() {
            CrmContactsEntryMarketingsPanel.this.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
            if (this.getSelectedRowCount() < 1) {
                CrmContactsEntryMarketingsPanel.this.relationForm.unselectRelation();
            } else {
                int n = this.convertRowIndexToModel(this.getSelectedRow());
                DbCrmMarketingFeedback dbCrmMarketingFeedback = new DbCrmMarketingFeedback();
                dbCrmMarketingFeedback.contactEntryId = CrmContactsEntryMarketingsPanel.this.currentContactsEntry != null ? ((CrmContactsEntryMarketingsPanel)CrmContactsEntryMarketingsPanel.this).currentContactsEntry.id : 0L;
                dbCrmMarketingFeedback.marketingId = CrmContactsEntryMarketingsPanel.this.marketingsTable.getMarketingIdAt(n);
                dbCrmMarketingFeedback.isPositive = CrmContactsEntryMarketingsPanel.this.marketingsTable.isPositiveAt(n);
                dbCrmMarketingFeedback.time = CrmContactsEntryMarketingsPanel.this.marketingsTable.getTimeAt(n);
                CrmContactsEntryMarketingsPanel.this.relationForm.selectRelation(this.getMarketingAt(n), dbCrmMarketingFeedback);
            }
        }

        protected void doShowActions(int n, int n2) {
            CrmContactsEntryMarketingsPanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            CrmContactsEntryMarketingsPanel.this.doMarketingView();
        }

        public DbCrmMarketingFeedback getFeedbackAt(int n) {
            RelationTableRow relationTableRow = (RelationTableRow)this.getRow(n);
            return relationTableRow != null ? relationTableRow.getFeedback() : null;
        }

        public Date getTimeAt(int n) {
            DbCrmMarketingFeedback dbCrmMarketingFeedback = this.getFeedbackAt(n);
            return dbCrmMarketingFeedback != null ? dbCrmMarketingFeedback.time : null;
        }

        public boolean isPositiveAt(int n) {
            DbCrmMarketingFeedback dbCrmMarketingFeedback = this.getFeedbackAt(n);
            return dbCrmMarketingFeedback != null && dbCrmMarketingFeedback.isPositive;
        }

        @Override
        protected List<AbstractTable.Column> listColumns() {
            ArrayList<AbstractTable.Column> arrayList = new ArrayList<AbstractTable.Column>();
            arrayList.add(RelationTableColumn.FEEDBACK_TIME);
            arrayList.addAll(super.listColumns());
            for (RelationTableColumn relationTableColumn : RelationTableColumn.values()) {
                if (arrayList.contains((Object)relationTableColumn)) continue;
                arrayList.add(relationTableColumn);
            }
            return arrayList;
        }
    }

    private class RelationForm
    extends CrmMarketingRelationPanel {
        private RelationForm() {
        }

        @Override
        protected void close() {
            if (CrmContactsEntryMarketingsPanel.this.marketingsTable.getSelectedRowCount() > 0) {
                CrmContactsEntryMarketingsPanel.this.marketingsTable.clearSelection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean submit(DbCrmMarketing dbCrmMarketing, DbCrmMarketingFeedback dbCrmMarketingFeedback) {
            if (dbCrmMarketing == null) {
                return false;
            }
            CrmContactsEntryMarketingsPanel.this.marketingsTable.setEnabled(false);
            try {
                if (this.getCurrentCrmMarketingId() < 1L) {
                    CrmContactsEntryMarketingsPanel.this.marketingsTable.addRow(new RelationTableRow(dbCrmMarketing, dbCrmMarketingFeedback));
                } else {
                    int n = CrmContactsEntryMarketingsPanel.this.marketingsTable.getSelectedRow();
                    if (n >= 0) {
                        int n2 = CrmContactsEntryMarketingsPanel.this.marketingsTable.convertRowIndexToModel(n);
                        CrmContactsEntryMarketingsPanel.this.marketingsTable.setRowAt(n2, new RelationTableRow(dbCrmMarketing, dbCrmMarketingFeedback));
                    }
                }
            }
            finally {
                CrmContactsEntryMarketingsPanel.this.marketingsTable.clearSelection();
                CrmContactsEntryMarketingsPanel.this.marketingsTable.setEnabled(true);
                CrmContactsEntryMarketingsPanel.this.updateTitle();
            }
            return true;
        }
    }
}

