/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.openindex.openestate.tool.crm.db.DbCrmMarketing;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DateRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.FormattedDate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.SortOrder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmMarketingTable<R extends Row>
extends AbstractTable<R, AbstractTable.Model<R>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmMarketingTable.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmMarketingTable.class);

    public CrmMarketingTable(String string) {
        super(string);
    }

    public CrmMarketingTable(String string, AbstractTable.Model<R> model) {
        super(string, model);
    }

    public DbCrmMarketing getMarketingAt(int n) {
        Row row = (Row)this.getRow(n);
        return row != null ? row.getMarketing() : null;
    }

    public Long getMarketingIdAt(int n) {
        DbCrmMarketing dbCrmMarketing = this.getMarketingAt(n);
        return dbCrmMarketing != null ? dbCrmMarketing.id : 0L;
    }

    public int getRowForMarketingId(long l) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Long l2 = this.getMarketingIdAt(i);
            if (l != l2) continue;
            return i;
        }
        return -1;
    }

    protected void init() {
        this.setSortable(true);
        this.setColumnControlVisible(true);
        this.setMultipleIntervalSelection();
        super.init();
        this.getColumn(Column.ID).setMaxWidth(75);
        this.setSortOrder((Object)Column.BEGIN, SortOrder.DESCENDING);
    }

    protected List<AbstractTable.Column> listColumns() {
        return new ArrayList<AbstractTable.Column>(Arrays.asList(Column.values()));
    }

    public static class Row
    extends AbstractTable.Row {
        private final DbCrmMarketing marketing;

        public Row(DbCrmMarketing dbCrmMarketing) {
            this.marketing = dbCrmMarketing;
        }

        public DbCrmMarketing getMarketing() {
            return this.marketing;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof Column) {
                return this.getValueForMarketing((Column)column);
            }
            return null;
        }

        public Object getValueForMarketing(Column column) {
            if (this.marketing == null) {
                return null;
            }
            switch (column) {
                case ID: {
                    return this.marketing.id;
                }
                case TITLE: {
                    return StringUtils.trimToEmpty((String)this.marketing.title);
                }
                case INTERVAL: {
                    return this.marketing.interval;
                }
                case STATUS: {
                    return this.marketing.status;
                }
                case BEGIN: {
                    return this.marketing.begin != null ? FormattedDate.createDateTimeInstance((Date)this.marketing.begin, (int)3, (int)3) : null;
                }
                case END: {
                    return this.marketing.end != null ? FormattedDate.createDateTimeInstance((Date)this.marketing.end, (int)3, (int)3) : null;
                }
            }
            return null;
        }
    }

    public static enum Column implements AbstractTable.Column
    {
        ID,
        TITLE,
        BEGIN,
        END,
        INTERVAL,
        STATUS;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case BEGIN: 
                case END: {
                    return new DefaultTableCellRenderer((Renderer)new DateRenderer(DateFormat.getDateInstance(2)));
                }
                case INTERVAL: {
                    return new DefaultTableCellRenderer((Renderer)new TranslatableRenderer());
                }
                case STATUS: {
                    return new DefaultTableCellRenderer((Renderer)new TranslatableRenderer());
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ID: {
                    return Long.class;
                }
                case TITLE: {
                    return String.class;
                }
                case BEGIN: 
                case END: {
                    return Date.class;
                }
                case INTERVAL: {
                    return DbCrmMarketing.Interval.class;
                }
                case STATUS: {
                    return DbCrmMarketing.Status.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ID: {
                    return StringUtils.capitalize((String)I18N.tr("ID"));
                }
                case TITLE: {
                    return StringUtils.capitalize((String)I18N.tr("title"));
                }
                case BEGIN: {
                    return StringUtils.capitalize((String)I18N.tr("begin"));
                }
                case END: {
                    return StringUtils.capitalize((String)I18N.tr("end"));
                }
                case INTERVAL: {
                    return StringUtils.capitalize((String)I18N.tr("interval"));
                }
                case STATUS: {
                    return StringUtils.capitalize((String)I18N.tr("status"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                case ID: {
                    return false;
                }
            }
            return true;
        }
    }
}

