/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolFrame;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolProjectPlugin;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.crm.CrmActivityTablePanel;
import com.openindex.openestate.tool.crm.CrmActivityViewPanel;
import com.openindex.openestate.tool.crm.CrmActivityViewTask;
import com.openindex.openestate.tool.crm.CrmFrameSidebarExtension;
import com.openindex.openestate.tool.crm.CrmMarketingTablePanel;
import com.openindex.openestate.tool.crm.CrmMarketingViewPanel;
import com.openindex.openestate.tool.crm.CrmMarketingViewTask;
import com.openindex.openestate.tool.crm.CrmPermission;
import com.openindex.openestate.tool.crm.CrmPluginUtils;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingHandler;
import com.openindex.openestate.tool.crm.extensions.DbCrmExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUpdateHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.utils.ProjectPermission;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class CrmPlugin
extends ImmoToolProjectPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmPlugin.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmPlugin.class);
    public static final String ID = "OpenEstate-Tool-CRM";
    public static final String RESOURCE_PATH = "/com/openindex/openestate/tool/crm/resources/";
    private static DbCrmExtension dbCrmExtension = null;

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public static DbCrmExtension getDbCrmExtension() {
        return dbCrmExtension;
    }

    public String getDescription() {
        return I18N.tr("Management of activities and customer relations.");
    }

    public ImageIcon getIcon() {
        return new ImageIcon(CrmPlugin.getResourceImage("crm.png", 32));
    }

    public String getId() {
        return ID;
    }

    public static CrmPlugin getInstance() {
        return (CrmPlugin)ImmoToolEnvironment.getPlugin((String)ID);
    }

    public String getLicense() {
        return "Freeware";
    }

    public ProjectPermission[] getPermissions() {
        return CrmPermission.values();
    }

    public String[] getRequiredProcedures() {
        return dbCrmExtension != null ? dbCrmExtension.getRequiredProcedures() : null;
    }

    public String[] getRequiredViews() {
        return dbCrmExtension != null ? dbCrmExtension.getRequiredViews() : null;
    }

    public static Icon getResourceIcon(String string, int n) {
        return ImmoToolUtils.getResourceIcon((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)CrmPlugin.class.getClassLoader());
    }

    public static Image getResourceImage(String string, int n) {
        return ImmoToolUtils.getResourceImage((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)CrmPlugin.class.getClassLoader());
    }

    public static URL getResourceImageURL(String string, int n) {
        return ImmoToolUtils.getResourceImageURL((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)CrmPlugin.class.getClassLoader());
    }

    public String getTitle() {
        return I18N.tr("CRM");
    }

    public String getUninstallQuery(String string) throws IOException {
        DbCrmExtension dbCrmExtension = CrmPluginUtils.getDbCrmExtension(string);
        if (dbCrmExtension == null) {
            throw new IOException("Can't find a DbCrmExtension for driver '" + string + "'!");
        }
        return dbCrmExtension.getUninstallQuery();
    }

    public DbUpdateHandler getUpdateHandler(String string) {
        DbCrmExtension dbCrmExtension = CrmPluginUtils.getDbCrmExtension(string);
        if (dbCrmExtension == null) {
            LOGGER.warn("Can't find a DbCrmExtension for driver '" + string + "'!");
            return null;
        }
        return dbCrmExtension.getUpdateHandler();
    }

    public void install(Connection connection, DbExtension dbExtension, String string, boolean bl) throws SQLException, IOException {
        DbCrmExtension dbCrmExtension = CrmPluginUtils.getDbCrmExtension(string);
        if (dbCrmExtension == null) {
            throw new SQLException("Can't find a DbCrmExtension for driver '" + string + "'!");
        }
        dbCrmExtension.install(connection);
        super.install(connection, dbExtension, string, bl);
    }

    public boolean isAllowed(ImmoToolProject immoToolProject) {
        try {
            return CrmPlugin.isUserAllowedTo(CrmPermission.USE_PLUGIN, immoToolProject) && ((ContactsPlugin)ImmoToolEnvironment.getPlugin((String)"OpenEstate-Tool-Contacts")).isAllowed(immoToolProject);
        }
        catch (Exception exception) {
            LOGGER.warn("Can't check CRM addon for allowance!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean isUsable(ImmoToolProject immoToolProject) {
        try {
            return super.isUsable(immoToolProject) && this.isAllowed(immoToolProject) && ((ContactsPlugin)ImmoToolEnvironment.getPlugin((String)"OpenEstate-Tool-Contacts")).isUsable(immoToolProject);
        }
        catch (Exception exception) {
            LOGGER.warn("Can't check CRM addon for usability!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return false;
        }
    }

    public static boolean isUserAllowedTo(CrmPermission crmPermission) {
        return CrmPlugin.isUserAllowedTo(crmPermission, ImmoToolProject.getAppInstance());
    }

    public static boolean isUserAllowedTo(CrmPermission crmPermission, ImmoToolProject immoToolProject) {
        if (immoToolProject == null) {
            return false;
        }
        DbUser dbUser = immoToolProject.getUser();
        return dbUser != null ? dbUser.isAllowedTo(ID, (ProjectPermission)crmPermission) : false;
    }

    public void repair(Connection connection, AbstractDbDriver abstractDbDriver) throws SQLException {
        CrmPlugin.getDbCrmExtension().repair(connection, abstractDbDriver);
    }

    public static void setDbCrmExtension(DbCrmExtension dbCrmExtension) {
        CrmPlugin.dbCrmExtension = dbCrmExtension;
    }

    public static final class SidebarSelectAction
    extends AbstractI18nAction {
        public SidebarSelectAction() {
            this.setSmallIcon(CrmPlugin.getResourceIcon("crm.png", 16));
            this.setEnabled(CrmPlugin.isUserAllowedTo(CrmPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolFrame immoToolFrame = (ImmoToolFrame)ImmoToolApp.getInstance().getFrame();
            if (immoToolFrame != null) {
                immoToolFrame.selectSidebar(CrmFrameSidebarExtension.class);
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show CRM view")));
            this.setShortDescription(I18N.tr("Show CRM view in the sidebar."));
        }
    }

    private static final class SidebarRefreshTask
    extends ImmoToolTask<TreeModel, Void> {
        private final CrmFrameSidebarExtension.Tree tree;

        public SidebarRefreshTask(CrmFrameSidebarExtension.Tree tree) {
            this.tree = tree;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TreeModel doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbCrmMarketingHandler dbCrmMarketingHandler = CrmPlugin.getDbCrmExtension().getCrmMarketingHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                TreeModel treeModel = CrmFrameSidebarExtension.createTreeModel(immoToolProject, connection, dbCrmMarketingHandler);
                return treeModel;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't refresh sidebar!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(TreeModel treeModel) {
            super.succeeded((Object)treeModel);
            if (treeModel == null) {
                return;
            }
            this.tree.setModel(treeModel);
            this.tree.expandAll();
        }
    }

    public static final class SidebarRefreshAction
    extends AbstractI18nAction {
        public SidebarRefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.setEnabled(CrmPlugin.isUserAllowedTo(CrmPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmFrameSidebarExtension.Tree tree = CrmFrameSidebarExtension.getCurrentSidebarTree();
            if (tree != null) {
                ImmoToolUtils.executeTask((ImmoToolTask)new SidebarRefreshTask(tree));
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Refresh CRM view in the sidebar."));
        }
    }

    private static final class MarketingTableTask
    extends ImmoToolTask<CrmMarketingTablePanel, Void> {
        private final boolean asNewTab;

        public MarketingTableTask(boolean bl) {
            this.asNewTab = bl;
        }

        protected CrmMarketingTablePanel doInBackground() throws Exception {
            AbstractMainTab abstractMainTab;
            AbstractMainTab abstractMainTab2 = abstractMainTab = !this.asNewTab ? ImmoToolAppUtils.getMatchingTab(CrmMarketingTablePanel.class) : null;
            if (CrmMarketingTablePanel.class.isInstance(abstractMainTab)) {
                CrmMarketingTablePanel crmMarketingTablePanel = (CrmMarketingTablePanel)abstractMainTab;
                ImmoToolAppUtils.selectTab((Component)((Object)crmMarketingTablePanel));
                return null;
            }
            return CrmMarketingTablePanel.createTab();
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load table!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(CrmMarketingTablePanel crmMarketingTablePanel) {
            super.succeeded((Object)crmMarketingTablePanel);
            if (crmMarketingTablePanel != null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)crmMarketingTablePanel);
                crmMarketingTablePanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
            }
        }
    }

    public static final class MarketingTableAction
    extends AbstractI18nAction {
        private final boolean asNewTab;

        public MarketingTableAction() {
            this(false);
        }

        public MarketingTableAction(boolean bl) {
            this.asNewTab = bl;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.setEnabled(CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new MarketingTableTask(this.asNewTab));
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show marketings")));
            this.setShortDescription(I18N.tr("Show a table of marketing actions."));
        }
    }

    public static final class MarketingFormAction
    extends AbstractI18nAction {
        private final long marketingId;

        public MarketingFormAction() {
            this(0L);
        }

        public MarketingFormAction(long l) {
            this.marketingId = l;
            if (l < 1L) {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
                this.setEnabled(CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS_EDIT));
            } else {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
                this.setEnabled(CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS));
            }
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.marketingId < 1L) {
                CrmMarketingViewPanel crmMarketingViewPanel = CrmMarketingViewPanel.createTab();
                ImmoToolAppUtils.showTab((AbstractMainTab)crmMarketingViewPanel);
                crmMarketingViewPanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
            } else {
                ImmoToolUtils.executeTask((ImmoToolTask)new CrmMarketingViewTask(ImmoToolProject.getAppInstance().getDbDriver(), this.marketingId));
            }
        }

        protected final void updateLocalization() {
            if (this.marketingId < 1L) {
                this.setName(StringUtils.capitalize((String)I18N.tr("new marketing")));
                this.setShortDescription(I18N.tr("Add a new marketing action."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("show marketing")));
                this.setShortDescription(I18N.tr("Show details about the marketing action."));
            }
        }
    }

    private static final class ActivityTableTask
    extends ImmoToolTask<CrmActivityTablePanel, Void> {
        private final DbCrmActivity.Type type;
        private final boolean asNewTab;

        public ActivityTableTask(DbCrmActivity.Type type, boolean bl) {
            this.type = type;
            this.asNewTab = bl;
        }

        protected CrmActivityTablePanel doInBackground() throws Exception {
            AbstractMainTab abstractMainTab;
            AbstractMainTab abstractMainTab2 = abstractMainTab = !this.asNewTab ? ImmoToolAppUtils.getMatchingTab(CrmActivityTablePanel.class) : null;
            if (abstractMainTab != null && CrmActivityTablePanel.class.isInstance(abstractMainTab)) {
                CrmActivityTablePanel crmActivityTablePanel = (CrmActivityTablePanel)abstractMainTab;
                if (this.type != crmActivityTablePanel.getCurrentType()) {
                    crmActivityTablePanel.setType(this.type);
                    crmActivityTablePanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
                }
                ImmoToolAppUtils.selectTab((Component)((Object)crmActivityTablePanel));
                return null;
            }
            return CrmActivityTablePanel.createTab(this.type);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load table!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(CrmActivityTablePanel crmActivityTablePanel) {
            super.succeeded((Object)crmActivityTablePanel);
            if (crmActivityTablePanel != null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)crmActivityTablePanel);
                crmActivityTablePanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
            }
        }
    }

    public static final class ActivityTableAction
    extends AbstractI18nAction {
        private final DbCrmActivity.Type type;
        private final boolean asNewTab;

        public ActivityTableAction() {
            this(null, false);
        }

        public ActivityTableAction(boolean bl) {
            this(null, bl);
        }

        public ActivityTableAction(DbCrmActivity.Type type) {
            this(type, false);
        }

        public ActivityTableAction(DbCrmActivity.Type type, boolean bl) {
            this.type = type;
            this.asNewTab = bl;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.setEnabled(CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new ActivityTableTask(this.type, this.asNewTab));
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show activities")));
            this.setShortDescription(I18N.tr("Show a table of activities."));
        }
    }

    public static final class ActivityFormAction
    extends AbstractI18nAction {
        private final long activityId;
        private final DbCrmActivity.Type addType;

        public ActivityFormAction() {
            this(0L, null);
        }

        public ActivityFormAction(DbCrmActivity.Type type) {
            this(0L, type);
        }

        public ActivityFormAction(long l) {
            this(l, null);
        }

        private ActivityFormAction(long l, DbCrmActivity.Type type) {
            this.activityId = l;
            DbCrmActivity.Type type2 = this.addType = l < 1L ? type : null;
            if (l < 1L && type != null) {
                this.setSmallIcon(type.getIcon(16));
                this.setEnabled(CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES_EDIT));
            } else if (l < 1L) {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
                this.setEnabled(CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES_EDIT));
            } else {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
                this.setEnabled(CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES));
            }
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.activityId < 1L) {
                CrmActivityViewPanel crmActivityViewPanel = CrmActivityViewPanel.createTab(this.addType);
                ImmoToolAppUtils.showTab((AbstractMainTab)crmActivityViewPanel);
                crmActivityViewPanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
            } else {
                ImmoToolUtils.executeTask((ImmoToolTask)new CrmActivityViewTask(ImmoToolProject.getAppInstance().getDbDriver(), this.activityId));
            }
        }

        protected final void updateLocalization() {
            if (this.activityId < 1L && DbCrmActivity.Type.CALL.equals((Object)this.addType)) {
                this.setName(StringUtils.capitalize((String)I18N.tr("new phone activity")));
                this.setShortDescription(I18N.tr("Add a new phone activity."));
            } else if (this.activityId < 1L && DbCrmActivity.Type.EMAIL.equals((Object)this.addType)) {
                this.setName(StringUtils.capitalize((String)I18N.tr("new e-mail activity")));
                this.setShortDescription(I18N.tr("Add a new e-mail activity."));
            } else if (this.activityId < 1L && DbCrmActivity.Type.FAX.equals((Object)this.addType)) {
                this.setName(StringUtils.capitalize((String)I18N.tr("new fax activity")));
                this.setShortDescription(I18N.tr("Add a new fax activity."));
            } else if (this.activityId < 1L && DbCrmActivity.Type.LETTER.equals((Object)this.addType)) {
                this.setName(StringUtils.capitalize((String)I18N.tr("new letter activity")));
                this.setShortDescription(I18N.tr("Add a new letter activity."));
            } else if (this.activityId < 1L && DbCrmActivity.Type.MEETING.equals((Object)this.addType)) {
                this.setName(StringUtils.capitalize((String)I18N.tr("new personal activity")));
                this.setShortDescription(I18N.tr("Add a new personal activity."));
            } else if (this.activityId < 1L) {
                this.setName(StringUtils.capitalize((String)I18N.tr("new activity")));
                this.setShortDescription(I18N.tr("Add a new activity."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("show activity")));
                this.setShortDescription(I18N.tr("Show details about the activity."));
            }
        }
    }
}

