/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.crm.db.DbCrmActivityHandlerImpl;
import com.openindex.openestate.tool.utils.Permission;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbCrmActivityHandler
extends DbCrmActivityHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbCrmActivityHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbCrmActivityHandler.class);
    public static final String PROC_REMOVE_ACTIVITIES = "remove_immotool_crm_activities";
    public static final String PROC_REMOVE_ACTIVITIES_CONTACTS_ENTRIES = "remove_immotool_crm_activities_contacts_entries";
    public static final String PROC_SAVE_ACTIVITIES = "save_immotool_crm_activities";
    public static final String PROC_SAVE_ACTIVITIES_CONTACTS_ENTRIES = "save_immotool_crm_activities_contacts_entries";
    public static final String VIEW_ACTIVITIES = "view_immotool_crm_activities";
    public static final String VIEW_ACTIVITIES_CONTACTS_ENTRIES = "view_immotool_crm_activities_contacts_entries";
    public static final String TABLE_ACTIVITIES = "immotool_crm_activities";
    private static final String FIELD_ACTIVITY_ID = "activity_id";
    private static final String FIELD_ACTIVITY_SUBJECT = "activity_subject";
    private static final String FIELD_ACTIVITY_TYPE = "activity_type";
    private static final String FIELD_ACTIVITY_DIRECTION = "activity_direction";
    private static final String FIELD_ACTIVITY_STATUS = "activity_status";
    private static final String FIELD_ACTIVITY_BEGIN = "activity_begin";
    private static final String FIELD_ACTIVITY_END = "activity_end";
    private static final String FIELD_ACTIVITY_FIXED = "activity_fixed";
    private static final String FIELD_ACTIVITY_NOTES = "activity_notes";
    public static final String TABLE_ACTIVITIES_CONTACTS_ENTRIES = "immotool_crm_activities_contacts_entries";
    private static final String FIELD_CONTACTS_ENTRY_ID = "contacts_entry_id";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";
    private static final String FIELD_ACCESS_OWNER_ID = "access_owner_id";
    private static final String FIELD_ACCESS_GROUP_ID = "access_group_id";
    private static final String FIELD_ACCESS_PERMISSIONS = "access_permissions";

    private DbCrmActivity createActivity(ResultSet resultSet) throws SQLException {
        String string;
        DbCrmActivity dbCrmActivity = this.buildActivity();
        dbCrmActivity.id = resultSet.getLong(FIELD_ACTIVITY_ID);
        dbCrmActivity.begin = resultSet.getTimestamp(FIELD_ACTIVITY_BEGIN);
        dbCrmActivity.end = resultSet.getTimestamp(FIELD_ACTIVITY_END);
        dbCrmActivity.notes = resultSet.getString(FIELD_ACTIVITY_NOTES);
        dbCrmActivity.subject = resultSet.getString(FIELD_ACTIVITY_SUBJECT);
        dbCrmActivity.fixed = resultSet.getBoolean(FIELD_ACTIVITY_FIXED);
        dbCrmActivity.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbCrmActivity.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        dbCrmActivity.ownerUserId = resultSet.getLong(FIELD_ACCESS_OWNER_ID);
        dbCrmActivity.ownerGroupId = resultSet.getLong(FIELD_ACCESS_GROUP_ID);
        dbCrmActivity.permission = new Permission(resultSet.getInt(FIELD_ACCESS_PERMISSIONS));
        try {
            string = resultSet.getString(FIELD_ACTIVITY_STATUS);
            dbCrmActivity.status = !StringUtils.isBlank((CharSequence)string) ? DbCrmActivity.Status.valueOf(string) : null;
        }
        catch (Exception exception) {
            dbCrmActivity.status = null;
            LOGGER.warn("Can't read status of CRM activity #" + dbCrmActivity.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            string = resultSet.getString(FIELD_ACTIVITY_TYPE);
            dbCrmActivity.type = !StringUtils.isBlank((CharSequence)string) ? DbCrmActivity.Type.valueOf(string) : null;
        }
        catch (Exception exception) {
            dbCrmActivity.type = null;
            LOGGER.warn("Can't read type of CRM activity #" + dbCrmActivity.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            string = resultSet.getString(FIELD_ACTIVITY_DIRECTION);
            dbCrmActivity.direction = !StringUtils.isBlank((CharSequence)string) ? DbCrmActivity.Direction.valueOf(string) : null;
        }
        catch (Exception exception) {
            dbCrmActivity.direction = null;
            LOGGER.warn("Can't read direction of CRM activity #" + dbCrmActivity.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return dbCrmActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbCrmActivity[] getActivities(Connection connection, DbCrmActivity.Type type) throws SQLException {
        DbCrmActivity[] dbCrmActivityArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (type == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_activities ORDER BY activity_begin DESC, activity_subject ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_activities WHERE activity_type = ? ORDER BY activity_begin DESC, activity_subject ASC;");
                preparedStatement.setString(1, type.name());
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbCrmActivity> arrayList = new ArrayList<DbCrmActivity>();
            while (resultSet.next()) {
                arrayList.add(this.createActivity(resultSet));
            }
            dbCrmActivityArray = arrayList.toArray(new DbCrmActivity[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCrmActivityArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbCrmActivity[] getActivities(Connection connection, long[] lArray) throws SQLException {
        DbCrmActivity[] dbCrmActivityArray;
        if (lArray != null && lArray.length < 1) {
            return new DbCrmActivity[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_activities ORDER BY activity_begin DESC, activity_subject ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_activities WHERE activity_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_ACTIVITY_BEGIN + " DESC, " + FIELD_ACTIVITY_SUBJECT + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbCrmActivity> arrayList = new ArrayList<DbCrmActivity>();
            while (resultSet.next()) {
                arrayList.add(this.createActivity(resultSet));
            }
            dbCrmActivityArray = arrayList.toArray(new DbCrmActivity[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCrmActivityArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbCrmActivity[] getActivities(Connection connection, Date date, Date date2) throws SQLException {
        DbCrmActivity[] dbCrmActivityArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (date != null && date2 != null) {
                arrayList.add("((activity_begin >= ? AND activity_begin <= ?) OR (activity_end >= ? AND activity_end <= ?))");
            } else if (date != null) {
                arrayList.add("activity_begin >= ? AND activity_end <= ?");
            } else if (date2 != null) {
                arrayList.add("activity_begin >= ? AND activity_end <= ?");
            }
            String string = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)" ) AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_activities " + string + " ORDER BY " + FIELD_ACTIVITY_BEGIN + " DESC, " + FIELD_ACTIVITY_SUBJECT + " ASC;");
            int n = 0;
            if (date != null && date2 != null) {
                preparedStatement.setTimestamp(++n, new Timestamp(date.getTime()));
                preparedStatement.setTimestamp(++n, new Timestamp(date2.getTime()));
                preparedStatement.setTimestamp(++n, new Timestamp(date.getTime()));
                preparedStatement.setTimestamp(++n, new Timestamp(date2.getTime()));
            } else if (date != null) {
                preparedStatement.setTimestamp(++n, new Timestamp(date.getTime()));
                preparedStatement.setTimestamp(++n, new Timestamp(date.getTime()));
            } else if (date2 != null) {
                preparedStatement.setTimestamp(++n, new Timestamp(date2.getTime()));
                preparedStatement.setTimestamp(++n, new Timestamp(date2.getTime()));
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbCrmActivity> arrayList2 = new ArrayList<DbCrmActivity>();
            while (resultSet.next()) {
                arrayList2.add(this.createActivity(resultSet));
            }
            dbCrmActivityArray = arrayList2.toArray(new DbCrmActivity[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCrmActivityArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbCrmActivity[] getActivitiesByKeyword(Connection connection, String string, DbCrmActivity.Type[] typeArray, int n) throws SQLException {
        DbCrmActivity[] dbCrmActivityArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((string = StringUtils.trimToNull((String)StringUtils.lowerCase((String)string))) != null) {
            arrayList.add("LOWER(activity_subject) LIKE ?");
        }
        if (typeArray != null) {
            arrayList.add("activity_type IN (" + JdbcUtils.writeQuestionMarkList((int)typeArray.length) + ")");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = "SELECT * FROM view_immotool_crm_activities";
            if (!arrayList.isEmpty()) {
                string2 = string2 + " WHERE " + StringUtils.join((Object[])arrayList.toArray(new String[0]), (String)" AND ");
            }
            string2 = string2 + "ORDER BY activity_begin DESC, activity_subject ASC ";
            string2 = string2 + (n > 0 ? "LIMIT " + n : "");
            preparedStatement = connection.prepareStatement(string2);
            int n2 = 0;
            if (string != null) {
                preparedStatement.setString(++n2, "%" + string + "%");
            }
            if (typeArray != null) {
                for (DbCrmActivity.Type type : typeArray) {
                    preparedStatement.setString(++n2, type.name());
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList arrayList2 = new ArrayList();
            while (resultSet.next()) {
                arrayList2.add(this.createActivity(resultSet));
            }
            dbCrmActivityArray = arrayList2.toArray(new DbCrmActivity[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCrmActivityArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbCrmActivity[] getActivitiesForContact(Connection connection, long[] lArray, DbCrmActivity.Type type) throws SQLException {
        DbCrmActivity[] dbCrmActivityArray;
        if (lArray != null && lArray.length < 1) {
            return new DbCrmActivity[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (lArray != null) {
                arrayList.add("activity_id IN (SELECT activity_id FROM view_immotool_crm_activities_contacts_entries WHERE contacts_entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + "))");
            }
            if (type != null) {
                arrayList.add("activity_type = ?");
            }
            String string = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)" ) AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_activities " + string + " ORDER BY " + FIELD_ACTIVITY_BEGIN + " DESC, " + FIELD_ACTIVITY_SUBJECT + " ASC;");
            int n = 0;
            if (lArray != null) {
                for (long l : lArray) {
                    preparedStatement.setLong(++n, l);
                }
            }
            if (type != null) {
                preparedStatement.setString(++n, type.name());
            }
            resultSet = preparedStatement.executeQuery();
            Object object = new ArrayList();
            while (resultSet.next()) {
                object.add(this.createActivity(resultSet));
            }
            dbCrmActivityArray = object.toArray(new DbCrmActivity[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCrmActivityArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getActivityIds(Connection connection, long[] lArray, DbCrmActivity.Type type) throws SQLException {
        long[] lArray2;
        if (lArray != null && lArray.length < 1) {
            return new long[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (lArray != null) {
                arrayList.add("activity_id IN (SELECT activity_id FROM view_immotool_crm_activities_contacts_entries WHERE contacts_entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + "))");
            }
            if (type != null) {
                arrayList.add("activity_type = ?");
            }
            String string = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)" ) AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT activity_id FROM view_immotool_crm_activities " + string + " ORDER BY " + FIELD_ACTIVITY_ID + " ASC;");
            int n = 0;
            if (lArray != null) {
                for (long l : lArray) {
                    preparedStatement.setLong(++n, l);
                }
            }
            if (type != null) {
                preparedStatement.setString(++n, type.name());
            }
            resultSet = preparedStatement.executeQuery();
            Object object = new ArrayList();
            while (resultSet.next()) {
                object.add(resultSet.getLong(FIELD_ACTIVITY_ID));
            }
            lArray2 = ArrayUtils.toPrimitive((Long[])object.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadContactEntries(Connection connection, DbCrmActivity[] dbCrmActivityArray) throws SQLException {
        HashMap<Long, DbCrmActivity> hashMap = new HashMap<Long, DbCrmActivity>();
        for (DbCrmActivity dbCrmActivity : dbCrmActivityArray) {
            if (dbCrmActivity.id <= 0L || hashMap.containsKey(dbCrmActivity.id)) continue;
            hashMap.put(dbCrmActivity.id, dbCrmActivity);
            if (dbCrmActivity.contactEntryIds != null) {
                dbCrmActivity.contactEntryIds.clear();
                continue;
            }
            dbCrmActivity.contactEntryIds = new ArrayList<Long>();
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_activities_contacts_entries WHERE activity_id IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_ACTIVITY_ID + " ASC, " + FIELD_CONTACTS_ENTRY_ID + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong(FIELD_ACTIVITY_ID);
                long l2 = resultSet.getLong(FIELD_CONTACTS_ENTRY_ID);
                ((DbCrmActivity)hashMap.get((Object)Long.valueOf((long)l))).contactEntryIds.add(l2);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    @Override
    public void removeActivities(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_crm_activities(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void removeActivityContactEntries(Connection connection, long l, long[] lArray) throws SQLException {
        if (l < 1L || lArray == null) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL remove_immotool_crm_activities_contacts_entries(:activity_id, :contacts_entry_id);");
            for (long l2 : lArray) {
                if (l2 <= 0L) continue;
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_ACTIVITY_ID, l);
                namedCallableStatement.setLong(FIELD_CONTACTS_ENTRY_ID, l2);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveActivity(Connection connection, DbCrmActivity dbCrmActivity) throws SQLException {
        ArrayList<CallableStatement> arrayList;
        NamedCallableStatement namedCallableStatement;
        boolean bl;
        block13: {
            bl = connection.getAutoCommit();
            namedCallableStatement = null;
            arrayList = new ArrayList<CallableStatement>();
            try {
                long l;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_crm_activities(:activity_id, :activity_subject, :activity_type, :activity_direction, :activity_status, :activity_begin, :activity_end, :activity_fixed, :activity_notes, :access_owner_id, :access_group_id, :access_permissions);");
                namedCallableStatement.setLong(FIELD_ACTIVITY_ID, dbCrmActivity.id);
                namedCallableStatement.setString(FIELD_ACTIVITY_SUBJECT, StringUtils.abbreviate((String)dbCrmActivity.subject, (int)255));
                namedCallableStatement.setString(FIELD_ACTIVITY_NOTES, dbCrmActivity.notes);
                namedCallableStatement.setString(FIELD_ACTIVITY_STATUS, dbCrmActivity.status != null ? dbCrmActivity.status.name() : null);
                namedCallableStatement.setString(FIELD_ACTIVITY_TYPE, dbCrmActivity.type != null ? dbCrmActivity.type.name() : null);
                namedCallableStatement.setString(FIELD_ACTIVITY_DIRECTION, dbCrmActivity.direction != null ? dbCrmActivity.direction.name() : null);
                namedCallableStatement.setTimestamp(FIELD_ACTIVITY_BEGIN, dbCrmActivity.begin != null ? new Timestamp(dbCrmActivity.begin.getTime()) : null);
                namedCallableStatement.setTimestamp(FIELD_ACTIVITY_END, dbCrmActivity.end != null ? new Timestamp(dbCrmActivity.end.getTime()) : null);
                namedCallableStatement.setBoolean(FIELD_ACTIVITY_FIXED, dbCrmActivity.fixed);
                namedCallableStatement.setLong(FIELD_ACCESS_OWNER_ID, dbCrmActivity.ownerUserId);
                namedCallableStatement.setLong(FIELD_ACCESS_GROUP_ID, dbCrmActivity.ownerGroupId);
                namedCallableStatement.setInt(FIELD_ACCESS_PERMISSIONS, dbCrmActivity.permission != null ? dbCrmActivity.permission.getValue() : -1);
                namedCallableStatement.execute();
                long l2 = l = dbCrmActivity.id < 1L ? namedCallableStatement.getLong(FIELD_ACTIVITY_ID) : dbCrmActivity.id;
                if (l < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                if (dbCrmActivity.contactEntryIds != null) {
                    DbCrmActivity dbCrmActivity2;
                    ArrayList<Long> arrayList2 = new ArrayList<Long>();
                    if (dbCrmActivity.id > 0L) {
                        dbCrmActivity2 = new DbCrmActivity();
                        dbCrmActivity2.id = dbCrmActivity.id;
                        this.loadContactEntries(connection, dbCrmActivity2);
                        if (dbCrmActivity2.contactEntryIds != null && !dbCrmActivity2.contactEntryIds.isEmpty()) {
                            arrayList2.addAll(dbCrmActivity2.contactEntryIds);
                        }
                        NamedCallableStatement namedCallableStatement2 = new NamedCallableStatement(connection, "CALL remove_immotool_crm_activities_contacts_entries(:activity_id, :contacts_entry_id);");
                        for (Long l3 : arrayList2) {
                            if (dbCrmActivity.contactEntryIds.contains(l3)) continue;
                            namedCallableStatement2.clearParameters();
                            namedCallableStatement2.setLong(FIELD_ACTIVITY_ID, dbCrmActivity.id);
                            namedCallableStatement2.setLong(FIELD_CONTACTS_ENTRY_ID, l3.longValue());
                            namedCallableStatement2.execute();
                            arrayList.add(namedCallableStatement2.getStatement());
                        }
                    }
                    if (!dbCrmActivity.contactEntryIds.isEmpty()) {
                        dbCrmActivity2 = new NamedCallableStatement(connection, "CALL save_immotool_crm_activities_contacts_entries(:activity_id, :contacts_entry_id);");
                        for (Long l4 : dbCrmActivity.contactEntryIds) {
                            if (arrayList2.contains(l4)) continue;
                            dbCrmActivity2.clearParameters();
                            dbCrmActivity2.setLong(FIELD_ACTIVITY_ID, l);
                            dbCrmActivity2.setLong(FIELD_CONTACTS_ENTRY_ID, l4);
                            dbCrmActivity2.execute();
                            arrayList.add(dbCrmActivity2.getStatement());
                        }
                    }
                }
                connection.commit();
                if (dbCrmActivity.id >= 1L) break block13;
                dbCrmActivity.id = l;
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    for (Statement statement : arrayList) {
                        JdbcUtils.closeQuietly((Statement)statement);
                    }
                    connection.setAutoCommit(bl);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        for (Statement statement : arrayList) {
            JdbcUtils.closeQuietly((Statement)statement);
        }
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveActivityContactEntries(Connection connection, long l, long[] lArray) throws SQLException {
        if (l < 1L || lArray == null) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_crm_activities_contacts_entries(:activity_id, :contacts_entry_id);");
            for (long l2 : lArray) {
                if (l2 <= 0L) continue;
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_ACTIVITY_ID, l);
                namedCallableStatement.setLong(FIELD_CONTACTS_ENTRY_ID, l2);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

