/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.db.DbCrmActivityHandler;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingHandler;
import com.openindex.openestate.tool.crm.db.DbCrmUpdateListener;
import com.openindex.openestate.tool.crm.db.hsql.HSqlDbCrmActivityHandler;
import com.openindex.openestate.tool.crm.db.hsql.HSqlDbCrmMarketingHandler;
import com.openindex.openestate.tool.crm.extensions.DbCrmAdapter;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.AbstractDbUpdateListener;
import com.openindex.openestate.tool.db.DbUpdateHandler;
import com.openindex.openestate.tool.db.DbUpdateHandlerImpl;
import com.openindex.openestate.tool.db.hsql.HSqlDbUpdateHandler;
import com.openindex.openestate.tool.db.hsql.HSqlUtils;
import com.openindex.openestate.tool.extensions.DbExtension;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbCrmExtension
extends DbCrmAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbCrmExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbCrmExtension.class);
    public static final String RESOURCE_PATH = "/com/openindex/openestate/tool/crm/db/hsql/resources/";
    private static final DbCrmActivityHandler ACTIVITY_HANDLER = new HSqlDbCrmActivityHandler();
    private static final DbCrmMarketingHandler MARKETING_HANDLER = new HSqlDbCrmMarketingHandler();

    @Override
    public DbCrmActivityHandler getCrmActivityHandler() {
        return ACTIVITY_HANDLER;
    }

    @Override
    public DbCrmMarketingHandler getCrmMarketingHandler() {
        return MARKETING_HANDLER;
    }

    @Override
    public final String[] getRequiredProcedures() {
        return new String[]{"remove_immotool_crm_activities", "remove_immotool_crm_activities_contacts_entries", "save_immotool_crm_activities", "save_immotool_crm_activities_contacts_entries", "remove_immotool_crm_marketing", "remove_immotool_crm_marketing_feedback", "save_immotool_crm_marketing", "save_immotool_crm_marketing_feedback"};
    }

    @Override
    public final String[] getRequiredViews() {
        return new String[]{"view_immotool_crm_activities", "view_immotool_crm_activities_contacts_entries", "view_immotool_crm_marketing", "view_immotool_crm_marketing_feedback"};
    }

    @Override
    public String[] getSupportedDrivers() {
        return new String[]{"HSQL.local", "HSQL.remote"};
    }

    @Override
    public String getUninstallQuery() throws IOException {
        return HSqlDbCrmExtension.readHsqlQuery("uninstall.sql");
    }

    @Override
    public DbUpdateHandler getUpdateHandler() {
        String string = null;
        try {
            string = this.getUninstallQuery();
        }
        catch (IOException iOException) {
            LOGGER.warn("Can't load uninstall query!");
            LOGGER.warn("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        return new CrmUpdateHandler(string, new DbCrmUpdateListener());
    }

    @Override
    public void install(Connection connection) throws IOException, SQLException {
        Statement statement = null;
        SqlFile sqlFile = null;
        try {
            statement = connection.createStatement();
            sqlFile = HSqlDbCrmExtension.readHsqlFile("schema.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            sqlFile = HSqlDbCrmExtension.readHsqlFile("routines.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            statement.execute("CHECKPOINT;");
        }
        catch (SqlToolError sqlToolError) {
            sqlFile.closeReader();
            connection.rollback();
            LOGGER.error("Can't execute schema!");
            LOGGER.error("> " + sqlToolError.getLocalizedMessage(), (Throwable)sqlToolError);
            throw new SQLException("Can't execute schema!");
        }
        catch (SQLException sQLException) {
            if (sqlFile != null) {
                sqlFile.closeReader();
            }
            connection.rollback();
            throw sQLException;
        }
        finally {
            JdbcUtils.closeQuietly((Statement)statement);
        }
    }

    private static SqlFile readHsqlFile(String string) throws IOException {
        return HSqlUtils.readHSqlFile((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbCrmExtension.class.getClassLoader());
    }

    private static String readHsqlQuery(String string) throws IOException {
        return HSqlUtils.readHSqlQuery((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbCrmExtension.class.getClassLoader());
    }

    @Override
    public void repair(Connection connection, AbstractDbDriver abstractDbDriver) throws SQLException {
        super.repair(connection, abstractDbDriver);
        HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_crm_activities");
        HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_crm_marketing");
        HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_crm_activities");
        HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_crm_marketing");
    }

    private static final class CrmUpdateHandler
    extends HSqlDbUpdateHandler {
        public CrmUpdateHandler(String string, AbstractDbUpdateListener abstractDbUpdateListener) {
            super("OpenEstate-Tool-CRM", DbUpdateHandlerImpl.Type.PLUGIN, CrmPlugin.getInstance().getApiVersion(), string, HSqlDbCrmExtension.RESOURCE_PATH, CrmPlugin.class.getClassLoader(), abstractDbUpdateListener);
        }

        public void updateFinished(Connection connection, AbstractDbDriver abstractDbDriver, DbExtension dbExtension, long l, long l2) throws SQLException, IOException {
            super.updateFinished(connection, abstractDbDriver, dbExtension, l, l2);
            if (l < 5L) {
                HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_crm_activities");
                HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_crm_marketing");
            }
            if (l < 5L) {
                HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_crm_activities");
                HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_crm_marketing");
            }
        }
    }
}

