-- -----------------------------------------------------
-- CRM-Addon for OpenEstate-ImmoTool
-- update 6 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Add function 'can_read_immotool_crm_activities'
-- Add function 'can_read_immotool_crm_marketing'
-- -----------------------------------------------------

\.
-- -----------------------------------------------------
-- Function can_read_immotool_crm_activities
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_crm_activities( val_activity_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_crm_activities
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_crm_activities
      WHERE activity_id = val_activity_id;

    RETURN can_read( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_read_immotool_crm_marketing
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_crm_marketing( val_marketing_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_crm_marketing
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_crm_marketing
      WHERE marketing_id = val_marketing_id;

    RETURN can_read( permissions, owner_uid, owner_gid );
  END;
.;
