/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.mail.MailAccountDialog;
import com.openindex.openestate.tool.mail.MailAccountDialogForm;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailAccountPropertiesTab
extends MailAccountDialogForm {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailAccountPropertiesTab.class);
    private static final I18n I18N = I18nFactory.getI18n(MailAccountPropertiesTab.class);
    private static final String TABLE_ID = "MailAccountPropertiesTab.Table";
    private JXTitledSeparator propertiesTitle;
    private Table propertiesTable;
    private PropertyAddAction propertyAddAction;
    private PropertyRemoveAction propertyRemoveAction;

    public MailAccountPropertiesTab(MailAccountDialog mailAccountDialog) {
        super(mailAccountDialog);
        this.build();
    }

    private void build() {
        this.propertiesTable = new Table();
        this.propertiesTable.getTableHeader().setReorderingAllowed(false);
        this.propertiesTable.setSelectionMode(0);
        ImmoToolUtils.configureTable((JXTable)this.propertiesTable);
        this.propertiesTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.propertyAddAction = new PropertyAddAction();
        this.propertyRemoveAction = new PropertyRemoveAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.propertiesTitle, (Action[])new Action[]{this.propertyAddAction, this.propertyRemoveAction});
        this.setLayout(new BorderLayout(5, 5));
        this.add(jPanel, "North");
        this.add(this.propertiesTable.createScrollPane(), "Center");
        this.updateLocalization();
        this.load(null);
        this.loadDefaults();
    }

    private void doPropertyAdd() {
        if (!this.propertiesTable.isEnabled()) {
            return;
        }
        this.propertiesTable.addRow(new TableRow("", ""));
        int n = this.propertiesTable.getRowCount() - 1;
        this.propertiesTable.getSelectionModel().setSelectionInterval(n, n);
        this.propertiesTable.scrollRowToVisible(n);
    }

    private void doPropertyRemove() {
        if (!this.propertiesTable.isEnabled()) {
            return;
        }
        int n = this.propertiesTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        int n2 = this.propertiesTable.convertRowIndexToModel(n);
        this.propertiesTable.removeRow(n2);
        if (this.propertiesTable.getRowCount() == 0) {
            return;
        }
        n = n >= this.propertiesTable.getRowCount() ? this.propertiesTable.getRowCount() - 1 : n;
        this.propertiesTable.getSelectionModel().setSelectionInterval(n, n);
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < this.propertiesTable.getRowCount(); ++i) {
            hashMap.put(this.propertiesTable.getKeyAt(i), this.propertiesTable.getValueAt(i));
        }
        return hashMap;
    }

    @Override
    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("extended"));
    }

    @Override
    public ValidationHandler getValidationHandler() {
        return null;
    }

    @Override
    public void load(DbMailAccount dbMailAccount) {
        this.propertyRemoveAction.setEnabled(false);
        this.propertiesTable.clearRows();
        if (dbMailAccount == null) {
            return;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>(dbMailAccount.buildCustomPropertyMap());
        for (Map.Entry<String, String> entry : treeMap.entrySet()) {
            this.propertiesTable.addRow(new TableRow(entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public void save(DbMailAccount dbMailAccount) {
        if (dbMailAccount == null) {
            throw new NullPointerException("No account provided!");
        }
        dbMailAccount.clearCustomProperties();
        Map<String, String> map = this.getProperties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            dbMailAccount.setCustomProperty(entry.getKey(), entry.getValue());
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.propertiesTable.setEnabled(bl);
        this.propertyAddAction.setEnabled(bl);
        this.propertyRemoveAction.setEnabled(bl && this.propertiesTable.getSelectedRowCount() > 0);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.propertiesTitle.setTitle(StringUtils.capitalize((String)I18N.tr("extended settings")));
    }

    private class PropertyRemoveAction
    extends AbstractI18nAction {
        public PropertyRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setName("");
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailAccountPropertiesTab.this.doPropertyRemove();
        }

        protected void updateLocalization() {
            this.setShortDescription(I18N.tr("Remove the selected settings."));
        }
    }

    private class PropertyAddAction
    extends AbstractI18nAction {
        public PropertyAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.setName("");
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailAccountPropertiesTab.this.doPropertyAdd();
        }

        protected void updateLocalization() {
            this.setShortDescription(I18N.tr("Add new setting."));
        }
    }

    public static class TableRow
    extends AbstractTable.Row {
        private String key;
        private String value;

        public TableRow(String string) {
            this(string, null);
        }

        public TableRow(String string, String string2) {
            this.key = string;
            this.value = StringUtils.trimToNull((String)string2);
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof TableColumn) {
                return this.getValueForProperty((TableColumn)column);
            }
            return null;
        }

        public Object getValueForProperty(TableColumn tableColumn) {
            switch (tableColumn) {
                case KEY: {
                    return StringUtils.trimToEmpty((String)this.key);
                }
                case VALUE: {
                    return StringUtils.trimToEmpty((String)this.value);
                }
            }
            return null;
        }

        public void setKey(String string) {
            this.key = string;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public void setValueAt(Object object, AbstractTable.Column column) {
            if (TableColumn.KEY.equals(column)) {
                this.key = StringUtils.trimToNull((String)((String)object));
            } else if (TableColumn.VALUE.equals(column)) {
                this.value = StringUtils.trimToNull((String)((String)object));
            } else {
                super.setValueAt(object, column);
            }
        }
    }

    public static enum TableColumn implements AbstractTable.Column
    {
        KEY,
        VALUE;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                default: 
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case KEY: 
                case VALUE: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case KEY: {
                    return StringUtils.capitalize((String)I18N.tr("name"));
                }
                case VALUE: {
                    return StringUtils.capitalize((String)I18N.tr("value"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }

    private class Table
    extends AbstractTable<TableRow, AbstractTable.Model<TableRow>> {
        public Table() {
            super(MailAccountPropertiesTab.TABLE_ID);
        }

        protected void doSelect() {
            MailAccountPropertiesTab.this.propertyRemoveAction.setEnabled(this.getSelectedRowCount() > 0);
        }

        public String getKeyAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? tableRow.getKey() : null;
        }

        public String getValueAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? tableRow.getValue() : null;
        }

        protected void init() {
            this.setSortable(true);
            this.setEditable(true);
            this.setColumnControlVisible(false);
            this.setSingleSelection();
            super.init();
        }

        protected List<AbstractTable.Column> listColumns() {
            ArrayList<AbstractTable.Column> arrayList = new ArrayList<AbstractTable.Column>();
            arrayList.addAll(Arrays.asList(TableColumn.values()));
            return arrayList;
        }
    }
}

