/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.mail.MailHandler;
import com.openindex.openestate.tool.mail.MailPlugin;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailAutoRetrievalTimer
extends Timer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailAutoRetrievalTimer.class);
    private static final I18n I18N = I18nFactory.getI18n(MailAutoRetrievalTimer.class);
    private static final int DELAY = 60000;
    private boolean isRunning = false;
    private boolean isFirstCall = false;

    public MailAutoRetrievalTimer() {
        super(60000, null);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MailAutoRetrievalTimer.this.timingOccured();
            }
        });
    }

    @Override
    public void start() {
        this.isFirstCall = true;
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
    }

    private synchronized void timingOccured() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Look for new messages"){

            protected Boolean doInBackground() throws Exception {
                MailHandler mailHandler = MailPlugin.getMailHandler();
                if (mailHandler != null) {
                    mailHandler.lookForNewMessages(true, MailAutoRetrievalTimer.this.isFirstCall);
                    return true;
                }
                return false;
            }

            protected void finished() {
                super.finished();
                MailAutoRetrievalTimer.this.isRunning = false;
                MailAutoRetrievalTimer.this.isFirstCall = false;
            }
        });
    }
}

