/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.tool.mail.db.DbMailHeader;
import com.openindex.openestate.tool.mail.db.DbMailPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailNotification {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailNotification.class);
    private static final I18n I18N = I18nFactory.getI18n(MailNotification.class);
    private static final String HEADER_DISPOSITION_NOTIFICATION_TO = "Disposition-Notification-To";
    private static final String HEADER_RETURN_RECEIPT_TO = "Return-Receipt-To";
    private static final String HEADER_X_CONFIRM_READING_TO = "X-Confirm-Reading-To";

    public static InternetAddress[] readFromHeader(DbMailPart dbMailPart) {
        if (dbMailPart == null || dbMailPart.headers == null || dbMailPart.headers.isEmpty()) {
            return null;
        }
        Object[] objectArray = dbMailPart.getHeader(HEADER_DISPOSITION_NOTIFICATION_TO);
        Object[] objectArray2 = dbMailPart.getHeader(HEADER_X_CONFIRM_READING_TO);
        Object[] objectArray3 = dbMailPart.getHeader(HEADER_RETURN_RECEIPT_TO);
        return MailNotification.readFromHeader(!ArrayUtils.isEmpty((Object[])objectArray) ? ((DbMailHeader)objectArray[0]).value.trim() : null, !ArrayUtils.isEmpty((Object[])objectArray2) ? ((DbMailHeader)objectArray2[0]).value.trim() : null, !ArrayUtils.isEmpty((Object[])objectArray3) ? ((DbMailHeader)objectArray3[0]).value.trim() : null);
    }

    public static InternetAddress[] readFromHeader(Message message) throws MessagingException {
        if (message == null) {
            return null;
        }
        Object[] objectArray = message.getHeader(HEADER_DISPOSITION_NOTIFICATION_TO);
        Object[] objectArray2 = message.getHeader(HEADER_X_CONFIRM_READING_TO);
        Object[] objectArray3 = message.getHeader(HEADER_RETURN_RECEIPT_TO);
        return MailNotification.readFromHeader(!ArrayUtils.isEmpty((Object[])objectArray) ? ((String)objectArray[0]).trim() : null, !ArrayUtils.isEmpty((Object[])objectArray2) ? ((String)objectArray2[0]).trim() : null, !ArrayUtils.isEmpty((Object[])objectArray3) ? ((String)objectArray3[0]).trim() : null);
    }

    private static InternetAddress[] readFromHeader(String string, String string2, String string3) {
        Object[] objectArray;
        if (!StringUtils.isBlank((CharSequence)string)) {
            try {
                objectArray = InternetAddress.parse((String)string);
                if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                    return objectArray;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!StringUtils.isBlank((CharSequence)string2)) {
            try {
                objectArray = InternetAddress.parse((String)string2);
                if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                    return objectArray;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!StringUtils.isBlank((CharSequence)string3)) {
            try {
                objectArray = InternetAddress.parse((String)string3);
                if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                    return objectArray;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void writeToHeader(InternetAddress internetAddress, Email email) {
        if (internetAddress == null || email == null) {
            return;
        }
        email.addHeader(HEADER_RETURN_RECEIPT_TO, internetAddress.toUnicodeString());
        email.addHeader(HEADER_X_CONFIRM_READING_TO, internetAddress.toUnicodeString());
        email.addHeader(HEADER_DISPOSITION_NOTIFICATION_TO, internetAddress.toUnicodeString());
    }

    public static void writeToHeader(InternetAddress internetAddress, Message message) throws MessagingException {
        if (internetAddress == null || message == null) {
            return;
        }
        message.setHeader(HEADER_RETURN_RECEIPT_TO, internetAddress.toString());
        message.setHeader(HEADER_X_CONFIRM_READING_TO, internetAddress.toString());
        message.setHeader(HEADER_DISPOSITION_NOTIFICATION_TO, internetAddress.toString());
    }
}

