/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.ProjectPermission;
import java.util.ArrayList;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public enum MailPermission implements ProjectPermission
{
    USE_PLUGIN(null, I18n.marktr((String)"use addon")),
    ACCOUNTS_EDIT(USE_PLUGIN, I18n.marktr((String)"edit mail accounts")),
    ACCOUNTS_REMOVE(USE_PLUGIN, I18n.marktr((String)"remove mail accounts")),
    ACCOUNTS_EXPORT(USE_PLUGIN, I18n.marktr((String)"export mail accounts"));

    private static final Logger LOGGER;
    private static final I18n I18N;
    private final String i18nKey;
    private final ProjectPermission parent;

    private MailPermission(ProjectPermission projectPermission, String string2) {
        this.parent = projectPermission;
        this.i18nKey = string2;
    }

    public ProjectPermission[] getChildren() {
        ArrayList<MailPermission> arrayList = new ArrayList<MailPermission>();
        for (MailPermission mailPermission : MailPermission.values()) {
            if (!this.equals(mailPermission.parent)) continue;
            arrayList.add(mailPermission);
        }
        return arrayList.toArray(new ProjectPermission[0]);
    }

    public String getKey() {
        return this.name();
    }

    public ProjectPermission getParent() {
        return this.parent;
    }

    public String getTranslation() {
        return ImmoToolUtils.getI18nString(MailPermission.class, (String)this.i18nKey);
    }

    public String getTranslation(Locale locale) {
        return ImmoToolUtils.getI18nString(MailPermission.class, (String)this.i18nKey, (Locale)locale);
    }

    static {
        LOGGER = LoggerFactory.getLogger(MailPermission.class);
        I18N = I18nFactory.getI18n(MailPermission.class);
    }
}

