/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolFrame;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolProjectPlugin;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskContainer;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUpdateHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.gui.ActionLink;
import com.openindex.openestate.tool.mail.MailAccountDialog;
import com.openindex.openestate.tool.mail.MailAutoRetrievalTimer;
import com.openindex.openestate.tool.mail.MailFrameSidebarExtension;
import com.openindex.openestate.tool.mail.MailHandler;
import com.openindex.openestate.tool.mail.MailPermission;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.MailProjectExtension;
import com.openindex.openestate.tool.mail.MailTablePanel;
import com.openindex.openestate.tool.mail.MailWritePanel;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailAccountHandler;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import com.openindex.openestate.tool.mail.extensions.DbMailExtension;
import com.openindex.openestate.tool.mail.extensions.MailHandlerAdapter;
import com.openindex.openestate.tool.mail.utils.MailFolderDialog;
import com.openindex.openestate.tool.mail.utils.MailImportTask;
import com.openindex.openestate.tool.utils.ProjectPermission;
import com.openindex.openestate.tool.utils.StatusNotification;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class MailPlugin
extends ImmoToolProjectPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailPlugin.class);
    private static final I18n I18N = I18nFactory.getI18n(MailPlugin.class);
    public static final String ID = "OpenEstate-Tool-Mail";
    public static final String RESOURCE_PATH = "/com/openindex/openestate/tool/mail/resources/";
    private static DbMailExtension dbMailExtension = null;
    private static MailHandler mailHandler = null;
    private static MailAutoRetrievalTimer autoRetrievalTimer = null;
    private static MailMessageFoundListener messageFoundListener = null;

    public static synchronized void createAutoRetrievalTimer() {
        MailPlugin.stopAutoRetrievalTimer();
        autoRetrievalTimer = new MailAutoRetrievalTimer();
    }

    protected void doStart() throws Exception {
        if (System.getProperty("mail.mime.address.strict") == null) {
            System.setProperty("mail.mime.address.strict", "false");
        }
    }

    protected void doStop() throws Exception {
        MailPlugin.stopAutoRetrievalTimer();
    }

    public static Timer getAutoRetrievalTimer() {
        return autoRetrievalTimer;
    }

    public static DbMailExtension getDbMailExtension() {
        return dbMailExtension;
    }

    public String getDescription() {
        return I18N.tr("Management and storage of e-mails.");
    }

    public ImageIcon getIcon() {
        return new ImageIcon(MailPlugin.getResourceImage("mail_generic.png", 32));
    }

    public String getId() {
        return ID;
    }

    public static MailPlugin getInstance() {
        return (MailPlugin)ImmoToolEnvironment.getPlugin((String)ID);
    }

    public String getLicense() {
        return "Freeware";
    }

    public static MailHandler getMailHandler() {
        return mailHandler;
    }

    public ProjectPermission[] getPermissions() {
        return MailPermission.values();
    }

    public final String[] getRequiredProcedures() {
        return dbMailExtension != null ? dbMailExtension.getRequiredProcedures() : null;
    }

    public final String[] getRequiredViews() {
        return dbMailExtension != null ? dbMailExtension.getRequiredViews() : null;
    }

    public static Icon getResourceIcon(String string, int n) {
        return ImmoToolUtils.getResourceIcon((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)MailPlugin.class.getClassLoader());
    }

    public static Image getResourceImage(String string, int n) {
        return ImmoToolUtils.getResourceImage((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)MailPlugin.class.getClassLoader());
    }

    public static URL getResourceImageURL(String string, int n) {
        return ImmoToolUtils.getResourceImageURL((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)MailPlugin.class.getClassLoader());
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("e-mails"));
    }

    public String getUninstallQuery(String string) throws IOException {
        DbMailExtension dbMailExtension = MailPluginUtils.getDbMailExtension(string);
        if (dbMailExtension == null) {
            throw new IOException("Can't find a DbMailExtension for driver '" + string + "'!");
        }
        return dbMailExtension.getUninstallQuery();
    }

    public DbUpdateHandler getUpdateHandler(String string) {
        DbMailExtension dbMailExtension = MailPluginUtils.getDbMailExtension(string);
        if (dbMailExtension == null) {
            LOGGER.warn("Can't find a DbMailExtension for driver '" + string + "'!");
            return null;
        }
        return dbMailExtension.getUpdateHandler();
    }

    public void install(Connection connection, DbExtension dbExtension, String string, boolean bl) throws SQLException, IOException {
        DbMailExtension dbMailExtension = MailPluginUtils.getDbMailExtension(string);
        if (dbMailExtension == null) {
            throw new SQLException("Can't find a DbMailExtension for driver '" + string + "'!");
        }
        dbMailExtension.install(connection);
        super.install(connection, dbExtension, string, bl);
    }

    public boolean isAllowed(ImmoToolProject immoToolProject) {
        return MailPlugin.isUserAllowedTo(MailPermission.USE_PLUGIN, immoToolProject);
    }

    public boolean isUsable(ImmoToolProject immoToolProject) {
        return super.isUsable(immoToolProject) && this.isAllowed(immoToolProject);
    }

    public static boolean isUserAllowedTo(MailPermission mailPermission) {
        return MailPlugin.isUserAllowedTo(mailPermission, ImmoToolProject.getAppInstance());
    }

    public static boolean isUserAllowedTo(MailPermission mailPermission, ImmoToolProject immoToolProject) {
        if (immoToolProject == null) {
            return false;
        }
        DbUser dbUser = immoToolProject.getUser();
        return dbUser != null ? dbUser.isAllowedTo(ID, (ProjectPermission)mailPermission) : false;
    }

    public static void loadSettings(ImmoToolProject immoToolProject) throws SQLException, IOException {
    }

    public static void loadSettings(ImmoToolProject immoToolProject, Connection connection) throws SQLException, IOException {
    }

    public void repair(Connection connection, AbstractDbDriver abstractDbDriver) throws SQLException {
        MailPlugin.getDbMailExtension().repair(connection, abstractDbDriver);
    }

    public static void saveSettings(ImmoToolProject immoToolProject) throws SQLException, IOException {
    }

    public static void saveSettings(ImmoToolProject immoToolProject, Connection connection) throws SQLException, IOException {
    }

    public static void setDbMailExtension(DbMailExtension dbMailExtension) {
        MailPlugin.dbMailExtension = dbMailExtension;
    }

    public static void setMailHandler(MailHandler mailHandler) {
        MailPlugin.mailHandler = mailHandler;
        if (MailPlugin.mailHandler != null) {
            messageFoundListener = new MailMessageFoundListener();
            MailPlugin.mailHandler.addCustomListener(messageFoundListener);
        } else {
            messageFoundListener = null;
        }
    }

    public static void startAutoRetrievalTimer() {
        MailPlugin.startAutoRetrievalTimer(-1);
    }

    public static void startAutoRetrievalTimer(int n) {
        if (autoRetrievalTimer != null) {
            autoRetrievalTimer.setInitialDelay(n >= 0 ? n : autoRetrievalTimer.getDelay());
            autoRetrievalTimer.start();
        }
    }

    public static void stopAutoRetrievalTimer() {
        if (autoRetrievalTimer != null) {
            autoRetrievalTimer.stop();
        }
    }

    public static void unloadSettings() {
    }

    public static final class SidebarSelectAction
    extends AbstractI18nAction {
        public SidebarSelectAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon("mail_generic.png", 16));
            this.setEnabled(MailPlugin.isUserAllowedTo(MailPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolFrame immoToolFrame = (ImmoToolFrame)ImmoToolApp.getInstance().getFrame();
            if (immoToolFrame != null) {
                immoToolFrame.selectSidebar(MailFrameSidebarExtension.class);
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show e-mail view")));
            this.setShortDescription(I18N.tr("Show e-mail view in the sidebar."));
        }
    }

    private static final class SidebarRefreshTask
    extends ImmoToolTask<Boolean, Void> {
        private final MailHandler mailHandler;

        public SidebarRefreshTask(MailHandler mailHandler) {
            this.mailHandler = mailHandler;
        }

        protected Boolean doInBackground() throws Exception {
            this.mailHandler.loadAccounts();
            return true;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't refresh sidebar!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            this.mailHandler.loadRemoteAccountsInBackground();
        }
    }

    public static final class SidebarRefreshAction
    extends AbstractI18nAction {
        public SidebarRefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.setEnabled(MailPlugin.isUserAllowedTo(MailPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailHandler mailHandler = MailPlugin.getMailHandler();
            if (mailHandler != null) {
                ImmoToolUtils.executeTask((ImmoToolTask)new SidebarRefreshTask(mailHandler));
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Refresh e-mail view in the sidebar."));
        }
    }

    public static final class MessageWriteAction
    extends AbstractI18nAction {
        private final long folderId;

        public MessageWriteAction() {
            this(0L);
        }

        public MessageWriteAction(long l) {
            this.folderId = l;
            this.setSmallIcon(MailPlugin.getResourceIcon("mail_new.png", 16));
            this.setEnabled(MailPlugin.isUserAllowedTo(MailPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailWritePanel mailWritePanel = MailWritePanel.createTab();
            ImmoToolAppUtils.showTab((AbstractMainTab)mailWritePanel);
            mailWritePanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("compose e-mail")));
            this.setShortDescription(I18N.tr("Compose a new e-mail."));
        }
    }

    public static final class MessageLookupAction
    extends AbstractI18nAction {
        private final long accountId;

        public MessageLookupAction() {
            this(0L);
        }

        public MessageLookupAction(long l) {
            this.accountId = l;
            this.setSmallIcon(MailPlugin.getResourceIcon("mail_get.png", 16));
            this.setEnabled(MailPlugin.isUserAllowedTo(MailPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailHandler mailHandler = MailPlugin.getMailHandler();
            DbMailAccount dbMailAccount = this.accountId > 0L ? mailHandler.getAccount(this.accountId) : null;
            mailHandler.lookForNewMessagesInBackground(dbMailAccount);
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("retrieve e-mails")));
            if (this.accountId > 0L) {
                this.setShortDescription(I18N.tr("Look for new messages in the selected mail account."));
            } else {
                this.setShortDescription(I18N.tr("Look for new messages in all mail accounts."));
            }
        }
    }

    private static final class MessageImportTask
    extends ImmoToolTaskContainer {
        private final File[] files;
        private final DbMailFolder destFolder;

        public MessageImportTask(File[] fileArray, DbMailFolder dbMailFolder) {
            this.files = fileArray;
            this.destFolder = dbMailFolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbMailAccountHandler dbMailAccountHandler = MailPlugin.getDbMailExtension().getAccountHandler();
            DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                DbMailAccount dbMailAccount = dbMailAccountHandler.getAccount(connection, this.destFolder.accountId);
                dbMailAccountHandler.loadAccountSettings(connection, dbMailAccount);
                MailImportTask mailImportTask = new MailImportTask(connection, dbMailMessageHandler, this.destFolder, dbMailAccount);
                for (File file : this.files) {
                    if (file.isDirectory()) continue;
                    mailImportTask.addMessage(file);
                }
                this.add(mailImportTask);
                Boolean bl = super.doInBackground();
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't import messages!", (Throwable)throwable, (Window)this.getParentWindow());
        }
    }

    public static final class MessageImportAction
    extends AbstractI18nAction {
        private final long folderId;

        public MessageImportAction() {
            this(0L);
        }

        public MessageImportAction(long l) {
            this.folderId = l;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_import.png", (int)16));
            this.setEnabled(MailPlugin.isUserAllowedTo(MailPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DbMailFolder dbMailFolder;
            MailHandler mailHandler = MailPlugin.getMailHandler();
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file == null || !file.exists()) {
                        return false;
                    }
                    return file.isDirectory() || StringUtils.endsWithIgnoreCase((CharSequence)file.getName(), (CharSequence)".eml") || StringUtils.endsWithIgnoreCase((CharSequence)file.getName(), (CharSequence)".txt");
                }

                @Override
                public String getDescription() {
                    return "*.eml, *.txt";
                }
            });
            jFileChooser.setMultiSelectionEnabled(true);
            int n = jFileChooser.showOpenDialog((Component)ImmoToolEnvironment.getFrame());
            if (n != 0) {
                return;
            }
            Object[] objectArray = jFileChooser.getSelectedFiles();
            if (ArrayUtils.isEmpty((Object[])objectArray)) {
                return;
            }
            if (this.folderId > 0L) {
                dbMailFolder = mailHandler.getFolder(this.folderId);
                if (dbMailFolder == null) {
                    LOGGER.warn("Can't find folder #" + this.folderId);
                    return;
                }
            } else {
                dbMailFolder = MailFolderDialog.showDialog(StringUtils.capitalize((String)I18N.tr("import e-mail")), I18N.tr("Please select a folder, where the imported e-mails shall be stored."), mailHandler, (Window)ImmoToolEnvironment.getFrame());
                if (dbMailFolder == null) {
                    return;
                }
            }
            ImmoToolTaskDialog.showDialog((ImmoToolTask)new MessageImportTask((File[])objectArray, dbMailFolder), (Window)ImmoToolEnvironment.getFrame());
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("import e-mail")));
            this.setShortDescription(I18N.tr("Import an e-mail from a file."));
        }
    }

    private static class MailMessageFolderLink
    extends ActionLink {
        public MailMessageFolderLink(long l, String string) {
            super(string, (ActionListener)((Object)new FolderViewAction(l, false, true)));
        }
    }

    private static class MailMessageFoundListener
    extends MailHandlerAdapter {
        private final JPanel panel;
        private StatusNotification notification;
        private final Map<Long, DbMailAccount> accounts = new HashMap<Long, DbMailAccount>();
        private final Map<Long, DbMailFolder> folders = new HashMap<Long, DbMailFolder>();
        private final Map<Long, Integer> folderCounter = new HashMap<Long, Integer>();

        public MailMessageFoundListener() {
            this.panel = new JPanel(new BorderLayout());
            this.panel.setOpaque(false);
            this.notification = null;
        }

        @Override
        public void messageWasFound(DbMailMessage dbMailMessage) {
            boolean bl;
            if (dbMailMessage.isSeen) {
                return;
            }
            DbMailFolder dbMailFolder = MailPlugin.getMailHandler().getFolder(dbMailMessage.folderId);
            if (dbMailFolder == null) {
                LOGGER.warn("Unknown mail folder #" + dbMailMessage.folderId);
                return;
            }
            DbMailAccount dbMailAccount = MailPlugin.getMailHandler().getAccount(dbMailFolder.accountId);
            if (dbMailAccount == null) {
                LOGGER.warn("Unknown mail account #" + dbMailFolder.accountId);
                return;
            }
            boolean bl2 = bl = this.notification == null || !ImmoToolEnvironment.isStatusNotificationShown((StatusNotification)this.notification);
            if (bl) {
                this.accounts.clear();
                this.folders.clear();
                this.folderCounter.clear();
                this.notification = new StatusNotification((JComponent)this.panel, MailPlugin.getResourceIcon("mail_generic.png", 32));
            }
            if (!this.accounts.containsKey(dbMailAccount.id)) {
                this.accounts.put(dbMailAccount.id, dbMailAccount);
            }
            if (!this.folders.containsKey(dbMailFolder.id)) {
                this.folders.put(dbMailFolder.id, dbMailFolder);
            }
            if (!this.folderCounter.containsKey(dbMailFolder.id)) {
                this.folderCounter.put(dbMailFolder.id, 1);
            } else {
                this.folderCounter.put(dbMailFolder.id, this.folderCounter.get(dbMailFolder.id) + 1);
            }
            this.rebuild();
            ImmoToolEnvironment.showStatusNotification((StatusNotification)this.notification);
        }

        private void rebuild() {
            JPanel jPanel = new JPanel(new GridLayout(0, 1));
            jPanel.setOpaque(false);
            for (DbMailAccount dbMailAccount : new TreeSet<DbMailAccount>(this.accounts.values())) {
                jPanel.add(new JLabel("<html><b>" + StringUtils.capitalize((String)I18N.tr("mail account")) + " '" + StringEscapeUtils.escapeXml11((String)dbMailAccount.writeName()) + "'</b></html>"));
                for (DbMailFolder dbMailFolder : new TreeSet<DbMailFolder>(this.folders.values())) {
                    if (dbMailFolder.accountId != dbMailAccount.id) continue;
                    int n = this.folderCounter.get(dbMailFolder.id);
                    jPanel.add((Component)((Object)new MailMessageFolderLink(dbMailFolder.id, "<html>" + I18N.trn("has {0} new message in folder {1}", "has {0} new messages in folder {1}", (long)n, (Object)n, (Object)("<b>" + dbMailFolder.name + "</b>")) + "</html>")));
                }
            }
            this.panel.removeAll();
            this.panel.add((Component)jPanel, "Center");
            this.panel.revalidate();
            this.panel.repaint();
        }
    }

    public static final class FolderViewAction
    extends AbstractI18nAction {
        private final long folderId;
        private boolean reloadRemotely;
        private boolean asNewTab;

        public FolderViewAction(long l) {
            this(l, false, false);
        }

        public FolderViewAction(long l, boolean bl) {
            this(l, bl, false);
        }

        public FolderViewAction(long l, boolean bl, boolean bl2) {
            this.folderId = l;
            this.reloadRemotely = bl;
            this.asNewTab = bl2;
            this.setSmallIcon(MailPlugin.getResourceIcon("mail_generic.png", 16));
            this.setEnabled(MailPlugin.isUserAllowedTo(MailPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractMainTab abstractMainTab;
            if (this.folderId < 1L) {
                return;
            }
            MailHandler mailHandler = MailPlugin.getMailHandler();
            DbMailFolder dbMailFolder = mailHandler.getFolder(this.folderId);
            if (dbMailFolder == null || !dbMailFolder.holdsMessages) {
                return;
            }
            AbstractMainTab abstractMainTab2 = abstractMainTab = !this.asNewTab ? ImmoToolAppUtils.getMatchingTab(MailTablePanel.class) : null;
            if (abstractMainTab instanceof MailTablePanel) {
                MailTablePanel mailTablePanel = (MailTablePanel)abstractMainTab;
                if (mailTablePanel.getCurrentFolderId() != this.folderId) {
                    mailTablePanel.setFolder(dbMailFolder, mailHandler);
                    mailTablePanel.doRefresh();
                }
                ImmoToolAppUtils.selectTab((Component)((Object)mailTablePanel));
            } else {
                MailTablePanel mailTablePanel = MailTablePanel.createTab(dbMailFolder);
                mailTablePanel.doRefresh();
                ImmoToolAppUtils.showTab((AbstractMainTab)mailTablePanel);
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show e-mails")));
            this.setShortDescription(I18N.tr("Show e-mails in the selected folder."));
        }
    }

    public static final class FolderRenameAction
    extends AbstractI18nAction {
        private final long folderId;
        private final String newName;

        public FolderRenameAction(long l) {
            this(l, null);
        }

        public FolderRenameAction(long l, String string) {
            this.folderId = l;
            this.newName = string;
            this.setEnabled(MailPlugin.isUserAllowedTo(MailPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            String string2;
            if (this.folderId < 1L) {
                return;
            }
            MailHandler mailHandler = MailPlugin.getMailHandler();
            DbMailFolder dbMailFolder = mailHandler.getFolder(this.folderId);
            if (dbMailFolder == null || dbMailFolder.parentFolderId < 1L) {
                return;
            }
            String string3 = string2 = this.newName != null ? this.newName : ImmoToolUtils.showInputDialog((String)I18N.tr("Please enter a name for the e-mail folder."), (String)StringUtils.trimToEmpty((String)dbMailFolder.name), (Component)ImmoToolEnvironment.getFrame());
            if (StringUtils.isBlank((CharSequence)string2)) {
                return;
            }
            try {
                string = mailHandler.getFolderSeparator(dbMailFolder.accountId);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load folder separator!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                string = "/";
            }
            String string4 = "_".equals(string) ? "-" : "_";
            string2 = StringUtils.replace((String)string2, (String)string, (String)string4).trim();
            DbMailFolder dbMailFolder2 = dbMailFolder.parentFolder.getSubFolder(string2);
            if (dbMailFolder2 != null) {
                ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("A mail folder with the name {0} already exists!", (Object)('\"' + string2 + '\"')), (Component)ImmoToolEnvironment.getFrame());
                return;
            }
            mailHandler.renameFolderInBackground(dbMailFolder, string2);
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("rename folder")));
            this.setShortDescription(I18N.tr("Change the name of the selected e-mail folder."));
        }
    }

    public static final class FolderRemoveAction
    extends AbstractI18nAction {
        private final long folderId;

        public FolderRemoveAction(long l) {
            this.folderId = l;
            this.setEnabled(MailPlugin.isUserAllowedTo(MailPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.folderId < 1L) {
                return;
            }
            MailHandler mailHandler = MailPlugin.getMailHandler();
            DbMailFolder dbMailFolder = mailHandler.getFolder(this.folderId);
            if (dbMailFolder == null) {
                return;
            }
            String string = "<html><b>" + I18N.tr("Do you really want to remove mail folder {0}?", (Object)('\"' + StringEscapeUtils.escapeXml11((String)dbMailFolder.name) + '\"')) + "</b><br>" + I18N.tr("All messages within the folder will get lost!") + "</html>";
            if (!ImmoToolUtils.showQuestionDialog((String)string, (Component)ImmoToolEnvironment.getFrame())) {
                return;
            }
            mailHandler.removeFolderInBackground(dbMailFolder);
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove folder")));
            this.setShortDescription(I18N.tr("Remove the selected e-mail folder from the mailbox."));
        }
    }

    public static final class FolderAddAction
    extends AbstractI18nAction {
        private final long parentFolderId;
        private final String name;

        public FolderAddAction(long l) {
            this(l, null);
        }

        public FolderAddAction(long l, String string) {
            this.parentFolderId = l;
            this.name = string;
            this.setEnabled(MailPlugin.isUserAllowedTo(MailPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            String string2;
            if (this.parentFolderId < 1L) {
                return;
            }
            MailHandler mailHandler = MailPlugin.getMailHandler();
            DbMailFolder dbMailFolder = mailHandler.getFolder(this.parentFolderId);
            if (dbMailFolder == null) {
                return;
            }
            String string3 = string2 = this.name != null ? this.name : ImmoToolUtils.showInputDialog((String)I18N.tr("Please enter a name for the e-mail folder."), (Component)ImmoToolEnvironment.getFrame());
            if (StringUtils.isBlank((CharSequence)string2)) {
                return;
            }
            try {
                string = mailHandler.getFolderSeparator(dbMailFolder.accountId);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load folder separator!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                string = "/";
            }
            String string4 = "_".equals(string) ? "-" : "_";
            string2 = StringUtils.replace((String)string2, (String)string, (String)string4).trim();
            DbMailFolder dbMailFolder2 = dbMailFolder.getSubFolder(string2);
            if (dbMailFolder2 != null) {
                ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("A mail folder with the name {0} already exists!", (Object)('\"' + string2 + '\"')), (Component)ImmoToolEnvironment.getFrame());
                return;
            }
            mailHandler.addFolderInBackground(string2, dbMailFolder);
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("add folder")));
            this.setShortDescription(I18N.tr("Add a new folder into the e-mail account."));
        }
    }

    public static final class AccountSetupAction
    extends AbstractI18nAction {
        private final long selectedAccountId;

        public AccountSetupAction() {
            this(0L);
        }

        public AccountSetupAction(long l) {
            this.selectedAccountId = l;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"configure.png", (int)16));
            this.setEnabled(MailPlugin.isUserAllowedTo(MailPermission.ACCOUNTS_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailAccountDialog.SubmitTask submitTask;
            final ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (immoToolProject == null) {
                return;
            }
            DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
            final MailProjectExtension mailProjectExtension = new MailProjectExtension();
            final MailHandler mailHandler = MailPlugin.getMailHandler();
            try {
                mailProjectExtension.close(immoToolProject);
            }
            catch (Exception exception) {
                LOGGER.error("Can't close mail environment!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't close mail environment!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
                return;
            }
            try {
                submitTask = MailAccountDialog.showDialog(this.selectedAccountId, dbMailExtension, immoToolProject, (Window)ImmoToolEnvironment.getFrame());
            }
            catch (Exception exception) {
                LOGGER.error("Can't open mail dialog!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't open mail dialog!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
                return;
            }
            if (submitTask == null) {
                try {
                    mailProjectExtension.open(immoToolProject, mailHandler);
                    mailProjectExtension.openFinished(immoToolProject);
                }
                catch (Exception exception) {
                    LOGGER.error("Can't load mail environment!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    ImmoToolUtils.showMessageErrorDialog((String)"Can't load mail environment!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
                }
            } else {
                submitTask.addListener((ImmoToolTask.Listener)new ImmoToolTask.Adapter(){

                    public void taskFinished(long l) {
                        try {
                            mailProjectExtension.open(immoToolProject, mailHandler);
                            mailProjectExtension.openFinished(immoToolProject);
                        }
                        catch (Exception exception) {
                            LOGGER.error("Can't load mail environment!");
                            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                            ImmoToolUtils.showMessageErrorDialog((String)"Can't load mail environment!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
                        }
                    }
                });
                ImmoToolUtils.executeTask((ImmoToolTask)submitTask);
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("setup mail accounts")));
            this.setShortDescription(I18N.tr("Edit the managed e-mail accounts."));
        }
    }

    private static final class AccountImportTask
    extends ImmoToolTask<DbMailAccount[], Void> {
        private AccountImportTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbMailAccount[] doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbMailAccountHandler dbMailAccountHandler = MailPlugin.getDbMailExtension().getAccountHandler();
            Connection connection = null;
            try {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setMultiSelectionEnabled(true);
                int n = jFileChooser.showOpenDialog((Component)ImmoToolEnvironment.getFrame());
                if (n != 0) {
                    DbMailAccount[] dbMailAccountArray = null;
                    return dbMailAccountArray;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (File file : jFileChooser.getSelectedFiles()) {
                    Properties properties = new Properties();
                    try (Object object = new FileInputStream(file);){
                        properties.load((InputStream)object);
                    }
                    object = new DbMailAccount();
                    ((DbMailAccount)object).load(properties);
                    connection = immoToolProject.getDbConnection();
                    dbMailAccountHandler.saveAccount(connection, (DbMailAccount)object);
                    arrayList.add(object);
                }
                Comparable<File>[] comparableArray = arrayList.toArray(new DbMailAccount[0]);
                return comparableArray;
            }
            finally {
                JdbcUtils.closeQuietly(connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't import e-mail accounts!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(DbMailAccount[] dbMailAccountArray) {
            super.succeeded((Object)dbMailAccountArray);
            if (ArrayUtils.isEmpty((Object[])dbMailAccountArray)) {
                return;
            }
            new SidebarRefreshAction().actionPerformed(null);
            ImmoToolUtils.showMessageInfoDialog((String)I18N.trn("{0} mail account was imported.", "{0} mail accounts were imported.", (long)dbMailAccountArray.length, (Object)dbMailAccountArray.length), (Component)ImmoToolEnvironment.getFrame());
        }
    }

    public static final class AccountImportAction
    extends AbstractI18nAction {
        public AccountImportAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_import.png", (int)16));
            this.setEnabled(MailPlugin.isUserAllowedTo(MailPermission.ACCOUNTS_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new AccountImportTask());
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("import mail account")));
            this.setShortDescription(I18N.tr("Import previously saved e-mail accounts."));
        }
    }

    private static final class AccountExportTask
    extends ImmoToolTask<File, Void> {
        private final long accountId;

        public AccountExportTask(long l) {
            this.accountId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected File doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbMailAccountHandler dbMailAccountHandler = MailPlugin.getDbMailExtension().getAccountHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                DbMailAccount dbMailAccount = dbMailAccountHandler.getAccount(connection, this.accountId);
                if (dbMailAccount == null) {
                    throw new Exception("Can't find e-mail account #" + this.accountId + "!");
                }
                dbMailAccountHandler.loadAccountSettings(connection, dbMailAccount);
                connection.close();
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setSelectedFile(new File("account-" + dbMailAccount.id + ".properties"));
                int n = jFileChooser.showSaveDialog((Component)ImmoToolEnvironment.getFrame());
                if (n != 0) {
                    File file = null;
                    return file;
                }
                File file = jFileChooser.getSelectedFile();
                Properties properties = new Properties();
                dbMailAccount.save(properties);
                try (Object object = new FileOutputStream(file);){
                    properties.store((OutputStream)object, "exported mail account");
                    ((OutputStream)object).flush();
                }
                object = file;
                return object;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't export e-mail account!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(File file) {
            super.succeeded((Object)file);
            if (file == null) {
                return;
            }
            ImmoToolUtils.showMessageInfoDialog((String)I18N.tr("The mail account was exported successfully."), (Component)ImmoToolEnvironment.getFrame());
        }
    }

    public static final class AccountExportAction
    extends AbstractI18nAction {
        private final long accountId;

        public AccountExportAction(long l) {
            this.accountId = l;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16));
            this.setEnabled(MailPlugin.isUserAllowedTo(MailPermission.ACCOUNTS_EXPORT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.accountId < 1L) {
                return;
            }
            ImmoToolUtils.executeTask((ImmoToolTask)new AccountExportTask(this.accountId));
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("export e-mail account")));
            this.setShortDescription(I18N.tr("Export the selected e-mail account into a file."));
        }
    }
}

