/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskContainer;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.gui.AbstractMainTable;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.mail.MailEditor;
import com.openindex.openestate.tool.mail.MailFrameSidebarExtension;
import com.openindex.openestate.tool.mail.MailHandler;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.MailTable;
import com.openindex.openestate.tool.mail.MailViewPanel;
import com.openindex.openestate.tool.mail.MailWritePanel;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import com.openindex.openestate.tool.mail.extensions.MailHandlerAdapter;
import com.openindex.openestate.tool.mail.extensions.MailHandlerExtension;
import com.openindex.openestate.tool.mail.extensions.MailTableExtension;
import com.openindex.openestate.tool.mail.utils.MailExportTask;
import com.openindex.openestate.tool.mail.utils.MailFolderDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class MailTablePanel
extends AbstractMainTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailTablePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(MailTablePanel.class);
    private static final String TABLE_ID = "MailTablePanel.Table";
    private long currentAccountId = 0L;
    private String currentAccountName = null;
    private long currentFolderId = 0L;
    private String currentFolderName = null;
    private DbMailFolder.SpecialType currentFolderSpecialType = null;
    private JSplitPane mainSplitter;
    private Table table;
    private JPanel mailViewContainerPanel;
    private MailViewPanel mailViewPanel;
    private final transient MailHandlerExtension mailListener;
    private AbstractI18nAction refreshAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;

    private MailTablePanel() {
        this.updateLocalization();
        this.mailListener = new MailListener();
        MailPlugin.getMailHandler().addCustomListener(this.mailListener);
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.refreshAction = this.createDefaultRefreshAction();
        this.closeAction = this.createDefaultCloseAction();
        this.showActionsAction = this.createDefaultShowActionsAction(MailPlugin.getResourceIcon("mail_generic.png", 16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.refreshAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected JComponent buildMainComponent() {
        this.mailViewPanel = MailViewPanel.createTab();
        this.mailViewPanel.setCloseHandler(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MailTablePanel.this.table.clearSelection();
                MailTablePanel.this.mailViewContainerPanel.setVisible(false);
            }
        });
        this.mailViewContainerPanel = new JPanel();
        this.mailViewContainerPanel.setLayout(new BorderLayout());
        this.mailViewContainerPanel.add((Component)((Object)this.mailViewPanel), "Center");
        this.mailViewContainerPanel.setVisible(false);
        this.mainSplitter = new JSplitPane(0);
        this.mainSplitter.setTopComponent(((Table)this.createTable()).createScrollPane());
        this.mainSplitter.setBottomComponent(this.mailViewContainerPanel);
        return this.mainSplitter;
    }

    public static MailTablePanel createTab(DbMailFolder dbMailFolder) {
        MailTablePanel mailTablePanel = new MailTablePanel();
        mailTablePanel.setFolder(dbMailFolder);
        return mailTablePanel;
    }

    protected JXTable createTable() {
        this.table = new Table();
        this.table.setDragEnabled(true);
        this.table.setTransferHandler(new TableTransferHandler());
        return this.table;
    }

    protected void doLoadInBackground(Connection connection) throws Exception {
        this.doLoadInBackground(connection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadInBackground(Connection connection, boolean bl) throws Exception {
        if (!this.table.isEnabled()) {
            return;
        }
        int n = this.table.getSortedColumnIndex();
        SortOrder sortOrder = this.table.getSortOrder(n);
        this.table.setEnabled(false);
        this.table.clearSelection();
        this.table.clearRows();
        AbstractTable.Model model = this.table.newModel();
        try {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
            DbMailFolder dbMailFolder = this.getCurrentFolder();
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            DbMailMessage[] dbMailMessageArray = dbMailFolder != null ? dbMailMessageHandler.getMessagesFromFolder(connection, dbMailFolder.id) : new DbMailMessage[]{};
            for (DbMailMessage object : dbMailMessageArray) {
                if (!hashMap.containsKey(object.mimeId)) {
                    hashMap.put(object.mimeId, object.id);
                }
                model.addRow((AbstractTable.Row)new MailTable.Row(object));
            }
            for (MailTableExtension mailTableExtension : this.table.getAddons()) {
                try {
                    mailTableExtension.load(immoToolProject, connection, dbMailFolder);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load mail-table-extension!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(model, n, sortOrder, bl){
                final /* synthetic */ AbstractTable.Model val$model;
                final /* synthetic */ int val$sortedColumnIndex;
                final /* synthetic */ SortOrder val$sortedColumnOrder;
                final /* synthetic */ boolean val$doRemoteLookup;
                {
                    this.val$model = model;
                    this.val$sortedColumnIndex = n;
                    this.val$sortedColumnOrder = sortOrder;
                    this.val$doRemoteLookup = bl;
                }

                @Override
                public void run() {
                    try {
                        MailTablePanel.this.table.setModel((TableModel)this.val$model);
                    }
                    finally {
                        MailTablePanel.this.table.setEnabled(true);
                        if (this.val$sortedColumnIndex > -1) {
                            MailTablePanel.this.table.setSortOrder(this.val$sortedColumnIndex, this.val$sortedColumnOrder);
                        }
                        if (this.val$doRemoteLookup) {
                            MailPlugin.getMailHandler().loadRemoteMessagesInBackground(MailTablePanel.this.getCurrentFolder());
                        }
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void doMailCopy() {
        MailHandler mailHandler = MailPlugin.getMailHandler();
        long[] lArray = this.getSelectedMessageIds();
        if (ArrayUtils.isEmpty((long[])lArray)) {
            return;
        }
        DbMailFolder dbMailFolder = MailFolderDialog.showDialog(this.currentFolderId, StringUtils.capitalize((String)I18N.tr("copy messages")), I18N.tr("In which folder do you want to copy the selected messages?"), mailHandler, (Window)ImmoToolEnvironment.getFrame());
        if (dbMailFolder == null) {
            return;
        }
        if (this.currentFolderId == dbMailFolder.id) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The messages are already assigned to the selected folder!"), (Component)((Object)this));
            return;
        }
        this.table.clearSelection();
        mailHandler.copyMessagesInBackground(lArray, dbMailFolder);
    }

    private void doMailEdit() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        long l = this.table.getMessageIdAt(this.table.convertRowIndexToModel(n));
        MailWritePanel mailWritePanel = MailWritePanel.createTab(MailEditor.ViewMode.DRAFT, l);
        ImmoToolAppUtils.showTab((AbstractMainTab)mailWritePanel);
        mailWritePanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
    }

    private void doMailExport() {
        long[] lArray = this.getSelectedMessageIds();
        if (ArrayUtils.isEmpty((long[])lArray)) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        if (lArray.length > 1) {
            jFileChooser.setDialogTitle(I18N.tr("Select a directory for export."));
            jFileChooser.setFileSelectionMode(1);
        } else {
            jFileChooser.setDialogTitle(I18N.tr("Select a file for export."));
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file == null) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.isFile() && file.getName().toLowerCase().endsWith(".eml");
                }

                @Override
                public String getDescription() {
                    return "*.eml";
                }
            });
            Long l = lArray[0];
            jFileChooser.setSelectedFile(new File("message-" + l + ".eml"));
        }
        int n = jFileChooser.showSaveDialog((Component)((Object)this));
        if (n != 0) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new MailExportContainerTask(lArray, jFileChooser.getSelectedFile()));
    }

    private void doMailForward() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        long l = this.table.getMessageIdAt(this.table.convertRowIndexToModel(n));
        MailWritePanel mailWritePanel = MailWritePanel.createTab(MailEditor.ViewMode.FORWARD, l);
        ImmoToolAppUtils.showTab((AbstractMainTab)mailWritePanel);
        mailWritePanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
    }

    private void doMailMove() {
        MailHandler mailHandler = MailPlugin.getMailHandler();
        long[] lArray = this.getSelectedMessageIds();
        if (ArrayUtils.isEmpty((long[])lArray)) {
            return;
        }
        DbMailFolder dbMailFolder = MailFolderDialog.showDialog(this.currentFolderId, StringUtils.capitalize((String)I18N.tr("move messages")), I18N.tr("In which folder do you want to move the selected messages?"), mailHandler, (Window)ImmoToolEnvironment.getFrame());
        if (dbMailFolder == null) {
            return;
        }
        if (this.currentFolderId == dbMailFolder.id) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The messages are already assigned to the selected folder!"), (Component)((Object)this));
            return;
        }
        this.table.clearSelection();
        mailHandler.moveMessagesInBackground(lArray, dbMailFolder);
    }

    private void doMailOpen() {
        this.showMesage(this.table.getSelectedRow(), true);
    }

    private void doMailRemove() {
        MailHandler mailHandler = MailPlugin.getMailHandler();
        long[] lArray = this.getSelectedMessageIds();
        if (ArrayUtils.isEmpty((long[])lArray)) {
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove the selected messages?"), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.table.clearSelection();
        mailHandler.removeMessagesInBackground(lArray);
    }

    private void doMailReply() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        long l = this.table.getMessageIdAt(this.table.convertRowIndexToModel(n));
        MailWritePanel mailWritePanel = MailWritePanel.createTab(MailEditor.ViewMode.REPLY, l);
        ImmoToolAppUtils.showTab((AbstractMainTab)mailWritePanel);
        mailWritePanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
    }

    private void doMailSetArchived(boolean bl) {
        if (!this.table.isEnabled() || this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.table.getSelectedRows()) {
            int n2 = this.table.convertRowIndexToModel(n);
            long l = this.table.getMessageIdAt(n2);
            boolean bl2 = this.table.isArchivedAt(n2);
            if (bl2 == bl) continue;
            if (!bl) {
                MailTableExtension mailTableExtension;
                boolean bl3 = true;
                MailTableExtension[] mailTableExtensionArray = this.table.getAddons();
                int n3 = mailTableExtensionArray.length;
                for (int i = 0; i < n3 && (bl3 = (mailTableExtension = mailTableExtensionArray[i]).canUnarchiveMessage(l)); ++i) {
                }
                if (!bl3) continue;
            }
            arrayList.add(l);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new MailSetArchivedTask(ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0])), bl));
    }

    private void doMailSetSeen(boolean bl) {
        if (!this.table.isEnabled() || this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.table.getSelectedRows()) {
            boolean bl2;
            int n2 = this.table.convertRowIndexToModel(n);
            long l = this.table.getMessageIdAt(n2);
            boolean bl3 = bl2 = !this.table.isUnreadAt(n2);
            if (bl2 == bl) continue;
            arrayList.add(l);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new MailSetSeenTask(ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0])), bl));
    }

    public void doRefresh() {
        this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
    }

    protected void doShowActions(Component component, int n, int n2) {
        int n3 = this.table.getSelectedRow();
        if (n3 < 0) {
            return;
        }
        boolean bl = this.table.isDraftAt(this.table.convertRowIndexToModel(n3));
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (int n4 : this.table.getSelectedRows()) {
            int n5;
            int n6 = this.table.convertRowIndexToModel(n4);
            long l = this.table.getMessageIdAt(n6);
            boolean bl6 = this.table.isArchivedAt(n6);
            int n7 = n5 = !this.table.isUnreadAt(n6) ? 1 : 0;
            if (n5 != 0 && !bl5) {
                bl5 = true;
            }
            if (n5 == 0 && !bl4) {
                bl4 = true;
            }
            if (!bl6 && !bl2) {
                bl2 = true;
            }
            if (bl6 && !bl3) {
                MailTableExtension mailTableExtension;
                int n8 = 1;
                MailTableExtension[] object2 = this.table.getAddons();
                int exception = object2.length;
                for (int i = 0; i < exception && (n8 = (mailTableExtension = object2[i]).canUnarchiveMessage(l)) != 0; ++i) {
                }
                if (n8 != 0) {
                    bl3 = true;
                }
            }
            if (bl2 && bl3 && bl4 && bl5) break;
        }
        Object object = new JMenu();
        ((AbstractButton)object).setText(StringUtils.capitalize((String)I18N.tr("change status")));
        ((JComponent)object).setToolTipText(I18N.tr("Modify status of the selected messages."));
        ((AbstractButton)object).setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
        JMenuItem jMenuItem = new JMenuItem((Action)((Object)new MailSetSeenAction(true)));
        jMenuItem.setEnabled(bl4);
        JMenuItem jMenuItem2 = new JMenuItem((Action)((Object)new MailSetSeenAction(false)));
        jMenuItem2.setEnabled(bl5);
        JMenuItem jMenuItem3 = new JMenuItem((Action)((Object)new MailSetArchivedAction(true)));
        jMenuItem3.setEnabled(bl2);
        JMenuItem jMenuItem4 = new JMenuItem((Action)((Object)new MailSetArchivedAction(false)));
        jMenuItem4.setEnabled(bl3);
        ((JMenu)object).add(jMenuItem);
        ((JMenu)object).add(jMenuItem2);
        ((JMenu)object).addSeparator();
        ((JMenu)object).add(jMenuItem3);
        ((JMenu)object).add(jMenuItem4);
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (bl) {
            jPopupMenu.add(new JMenuItem((Action)((Object)new MailEditAction())));
        } else {
            jPopupMenu.add(new JMenuItem((Action)((Object)new MailOpenAction())));
            jPopupMenu.add(new JMenuItem((Action)((Object)new MailReplyAction())));
            jPopupMenu.add(new JMenuItem((Action)((Object)new MailForwardAction())));
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem((Action)((Object)new MailCopyAction())));
        jPopupMenu.add(new JMenuItem((Action)((Object)new MailMoveAction())));
        jPopupMenu.add(new JMenuItem((Action)((Object)new MailExportAction())));
        jPopupMenu.addSeparator();
        long[] lArray = this.getSelectedMessageIds();
        for (MailTableExtension mailTableExtension : this.table.getAddons()) {
            try {
                Object[] objectArray = mailTableExtension.createActionMenuItems(lArray, this);
                if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
                for (Object object2 : objectArray) {
                    jPopupMenu.add((JMenuItem)object2);
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load message actions!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem((Action)((Object)new MailRemoveAction())));
        jPopupMenu.show(component, n, n2);
    }

    public long getCurrentAccountId() {
        return this.currentAccountId;
    }

    private DbMailFolder getCurrentFolder() {
        return this.currentFolderId > 0L ? MailPlugin.getMailHandler().getFolder(this.currentFolderId) : null;
    }

    public long getCurrentFolderId() {
        return this.currentFolderId;
    }

    protected Icon getHeaderIcon() {
        return this.currentFolderSpecialType != null ? this.currentFolderSpecialType.getIcon() : MailPlugin.getResourceIcon("folder.png", 32);
    }

    protected String getHeaderTitle() {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        int n = this.table != null ? this.table.getRowCount() : 0;
        int n2 = n > 0 && this.currentFolderId > 0L ? MailPlugin.getMailHandler().getUnseenMessageCount(this.currentFolderId) : 0;
        return StringUtils.capitalize((String)I18N.tr("e-mails")) + " | " + this.currentAccountName + " | " + this.currentFolderName + " | " + I18N.tr("{0} total", (Object)numberFormat.format(n)) + " | " + I18N.tr("{0} new", (Object)numberFormat.format(n2));
    }

    private long[] getSelectedMessageIds() {
        if (this.table.getSelectedRowCount() < 1) {
            return new long[0];
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.table.getSelectedRows()) {
            arrayList.add(this.table.getMessageIdAt(this.table.convertRowIndexToModel(n)));
        }
        return ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("e-mails"));
    }

    public String getTabToolTipText() {
        return I18N.tr("This tab contains the messages of mail folder {0}.", (Object)this.currentFolderName);
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.refreshAction.setEnabled(bl);
        this.closeAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl && this.table.getSelectedRowCount() > 0);
    }

    public void setFolder(long l) {
        MailHandler mailHandler = MailPlugin.getMailHandler();
        DbMailFolder dbMailFolder = mailHandler.getFolder(l);
        this.setFolder(dbMailFolder, mailHandler);
    }

    public void setFolder(DbMailFolder dbMailFolder) {
        this.setFolder(dbMailFolder, MailPlugin.getMailHandler());
    }

    public void setFolder(DbMailFolder dbMailFolder, MailHandler mailHandler) {
        if (mailHandler == null) {
            throw new NullPointerException("No mail handler was provided!");
        }
        if (dbMailFolder == null) {
            throw new NullPointerException("No folder was provided!");
        }
        if (!dbMailFolder.holdsMessages) {
            throw new IllegalArgumentException("Folder #" + dbMailFolder.id + " does not hold messages!");
        }
        if (this.currentFolderId == 0L || dbMailFolder.id == 0L || this.currentFolderId != dbMailFolder.id) {
            this.mailViewContainerPanel.setVisible(false);
        }
        DbMailAccount dbMailAccount = mailHandler.getAccount(dbMailFolder.accountId);
        this.currentAccountId = dbMailAccount.id;
        this.currentAccountName = dbMailAccount.writeName();
        this.currentFolderId = dbMailFolder.id;
        this.currentFolderName = dbMailFolder.name;
        this.currentFolderSpecialType = dbMailFolder.specialType;
        this.updateLocalization();
    }

    private void showMesage(int n, boolean bl) {
        if (n < 0) {
            if (bl) {
                this.mailViewContainerPanel.setVisible(false);
            }
            return;
        }
        int n2 = this.table.convertRowIndexToModel(n);
        long l = this.table.getMessageIdAt(n2);
        if (l < 1L) {
            return;
        }
        if (bl) {
            Object[] objectArray = ImmoToolAppUtils.getTabs(MailViewPanel.class);
            if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                for (Object object : objectArray) {
                    MailViewPanel mailViewPanel = (MailViewPanel)((Object)object);
                    if (l != mailViewPanel.getCurrentMessageLocalId()) continue;
                    ImmoToolAppUtils.selectTab((Component)((Object)mailViewPanel));
                    return;
                }
            }
        } else if (this.mailViewContainerPanel.isVisible() && l == this.mailViewPanel.getCurrentMessageLocalId()) {
            return;
        }
        this.table.setEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new ShowMessageTask(l, bl));
    }

    protected void updateLocalization() {
        super.updateLocalization();
    }

    private static class MailSetSeenTask
    extends ImmoToolTask<Boolean, Void> {
        private final long[] messageIds;
        private final boolean seen;

        public MailSetSeenTask(long[] lArray, boolean bl) {
            this.messageIds = lArray;
            this.seen = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            if (ArrayUtils.isEmpty((long[])this.messageIds)) {
                return false;
            }
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
            MailHandler mailHandler = MailPlugin.getMailHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                for (DbMailMessage dbMailMessage : dbMailMessageHandler.getMessages(connection, this.messageIds)) {
                    mailHandler.markMessageSeen(immoToolProject, connection, dbMailMessage, null, this.seen);
                }
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            String string = this.seen ? "Can't mark messages as seen!" : "Can't mark messages as unseen!";
            ImmoToolUtils.showMessageErrorDialog((String)string, (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private class MailSetSeenAction
    extends AbstractI18nAction {
        private final boolean seen;

        public MailSetSeenAction(boolean bl) {
            this.seen = bl;
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailTablePanel.this.doMailSetSeen(this.seen);
        }

        protected void updateLocalization() {
            if (this.seen) {
                this.setName(StringUtils.capitalize((String)I18N.tr("seen")));
                this.setShortDescription(I18N.tr("Tag the selected e-mails as \"seen\"."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("unseen")));
                this.setShortDescription(I18N.tr("Tag the selected e-mails as \"unseen\"."));
            }
        }
    }

    private static class MailSetArchivedTask
    extends ImmoToolTask<Boolean, Void> {
        private final long[] messageIds;
        private final boolean archived;

        public MailSetArchivedTask(long[] lArray, boolean bl) {
            this.messageIds = lArray;
            this.archived = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            if (ArrayUtils.isEmpty((long[])this.messageIds)) {
                return false;
            }
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
            MailHandler mailHandler = MailPlugin.getMailHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                for (DbMailMessage dbMailMessage : dbMailMessageHandler.getMessages(connection, this.messageIds)) {
                    mailHandler.markMessageArchived(immoToolProject, connection, dbMailMessage, null, this.archived);
                }
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            String string = this.archived ? "Can't mark messages as archived!" : "Can't mark messages as unarchived!";
            ImmoToolUtils.showMessageErrorDialog((String)string, (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private class MailSetArchivedAction
    extends AbstractI18nAction {
        private final boolean archived;

        public MailSetArchivedAction(boolean bl) {
            this.archived = bl;
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailTablePanel.this.doMailSetArchived(this.archived);
        }

        protected void updateLocalization() {
            if (this.archived) {
                this.setName(StringUtils.capitalize((String)I18N.tr("add to archive")));
                this.setShortDescription(I18N.tr("Archive the selected messages into the database."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("remove from archive")));
                this.setShortDescription(I18N.tr("Remove the selected messages from the archive."));
            }
        }
    }

    private class MailReplyAction
    extends AbstractI18nAction {
        public MailReplyAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon("mail_reply.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailTablePanel.this.doMailReply();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("reply")));
            this.setShortDescription(I18N.tr("Reply to the selected message."));
        }
    }

    private class MailRemoveAction
    extends AbstractI18nAction {
        public MailRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailTablePanel.this.doMailRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove")));
            this.setShortDescription(I18N.tr("Remove the selected messages."));
        }
    }

    private class MailOpenAction
    extends AbstractI18nAction {
        public MailOpenAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_open.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailTablePanel.this.doMailOpen();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("open")));
            this.setShortDescription(I18N.tr("Open the selected message."));
        }
    }

    private class MailMoveAction
    extends AbstractI18nAction {
        public MailMoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_right.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailTablePanel.this.doMailMove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("move")));
            this.setShortDescription(I18N.tr("Move the selected messages into another folder."));
        }
    }

    private class MailForwardAction
    extends AbstractI18nAction {
        public MailForwardAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon("mail_forward.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailTablePanel.this.doMailForward();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("forward")));
            this.setShortDescription(I18N.tr("Forward the selected message."));
        }
    }

    private static class MailExportContainerTask
    extends ImmoToolTaskContainer {
        private final long[] messageIds;
        private final File destinationFile;

        public MailExportContainerTask(long[] lArray, File file) {
            this.messageIds = lArray;
            this.destinationFile = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            if (ArrayUtils.isEmpty((long[])this.messageIds)) {
                return false;
            }
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                if (this.messageIds.length == 1) {
                    long l = this.messageIds[0];
                    this.add(new MailExportTask(connection, dbMailMessageHandler, l, this.destinationFile));
                } else {
                    for (long l : this.messageIds) {
                        File file = new File(this.destinationFile + File.separator + l + ".eml");
                        this.add(new MailExportTask(connection, dbMailMessageHandler, l, file));
                    }
                }
                Boolean bl = super.doInBackground();
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't export selected messages!", (Throwable)throwable, (Window)this.getParentWindow());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (Boolean.TRUE.equals(bl)) {
                ImmoToolUtils.showMessageInfoDialog((String)I18N.tr("The messages were successfully exported."), (Component)ImmoToolEnvironment.getFrame());
            }
        }
    }

    private class MailExportAction
    extends AbstractI18nAction {
        public MailExportAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailTablePanel.this.doMailExport();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("export")));
            this.setShortDescription(I18N.tr("Save the selected messages to harddisk."));
        }
    }

    private class MailEditAction
    extends AbstractI18nAction {
        public MailEditAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon("draft.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailTablePanel.this.doMailEdit();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("edit")));
            this.setShortDescription(I18N.tr("Edit the selected draft message."));
        }
    }

    private class MailCopyAction
    extends AbstractI18nAction {
        public MailCopyAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_copy.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailTablePanel.this.doMailCopy();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("copy")));
            this.setShortDescription(I18N.tr("Copy the selected messages into another folder."));
        }
    }

    private static class TableTransferHandler
    extends TransferHandler {
        private TableTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof Table) {
                Table table = (Table)((Object)jComponent);
                if (table.getSelectedRowCount() < 1) {
                    return null;
                }
                ArrayList<Long> arrayList = new ArrayList<Long>();
                for (int n : table.getSelectedRows()) {
                    int n2 = table.convertRowIndexToModel(n);
                    arrayList.add(table.getMessageIdAt(n2));
                }
                return new TableTransferable(arrayList.toArray(new Long[0]));
            }
            return null;
        }

        @Override
        public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
            super.exportAsDrag(jComponent, inputEvent, n);
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2 && jComponent instanceof Table) {
                Table table = (Table)((Object)jComponent);
                table.clearSelection();
            }
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 2;
        }
    }

    private static class TableTransferable
    implements Transferable {
        private final Long[] msgIds;

        public TableTransferable(Long[] longArray) {
            this.msgIds = longArray;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this.msgIds;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{MailFrameSidebarExtension.MAIL_MESSAGE_ID_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return MailFrameSidebarExtension.MAIL_MESSAGE_ID_FLAVOR.equals(dataFlavor);
        }
    }

    private class Table
    extends MailTable<MailTable.Row> {
        public Table() {
            super(MailTablePanel.TABLE_ID);
        }

        protected void doRemove() {
            MailTablePanel.this.doMailRemove();
        }

        protected void doSelect() {
            MailTablePanel.this.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
            if (this.getSelectedRowCount() == 1) {
                MailTablePanel.this.showMesage(this.getSelectedRow(), false);
            }
        }

        protected void doShowActions(int n, int n2) {
            MailTablePanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            MailTablePanel.this.doMailOpen();
        }
    }

    private class ShowMessageTask
    extends ImmoToolTask<DbMailMessage, Void> {
        private final long msgId;
        private final boolean asNewTab;

        public ShowMessageTask(long l, boolean bl) {
            this.msgId = l;
            this.asNewTab = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbMailMessage doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                DbMailMessage dbMailMessage = dbMailMessageHandler.getMessage(connection, this.msgId);
                if (dbMailMessage == null) {
                    throw new Exception("Can't find message #" + this.msgId + "!");
                }
                DbMailMessage dbMailMessage2 = dbMailMessage;
                return dbMailMessage2;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)("Can't load message #" + this.msgId + "!"), (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            MailTablePanel.this.table.setEnabled(true);
        }

        protected void succeeded(DbMailMessage dbMailMessage) {
            super.succeeded((Object)dbMailMessage);
            if (dbMailMessage == null) {
                return;
            }
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (this.asNewTab) {
                MailViewPanel mailViewPanel = MailViewPanel.createTab(dbMailMessage);
                ImmoToolAppUtils.showTab((AbstractMainTab)mailViewPanel);
                mailViewPanel.loadInBackground(immoToolProject.getDbDriver());
            } else {
                MailTablePanel.this.mailViewPanel.setMessage(dbMailMessage);
                MailTablePanel.this.mailViewContainerPanel.setVisible(true);
                MailTablePanel.this.mainSplitter.setDividerLocation(0.35);
                MailTablePanel.this.mailViewPanel.loadInBackground(immoToolProject.getDbDriver());
                MailTablePanel.this.table.scrollRowToVisible(MailTablePanel.this.table.getSelectedRow());
            }
        }
    }

    private class MailListener
    extends MailHandlerAdapter {
        private MailListener() {
        }

        @Override
        public void folderWasMoved(DbMailFolder dbMailFolder, long l, long l2) {
            if (dbMailFolder == null || dbMailFolder.id < 1L || MailTablePanel.this.currentFolderId != dbMailFolder.id) {
                return;
            }
            try {
                MailTablePanel.this.currentFolderName = dbMailFolder.name;
                MailTablePanel.this.currentFolderSpecialType = dbMailFolder.specialType;
                MailTablePanel.this.currentAccountName = MailPlugin.getMailHandler().getAccount(dbMailFolder.accountId).writeName();
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MailTablePanel.this.updateLocalization();
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.warn("Can't update table!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }

        @Override
        public void folderWasRemoved(long l) {
            if (l < 1L || MailTablePanel.this.currentFolderId != l) {
                return;
            }
            MailTablePanel.this.doClose(true);
        }

        @Override
        public void folderWasUpdated(DbMailFolder dbMailFolder) {
            if (dbMailFolder == null || dbMailFolder.id < 1L || MailTablePanel.this.currentFolderId != dbMailFolder.id) {
                return;
            }
            try {
                MailTablePanel.this.currentFolderName = dbMailFolder.name;
                MailTablePanel.this.currentFolderSpecialType = dbMailFolder.specialType;
                MailTablePanel.this.currentAccountName = MailPlugin.getMailHandler().getAccount(dbMailFolder.accountId).writeName();
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MailTablePanel.this.updateLocalization();
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.warn("Can't update table!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }

        @Override
        public void messageMarkedAnswered(DbMailMessage dbMailMessage) {
            if (dbMailMessage == null || MailTablePanel.this.currentFolderId != dbMailMessage.folderId) {
                return;
            }
            this.updateMessageRow(dbMailMessage);
        }

        @Override
        public void messageMarkedForwarded(DbMailMessage dbMailMessage) {
            if (dbMailMessage == null || MailTablePanel.this.currentFolderId != dbMailMessage.folderId) {
                return;
            }
            this.updateMessageRow(dbMailMessage);
        }

        @Override
        public void messageMarkedSeen(DbMailMessage dbMailMessage) {
            if (dbMailMessage == null || MailTablePanel.this.currentFolderId != dbMailMessage.folderId) {
                return;
            }
            this.updateMessageRow(dbMailMessage);
        }

        @Override
        public void messageWasAdded(final DbMailMessage dbMailMessage) {
            if (dbMailMessage == null || MailTablePanel.this.currentFolderId != dbMailMessage.folderId) {
                return;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MailTablePanel.this.table.addRow(new MailTable.Row(dbMailMessage));
                        MailTablePanel.this.updateLocalization();
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.warn("Can't update table!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }

        @Override
        public void messageWasFound(final DbMailMessage dbMailMessage) {
            if (dbMailMessage == null || MailTablePanel.this.currentFolderId != dbMailMessage.folderId) {
                return;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MailTablePanel.this.table.addRow(new MailTable.Row(dbMailMessage));
                        MailTablePanel.this.updateLocalization();
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.warn("Can't update table!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }

        @Override
        public void messageWasMoved(final DbMailMessage dbMailMessage, long l, final long l2) {
            if (dbMailMessage == null || MailTablePanel.this.currentFolderId != l && MailTablePanel.this.currentFolderId != l2) {
                return;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (MailTablePanel.this.currentFolderId == l2) {
                            MailTablePanel.this.table.addRow(new MailTable.Row(dbMailMessage));
                        } else {
                            int n = MailTablePanel.this.table.getRowForMessageId(dbMailMessage.id);
                            if (n > -1) {
                                MailTablePanel.this.table.removeRow(n);
                            }
                            if (dbMailMessage.id == MailTablePanel.this.mailViewPanel.getCurrentMessageLocalId()) {
                                MailTablePanel.this.mailViewContainerPanel.setVisible(false);
                            }
                        }
                        MailTablePanel.this.updateLocalization();
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.warn("Can't update table!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }

        @Override
        public void messageWasRemoved(final long l, long l2) {
            if (l < 1L || l2 < 1L || MailTablePanel.this.currentFolderId != l2) {
                return;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        int n = MailTablePanel.this.table.getRowForMessageId(l);
                        if (n > -1) {
                            MailTablePanel.this.table.removeRow(n);
                        }
                        if (l == MailTablePanel.this.mailViewPanel.getCurrentMessageLocalId()) {
                            MailTablePanel.this.mailViewContainerPanel.setVisible(false);
                        }
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.warn("Can't update table!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }

        @Override
        public void messageWasUpdated(DbMailMessage dbMailMessage) {
            if (dbMailMessage == null || MailTablePanel.this.currentFolderId != dbMailMessage.folderId) {
                return;
            }
            this.updateMessageRow(dbMailMessage);
        }

        private void updateMessageRow(final DbMailMessage dbMailMessage) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        int n = MailTablePanel.this.table.getRowForMessageId(dbMailMessage.id);
                        if (n > -1) {
                            MailTablePanel.this.table.setRowAt(n, new MailTable.Row(dbMailMessage));
                        }
                        MailTablePanel.this.updateLocalization();
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.warn("Can't update table!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }
}

