/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.db;

import com.openindex.openestate.tool.mail.MailNotification;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.db.DbMailAddress;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.UIDFolder;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbMailMessage
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbMailMessage.class);
    private static final I18n I18N = I18nFactory.getI18n(DbMailMessage.class);
    public static final Flags FLAGS_FORWARDED = new Flags("forwarded");
    public static final String HEADER_IN_REPLY_TO = "In-Reply-To";
    public static final String HEADER_REFERENCES = "References";
    public static final String HEADER_IMMOTOOL_VERSION = "X-OpenEstate-ImmoTool-Version";
    public static final String HEADER_IMMOTOOL_CONTACTS = "X-OpenEstate-ImmoTool-Contacts";
    public long id = 0L;
    public long folderId = 0L;
    public Long uid = null;
    public Long uidValidity = null;
    public String hash = null;
    public String mimeId = null;
    public String inReplyTo = null;
    public String subject = null;
    public String from = null;
    public String to = null;
    public long size = 0L;
    public boolean isAnswered = false;
    public boolean isArchived = false;
    public boolean isDownloaded = false;
    public boolean isDraft = false;
    public boolean isFlagged = false;
    public boolean isForwarded = false;
    public boolean isSeen = false;
    public boolean isReceived = false;
    public boolean hasAttachments = false;
    public MdnStatus mdnStatus = null;
    public Date receivedAt = null;
    public Date sentAt = null;
    public Date createdAt = null;
    public Date modifiedAt = null;
    public List<DbMailAddress> addresses = null;

    public static DbMailMessage createMessage(MimeMessage mimeMessage) throws MessagingException {
        return DbMailMessage.createMessage(mimeMessage, mimeMessage.getFolder());
    }

    public static DbMailMessage createMessage(MimeMessage mimeMessage, Folder folder) throws MessagingException {
        Object object;
        int n;
        int n2;
        Object[] objectArray;
        DbMailMessage dbMailMessage = new DbMailMessage();
        dbMailMessage.hash = MailPluginUtils.calculateMessageHash((Message)mimeMessage);
        dbMailMessage.mimeId = mimeMessage.getMessageID();
        dbMailMessage.subject = mimeMessage.getSubject();
        dbMailMessage.receivedAt = mimeMessage.getReceivedDate();
        dbMailMessage.sentAt = mimeMessage.getSentDate();
        dbMailMessage.size = mimeMessage.getSize();
        if (dbMailMessage.size < 0L) {
            dbMailMessage.size = MailPluginUtils.calculateMessageSize(mimeMessage);
        }
        dbMailMessage.isDownloaded = false;
        dbMailMessage.isForwarded = false;
        dbMailMessage.isReceived = false;
        dbMailMessage.hasAttachments = false;
        dbMailMessage.addresses = new ArrayList<DbMailAddress>();
        dbMailMessage.updateFlags(mimeMessage.getFlags());
        Object[] objectArray2 = MailNotification.readFromHeader((Message)mimeMessage);
        dbMailMessage.mdnStatus = !ArrayUtils.isEmpty((Object[])objectArray2) ? MdnStatus.REQUESTED : null;
        Address[] addressArray = mimeMessage.getFrom();
        if (addressArray != null) {
            objectArray = addressArray;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                if (dbMailMessage.from == null) {
                    dbMailMessage.from = object.toString();
                }
                dbMailMessage.addresses.add(DbMailAddress.createAddress((InternetAddress)object, DbMailAddress.Type.FROM));
            }
        }
        if ((addressArray = mimeMessage.getRecipients(MimeMessage.RecipientType.TO)) != null) {
            objectArray = addressArray;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                if (dbMailMessage.to == null) {
                    dbMailMessage.to = object.toString();
                }
                dbMailMessage.addresses.add(DbMailAddress.createAddress((InternetAddress)object, DbMailAddress.Type.TO));
            }
        }
        if ((addressArray = mimeMessage.getRecipients(MimeMessage.RecipientType.CC)) != null) {
            objectArray = addressArray;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                dbMailMessage.addresses.add(DbMailAddress.createAddress((InternetAddress)object, DbMailAddress.Type.CC));
            }
        }
        if ((addressArray = mimeMessage.getRecipients(MimeMessage.RecipientType.BCC)) != null) {
            objectArray = addressArray;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                dbMailMessage.addresses.add(DbMailAddress.createAddress((InternetAddress)object, DbMailAddress.Type.BCC));
            }
        }
        if ((addressArray = mimeMessage.getReplyTo()) != null) {
            objectArray = addressArray;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                dbMailMessage.addresses.add(DbMailAddress.createAddress((InternetAddress)object, DbMailAddress.Type.REPLY_TO));
            }
        }
        String string = dbMailMessage.inReplyTo = !ArrayUtils.isEmpty((Object[])(objectArray = mimeMessage.getHeader(HEADER_IN_REPLY_TO))) ? objectArray[0] : null;
        if (StringUtils.isBlank((CharSequence)dbMailMessage.inReplyTo)) {
            objectArray = mimeMessage.getHeader(HEADER_REFERENCES);
            dbMailMessage.inReplyTo = !ArrayUtils.isEmpty((Object[])objectArray) ? objectArray[0] : null;
        }
        try {
            if (folder != null) {
                dbMailMessage.updateUid(folder, (Message)mimeMessage);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't save message-UID!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        Enumeration enumeration = mimeMessage.getAllHeaders();
        while (enumeration.hasMoreElements()) {
            Header header = (Header)enumeration.nextElement();
            object = StringUtils.trimToEmpty((String)header.getName());
            if (!((String)object).equalsIgnoreCase("Received")) continue;
            dbMailMessage.isReceived = true;
            break;
        }
        return dbMailMessage;
    }

    public DbMailAddress[] getAddresses() {
        return this.getAddresses(null);
    }

    public DbMailAddress[] getAddresses(DbMailAddress.Type type) {
        if (this.addresses == null || this.addresses.isEmpty()) {
            return new DbMailAddress[0];
        }
        if (type == null) {
            return this.addresses.toArray(new DbMailAddress[0]);
        }
        ArrayList<DbMailAddress> arrayList = new ArrayList<DbMailAddress>();
        for (DbMailAddress dbMailAddress : this.addresses) {
            if (!type.equals((Object)dbMailAddress.type)) continue;
            arrayList.add(dbMailAddress);
        }
        return arrayList.toArray(new DbMailAddress[0]);
    }

    public DbMailAddress[] getBcc() {
        return this.getAddresses(DbMailAddress.Type.BCC);
    }

    public DbMailAddress[] getCc() {
        return this.getAddresses(DbMailAddress.Type.CC);
    }

    public DbMailAddress[] getFrom() {
        return this.getAddresses(DbMailAddress.Type.FROM);
    }

    public DbMailAddress[] getReplyTo() {
        return this.getAddresses(DbMailAddress.Type.REPLY_TO);
    }

    public DbMailAddress[] getTo() {
        return this.getAddresses(DbMailAddress.Type.TO);
    }

    public void updateFlags(Flags flags) {
        this.isAnswered = flags != null && flags.contains(Flags.Flag.ANSWERED);
        this.isDraft = flags != null && flags.contains(Flags.Flag.DRAFT);
        this.isFlagged = flags != null && flags.contains(Flags.Flag.FLAGGED);
        this.isSeen = flags != null && flags.contains(Flags.Flag.SEEN);
        this.isForwarded = flags != null && flags.contains(FLAGS_FORWARDED);
    }

    public void updateUid(Folder folder, Message message) throws MessagingException {
        if (folder instanceof UIDFolder) {
            this.updateUid((UIDFolder)folder, message);
        } else {
            this.uid = null;
            this.uidValidity = null;
        }
    }

    public void updateUid(UIDFolder uIDFolder, Message message) throws MessagingException {
        try {
            this.uid = uIDFolder != null ? uIDFolder.getUID(message) : 0L;
            this.uidValidity = uIDFolder != null ? uIDFolder.getUIDValidity() : 0L;
        }
        catch (NoSuchElementException noSuchElementException) {
            LOGGER.warn("Can't set message uid!");
            if (message instanceof MimeMessage) {
                LOGGER.warn("> mime-id: " + ((MimeMessage)message).getMessageID());
            }
            LOGGER.warn("> " + noSuchElementException.getLocalizedMessage());
            this.uid = null;
            this.uidValidity = null;
        }
    }

    public static enum MdnStatus {
        REQUESTED,
        SENT,
        DENIED;

    }
}

