/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.db;

import com.openindex.openestate.tool.mail.db.DbMailHeader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbMailPart
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbMailPart.class);
    private static final I18n I18N = I18nFactory.getI18n(DbMailPart.class);
    public long id = 0L;
    public long messageId = 0L;
    public long parentPartId = 0L;
    public String type = null;
    public String disposition = null;
    public String description = null;
    public String text = null;
    public String fileName = null;
    public long fileSize = 0L;
    public Date createdAt = null;
    public Date modifiedAt = null;
    public File tempFileContent = null;
    public DbMailPart parentPart = null;
    public List<DbMailPart> subParts = null;
    public List<DbMailHeader> headers = null;

    public static DbMailPart createPart(MimeMessage mimeMessage) throws MessagingException, IOException {
        Object object = null;
        try {
            object = mimeMessage.getContent();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.warn("Can't read mail-part because of unsupported encoding: " + mimeMessage.getContentType());
            LOGGER.warn("> Number     : " + mimeMessage.getMessageNumber());
            LOGGER.warn("> Subject    : " + mimeMessage.getSubject());
            LOGGER.warn("> Message-ID : " + mimeMessage.getMessageID());
            if (!mimeMessage.getContentType().toLowerCase().startsWith("text/")) {
                throw unsupportedEncodingException;
            }
            LOGGER.warn("> Try falling back to US-ASCII.");
            try (StringWriter stringWriter = new StringWriter();){
                IOUtils.copy((InputStream)mimeMessage.getDataHandler().getInputStream(), (Writer)stringWriter, (String)"US-ASCII");
                object = stringWriter.toString();
            }
        }
        if (object instanceof MimeMultipart) {
            DbMailPart dbMailPart = DbMailPart.parseMultiPart((MimeMultipart)object);
            DbMailPart.initPart(dbMailPart, (Part)mimeMessage);
            return dbMailPart;
        }
        if (object instanceof MimePart) {
            return DbMailPart.parseSinglePart((MimePart)object);
        }
        if (object instanceof String) {
            DbMailPart dbMailPart = new DbMailPart();
            DbMailPart.initPart(dbMailPart, (Part)mimeMessage);
            dbMailPart.text = (String)object;
            return dbMailPart;
        }
        if (object == null) {
            throw new MessagingException("Empty mail-content!");
        }
        throw new MessagingException("Unsupported mail-content : " + object.getClass().getName());
    }

    public DbMailPart[] getAllSubParts() {
        ArrayList<DbMailPart> arrayList = new ArrayList<DbMailPart>();
        if (this.subParts != null) {
            for (DbMailPart dbMailPart : this.subParts) {
                arrayList.addAll(Arrays.asList(dbMailPart.getAllSubParts()));
                arrayList.add(dbMailPart);
            }
        }
        return arrayList.toArray(new DbMailPart[0]);
    }

    public DbMailHeader[] getHeader(String string) {
        if (StringUtils.isBlank((CharSequence)string) || this.headers == null || this.headers.isEmpty()) {
            return new DbMailHeader[0];
        }
        ArrayList<DbMailHeader> arrayList = new ArrayList<DbMailHeader>();
        for (DbMailHeader dbMailHeader : this.headers) {
            if (!string.equalsIgnoreCase(dbMailHeader.key)) continue;
            arrayList.add(dbMailHeader);
        }
        return arrayList.toArray(new DbMailHeader[0]);
    }

    public DbMailPart[] getSingleParts() {
        ArrayList<DbMailPart> arrayList = new ArrayList<DbMailPart>();
        try {
            ContentType contentType = new ContentType(this.type);
            if (!contentType.match("multipart/")) {
                arrayList.add(this);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read mime-type '" + this.type + "' for message-part #" + this.id);
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        if (this.subParts != null) {
            for (DbMailPart dbMailPart : this.subParts) {
                arrayList.addAll(Arrays.asList(dbMailPart.getSingleParts()));
            }
        }
        return arrayList.toArray(new DbMailPart[0]);
    }

    public File[] getTempFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.tempFileContent != null) {
            arrayList.add(this.tempFileContent);
        }
        for (DbMailPart dbMailPart : this.getAllSubParts()) {
            if (dbMailPart.tempFileContent == null) continue;
            arrayList.add(dbMailPart.tempFileContent);
        }
        return arrayList.toArray(new File[0]);
    }

    public boolean hasAttachment() {
        if (this.tempFileContent != null || !StringUtils.isEmpty((CharSequence)this.disposition)) {
            return true;
        }
        for (DbMailPart dbMailPart : this.getSingleParts()) {
            if (dbMailPart.tempFileContent == null && StringUtils.isEmpty((CharSequence)dbMailPart.disposition)) continue;
            return true;
        }
        return false;
    }

    private static void initPart(DbMailPart dbMailPart, Part part) throws MessagingException {
        ContentDisposition contentDisposition;
        Object object;
        dbMailPart.description = part.getDescription();
        dbMailPart.fileName = part.getFileName();
        try {
            object = part.getDisposition();
            contentDisposition = object != null && ((String)object).trim().length() > 0 ? new ContentDisposition((String)object) : null;
            dbMailPart.disposition = contentDisposition != null ? contentDisposition.getDisposition().toLowerCase() : null;
        }
        catch (ParseException parseException) {
            LOGGER.warn("Can't parse Content-Disposition!");
            LOGGER.warn("> " + part.getDisposition());
            LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
            dbMailPart.disposition = null;
        }
        try {
            object = part.getContentType();
            contentDisposition = object != null && ((String)object).trim().length() > 0 ? new ContentType((String)object) : null;
            dbMailPart.type = contentDisposition != null ? contentDisposition.getBaseType().toLowerCase() : null;
        }
        catch (ParseException parseException) {
            LOGGER.warn("Can't parse Content-Type!");
            LOGGER.warn("> " + part.getContentType());
            LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
            dbMailPart.type = null;
        }
        dbMailPart.headers = new ArrayList<DbMailHeader>();
        object = part.getAllHeaders();
        while (object.hasMoreElements()) {
            dbMailPart.headers.add(DbMailHeader.createHeader((Header)object.nextElement()));
        }
    }

    private static DbMailPart parseMultiPart(MimeMultipart mimeMultipart) throws MessagingException, IOException {
        DbMailPart dbMailPart = new DbMailPart();
        dbMailPart.subParts = new ArrayList<DbMailPart>();
        for (int i = 0; i < mimeMultipart.getCount(); ++i) {
            DbMailPart dbMailPart2;
            MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMultipart.getBodyPart(i);
            if (!mimeBodyPart.isMimeType("multipart/*")) {
                dbMailPart2 = DbMailPart.parseSinglePart((MimePart)mimeBodyPart);
            } else {
                dbMailPart2 = DbMailPart.parseMultiPart((MimeMultipart)mimeBodyPart.getContent());
                DbMailPart.initPart(dbMailPart2, (Part)mimeBodyPart);
            }
            dbMailPart2.parentPart = dbMailPart;
            dbMailPart.subParts.add(dbMailPart2);
        }
        return dbMailPart;
    }

    private static DbMailPart parseSinglePart(MimePart mimePart) throws MessagingException, IOException {
        boolean bl;
        DbMailPart dbMailPart = new DbMailPart();
        DbMailPart.initPart(dbMailPart, (Part)mimePart);
        boolean bl2 = bl = mimePart.isMimeType("text/plain") || mimePart.isMimeType("text/html");
        if (bl) {
            Object object = null;
            try {
                object = mimePart.getContent();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.warn("Can't read mail-part because of unsupported encoding: " + mimePart.getContentType());
                LOGGER.warn("> Content-ID : " + mimePart.getContentID());
                if (!mimePart.getContentType().toLowerCase().startsWith("text/")) {
                    throw unsupportedEncodingException;
                }
                LOGGER.warn("> Try falling back to US-ASCII.");
                try (StringWriter stringWriter = new StringWriter();){
                    IOUtils.copy((InputStream)mimePart.getDataHandler().getInputStream(), (Writer)stringWriter, (String)"US-ASCII");
                    object = stringWriter.toString();
                }
            }
            String string = dbMailPart.text = object != null ? object.toString() : null;
            if (dbMailPart.tempFileContent != null && dbMailPart.tempFileContent.isFile()) {
                FileUtils.deleteQuietly((File)dbMailPart.tempFileContent);
            }
        } else {
            dbMailPart.text = null;
            dbMailPart.tempFileContent = null;
            try {
                dbMailPart.tempFileContent = File.createTempFile("mailbox.", ".attachment");
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(dbMailPart.tempFileContent));){
                    IOUtils.copy((InputStream)mimePart.getInputStream(), (OutputStream)bufferedOutputStream);
                    ((OutputStream)bufferedOutputStream).flush();
                }
            }
            catch (IOException iOException) {
                FileUtils.deleteQuietly((File)dbMailPart.tempFileContent);
                dbMailPart.tempFileContent = null;
                throw iOException;
            }
        }
        return dbMailPart;
    }

    public void setMessageId(long l) {
        this.messageId = l;
        if (this.subParts != null) {
            for (DbMailPart dbMailPart : this.subParts) {
                dbMailPart.setMessageId(l);
            }
        }
    }
}

