/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.io;

import com.openindex.openestate.tool.core.LoggingOutputStream;
import com.openindex.openestate.tool.core.ssl.ExtendedSSLSocketFactory;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.io.AbstractMailWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.IDN;
import java.util.Map;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import org.apache.commons.mail.DefaultAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class SmtpWriter
extends AbstractMailWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmtpWriter.class);
    private static final I18n I18N = I18nFactory.getI18n(SmtpWriter.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"mail.smtp");
    private static final String SMTP_HOST = "smtp.host";
    private static final String SMTP_PORT = "smtp.port";
    private static final String SMTP_AUTH_METHOD = "smtp.auth.method";
    private static final String SMTP_AUTH_USER = "smtp.auth.user";
    private static final String SMTP_AUTH_PASS = "smtp.auth.pass";
    private static final String SMTP_CRYPT_METHOD = "smtp.crypt.method";

    public SmtpWriter() {
        this.put(SMTP_HOST, "localhost");
        this.put(SMTP_PORT, "25");
        this.put(SMTP_AUTH_METHOD, AuthMethod.ANONYMOUS.name());
        this.put(SMTP_CRYPT_METHOD, CryptMethod.NO_ENCRYPTION.name());
    }

    @Override
    public Session createSession(Map<String, String> map) {
        Object object;
        Object object2;
        DefaultAuthenticator defaultAuthenticator = null;
        AuthMethod authMethod = this.getAuthMethod();
        CryptMethod cryptMethod = this.getCryptMethod();
        String string = CryptMethod.SMTPS.equals((Object)cryptMethod) ? "smtps" : "smtp";
        Properties properties = new Properties();
        properties.setProperty("mail.debug", "false");
        properties.setProperty("mail.transport.protocol", string);
        properties.setProperty("mail." + string + ".host", IDN.toASCII(this.getHost()));
        properties.setProperty("mail." + string + ".port", String.valueOf(this.getPort()));
        properties.setProperty("mail." + string + ".connectiontimeout", "10000");
        properties.setProperty("mail." + string + ".timeout", "10000");
        if (authMethod != null && !AuthMethod.ANONYMOUS.equals((Object)authMethod)) {
            object2 = this.getAuthUser();
            object = this.getAuthPass();
            defaultAuthenticator = new DefaultAuthenticator((String)(object2 != null ? object2 : ""), object != null ? String.valueOf((char[])object) : "");
            properties.setProperty("mail." + string + ".auth", "true");
        }
        if (CryptMethod.SMTPS.equals((Object)cryptMethod)) {
            try {
                properties.put("mail." + string + ".socketFactory", new ExtendedSSLSocketFactory());
                properties.setProperty("mail." + string + ".socketFactory.fallback", "false");
                properties.setProperty("mail." + string + ".socketFactory.port", String.valueOf(this.getPort()));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't create SSL socket factory!");
                LOGGER.warn("> " + exception.getLocalizedMessage());
            }
        } else if (CryptMethod.STARTTLS.equals((Object)cryptMethod)) {
            properties.setProperty("mail." + string + ".starttls.enable", "true");
            properties.setProperty("mail." + string + ".starttls.required", "true");
            try {
                properties.put("mail." + string + ".ssl.socketFactory", new ExtendedSSLSocketFactory());
                properties.setProperty("mail." + string + ".ssl.socketFactory.fallback", "false");
                properties.setProperty("mail." + string + ".ssl.socketFactory.port", String.valueOf(this.getPort()));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't create SSL socket factory!");
                LOGGER.warn("> " + exception.getLocalizedMessage());
            }
        }
        if (map != null && !map.isEmpty()) {
            object2 = map.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                properties.setProperty((String)object.getKey(), (String)object.getValue());
            }
        }
        object2 = Session.getInstance((Properties)properties, defaultAuthenticator);
        if (this.isDebug() || Boolean.TRUE.equals(Boolean.valueOf(properties.getProperty("mail.debug")))) {
            object = "[";
            object = (String)object + "SMTP] ";
            try {
                object2.setDebugOut(new PrintStream((OutputStream)new LoggingOutputStream(DEBUG_LOGGER, LoggingOutputStream.Priority.INFO, (String)object), true, "UTF-8"));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't register IMAP debug stream!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            object2.setDebug(true);
        }
        return object2;
    }

    public AuthMethod getAuthMethod() {
        return this.containsKey(SMTP_AUTH_METHOD) ? AuthMethod.valueOf((String)this.get(SMTP_AUTH_METHOD)) : null;
    }

    public char[] getAuthPass() {
        return this.containsKey(SMTP_AUTH_PASS) ? ((String)this.get(SMTP_AUTH_PASS)).toCharArray() : null;
    }

    public String getAuthUser() {
        return (String)this.get(SMTP_AUTH_USER);
    }

    public CryptMethod getCryptMethod() {
        return this.containsKey(SMTP_CRYPT_METHOD) ? CryptMethod.valueOf((String)this.get(SMTP_CRYPT_METHOD)) : null;
    }

    public String getHost() {
        return (String)this.get(SMTP_HOST);
    }

    public int getPort() {
        return this.containsKey(SMTP_PORT) ? Integer.parseInt((String)this.get(SMTP_PORT)) : 0;
    }

    @Override
    public final AbstractMailWriter.Type getType() {
        return AbstractMailWriter.Type.SMTP;
    }

    @Override
    protected Transport openTransport(Session session) throws MessagingException {
        AuthMethod authMethod = this.getAuthMethod();
        CryptMethod cryptMethod = this.getCryptMethod();
        Transport transport = null;
        try {
            transport = session.getTransport(CryptMethod.SMTPS.equals((Object)cryptMethod) ? "smtps" : "smtp");
            switch (authMethod) {
                case ANONYMOUS: {
                    transport.connect();
                    break;
                }
                case PLAIN: 
                case LOGIN: 
                case CRAM_MD5: 
                case DIGEST_MD5: {
                    transport.connect(this.getAuthUser(), String.valueOf(this.getAuthPass()));
                    break;
                }
            }
            return transport;
        }
        catch (MessagingException messagingException) {
            MailPluginUtils.closeQuietly(transport);
            throw messagingException;
        }
    }

    public void setAuthMethod(AuthMethod authMethod) {
        if (authMethod == null) {
            this.remove(SMTP_AUTH_METHOD);
        } else {
            this.put(SMTP_AUTH_METHOD, authMethod.name());
        }
    }

    public void setAuthPass(char[] cArray) {
        if (cArray == null) {
            this.remove(SMTP_AUTH_PASS);
        } else {
            this.put(SMTP_AUTH_PASS, String.valueOf(cArray));
        }
    }

    public void setAuthUser(String string) {
        if (string == null) {
            this.remove(SMTP_AUTH_USER);
        } else {
            this.put(SMTP_AUTH_USER, string);
        }
    }

    public void setCryptMethod(CryptMethod cryptMethod) {
        if (cryptMethod == null) {
            this.remove(SMTP_CRYPT_METHOD);
        } else {
            this.put(SMTP_CRYPT_METHOD, cryptMethod.name());
        }
    }

    public void setHost(String string) {
        if (string == null) {
            this.remove(SMTP_HOST);
        } else {
            this.put(SMTP_HOST, string);
        }
    }

    public void setPort(int n) {
        if (n < 1) {
            this.remove(SMTP_PORT);
        } else {
            this.put(SMTP_PORT, String.valueOf(n));
        }
    }

    public static enum CryptMethod {
        NO_ENCRYPTION,
        STARTTLS,
        SMTPS;

    }

    public static enum AuthMethod {
        ANONYMOUS,
        PLAIN,
        LOGIN,
        CRAM_MD5,
        DIGEST_MD5,
        POP_BEFORE_SMTP;

    }
}

