/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.alexandriasoftware.swing.action.ButtonClickedActionListener;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultSelectButton;
import com.openindex.openestate.tool.gui.DefaultSplitButton;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.mail.MailEditorPane;
import com.openindex.openestate.tool.mail.MailHandler;
import com.openindex.openestate.tool.mail.MailNotification;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.MailPriority;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailAddress;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.db.DbMailHeader;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import com.openindex.openestate.tool.mail.db.DbMailPart;
import com.openindex.openestate.tool.mail.extensions.MailEditorExtension;
import com.openindex.openestate.tool.mail.gui.MailFromRenderer;
import com.openindex.openestate.tool.mail.io.AbstractMailWriter;
import com.openindex.openestate.tool.utils.HtmlToPlainText;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.tidy.Tidy;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailEditor
extends AbstractPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailEditor.class);
    private static final I18n I18N = I18nFactory.getI18n(MailEditor.class);
    private static final String SETTINGS_LAYOUT = "fill:[65dlu,pref], 3dlu, 50dlu:grow";
    private static final int TEMP_SAVE_INTERVAL = 60000;
    private static File lastAttachmentLocation = null;
    private final boolean saveAsTemporaryDraft;
    private final RecipientMode recipientMode;
    private ValidationHandler validationHandler;
    private DbMailAccount currentAccount = null;
    private long referencedMessageId = 0L;
    private String referencedMessageMimeId = null;
    private DbMailMessage tempDraftMessage = null;
    private long tempDraftMessageHash = 0L;
    private long tempDraftAccountId = 0L;
    private Map<Long, File> tempDownloadedFiles = null;
    private Map<DbMailFolder.SpecialType, DbMailMessage> savedMessages;
    private Map<DbMailFolder.SpecialType, Long> savedMessageAccountIds;
    private List<DbMailAddress> preLoadedAddresses = null;
    private long savedMessageHash = 0L;
    private Timer tempDraftTimer = null;
    private int fixedSettingsHeight = 0;
    private ViewMode mode = ViewMode.NEW;
    private AddressHandler addressHandler;
    private List<MailEditorExtension> extensions;
    private JButton attachmentButton;
    private DefaultSplitButton saveButton;
    private JButton optionsButton;
    private JRadioButtonMenuItem modeHtmlButton;
    private JRadioButtonMenuItem modePlainButton;
    private JRadioButtonMenuItem priorityLowButton;
    private JRadioButtonMenuItem priorityNormalButton;
    private JRadioButtonMenuItem priorityHighButton;
    private JRadioButtonMenuItem priorityDisabledButton;
    private JCheckBoxMenuItem notifyReceptionButton;
    private JSplitPane topSplitPane;
    private JSplitPane mainSplitPane;
    private JPanel attachmentPanel;
    private JLabel attachmentInfoLabel;
    private JList<AttachmentItem> attachmentList;
    private JLabel accountLabel;
    private JComboBox<DbMailAccount> accountBox;
    private JLabel subjectLabel;
    private JTextField subjectField;
    private DefaultFormBuilder recipientsFormBuilder;
    private JPanel recipientsPanel;
    private JScrollPane recipientsPanelScroller;
    private ArrayList<RecipientField> recipientFields;
    private MailEditorPane mailEditor;

    public MailEditor() {
        this(null, false);
    }

    public MailEditor(boolean bl) {
        this(null, bl);
    }

    public MailEditor(RecipientMode recipientMode) {
        this(recipientMode, false);
    }

    public MailEditor(RecipientMode recipientMode, boolean bl) {
        this.recipientMode = recipientMode != null ? recipientMode : RecipientMode.ALL;
        this.saveAsTemporaryDraft = bl;
        this.recipientFields = new ArrayList();
        this.savedMessages = new EnumMap<DbMailFolder.SpecialType, DbMailMessage>(DbMailFolder.SpecialType.class);
        this.savedMessageAccountIds = new EnumMap<DbMailFolder.SpecialType, Long>(DbMailFolder.SpecialType.class);
        this.build();
    }

    public void addRecipient(RecipientType recipientType, Address address) {
        AddressField addressField = this.addressHandler.createAddressField(null);
        this.addRecipient(new RecipientField(addressField, recipientType, address));
    }

    private void addRecipient(final RecipientField recipientField) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                recipientField.addressField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                        Address address;
                        if (10 == keyEvent.getKeyCode()) {
                            int n = MailEditor.this.recipientFields.indexOf(recipientField);
                            if (n < 0) {
                                return;
                            }
                            Address address2 = recipientField.getAddress();
                            if (n + 1 >= MailEditor.this.recipientFields.size()) {
                                if (address2 == null || address2.isBlank()) {
                                    MailEditor.this.subjectField.requestFocus();
                                } else if (RecipientMode.ONE_REPLY_TO.equals((Object)MailEditor.this.recipientMode)) {
                                    MailEditor.this.subjectField.requestFocus();
                                } else if (RecipientMode.ALL.equals((Object)MailEditor.this.recipientMode)) {
                                    MailEditor.this.addRecipient(recipientField.getType(), null);
                                }
                            } else {
                                ((RecipientField)MailEditor.this.recipientFields.get(n + 1)).addressField.requestFocus();
                            }
                        } else if ((8 == keyEvent.getKeyCode() || 127 == keyEvent.getKeyCode()) && ((address = recipientField.getAddress()) == null || address.isBlank()) && RecipientMode.ALL.equals((Object)MailEditor.this.recipientMode)) {
                            MailEditor.this.removeRecipient(recipientField);
                        }
                    }
                });
                MailEditor.this.recipientsFormBuilder.add((Component)recipientField.typeButton).xy(1, MailEditor.this.recipientsFormBuilder.nextRow());
                MailEditor.this.recipientsFormBuilder.add((Component)recipientField.addressField.getComponent()).xy(3, MailEditor.this.recipientsFormBuilder.row());
                MailEditor.this.recipientsPanel.revalidate();
                MailEditor.this.recipientsPanel.repaint();
                MailEditor.this.recipientFields.add(recipientField);
                recipientField.addressField.requestFocus();
                MailEditor.this.updateMainDivider();
                MailEditor.this.scrollRecipientsToBottom();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                LOGGER.error("Can't add recipient!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.addressHandler = null;
        this.extensions = new ArrayList<MailEditorExtension>();
        try {
            for (MailEditorExtension mailEditorExtension : MailPluginUtils.getMailEditorExtensions()) {
                try {
                    this.extensions.add(mailEditorExtension);
                    if (this.addressHandler != null) continue;
                    this.addressHandler = mailEditorExtension.getAddressHandler();
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load mail-editor-extension!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load mail-editor-extensions!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        if (this.addressHandler == null) {
            this.addressHandler = new DefaultAddressHandler();
        }
        this.buildButtons();
        this.setLayout(new BorderLayout(5, 5));
        this.add(this.buildMainPanel(), "Center");
        this.updateLocalization();
        this.validationHandler.init();
    }

    private JComponent buildMailAttachmentPanel() {
        DefaultListModel defaultListModel = new DefaultListModel();
        defaultListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                if (!MailEditor.this.attachmentList.isEnabled()) {
                    return;
                }
                MailEditor.this.updateAttachments();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                if (!MailEditor.this.attachmentList.isEnabled()) {
                    return;
                }
                MailEditor.this.updateAttachments();
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                if (!MailEditor.this.attachmentList.isEnabled()) {
                    return;
                }
                MailEditor.this.updateAttachments();
            }
        });
        this.attachmentList = new AttachmentList(defaultListModel);
        this.attachmentList.setCellRenderer((ListCellRenderer<AttachmentItem>)new DefaultListCellRenderer((Renderer)new AbstractRenderer<AttachmentItem>(){
            private final Icon fileIcon = ImmoToolEnvironment.getResourceIcon((String)"file_new.png", (int)16);

            public void render(AttachmentItem attachmentItem, JLabel jLabel) {
                jLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                if (attachmentItem == null) {
                    jLabel.setText("");
                    jLabel.setIcon(null);
                } else {
                    jLabel.setIcon(this.fileIcon);
                    jLabel.setText(attachmentItem.getName());
                }
            }
        }));
        this.attachmentList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    int n = MailEditor.this.attachmentList.getSelectedIndex();
                    if (n > -1) {
                        MailEditor.this.doAttachmentOpen();
                    }
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                    int[] nArray = MailEditor.this.attachmentList.getSelectedIndices();
                    int n = MailEditor.this.attachmentList.locationToIndex(mouseEvent.getPoint());
                    if (n > -1 && !ArrayUtils.contains((int[])nArray, (int)n)) {
                        MailEditor.this.attachmentList.setSelectedIndex(n);
                    }
                    if (MailEditor.this.attachmentList.getSelectedIndex() > -1) {
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        jPopupMenu.add((Action)((Object)new AttachmentOpenAction()));
                        jPopupMenu.add((Action)((Object)new AttachmentRenameAction()));
                        jPopupMenu.addSeparator();
                        jPopupMenu.add((Action)((Object)new AttachmentRemoveAction()));
                        jPopupMenu.show(MailEditor.this.attachmentList, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    }
                }
            }
        });
        this.attachmentInfoLabel = new JLabel();
        this.attachmentInfoLabel.setBackground(this.attachmentList.getBackground());
        this.attachmentInfoLabel.setOpaque(true);
        JScrollPane jScrollPane = new JScrollPane(this.attachmentList);
        jScrollPane.setBorder(Paddings.EMPTY);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.attachmentPanel = new JPanel(new BorderLayout(5, 5));
        this.attachmentPanel.setBackground(this.attachmentList.getBackground());
        this.attachmentPanel.setOpaque(true);
        this.attachmentPanel.add((Component)this.attachmentInfoLabel, "North");
        this.attachmentPanel.add((Component)jScrollPane, "Center");
        return this.attachmentPanel;
    }

    private JComponent buildMailMessagePanel() {
        this.mailEditor = new MailEditorPane();
        return this.mailEditor;
    }

    private JComponent buildMailSettingsPanel() {
        this.accountLabel = new JLabel();
        this.accountLabel.setHorizontalAlignment(4);
        this.accountLabel.setFont(this.accountLabel.getFont().deriveFont(1));
        this.accountBox = new JComboBox();
        this.accountBox.setRenderer((ListCellRenderer<DbMailAccount>)new DefaultListCellRenderer((Renderer)new MailFromRenderer()));
        this.accountBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MailEditor.this.accountBox.isEnabled()) {
                    return;
                }
                MailEditor.this.updateAccount(false);
            }
        });
        this.validationHandler.putRule(this.accountBox, (ValidationRule)new NonEmptyComboBoxRule(this.accountBox));
        this.subjectLabel = new JLabel();
        this.subjectLabel.setHorizontalAlignment(4);
        this.subjectLabel.setFont(this.subjectLabel.getFont().deriveFont(1));
        this.subjectField = new JTextField();
        this.subjectField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if (10 != keyEvent.getKeyCode() && (8 == keyEvent.getKeyCode() || 127 == keyEvent.getKeyCode()) && StringUtils.isEmpty((CharSequence)MailEditor.this.subjectField.getText()) && (n = MailEditor.this.recipientFields.size() - 1) >= 0) {
                    MailEditor.this.scrollRecipientsToBottom();
                    ((RecipientField)MailEditor.this.recipientFields.get(n)).addressField.requestFocus();
                }
            }
        });
        this.validationHandler.putRule((JComponent)this.subjectField, ValidationHandler.NOT_BLANK);
        this.recipientsPanel = new JPanel();
        this.recipientsFormBuilder = DefaultFormBuilder.create((String)SETTINGS_LAYOUT, (JPanel)this.recipientsPanel);
        this.recipientsPanelScroller = new JScrollPane(this.recipientsPanel);
        this.recipientsPanelScroller.setBorder(Paddings.EMPTY);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)SETTINGS_LAYOUT);
        defaultFormBuilder.add((Component)this.accountLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.accountBox).xy(3, defaultFormBuilder.row());
        DefaultFormBuilder defaultFormBuilder2 = DefaultFormBuilder.create((String)SETTINGS_LAYOUT);
        defaultFormBuilder2.add((Component)this.subjectLabel).xy(1, defaultFormBuilder2.nextRow());
        defaultFormBuilder2.add((Component)this.subjectField).xy(3, defaultFormBuilder2.row());
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)defaultFormBuilder.getPanel(), "North");
        jPanel.add((Component)this.recipientsPanelScroller, "Center");
        jPanel.add((Component)defaultFormBuilder2.getPanel(), "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        this.fixedSettingsHeight = 0;
        this.fixedSettingsHeight += defaultFormBuilder.getPanel().getPreferredSize().height;
        this.fixedSettingsHeight += 5;
        this.fixedSettingsHeight += defaultFormBuilder2.getPanel().getPreferredSize().height;
        this.fixedSettingsHeight += 5;
        this.fixedSettingsHeight += 5;
        return jPanel;
    }

    private JComponent buildMainPanel() {
        this.topSplitPane = new JSplitPane(1);
        this.topSplitPane.setResizeWeight(1.0);
        this.topSplitPane.setLeftComponent(this.buildMailSettingsPanel());
        this.topSplitPane.setRightComponent(this.buildMailAttachmentPanel());
        this.topSplitPane.getRightComponent().setVisible(false);
        this.topSplitPane.setBorder(Paddings.EMPTY);
        this.mainSplitPane = new JSplitPane(0);
        this.mainSplitPane.setTopComponent(this.topSplitPane);
        this.mainSplitPane.setBottomComponent(this.buildMailMessagePanel());
        this.mainSplitPane.setBorder(Paddings.EMPTY);
        this.mainSplitPane.setDividerLocation(this.fixedSettingsHeight);
        return this.mainSplitPane;
    }

    private void buildButtons() {
        this.attachmentButton = new JButton((Action)((Object)new AttachmentAddAction()));
        this.saveButton = new DefaultSplitButton();
        this.saveButton.setIcon(ImmoToolEnvironment.getResourceIcon((String)"file_save.png", (int)16));
        this.saveButton.setBounds(this.attachmentButton.getBounds());
        this.saveButton.addButtonClickedActionListener(new ButtonClickedActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MailEditor.this.doSave();
            }
        });
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new SaveAsFileAction()));
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)((Object)new SaveAsDraftAction()));
        jPopupMenu.add((Action)((Object)new SaveAsTemplateAction()));
        this.saveButton.setPopupMenu(jPopupMenu);
        this.optionsButton = new JButton();
        this.optionsButton.setIcon(ImmoToolEnvironment.getResourceIcon((String)"configure.png", (int)16));
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MailEditor.this.showMessageOptions(MailEditor.this.optionsButton, 0, ((MailEditor)MailEditor.this).optionsButton.getSize().height);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        this.modeHtmlButton = new JRadioButtonMenuItem();
        this.modeHtmlButton.setSelected(true);
        this.modeHtmlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MailEditor.this.mailEditor.setMode(MailEditorPane.Mode.HTML_ONLY);
            }
        });
        buttonGroup.add(this.modeHtmlButton);
        this.modePlainButton = new JRadioButtonMenuItem();
        this.modePlainButton.setSelected(false);
        this.modePlainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MailEditor.this.mailEditor.setMode(MailEditorPane.Mode.TEXT_ONLY);
            }
        });
        buttonGroup.add(this.modePlainButton);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.priorityNormalButton = new JRadioButtonMenuItem();
        buttonGroup2.add(this.priorityNormalButton);
        this.priorityLowButton = new JRadioButtonMenuItem();
        buttonGroup2.add(this.priorityLowButton);
        this.priorityHighButton = new JRadioButtonMenuItem();
        buttonGroup2.add(this.priorityHighButton);
        this.priorityDisabledButton = new JRadioButtonMenuItem();
        this.priorityDisabledButton.setSelected(true);
        buttonGroup2.add(this.priorityDisabledButton);
        this.notifyReceptionButton = new JCheckBoxMenuItem();
    }

    public void cleanup() {
        if (this.tempDownloadedFiles != null) {
            for (File file : this.tempDownloadedFiles.values()) {
                FileUtils.deleteQuietly((File)file);
            }
        }
        if (this.tempDraftTimer != null) {
            this.tempDraftTimer.stop();
        }
        if (this.tempDraftMessage != null && this.tempDraftMessage.id > 0L) {
            MailHandler mailHandler = MailPlugin.getMailHandler();
            mailHandler.removeMessagesInBackground(new long[]{this.tempDraftMessage.id});
        }
    }

    private void clear() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MailEditor.this.cleanup();
                MailEditor.this.mailEditor.setMode(MailEditorPane.Mode.TEXT_ONLY);
                MailEditor.this.mailEditor.setPlainText("");
                MailEditor.this.mailEditor.setHtmlText("");
                MailEditor.this.subjectField.setText("");
                DefaultListModel defaultListModel = (DefaultListModel)MailEditor.this.attachmentList.getModel();
                defaultListModel.removeAllElements();
                MailEditor.this.updateAttachments();
                MailEditor.this.recipientFields.clear();
                MailEditor.this.updateRecipients();
                MailEditor.this.updateMainDivider();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                LOGGER.error("Can't add recipient!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    private void doAttachmentAdd() {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(I18N.tr("Select files for attachment."));
        jFileChooser.setApproveButtonText(StringUtils.capitalize((String)I18N.tr("attach files")));
        jFileChooser.setMultiSelectionEnabled(true);
        if (lastAttachmentLocation != null) {
            jFileChooser.setSelectedFile(new File(lastAttachmentLocation.getAbsolutePath() + File.separator + "."));
        }
        if ((n = jFileChooser.showOpenDialog((Component)((Object)this))) != 0) {
            return;
        }
        MailEditor.setLastAttachmentLocation(jFileChooser.getSelectedFile().getAbsoluteFile().getParentFile());
        for (File file : jFileChooser.getSelectedFiles()) {
            ((DefaultListModel)this.attachmentList.getModel()).addElement(new AttachmentItem(file, file.getName()));
        }
    }

    private void doAttachmentOpen() {
        int n = this.attachmentList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        try {
            DefaultListModel defaultListModel = (DefaultListModel)this.attachmentList.getModel();
            AttachmentItem attachmentItem = (AttachmentItem)defaultListModel.getElementAt(n);
            Desktop.getDesktop().open(attachmentItem.getFile());
        }
        catch (Exception exception) {
            LOGGER.error("Can't open file!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't open file!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private void doAttachmentRemove() {
        int[] nArray = this.attachmentList.getSelectedIndices();
        if (nArray.length < 1) {
            return;
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.attachmentList.getModel();
        for (int i = nArray.length - 1; i >= 0; --i) {
            defaultListModel.remove(nArray[i]);
        }
    }

    private void doAttachmentRename() {
        int n = this.attachmentList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.attachmentList.getModel();
        AttachmentItem attachmentItem = (AttachmentItem)defaultListModel.getElementAt(n);
        String string = ImmoToolUtils.showInputDialog((String)I18N.tr("Enter a new name for the attachment."), (String)attachmentItem.getName(), (Component)((Object)this));
        if (StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        attachmentItem.setName(string);
        this.attachmentList.repaint();
    }

    private void doSave() {
        this.doSaveAsDraft();
    }

    public void doSaveAsDraft() {
        this.doSaveIntoSpecialFolder(DbMailFolder.SpecialType.DRAFTS, false, false);
    }

    public void doSaveAsFile() {
        Serializable serializable;
        InternetAddress internetAddress;
        this.validationHandler.validate();
        if (!this.validationHandler.isValid()) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Your input is incomplete!"), (Component)((Object)this));
            return;
        }
        DbMailAccount dbMailAccount = (DbMailAccount)this.accountBox.getSelectedItem();
        Map<RecipientType, List<Address>> map = this.getEmailRecipients();
        if (map.isEmpty() || !map.containsKey((Object)RecipientType.TO) && !map.containsKey((Object)RecipientType.CC) && !map.containsKey((Object)RecipientType.BCC)) {
            internetAddress = dbMailAccount.getSenderFromAddress();
            if (internetAddress != null) {
                serializable = new ArrayList<Address>();
                serializable.add(this.addressHandler.createAddress(internetAddress));
                map.put(RecipientType.TO, (List<Address>)((Object)serializable));
            } else {
                ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("No recipient was provided for the e-mail!"), (Component)((Object)this));
                return;
            }
        }
        try {
            internetAddress = this.getEmail(dbMailAccount, map);
        }
        catch (Exception exception) {
            LOGGER.error("Can't build e-mail!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't build e-mail!"), (Component)ImmoToolEnvironment.getFrame());
            return;
        }
        serializable = new JFileChooser();
        ((JFileChooser)serializable).setSelectedFile(new File(System.currentTimeMillis() + ".eml"));
        ((JFileChooser)serializable).setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file != null && (file.isDirectory() || file.getName().toLowerCase().endsWith(".eml"));
            }

            @Override
            public String getDescription() {
                return I18N.tr("e-mails") + " (*.eml)";
            }
        });
        int n = ((JFileChooser)serializable).showSaveDialog((Component)((Object)this));
        if (n != 0) {
            return;
        }
        File file = ((JFileChooser)serializable).getSelectedFile();
        ImmoToolUtils.executeTask((ImmoToolTask)new SaveIntoFileTask((Email)internetAddress, file));
    }

    public void doSaveAsTemplate() {
        this.doSaveIntoSpecialFolder(DbMailFolder.SpecialType.TEMPLATES, false, false);
    }

    private void doSaveIntoSpecialFolder(DbMailFolder.SpecialType specialType, boolean bl, boolean bl2) {
        Email email;
        boolean bl3;
        DbMailAccount dbMailAccount;
        if (!bl2) {
            this.validationHandler.validate();
            if (!this.validationHandler.isValid()) {
                ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Your input is incomplete!"), (Component)((Object)this));
                return;
            }
        }
        if ((dbMailAccount = (DbMailAccount)this.accountBox.getSelectedItem()) == null) {
            dbMailAccount = MailPlugin.getMailHandler().getLocalPrivateAccount();
        }
        if (dbMailAccount == null) {
            return;
        }
        Map<RecipientType, List<Address>> map = this.getEmailRecipients();
        boolean bl4 = bl3 = map.isEmpty() || !map.containsKey((Object)RecipientType.TO) && !map.containsKey((Object)RecipientType.CC) && !map.containsKey((Object)RecipientType.BCC);
        if (bl3) {
            InternetAddress internetAddress = dbMailAccount.getSenderFromAddress();
            if (internetAddress != null) {
                ArrayList<Address> arrayList = new ArrayList<Address>();
                arrayList.add(this.addressHandler.createAddress(internetAddress));
                map.put(RecipientType.TO, arrayList);
            } else {
                if (!bl2) {
                    ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("No recipient was provided for the e-mail!"), (Component)((Object)this));
                }
                return;
            }
        }
        long l = this.getCurrentMessageHash();
        try {
            email = this.getEmail(dbMailAccount, map);
        }
        catch (Exception exception) {
            LOGGER.error("Can't build e-mail!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't build e-mail!"), (Component)ImmoToolEnvironment.getFrame());
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new SaveIntoFolderTask(dbMailAccount.id, email, l, specialType, map, bl3, bl, bl2));
    }

    private static String generateMessage(DbMailMessage dbMailMessage, DbMailPart dbMailPart, ContentType contentType, ViewMode viewMode) throws IOException, AddressException {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        Object object2;
        boolean bl;
        String string = null;
        boolean bl2 = bl = ViewMode.FORWARD.equals((Object)viewMode) || ViewMode.REPLY.equals((Object)viewMode);
        if (bl) {
            object2 = InternetAddress.parse((String)dbMailMessage.from)[0];
            object = object2.getPersonal();
            if (object == null || ((String)object).trim().length() == 0) {
                object = object2.getAddress();
            }
            serializable2 = dbMailMessage.isReceived && dbMailMessage.receivedAt != null ? dbMailMessage.receivedAt : dbMailMessage.sentAt;
            serializable = DateFormat.getDateTimeInstance(2, 3);
            string = I18N.tr("{0} wrote at {1}:", (Object)('\"' + (String)object + '\"'), (Object)((DateFormat)serializable).format((Date)serializable2));
        }
        if (contentType.match("text/html")) {
            object2 = dbMailPart.text;
            object2 = object2 != null ? StringEscapeUtils.unescapeHtml4((String)object2) : "";
            object = ImmoToolUtils.tidy();
            object.setWord2000(true);
            object.setXHTML(false);
            object.setHideComments(true);
            object.setHideEndTags(false);
            object.setPrintBodyOnly(true);
            object.setNumEntities(true);
            object.setQuoteAmpersand(true);
            object.setForceOutput(true);
            object2 = ImmoToolUtils.tidy((Tidy)object, (String)object2);
            if (object2 != null && bl) {
                object2 = "<p>&nbsp;</p>" + System.lineSeparator() + "<hr class=\"quote_begin\">" + System.lineSeparator() + "<p><b><font face=\"sans-serif\">" + StringEscapeUtils.escapeXml11((String)string) + "</font></b></p>" + System.lineSeparator() + "<blockquote style=\"background-color:#F0F0F0; padding:5px;\">" + (String)object2 + "</blockquote>" + System.lineSeparator() + "<hr class=\"quote_end\">" + System.lineSeparator() + "<p>&nbsp;</p>";
            }
            return object2;
        }
        if (contentType.match("text/plain")) {
            object2 = dbMailPart.text;
            if (object2 != null && bl) {
                object = new StringReader(((String)object2).trim());
                serializable2 = null;
                try {
                    serializable = new StringBuilder();
                    ((StringBuilder)serializable).append(string).append(System.lineSeparator());
                    for (Object e : IOUtils.readLines((Reader)object)) {
                        ((StringBuilder)serializable).append(System.lineSeparator()).append("> ").append(e);
                    }
                    object2 = ((StringBuilder)serializable).toString();
                }
                catch (Throwable throwable) {
                    serializable2 = throwable;
                    throw throwable;
                }
                finally {
                    if (object != null) {
                        if (serializable2 != null) {
                            try {
                                ((Reader)object).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable2).addSuppressed(throwable);
                            }
                        } else {
                            ((Reader)object).close();
                        }
                    }
                }
            }
            return StringUtils.trimToEmpty((String)object2);
        }
        return null;
    }

    public JButton getAttachmentButton() {
        return this.attachmentButton;
    }

    public long getCurrentMessageHash() {
        long l = 0L;
        DbMailAccount dbMailAccount = (DbMailAccount)this.accountBox.getSelectedItem();
        if (dbMailAccount != null) {
            l += (long)(dbMailAccount.name.hashCode() + Long.valueOf(dbMailAccount.id).hashCode());
        }
        Map<RecipientType, List<Address>> map = this.getEmailRecipients();
        for (Map.Entry<RecipientType, List<Address>> object : map.entrySet()) {
            l += (long)object.getKey().hashCode();
            for (Address address : object.getValue()) {
                l += (long)address.hashCode();
            }
        }
        l += (long)this.subjectField.getText().trim().hashCode();
        for (int i = 0; i < this.attachmentList.getModel().getSize(); ++i) {
            AttachmentItem attachmentItem = this.attachmentList.getModel().getElementAt(i);
            l += (long)attachmentItem.getFile().hashCode();
            l += (long)attachmentItem.getName().hashCode();
        }
        l += (long)this.mailEditor.getMode().hashCode();
        if (this.mailEditor.isTextOnlyMode()) {
            l += (long)this.mailEditor.getPlainText().trim().hashCode();
        }
        if (this.mailEditor.isHtmlOnlyMode()) {
            l += (long)this.mailEditor.getHtmlText().trim().hashCode();
        }
        return l;
    }

    public Email getEmail(DbMailAccount dbMailAccount, Map<RecipientType, List<Address>> map) throws ImmoToolException, EmailException {
        return this.getEmail(dbMailAccount, map, this.getEmailSubject(), this.getEmailPlainText(), this.getEmailHtmlText());
    }

    public Email getEmail(DbMailAccount dbMailAccount, Map<RecipientType, List<Address>> map, String string, String string2, String string3) throws ImmoToolException, EmailException {
        Object object2;
        HtmlEmail htmlEmail;
        Object object3;
        String string4 = Charset.defaultCharset().name();
        Session session = dbMailAccount.buildWriterSession();
        if (this.mailEditor.isTextOnlyMode()) {
            if (this.attachmentList.getModel().getSize() < 1) {
                object3 = new SimpleEmail();
                if (!StringUtils.isBlank((CharSequence)string2)) {
                    object3.setMsg(string2.trim());
                }
                htmlEmail = object3;
            } else {
                object3 = new MultiPartEmail();
                if (!StringUtils.isBlank((CharSequence)string2)) {
                    object3.addPart(string2.trim(), "text/plain; charset=" + string4);
                }
                htmlEmail = object3;
            }
        } else if (this.mailEditor.isHtmlOnlyMode()) {
            object3 = new HtmlEmail();
            string3 = ImmoToolUtils.getHtmlBody((String)string3);
            string3 = StringEscapeUtils.unescapeHtml4((String)StringEscapeUtils.escapeXml11((String)string3));
            object3.setHtmlMsg("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">" + System.lineSeparator() + "<html>" + System.lineSeparator() + "<head><title></title></head>" + System.lineSeparator() + "<body>" + System.lineSeparator() + string3 + "</body>" + System.lineSeparator() + "</html>");
            object2 = StringUtils.trimToNull((String)HtmlToPlainText.toPlainText((String)string3));
            if (object2 != null) {
                object3.setTextMsg((String)object2);
            }
            htmlEmail = object3;
        } else {
            throw new ImmoToolException("Invalid message type!");
        }
        if (htmlEmail == null) {
            throw new ImmoToolException("Can't construct email!");
        }
        htmlEmail.setMailSession(session);
        htmlEmail.setSubject(string);
        htmlEmail.setCharset(string4);
        htmlEmail.setFrom(dbMailAccount.getSenderFromMail(), dbMailAccount.getSenderFromName());
        htmlEmail.addHeader("X-OpenEstate-ImmoTool-Version", ImmoToolEnvironment.getApplicationVersion());
        if (!StringUtils.isEmpty((CharSequence)this.referencedMessageMimeId)) {
            htmlEmail.addHeader("References", this.referencedMessageMimeId);
            htmlEmail.addHeader("In-Reply-To", this.referencedMessageMimeId);
        }
        object3 = new TreeMap();
        for (Map.Entry object4 : map.entrySet()) {
            RecipientType recipientType = (RecipientType)((Object)object4.getKey());
            for (Address address : (List)object4.getValue()) {
                this.addressHandler.addRecipient(address, recipientType, (Email)htmlEmail, (Map<Long, String>)object3);
            }
        }
        if (!object3.isEmpty()) {
            object2 = new StringBuilder();
            for (Map.Entry entry : object3.entrySet()) {
                if (((StringBuilder)object2).length() > 0) {
                    ((StringBuilder)object2).append(";");
                }
                ((StringBuilder)object2).append(entry.getKey()).append(",").append((String)entry.getValue());
            }
            htmlEmail.addHeader("X-OpenEstate-ImmoTool-Contacts", ((StringBuilder)object2).toString());
        }
        for (int i = 0; i < this.attachmentList.getModel().getSize(); ++i) {
            AttachmentItem attachmentItem = this.attachmentList.getModel().getElementAt(i);
            if (!attachmentItem.getFile().isFile()) {
                LOGGER.warn("Can't find attached file anymore!");
                LOGGER.warn("> " + attachmentItem.getFile().getAbsolutePath());
                continue;
            }
            EmailAttachment emailAttachment = new EmailAttachment();
            emailAttachment.setPath(attachmentItem.getFile().getAbsolutePath());
            emailAttachment.setName(attachmentItem.getName());
            emailAttachment.setDisposition("attachment");
            emailAttachment.setDescription("");
            ((MultiPartEmail)htmlEmail).attach(emailAttachment);
        }
        if (this.priorityHighButton.isSelected()) {
            MailPriority.writeToHeader(MailPriority.HIGH, (Email)htmlEmail);
        } else if (this.priorityNormalButton.isSelected()) {
            MailPriority.writeToHeader(MailPriority.NORMAL, (Email)htmlEmail);
        } else if (this.priorityLowButton.isSelected()) {
            MailPriority.writeToHeader(MailPriority.LOW, (Email)htmlEmail);
        }
        if (this.notifyReceptionButton.isSelected()) {
            MailNotification.writeToHeader(htmlEmail.getFromAddress(), (Email)htmlEmail);
        }
        return htmlEmail;
    }

    public String getEmailHtmlText() {
        return this.mailEditor.getHtmlText().trim();
    }

    public String getEmailPlainText() {
        return this.mailEditor.getPlainText().trim();
    }

    public Map<RecipientType, List<Address>> getEmailRecipients() {
        EnumMap<RecipientType, List<Address>> enumMap = new EnumMap<RecipientType, List<Address>>(RecipientType.class);
        for (RecipientField recipientField : this.recipientFields) {
            Address address;
            RecipientType recipientType = recipientField.getType();
            if (recipientType == null || (address = recipientField.getAddress()) == null || address.isBlank()) continue;
            if (!enumMap.containsKey((Object)recipientType)) {
                enumMap.put(recipientType, new ArrayList());
            }
            ((List)enumMap.get((Object)recipientType)).add(address);
        }
        return enumMap;
    }

    public String getEmailSubject() {
        return this.subjectField.getText().trim();
    }

    public ViewMode getMode() {
        return this.mode;
    }

    public JButton getOptionsButton() {
        return this.optionsButton;
    }

    public long getReferencedMessageId() {
        return this.referencedMessageId;
    }

    public String getReferencedMessageMimeId() {
        return this.referencedMessageMimeId;
    }

    public DefaultSplitButton getSaveButton() {
        return this.saveButton;
    }

    public long getSavedMessageHash() {
        return this.savedMessageHash;
    }

    public DbMailAccount getSelectedAccount() {
        return (DbMailAccount)this.accountBox.getSelectedItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(long l) {
        MailHandler mailHandler = MailPlugin.getMailHandler();
        if (l < 1L && this.currentAccount != null) {
            l = this.currentAccount.id;
        }
        this.savedMessages.clear();
        this.savedMessageAccountIds.clear();
        try {
            this.accountBox.setEnabled(false);
            this.accountBox.removeAllItems();
            this.accountBox.addItem(null);
            int n = -1;
            for (DbMailAccount dbMailAccount : mailHandler.getRemoteAccounts()) {
                AbstractMailWriter.Type type = dbMailAccount.getWriterType();
                if (!AbstractMailWriter.Type.SMTP.equals((Object)type)) continue;
                this.accountBox.addItem(dbMailAccount);
                if (l <= 0L || l != dbMailAccount.id) continue;
                n = this.accountBox.getItemCount() - 1;
            }
            if (n > -1) {
                this.accountBox.setSelectedIndex(n);
            } else {
                this.accountBox.setSelectedIndex(this.accountBox.getItemCount() > 1 ? 1 : 0);
            }
        }
        finally {
            this.accountBox.setEnabled(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initMessage(Connection connection, DbMailMessage dbMailMessage, DbMailPart dbMailPart) {
        void var9_11;
        Object object;
        DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
        this.referencedMessageId = dbMailMessage.id;
        this.referencedMessageMimeId = ViewMode.REPLY.equals((Object)this.mode) || ViewMode.FORWARD.equals((Object)this.mode) ? dbMailMessage.mimeId : dbMailMessage.inReplyTo;
        String string = StringUtils.trimToEmpty((String)dbMailMessage.subject);
        if (ViewMode.REPLY.equals((Object)this.mode)) {
            string = "Re: " + string;
        } else if (ViewMode.FORWARD.equals((Object)this.mode)) {
            string = "Fwd: " + string;
        }
        this.subjectField.setText(string);
        MailPriority mailPriority = MailPriority.readFromHeader(dbMailPart);
        if (MailPriority.HIGH.equals((Object)mailPriority)) {
            this.priorityHighButton.setSelected(true);
        } else if (MailPriority.NORMAL.equals((Object)mailPriority)) {
            this.priorityNormalButton.setSelected(true);
        } else if (MailPriority.LOW.equals((Object)mailPriority)) {
            this.priorityLowButton.setSelected(true);
        } else {
            this.priorityDisabledButton.setSelected(true);
        }
        Object[] objectArray = MailNotification.readFromHeader(dbMailPart);
        this.notifyReceptionButton.setSelected(!ArrayUtils.isEmpty((Object[])objectArray));
        this.preLoadedAddresses = new ArrayList<DbMailAddress>();
        if (ViewMode.DRAFT.equals((Object)this.mode) || ViewMode.TEMPLATE.equals((Object)this.mode)) {
            this.preLoadedAddresses.addAll(Arrays.asList(dbMailMessage.getAddresses()));
        } else if (ViewMode.REPLY.equals((Object)this.mode)) {
            object = dbMailMessage.getAddresses(DbMailAddress.Type.REPLY_TO);
            if (ArrayUtils.isEmpty((Object[])object)) {
                object = dbMailMessage.getAddresses(DbMailAddress.Type.FROM);
            }
            if (!ArrayUtils.isEmpty((Object[])object)) {
                for (Object object2 : object) {
                    DbMailAddress dbMailAddress = new DbMailAddress();
                    dbMailAddress.type = DbMailAddress.Type.TO;
                    dbMailAddress.person = ((DbMailAddress)object2).person;
                    dbMailAddress.value = ((DbMailAddress)object2).value;
                    this.preLoadedAddresses.add(dbMailAddress);
                }
            }
        }
        this.attachmentList.setEnabled(false);
        this.tempDownloadedFiles = !ViewMode.REPLY.equals((Object)this.mode) ? MailPluginUtils.downloadAttachments(connection, dbMailMessageHandler, dbMailPart, true) : new HashMap<Long, File>();
        object = (DefaultListModel)this.attachmentList.getModel();
        ((DefaultListModel)object).removeAllElements();
        Object var9_10 = null;
        String string2 = null;
        for (DbMailPart dbMailPart2 : dbMailPart.getSingleParts()) {
            try {
                String string3;
                ContentType contentType = new ContentType(dbMailPart2.type);
                if (this.tempDownloadedFiles.containsKey(dbMailPart2.id)) {
                    ((DefaultListModel)object).addElement(new AttachmentItem(this.tempDownloadedFiles.get(dbMailPart2.id), dbMailPart2.fileName));
                    continue;
                }
                if (!StringUtils.isEmpty((CharSequence)dbMailPart2.disposition)) continue;
                if (var9_11 == null && contentType.match("text/plain")) {
                    string3 = MailEditor.generateMessage(dbMailMessage, dbMailPart2, contentType, this.mode);
                    String string4 = StringUtils.trimToEmpty((String)string3);
                    continue;
                }
                if (string2 != null || !contentType.match("text/html")) continue;
                string3 = MailEditor.generateMessage(dbMailMessage, dbMailPart2, contentType, this.mode);
                string2 = StringUtils.trimToEmpty((String)string3);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read single part!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.attachmentList.setEnabled(true);
        if (var9_11 != null) {
            this.mailEditor.setPlainText((String)var9_11);
        }
        if (string2 != null) {
            this.mailEditor.setHtmlText(string2);
        }
    }

    public void initValidation() {
        this.validationHandler.init();
    }

    public void insertText(String string) {
        this.mailEditor.insertText(string);
    }

    public void insertText(String string, int n) {
        this.mailEditor.insertText(string, n);
    }

    public boolean isDraftMode() {
        return ViewMode.DRAFT.equals((Object)this.mode);
    }

    public boolean isForwardMode() {
        return ViewMode.FORWARD.equals((Object)this.mode);
    }

    public boolean isNewMode() {
        return ViewMode.NEW.equals((Object)this.mode);
    }

    public boolean isReplyMode() {
        return ViewMode.REPLY.equals((Object)this.mode);
    }

    public boolean isTemplateMode() {
        return ViewMode.TEMPLATE.equals((Object)this.mode);
    }

    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    private void load(Connection connection, long l) throws SQLException, MessagingException, IOException {
        DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
        MailHandler mailHandler = MailPlugin.getMailHandler();
        DbMailMessage dbMailMessage = l > 0L ? dbMailMessageHandler.getMessage(connection, l) : null;
        DbMailPart dbMailPart = null;
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        if (l < 1L || dbMailMessage == null) {
            this.init(0L);
            this.updateAccount(true);
        } else {
            DbMailAccount dbMailAccount;
            dbMailMessage = dbMailMessageHandler.getMessage(connection, l);
            dbMailMessageHandler.loadAddresses(connection, dbMailMessage);
            DbMailFolder dbMailFolder = dbMailMessageHandler.getFolder(connection, dbMailMessage.folderId);
            DbMailAccount dbMailAccount2 = dbMailAccount = dbMailFolder != null ? mailHandler.getRemoteAccount(dbMailFolder.accountId) : null;
            if (dbMailAccount == null) {
                dbMailAccount = mailHandler.getLocalPrivateAccount();
            }
            this.init(dbMailAccount.id);
            this.updateAccount(true);
            if (!dbMailMessage.isDownloaded) {
                mailHandler.loadRemoteMessage(ImmoToolProject.getAppInstance(), connection, dbMailMessage, dbMailFolder);
            }
            dbMailPart = dbMailMessageHandler.getPartOnRoot(connection, l);
            dbMailMessageHandler.loadPartChildren(connection, dbMailPart, true);
            dbMailMessageHandler.loadPartHeaders(connection, dbMailPart, true);
            Object[] objectArray = dbMailPart.getHeader("X-OpenEstate-ImmoTool-Contacts");
            if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                for (Object object : objectArray) {
                    if (StringUtils.isBlank((CharSequence)((DbMailHeader)object).value)) continue;
                    for (String string : StringUtils.split((String)((DbMailHeader)object).value.trim(), (String)";")) {
                        String[] stringArray;
                        if (StringUtils.isBlank((CharSequence)string) || (stringArray = StringUtils.split((String)string.trim(), (String)",", (int)2)).length != 2) continue;
                        try {
                            Long l2 = Long.valueOf(stringArray[0]);
                            if (hashMap.containsKey(l2)) continue;
                            hashMap.put(l2, stringArray[1]);
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Can't read contact hash from '" + string + "'!");
                            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        }
                    }
                }
            }
        }
        if (dbMailMessage != null) {
            this.initMessage(connection, dbMailMessage, dbMailPart);
        }
        this.validationHandler.init();
        for (MailEditorExtension mailEditorExtension : this.extensions) {
            try {
                mailEditorExtension.loadMessage(connection, dbMailMessage, dbMailPart, hashMap, this.mode);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load mail!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAsDraft(long l) throws SQLException, MessagingException, IOException {
        Connection connection = null;
        try {
            connection = ImmoToolProject.getAppInstance().getDbConnection();
            this.loadAsDraft(connection, l);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void loadAsDraft(Connection connection, long l) throws SQLException, MessagingException, IOException {
        this.clear();
        this.mode = ViewMode.DRAFT;
        this.load(connection, l);
        this.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAsForward(long l) throws SQLException, MessagingException, IOException {
        Connection connection = null;
        try {
            connection = ImmoToolProject.getAppInstance().getDbConnection();
            this.loadAsForward(connection, l);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void loadAsForward(Connection connection, long l) throws SQLException, MessagingException, IOException {
        this.clear();
        this.mode = ViewMode.FORWARD;
        this.load(connection, l);
        this.startup();
    }

    public void loadAsNew() throws SQLException, MessagingException, IOException {
        this.loadAsNew(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAsNew(long l) throws SQLException, MessagingException, IOException {
        Connection connection = null;
        try {
            connection = ImmoToolProject.getAppInstance().getDbConnection();
            this.loadAsNew(connection, l);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void loadAsNew(Connection connection, long l) throws SQLException, MessagingException, IOException {
        this.clear();
        this.mode = ViewMode.NEW;
        this.load(connection, l);
        this.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAsReply(long l) throws SQLException, MessagingException, IOException {
        Connection connection = null;
        try {
            connection = ImmoToolProject.getAppInstance().getDbConnection();
            this.loadAsReply(connection, l);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void loadAsReply(Connection connection, long l) throws SQLException, MessagingException, IOException {
        this.clear();
        this.mode = ViewMode.REPLY;
        this.load(connection, l);
        this.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAsTemplate(long l) throws SQLException, MessagingException, IOException {
        Connection connection = null;
        try {
            connection = ImmoToolProject.getAppInstance().getDbConnection();
            this.loadAsTemplate(connection, l);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public void loadAsTemplate(Connection connection, long l) throws SQLException, MessagingException, IOException {
        this.clear();
        this.mode = ViewMode.TEMPLATE;
        this.load(connection, l);
        this.startup();
    }

    public void removeEmptyRecipients() {
        RecipientField recipientField;
        int n;
        if (this.recipientFields.size() < 2) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < this.recipientFields.size(); ++n) {
            recipientField = this.recipientFields.get(n);
            Address address = recipientField.getAddress();
            if (address != null && !ArrayUtils.isEmpty((Object[])address.getInternetAddresses())) continue;
            arrayList.add(n);
        }
        if (!arrayList.isEmpty()) {
            for (n = arrayList.size() - 1; n >= 0; --n) {
                recipientField = this.recipientFields.get(n);
                this.recipientFields.remove(recipientField);
                if (this.recipientFields.size() < 2) break;
            }
            this.recipientFields.trimToSize();
            this.updateRecipients();
            n = this.recipientFields.size() - 1;
            this.recipientFields.get(n).addressField.requestFocus();
        }
    }

    private void removeRecipient(RecipientField recipientField) {
        if (this.recipientFields.size() < 2) {
            return;
        }
        int n = this.recipientFields.indexOf(recipientField);
        if (n < 0) {
            return;
        }
        this.recipientFields.remove(recipientField);
        this.recipientFields.trimToSize();
        this.updateRecipients();
        if (this.recipientFields.size() > n) {
            this.recipientFields.get(n).addressField.requestFocus();
        } else if (n > 0 && this.recipientFields.size() > --n) {
            this.recipientFields.get(n).addressField.requestFocus();
        }
    }

    public void saveAdditionally(Connection connection, DbMailMessage dbMailMessage, Map<RecipientType, List<Address>> map, SaveMode saveMode) {
        if (this.extensions.isEmpty()) {
            return;
        }
        if (dbMailMessage == null || dbMailMessage.id < 1L) {
            throw new IllegalArgumentException("An invalid message was provided!");
        }
        for (MailEditorExtension mailEditorExtension : this.extensions) {
            try {
                mailEditorExtension.saveMessage(connection, dbMailMessage, map, saveMode);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load mail!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    private void scrollRecipientsToBottom() {
        int n = this.recipientsPanel.getPreferredSize().height;
        this.recipientsPanel.scrollRectToVisible(new Rectangle(0, n, 10, 10));
    }

    public void setHtmlText(String string) {
        this.mailEditor.setHtmlText(string);
    }

    public static synchronized void setLastAttachmentLocation(File file) {
        lastAttachmentLocation = file;
    }

    public void setPlainText(String string) {
        this.mailEditor.setPlainText(string);
    }

    private void showMessageOptions(Component component, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenu jMenu = new JMenu();
        jMenu.setText(StringUtils.capitalize((String)I18N.tr("text input")));
        jMenu.add(this.modePlainButton);
        jMenu.add(this.modeHtmlButton);
        jPopupMenu.add(jMenu);
        JMenu jMenu2 = new JMenu();
        jMenu2.setText(StringUtils.capitalize((String)I18N.tr("priority")));
        jMenu2.add(this.priorityLowButton);
        jMenu2.add(this.priorityNormalButton);
        jMenu2.add(this.priorityHighButton);
        jMenu2.addSeparator();
        jMenu2.add(this.priorityDisabledButton);
        jPopupMenu.add(jMenu2);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.notifyReceptionButton);
        for (MailEditorExtension mailEditorExtension : this.extensions) {
            try {
                Object[] objectArray = mailEditorExtension.createOptionMenuItems(this);
                if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
                for (Object object : objectArray) {
                    jPopupMenu.add((JMenuItem)object);
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load message options!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        jPopupMenu.show(component, n, n2);
    }

    private void startup() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (MailEditor.this.preLoadedAddresses != null && RecipientMode.ALL.equals((Object)MailEditor.this.recipientMode)) {
                    for (DbMailAddress dbMailAddress : MailEditor.this.preLoadedAddresses) {
                        InternetAddress internetAddress;
                        Address address;
                        RecipientType recipientType = RecipientType.fromDbMailAddressType(dbMailAddress.type);
                        if (recipientType == null || (address = (internetAddress = dbMailAddress.toInternetAddress()) != null ? MailEditor.this.addressHandler.loadAddress(internetAddress) : null) == null) continue;
                        MailEditor.this.addRecipient(recipientType, address);
                    }
                    MailEditor.this.preLoadedAddresses.clear();
                    MailEditor.this.preLoadedAddresses = null;
                }
                try {
                    MailEditor.this.accountBox.setEnabled(false);
                    if (MailEditor.this.accountBox.getItemCount() < 2) {
                        if (RecipientMode.ALL.equals((Object)MailEditor.this.recipientMode)) {
                            MailEditor.this.addRecipient(RecipientType.TO, null);
                        }
                    } else {
                        int n = MailEditor.this.accountBox.getSelectedIndex();
                        if (n < 2) {
                            MailEditor.this.accountBox.setSelectedIndex(1);
                        } else {
                            MailEditor.this.accountBox.setSelectedIndex(n);
                        }
                        MailEditor.this.updateAccount(true);
                    }
                }
                finally {
                    MailEditor.this.accountBox.setEnabled(true);
                }
                if (MailEditor.this.attachmentList.getModel().getSize() > 0) {
                    MailEditor.this.updateAttachments();
                }
                MailEditor.this.savedMessageHash = MailEditor.this.getCurrentMessageHash();
                if (MailEditor.this.saveAsTemporaryDraft) {
                    MailEditor.this.tempDraftMessageHash = MailEditor.this.savedMessageHash;
                    if (MailEditor.this.tempDraftTimer == null) {
                        MailEditor.this.tempDraftTimer = new Timer(60000, new ActionListener(){
                            private boolean isRunning = false;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if (this.isRunning) {
                                    return;
                                }
                                this.isRunning = true;
                                try {
                                    long l = MailEditor.this.getCurrentMessageHash();
                                    if (l == MailEditor.this.tempDraftMessageHash) {
                                        return;
                                    }
                                    MailEditor.this.tempDraftMessageHash = l;
                                    MailEditor.this.doSaveIntoSpecialFolder(DbMailFolder.SpecialType.DRAFTS, true, true);
                                }
                                finally {
                                    this.isRunning = false;
                                }
                            }
                        });
                        MailEditor.this.tempDraftTimer.start();
                    }
                }
                MailEditor.this.validationHandler.init();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                LOGGER.error("Can't add recipient!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateAccount(boolean bl) {
        InternetAddress[] internetAddressArray;
        Object object;
        Object object2;
        DbMailAccount dbMailAccount = (DbMailAccount)this.accountBox.getSelectedItem();
        if (this.currentAccount != null) {
            if (!bl && dbMailAccount != null && this.currentAccount.id == dbMailAccount.id) {
                return;
            }
            if (!RecipientMode.ALL.equals((Object)this.recipientMode)) {
                this.recipientFields.clear();
                this.updateRecipients();
            } else {
                object2 = this.currentAccount.getSenderReplyTo();
                if (!StringUtils.isEmpty((CharSequence)object2)) {
                    for (RecipientField recipientField : this.recipientFields.toArray(new RecipientField[0])) {
                        Address address;
                        if (!RecipientType.REPLY_TO.equals((Object)recipientField.getType()) || (address = recipientField.getAddress()) == null) continue;
                        object = address.getInternetAddresses();
                        InternetAddress[] internetAddressArray2 = internetAddressArray = object != null && ((InternetAddress[])object).length == 1 ? object[0] : null;
                        if (internetAddressArray == null || !((String)object2).equalsIgnoreCase(internetAddressArray.getAddress())) continue;
                        this.removeRecipient(recipientField);
                        break;
                    }
                }
            }
        }
        if (dbMailAccount != null) {
            object2 = dbMailAccount.getSenderReplyToAddress();
            if (!RecipientMode.NONE.equals((Object)this.recipientMode)) {
                if (RecipientMode.ONE_REPLY_TO.equals((Object)this.recipientMode)) {
                    this.addRecipient(RecipientType.REPLY_TO, this.addressHandler.createAddress((InternetAddress)object2));
                    RecipientField bl2 = this.recipientFields.get(this.recipientFields.size() - 1);
                    bl2.typeButton.setEnabled(false);
                } else if (RecipientMode.ALL.equals((Object)this.recipientMode) && object2 != null) {
                    boolean bl2;
                    boolean mode = false;
                    for (RecipientField recipientField : this.recipientFields.toArray(new RecipientField[0])) {
                        InternetAddress internetAddress;
                        if (!RecipientType.REPLY_TO.equals((Object)recipientField.getType()) || (object = recipientField.getAddress()) == null) continue;
                        internetAddressArray = object.getInternetAddresses();
                        InternetAddress internetAddress2 = internetAddress = internetAddressArray != null && internetAddressArray.length == 1 ? internetAddressArray[0] : null;
                        if (internetAddress == null || !object2.getAddress().equalsIgnoreCase(internetAddress.getAddress())) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        void var5_15;
                        void var5_13;
                        RecipientField recipientField;
                        Address address;
                        Object var5_11 = null;
                        if (!this.recipientFields.isEmpty() && ((address = (recipientField = this.recipientFields.get(this.recipientFields.size() - 1)).getAddress()) == null || address.isBlank())) {
                            RecipientField recipientField2 = recipientField;
                        }
                        if (var5_13 == null) {
                            this.addRecipient(RecipientType.REPLY_TO, null);
                            RecipientField recipientField3 = this.recipientFields.get(this.recipientFields.size() - 1);
                        }
                        var5_15.setAddress(this.addressHandler.createAddress((InternetAddress)object2));
                        var5_15.setType(RecipientType.REPLY_TO);
                        this.addRecipient(RecipientType.TO, null);
                    }
                }
            }
        }
        if (dbMailAccount != null) {
            this.notifyReceptionButton.setSelected(dbMailAccount.isEditorMdn());
            object2 = dbMailAccount.getEditorPriority();
            if (MailPriority.HIGH.equals(object2)) {
                this.priorityHighButton.setSelected(true);
            } else if (MailPriority.NORMAL.equals(object2)) {
                this.priorityNormalButton.setSelected(true);
            } else if (MailPriority.LOW.equals(object2)) {
                this.priorityLowButton.setSelected(true);
            } else {
                this.priorityDisabledButton.setSelected(true);
            }
            MailEditorPane.Mode mode = dbMailAccount.getEditorMode();
            if (MailEditorPane.Mode.HTML_ONLY.equals((Object)mode)) {
                this.modeHtmlButton.setSelected(true);
            } else if (MailEditorPane.Mode.TEXT_ONLY.equals((Object)mode)) {
                this.modePlainButton.setSelected(true);
            }
            if (mode != null) {
                this.mailEditor.setMode(mode);
            }
            for (MailEditorExtension mailEditorExtension : this.extensions) {
                try {
                    mailEditorExtension.selectAccount(dbMailAccount);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't select new account!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        this.mailEditor.setSignature(dbMailAccount != null ? dbMailAccount.getSenderSignatureText() : null);
        if (this.recipientFields.isEmpty()) {
            this.addRecipient(RecipientType.TO, null);
        }
        this.currentAccount = dbMailAccount;
    }

    private void updateAttachments() {
        DefaultListModel defaultListModel = (DefaultListModel)this.attachmentList.getModel();
        int n = defaultListModel.getSize();
        long l = 0L;
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            AttachmentItem attachmentItem = (AttachmentItem)defaultListModel.getElementAt(i);
            l += attachmentItem.getSize();
        }
        if (n < 1) {
            this.attachmentInfoLabel.setText("Keine Anh\u00e4nge");
            this.topSplitPane.getRightComponent().setVisible(false);
        } else {
            String string = I18N.trn("{0} attachment", "{0} attachments", (long)n, (Object)n);
            this.attachmentInfoLabel.setText("<html>&nbsp;<b>" + string + " <span style=\"color:#606060;\">| " + ImmoToolUtils.getHumanReadableByteCount((long)l) + "</b></span></html>");
            int n2 = this.attachmentInfoLabel.getPreferredSize().width;
            this.attachmentPanel.setMinimumSize(new Dimension(n2 + 5, this.attachmentPanel.getMinimumSize().height));
            if (!this.topSplitPane.getRightComponent().isVisible()) {
                this.topSplitPane.getRightComponent().setVisible(true);
                this.topSplitPane.setDividerLocation(this.topSplitPane.getMaximumDividerLocation() - 25);
            }
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.accountLabel.setText(StringUtils.capitalize((String)I18N.tr("from")) + ":");
        this.subjectLabel.setText(StringUtils.capitalize((String)I18N.tr("subject")) + ":");
        this.saveButton.setText(StringUtils.capitalize((String)I18N.tr("save")));
        this.saveButton.setToolTipText(I18N.tr("Save current message."));
        this.optionsButton.setText(StringUtils.capitalize((String)I18N.tr("options")));
        this.priorityDisabledButton.setText(I18N.tr("without priority"));
        this.priorityNormalButton.setText(MailPriority.NORMAL.getTranslation());
        this.priorityLowButton.setText(MailPriority.LOW.getTranslation());
        this.priorityHighButton.setText(MailPriority.HIGH.getTranslation());
        this.modeHtmlButton.setText(MailEditorPane.Mode.HTML_ONLY.getTranslation());
        this.modePlainButton.setText(MailEditorPane.Mode.TEXT_ONLY.getTranslation());
        this.notifyReceptionButton.setText(I18N.tr("Request mail delivery notification (MDN)."));
    }

    private void updateMainDivider() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (MailEditor.this.recipientFields.size() < 5) {
                    int n = ((MailEditor)MailEditor.this).recipientsPanel.getPreferredSize().height;
                    MailEditor.this.mainSplitPane.setDividerLocation(n + MailEditor.this.fixedSettingsHeight + 1);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                LOGGER.error("Can't add recipient!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    private void updateRecipients() {
        this.recipientsPanel.removeAll();
        this.recipientsFormBuilder = DefaultFormBuilder.create((String)SETTINGS_LAYOUT, (JPanel)this.recipientsPanel);
        for (RecipientField recipientField : this.recipientFields) {
            this.recipientsFormBuilder.add((Component)recipientField.typeButton).xy(1, this.recipientsFormBuilder.nextRow());
            this.recipientsFormBuilder.add((Component)recipientField.addressField.getComponent()).xy(3, this.recipientsFormBuilder.row());
        }
        this.recipientsPanel.revalidate();
        this.recipientsPanel.repaint();
        this.updateMainDivider();
    }

    private class SaveIntoFolderTask
    extends ImmoToolTask<Boolean, Void> {
        private final long accountId;
        private final Email email;
        private final long hash;
        private final DbMailFolder.SpecialType specialType;
        private final Map<RecipientType, List<Address>> recipients;
        private final boolean emptyRecipients;
        private final boolean updateTempDraftMessage;
        private final boolean silently;

        private SaveIntoFolderTask(long l, Email email, long l2, DbMailFolder.SpecialType specialType, Map<RecipientType, List<Address>> map, boolean bl, boolean bl2, boolean bl3) {
            super(I18N.tr("Saving e-mail into mail folder."));
            this.accountId = l;
            this.email = email;
            this.hash = l2;
            this.specialType = specialType;
            this.recipients = map;
            this.emptyRecipients = bl;
            this.updateTempDraftMessage = bl2;
            this.silently = bl3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            MailHandler mailHandler = MailPlugin.getMailHandler();
            DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
            Connection connection = null;
            try {
                long l;
                DbMailMessage dbMailMessage;
                String string;
                connection = immoToolProject.getDbConnection();
                DbMailFolder dbMailFolder = dbMailMessageHandler.getSpecialFolder(connection, this.accountId, this.specialType);
                if (dbMailFolder == null) {
                    dbMailFolder = dbMailMessageHandler.getSpecialFolder(connection, mailHandler.getLocalPrivateAccount().id, this.specialType);
                }
                if (dbMailFolder == null) {
                    throw new Exception("Can't find '" + this.specialType.name() + "' special folder!");
                }
                if (this.updateTempDraftMessage) {
                    string = StringUtils.trimToEmpty((String)this.email.getSubject());
                    this.email.setSubject(("[" + I18N.tr("backup") + "] " + string).trim());
                }
                this.email.buildMimeMessage();
                string = this.email.getMimeMessage();
                string.setFlags(new Flags(Flags.Flag.DRAFT), true);
                if (this.emptyRecipients) {
                    string.removeHeader("To");
                    string.removeHeader("Cc");
                    string.removeHeader("Bcc");
                }
                DbMailMessage dbMailMessage2 = dbMailMessage = this.updateTempDraftMessage ? MailEditor.this.tempDraftMessage : (DbMailMessage)MailEditor.this.savedMessages.get((Object)this.specialType);
                long l2 = this.updateTempDraftMessage ? MailEditor.this.tempDraftAccountId : (l = MailEditor.this.savedMessageAccountIds.containsKey((Object)this.specialType) ? (Long)MailEditor.this.savedMessageAccountIds.get((Object)this.specialType) : 0L);
                if (dbMailMessage == null) {
                    l = this.accountId;
                    dbMailMessage = mailHandler.addMessage(immoToolProject, connection, (MimeMessage)string, dbMailFolder);
                } else if (l > 0L && l != this.accountId) {
                    mailHandler.removeMessages(immoToolProject, connection, new long[]{dbMailMessage.id});
                    l = this.accountId;
                    dbMailMessage = mailHandler.addMessage(immoToolProject, connection, (MimeMessage)string, dbMailFolder);
                } else {
                    dbMailMessage = mailHandler.updateMessage(immoToolProject, connection, (MimeMessage)string, dbMailMessage);
                }
                if (DbMailFolder.SpecialType.DRAFTS.equals((Object)this.specialType)) {
                    MailEditor.this.saveAdditionally(connection, dbMailMessage, this.recipients, SaveMode.DRAFT);
                } else if (DbMailFolder.SpecialType.TEMPLATES.equals((Object)this.specialType)) {
                    MailEditor.this.saveAdditionally(connection, dbMailMessage, this.recipients, SaveMode.TEMPLATE);
                }
                if (this.updateTempDraftMessage) {
                    MailEditor.this.tempDraftMessage = dbMailMessage;
                    MailEditor.this.tempDraftAccountId = l;
                } else {
                    MailEditor.this.savedMessages.put(this.specialType, dbMailMessage);
                    MailEditor.this.savedMessageAccountIds.put(this.specialType, l);
                    MailEditor.this.savedMessageHash = this.hash;
                }
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            if (!this.silently) {
                ImmoToolUtils.showMessageErrorDialog((String)"Can't save message!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            if (!this.silently) {
                ImmoToolUtils.showMessageInfoDialog((String)I18N.tr("The message was saved to folder {0}.", (Object)('\"' + this.specialType.getTranslation() + '\"')), (Component)ImmoToolEnvironment.getFrame());
            }
        }
    }

    private static class SaveIntoFileTask
    extends ImmoToolTask<Boolean, Void> {
        private final Email email;
        private final File file;

        private SaveIntoFileTask(Email email, File file) {
            super(I18N.tr("Saving e-mail as file."));
            this.email = email;
            this.file = file;
        }

        protected Boolean doInBackground() throws Exception {
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
                this.email.buildMimeMessage();
                this.email.getMimeMessage().writeTo((OutputStream)fileOutputStream);
                fileOutputStream.flush();
                Boolean bl = true;
                return bl;
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't save message into file!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            String string = StringUtils.abbreviateMiddle((String)this.file.getAbsolutePath(), (String)"...", (int)75);
            String string2 = "<html><b>" + I18N.tr("The e-mail was saved successfully.") + "</b><br>" + I18N.tr("into file: {0}") + ": " + StringEscapeUtils.escapeXml11((String)string) + "</html>";
            ImmoToolUtils.showMessageInfoDialog((String)string2, (Component)ImmoToolEnvironment.getFrame());
        }
    }

    private class SaveAsTemplateAction
    extends AbstractI18nAction {
        private SaveAsTemplateAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon("folder_templates.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailEditor.this.doSaveAsTemplate();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("save as template")));
            this.setShortDescription(I18N.tr("Save current message as template into mailbox."));
        }
    }

    private class SaveAsFileAction
    extends AbstractI18nAction {
        private SaveAsFileAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailEditor.this.doSaveAsFile();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("save as file")));
            this.setShortDescription(I18N.tr("Save current message as file to harddisk."));
        }
    }

    private class SaveAsDraftAction
    extends AbstractI18nAction {
        private SaveAsDraftAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon("folder_drafts.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailEditor.this.doSaveAsDraft();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("save as draft")));
            this.setShortDescription(I18N.tr("Save current message as draft into mailbox."));
        }
    }

    private class AttachmentRenameAction
    extends AbstractI18nAction {
        private AttachmentRenameAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailEditor.this.doAttachmentRename();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("rename attachnemt")));
            this.setShortDescription(I18N.tr("Cange the file name of the selected attachment."));
        }
    }

    private class AttachmentRemoveAction
    extends AbstractI18nAction {
        private AttachmentRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailEditor.this.doAttachmentRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove attachment")));
            this.setShortDescription(I18N.tr("Remove the selected attachments from the message."));
        }
    }

    private class AttachmentOpenAction
    extends AbstractI18nAction {
        private AttachmentOpenAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_open.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailEditor.this.doAttachmentOpen();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("open attachment")));
            this.setShortDescription(I18N.tr("Open the attachment with an external program."));
        }
    }

    private class AttachmentAddAction
    extends AbstractI18nAction {
        private AttachmentAddAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon("attachment.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailEditor.this.doAttachmentAdd();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("add attachment")));
            this.setShortDescription(I18N.tr("Add an attachment to the message."));
        }
    }

    public static enum ViewMode implements Translatable
    {
        NEW(I18n.marktr((String)"compose a new e-mail")),
        DRAFT(I18n.marktr((String)"edit a draft")),
        TEMPLATE(I18n.marktr((String)"edit a template")),
        REPLY(I18n.marktr((String)"reply to an e-mail")),
        FORWARD(I18n.marktr((String)"forward an e-mail"));

        private final String i18nKey;

        private ViewMode(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(MailEditor.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(MailEditor.class, (String)this.i18nKey, (Locale)locale);
        }
    }

    public static enum SaveMode {
        DRAFT,
        TEMPLATE,
        OUTBOX;

    }

    public static enum RecipientType implements Translatable
    {
        TO(I18n.marktr((String)"to")),
        CC(I18n.marktr((String)"copy (CC)")),
        BCC(I18n.marktr((String)"blind copy (BCC)")),
        REPLY_TO(I18n.marktr((String)"reply to"));

        private final String i18nKey;

        private RecipientType(String string2) {
            this.i18nKey = string2;
        }

        public static RecipientType fromDbMailAddressType(DbMailAddress.Type type) {
            if (DbMailAddress.Type.TO.equals((Object)type)) {
                return TO;
            }
            if (DbMailAddress.Type.CC.equals((Object)type)) {
                return CC;
            }
            if (DbMailAddress.Type.BCC.equals((Object)type)) {
                return BCC;
            }
            if (DbMailAddress.Type.REPLY_TO.equals((Object)type)) {
                return REPLY_TO;
            }
            return null;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(MailEditor.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(MailEditor.class, (String)this.i18nKey, (Locale)locale);
        }
    }

    public static enum RecipientMode {
        ALL,
        ONE_REPLY_TO,
        NONE;

    }

    private static class RecipientField {
        private DefaultSelectButton typeButton;
        private AddressField addressField;

        private RecipientField(AddressField addressField) {
            this.addressField = addressField;
            this.typeButton = new DefaultSelectButton(0);
            this.typeButton.setHorizontalAlignment(4);
            for (RecipientType recipientType : RecipientType.values()) {
                this.typeButton.addOption(recipientType.name(), StringUtils.capitalize((String)recipientType.getTranslation()) + ":");
            }
        }

        private RecipientField(AddressField addressField, RecipientType recipientType, Address address) {
            this(addressField);
            this.setAddress(address);
            this.setType(recipientType);
        }

        public final Address getAddress() {
            return this.addressField.getAddress();
        }

        public final RecipientType getType() {
            String string = this.typeButton.getSelectedKey();
            return string != null ? RecipientType.valueOf(string) : null;
        }

        public final void setAddress(Address address) {
            this.addressField.setAddress(address);
        }

        public final void setType(RecipientType recipientType) {
            this.typeButton.setSelected(recipientType.name(), true);
            this.typeButton.updateText();
        }
    }

    public static class DefaultAddressHandler
    implements AddressHandler {
        @Override
        public void addRecipient(Address address, RecipientType recipientType, Email email, Map<Long, String> map) {
            if (address == null || recipientType == null || email == null) {
                return;
            }
            Object[] objectArray = address.getInternetAddresses();
            if (ArrayUtils.isEmpty((Object[])objectArray)) {
                return;
            }
            for (Object object : objectArray) {
                if (object == null) continue;
                try {
                    String string = object.getAddress();
                    String string2 = object.getPersonal();
                    switch (recipientType) {
                        case TO: {
                            email.addTo(string, string2);
                            break;
                        }
                        case CC: {
                            email.addCc(string, string2);
                            break;
                        }
                        case BCC: {
                            email.addBcc(string, string2);
                            break;
                        }
                        case REPLY_TO: {
                            email.addReplyTo(string, string2);
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't add recipient: " + object.toUnicodeString());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }

        @Override
        public Address createAddress(InternetAddress internetAddress) {
            return new DefaultAddress(internetAddress != null ? internetAddress.toUnicodeString() : "");
        }

        @Override
        public AddressField createAddressField(Address address) {
            return new DefaultAddressField(address);
        }

        @Override
        public Address loadAddress(InternetAddress internetAddress) {
            return this.createAddress(internetAddress);
        }
    }

    public static class DefaultAddressField
    implements AddressField {
        private JTextField field = new JTextField();

        public DefaultAddressField() {
            this(null);
        }

        public DefaultAddressField(Address address) {
            this.setAddress(address);
        }

        @Override
        public void addKeyListener(KeyListener keyListener) {
            this.field.addKeyListener(keyListener);
        }

        @Override
        public Address getAddress() {
            return new DefaultAddress(this.field.getText().trim());
        }

        @Override
        public JComponent getComponent() {
            return this.field;
        }

        @Override
        public void removeKeyListener(KeyListener keyListener) {
            this.field.removeKeyListener(keyListener);
        }

        @Override
        public void requestFocus() {
            this.field.requestFocusInWindow();
        }

        @Override
        public final void setAddress(Address address) {
            Object[] objectArray;
            Object[] objectArray2 = objectArray = address != null ? address.getInternetAddresses() : null;
            if (objectArray == null || ArrayUtils.isEmpty((Object[])objectArray)) {
                this.field.setText("");
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object : objectArray) {
                String string = object.toUnicodeString();
                if (StringUtils.isBlank((CharSequence)string)) continue;
                arrayList.add(string.trim());
            }
            this.field.setText(StringUtils.join(arrayList, (String)", "));
            this.field.setCaretPosition(0);
        }
    }

    public static class DefaultAddress
    implements Address {
        private String value;

        public DefaultAddress(String string) {
            this.value = string;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof DefaultAddress) {
                return this.hashCode() == object.hashCode();
            }
            return false;
        }

        @Override
        public InternetAddress[] getInternetAddresses() {
            String string = StringUtils.trimToNull((String)this.value);
            if (string == null) {
                return new InternetAddress[0];
            }
            ArrayList<InternetAddress> arrayList = new ArrayList<InternetAddress>();
            if (ImmoToolUtils.isValidMailAddress((String)string)) {
                try {
                    arrayList.add(new InternetAddress(ImmoToolUtils.toIdnMailAddress((String)string), null));
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't parse internet address!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            } else {
                try {
                    Object[] objectArray = InternetAddress.parse((String)string, (boolean)false);
                    if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                        for (Object object : objectArray) {
                            if (!ImmoToolUtils.isValidMailAddress((String)object.getAddress())) continue;
                            arrayList.add(ImmoToolUtils.toIdnInternetAddress((InternetAddress)object));
                        }
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't parse internet address!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            return arrayList.toArray(new InternetAddress[0]);
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return !StringUtils.isBlank((CharSequence)this.value) ? this.value.hashCode() : 0;
        }

        @Override
        public boolean isBlank() {
            return ArrayUtils.isEmpty((Object[])this.getInternetAddresses());
        }

        public void setValue(String string) {
            this.value = string;
        }
    }

    private static class AttachmentItem {
        private File file;
        private String name;
        private long size;

        private AttachmentItem(File file, String string) {
            this.file = file.getAbsoluteFile();
            this.size = file.length();
            this.name = string;
        }

        public File getFile() {
            return this.file;
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            return this.file != null ? this.file.getName() : "";
        }

        public long getSize() {
            return this.size > 0L ? this.size : 0L;
        }

        public void setName(String string) {
            this.name = string;
        }
    }

    private static class AttachmentList
    extends JList<AttachmentItem> {
        private AttachmentList(ListModel<AttachmentItem> listModel) {
            super(listModel);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.locationToIndex(mouseEvent.getPoint());
            if (n < 0) {
                return super.getToolTipText(mouseEvent);
            }
            AttachmentItem attachmentItem = (AttachmentItem)this.getModel().getElementAt(n);
            if (attachmentItem == null) {
                return super.getToolTipText(mouseEvent);
            }
            return "<html><div style=\"padding:3px;\"><b>" + StringEscapeUtils.escapeXml11((String)attachmentItem.getName()) + "</b> | " + ImmoToolUtils.getHumanReadableByteCount((long)attachmentItem.getSize()) + "<br>" + StringUtils.abbreviateMiddle((String)attachmentItem.getFile().getPath(), (String)"...", (int)50) + "</div></html>";
        }
    }

    public static interface AddressHandler {
        public void addRecipient(Address var1, RecipientType var2, Email var3, Map<Long, String> var4);

        public Address createAddress(InternetAddress var1);

        public AddressField createAddressField(Address var1);

        public Address loadAddress(InternetAddress var1);
    }

    public static interface AddressField {
        public void addKeyListener(KeyListener var1);

        public Address getAddress();

        public JComponent getComponent();

        public void removeKeyListener(KeyListener var1);

        public void requestFocus();

        public void setAddress(Address var1);
    }

    public static interface Address {
        public boolean equals(Object var1);

        public InternetAddress[] getInternetAddresses();

        public int hashCode();

        public boolean isBlank();
    }
}

