/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.db;

import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Locale;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbMailAddress
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbMailAddress.class);
    private static final I18n I18N = I18nFactory.getI18n(DbMailAddress.class);
    public long messageId = 0L;
    public String value = null;
    public String person = null;
    public Type type = null;

    public static DbMailAddress createAddress(InternetAddress internetAddress, Type type) {
        DbMailAddress dbMailAddress = new DbMailAddress();
        dbMailAddress.value = internetAddress.getAddress();
        dbMailAddress.person = internetAddress.getPersonal();
        dbMailAddress.type = type;
        return dbMailAddress;
    }

    public InternetAddress toInternetAddress() {
        if (StringUtils.isBlank((CharSequence)this.value)) {
            return null;
        }
        try {
            return StringUtils.isBlank((CharSequence)this.person) ? new InternetAddress(this.value.trim()) : new InternetAddress(this.value.trim(), this.person.trim());
        }
        catch (Exception exception) {
            LOGGER.error("Can't create InternetAddress!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public String write() {
        if (this.person != null) {
            return this.person + " (" + this.value + ")";
        }
        return this.value;
    }

    public static String write(DbMailAddress[] dbMailAddressArray) {
        return DbMailAddress.write(dbMailAddressArray, ", ");
    }

    public static String write(DbMailAddress[] dbMailAddressArray, String string) {
        if (dbMailAddressArray == null || dbMailAddressArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (DbMailAddress dbMailAddress : dbMailAddressArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(dbMailAddress.write());
        }
        return stringBuilder.toString();
    }

    public static enum Type implements Translatable
    {
        FROM(I18n.marktr((String)"from")),
        TO(I18n.marktr((String)"to")),
        CC(I18n.marktr((String)"copy (CC)")),
        BCC(I18n.marktr((String)"blind copy (BCC)")),
        REPLY_TO(I18n.marktr((String)"reply to"));

        private final String i18nKey;

        private Type(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(DbMailAddress.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(DbMailAddress.class, (String)this.i18nKey, (Locale)locale);
        }
    }
}

