/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailAccountHandlerImpl;
import com.openindex.openestate.tool.utils.Permission;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbMailAccountHandler
extends DbMailAccountHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbMailAccountHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbMailAccountHandler.class);
    public static final String PROC_REMOVE_ACCOUNTS = "remove_immotool_mails_accounts";
    public static final String PROC_REMOVE_ACCOUNTS_SETTINGS = "remove_immotool_mails_accounts_settings";
    public static final String PROC_SAVE_ACCOUNTS = "save_immotool_mails_accounts";
    public static final String PROC_SAVE_ACCOUNTS_SETTINGS = "save_immotool_mails_accounts_settings";
    public static final String VIEW_ACCOUNTS = "view_immotool_mails_accounts";
    public static final String VIEW_ACCOUNTS_SETTINGS = "view_immotool_mails_accounts_settings";
    public static final String TABLE_ACCOUNTS = "immotool_mails_accounts";
    public static final String FIELD_ACCOUNT_ID = "account_id";
    public static final String FIELD_ACCOUNT_NAME = "account_name";
    public static final String FIELD_ACCOUNT_NOTES = "account_notes";
    public static final String FIELD_ACCOUNT_ENABLED = "account_enabled";
    public static final String FIELD_ACCOUNT_TYPE = "account_type";
    public static final String FIELD_ACCOUNT_AUTO_RETRIEVAL = "account_auto_retrieval";
    public static final String FIELD_ACCOUNT_AUTO_RETRIEVAL_INTERVAL = "account_auto_retrieval_interval";
    public static final String FIELD_ACCOUNT_AUTO_RETRIEVAL_AT = "account_auto_retrieval_at";
    public static final String TABLE_ACCOUNTS_SETTINGS = "immotool_mails_accounts_settings";
    public static final String FIELD_SETTING_KEY = "setting_key";
    public static final String FIELD_SETTING_VALUE = "setting_value";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";
    private static final String FIELD_ACCESS_OWNER_ID = "access_owner_id";
    private static final String FIELD_ACCESS_GROUP_ID = "access_group_id";
    private static final String FIELD_ACCESS_PERMISSIONS = "access_permissions";

    private static DbMailAccount createAccount(ResultSet resultSet) throws SQLException {
        DbMailAccount dbMailAccount = new DbMailAccount();
        dbMailAccount.id = resultSet.getLong(FIELD_ACCOUNT_ID);
        dbMailAccount.name = resultSet.getString(FIELD_ACCOUNT_NAME);
        dbMailAccount.notes = resultSet.getString(FIELD_ACCOUNT_NOTES);
        dbMailAccount.enabled = resultSet.getBoolean(FIELD_ACCOUNT_ENABLED);
        dbMailAccount.autoRetrieval = resultSet.getBoolean(FIELD_ACCOUNT_AUTO_RETRIEVAL);
        dbMailAccount.autoRetrievalAt = resultSet.getTimestamp(FIELD_ACCOUNT_AUTO_RETRIEVAL_AT);
        dbMailAccount.autoRetrievalInterval = resultSet.getLong(FIELD_ACCOUNT_AUTO_RETRIEVAL_INTERVAL);
        dbMailAccount.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbMailAccount.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        dbMailAccount.ownerUserId = resultSet.getLong(FIELD_ACCESS_OWNER_ID);
        dbMailAccount.ownerGroupId = resultSet.getLong(FIELD_ACCESS_GROUP_ID);
        dbMailAccount.permission = new Permission(resultSet.getInt(FIELD_ACCESS_PERMISSIONS));
        String string = resultSet.getString(FIELD_ACCOUNT_TYPE);
        if (StringUtils.isBlank((CharSequence)string)) {
            dbMailAccount.type = DbMailAccount.Type.REMOTE;
        } else {
            try {
                dbMailAccount.type = DbMailAccount.Type.valueOf(string);
            }
            catch (Exception exception) {
                dbMailAccount.type = DbMailAccount.Type.REMOTE;
                LOGGER.warn("Can't load type of account #" + dbMailAccount.id + "!");
                LOGGER.warn("> fallback to 'REMOTE'");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return dbMailAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbMailAccount[] getAccounts(Connection connection, DbMailAccount.Type[] typeArray, Boolean bl) throws SQLException {
        DbMailAccount[] dbMailAccountArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (typeArray != null && typeArray.length > 0) {
                arrayList.add("account_type IN (" + JdbcUtils.writeQuestionMarkList((int)typeArray.length) + ")");
            }
            if (bl != null) {
                arrayList.add("account_enabled = ?");
            }
            preparedStatement = arrayList.isEmpty() ? connection.prepareStatement("SELECT * FROM view_immotool_mails_accounts ORDER BY account_id ASC;") : connection.prepareStatement("SELECT * FROM view_immotool_mails_accounts WHERE " + StringUtils.join(arrayList, (String)" AND ") + " ORDER BY " + FIELD_ACCOUNT_ID + " ASC;");
            int n = 0;
            if (typeArray != null && typeArray.length > 0) {
                for (DbMailAccount.Type type : typeArray) {
                    preparedStatement.setString(++n, type.name());
                }
            }
            if (bl != null) {
                preparedStatement.setBoolean(++n, bl);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList arrayList2 = new ArrayList();
            while (resultSet.next()) {
                arrayList2.add(HSqlDbMailAccountHandler.createAccount(resultSet));
            }
            dbMailAccountArray = arrayList2.toArray(new DbMailAccount[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailAccountArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbMailAccount[] getAccounts(Connection connection, long[] lArray) throws SQLException {
        DbMailAccount[] dbMailAccountArray;
        if (lArray != null && lArray.length == 0) {
            return new DbMailAccount[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_accounts ORDER BY account_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_accounts WHERE account_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_ACCOUNT_ID + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbMailAccount> arrayList = new ArrayList<DbMailAccount>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbMailAccountHandler.createAccount(resultSet));
            }
            dbMailAccountArray = arrayList.toArray(new DbMailAccount[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailAccountArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbMailAccount[] getAccountsForAutoRetrieval(Connection connection) throws SQLException {
        DbMailAccount[] dbMailAccountArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_accounts WHERE account_type = ? AND account_enabled = ? AND account_auto_retrieval = ? ORDER BY account_id ASC;");
            int n = 0;
            preparedStatement.setString(++n, DbMailAccount.Type.REMOTE.name());
            preparedStatement.setBoolean(++n, true);
            preparedStatement.setBoolean(++n, true);
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbMailAccount> arrayList = new ArrayList<DbMailAccount>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbMailAccountHandler.createAccount(resultSet));
            }
            dbMailAccountArray = arrayList.toArray(new DbMailAccount[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailAccountArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getAccountIds(Connection connection) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT account_id FROM view_immotool_mails_accounts ORDER BY account_id ASC;");
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_ACCOUNT_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbMailAccount getPrivateAccount(Connection connection) throws SQLException {
        DbMailAccount dbMailAccount;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_accounts WHERE account_type = ? AND access_owner_id IN ( SELECT user_id FROM view_immotool_users WHERE user_login = USER() ) LIMIT 1;");
            preparedStatement.setString(1, DbMailAccount.Type.LOCAL_PRIVATE.name());
            resultSet = preparedStatement.executeQuery();
            dbMailAccount = resultSet.next() ? HSqlDbMailAccountHandler.createAccount(resultSet) : null;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbMailAccount;
    }

    @Override
    public DbMailAccount[] getSharedAccounts(Connection connection) throws SQLException {
        return this.getAccounts(connection, DbMailAccount.Type.LOCAL_SHARED, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadAccountSettings(Connection connection, DbMailAccount[] dbMailAccountArray) throws SQLException {
        HashMap<Long, DbMailAccount> hashMap = new HashMap<Long, DbMailAccount>();
        for (DbMailAccount dbMailAccount : dbMailAccountArray) {
            if (dbMailAccount.id <= 0L || hashMap.containsKey(dbMailAccount.id)) continue;
            hashMap.put(dbMailAccount.id, dbMailAccount);
            if (dbMailAccount.settings != null) {
                dbMailAccount.settings.clear();
                continue;
            }
            dbMailAccount.settings = new HashMap<String, String>();
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_mails_accounts_settings WHERE account_id IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_ACCOUNT_ID + " ASC, " + FIELD_SETTING_KEY + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong(FIELD_ACCOUNT_ID);
                String string = resultSet.getString(FIELD_SETTING_KEY);
                String string2 = resultSet.getString(FIELD_SETTING_VALUE);
                if (!hashMap.containsKey(l)) continue;
                DbMailAccount dbMailAccount = (DbMailAccount)hashMap.get(l);
                if (string2 == null) continue;
                dbMailAccount.settings.put(string, string2);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    @Override
    public void removeAccounts(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_mails_accounts(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveAccount(Connection connection, DbMailAccount dbMailAccount) throws SQLException {
        ArrayList<CallableStatement> arrayList;
        NamedCallableStatement namedCallableStatement;
        boolean bl;
        block12: {
            bl = connection.getAutoCommit();
            namedCallableStatement = null;
            arrayList = new ArrayList<CallableStatement>();
            try {
                long l;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_mails_accounts(:account_id, :account_name, :account_type, :account_notes, :account_enabled, :account_auto_retrieval, :account_auto_retrieval_interval, :account_auto_retrieval_at, :access_owner_id, :access_group_id, :access_permissions);");
                namedCallableStatement.setLong(FIELD_ACCOUNT_ID, dbMailAccount.id);
                namedCallableStatement.setString(FIELD_ACCOUNT_NAME, StringUtils.abbreviate((String)dbMailAccount.name, (int)100));
                namedCallableStatement.setString(FIELD_ACCOUNT_TYPE, StringUtils.abbreviate((String)(dbMailAccount.type != null ? dbMailAccount.type.name() : DbMailAccount.Type.REMOTE.name()), (int)50));
                namedCallableStatement.setString(FIELD_ACCOUNT_NOTES, dbMailAccount.notes);
                namedCallableStatement.setBoolean(FIELD_ACCOUNT_ENABLED, dbMailAccount.enabled);
                namedCallableStatement.setBoolean(FIELD_ACCOUNT_AUTO_RETRIEVAL, dbMailAccount.autoRetrieval);
                namedCallableStatement.setLong(FIELD_ACCOUNT_AUTO_RETRIEVAL_INTERVAL, dbMailAccount.autoRetrievalInterval);
                namedCallableStatement.setLong(FIELD_ACCESS_OWNER_ID, dbMailAccount.ownerUserId);
                namedCallableStatement.setLong(FIELD_ACCESS_GROUP_ID, dbMailAccount.ownerGroupId);
                namedCallableStatement.setInt(FIELD_ACCESS_PERMISSIONS, dbMailAccount.permission != null ? dbMailAccount.permission.getValue() : -1);
                if (dbMailAccount.autoRetrievalAt != null) {
                    namedCallableStatement.setTimestamp(FIELD_ACCOUNT_AUTO_RETRIEVAL_AT, new Timestamp(dbMailAccount.autoRetrievalAt.getTime()));
                } else {
                    namedCallableStatement.setNull(FIELD_ACCOUNT_AUTO_RETRIEVAL_AT, 93);
                }
                namedCallableStatement.execute();
                long l2 = l = dbMailAccount.id < 1L ? namedCallableStatement.getLong(FIELD_ACCOUNT_ID) : dbMailAccount.id;
                if (l < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                if (dbMailAccount.settings != null) {
                    NamedCallableStatement namedCallableStatement2;
                    if (dbMailAccount.id > 0L) {
                        namedCallableStatement2 = new NamedCallableStatement(connection, "CALL remove_immotool_mails_accounts_settings(:account_id, :setting_key);");
                        namedCallableStatement2.setLong(FIELD_ACCOUNT_ID, dbMailAccount.id);
                        namedCallableStatement2.setNull(FIELD_SETTING_KEY, 12);
                        namedCallableStatement2.executeUpdate();
                        arrayList.add(namedCallableStatement2.getStatement());
                    }
                    namedCallableStatement2 = new NamedCallableStatement(connection, "CALL save_immotool_mails_accounts_settings(:account_id, :setting_key, :setting_value);");
                    for (String string : dbMailAccount.settings.keySet()) {
                        String string2 = dbMailAccount.settings.get(string);
                        if (string2 == null || string2.trim().length() == 0) continue;
                        namedCallableStatement2.clearParameters();
                        namedCallableStatement2.setLong(FIELD_ACCOUNT_ID, l);
                        namedCallableStatement2.setString(FIELD_SETTING_KEY, StringUtils.abbreviate((String)string, (int)255));
                        namedCallableStatement2.setString(FIELD_SETTING_VALUE, string2);
                        namedCallableStatement2.executeUpdate();
                        arrayList.add(namedCallableStatement2.getStatement());
                    }
                }
                connection.commit();
                if (dbMailAccount.id >= 1L) break block12;
                dbMailAccount.id = l;
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    for (Statement statement : arrayList) {
                        JdbcUtils.closeQuietly((Statement)statement);
                    }
                    connection.setAutoCommit(bl);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        for (Statement statement : arrayList) {
            JdbcUtils.closeQuietly((Statement)statement);
        }
        connection.setAutoCommit(bl);
    }
}

