/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base.mail;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;

public abstract class AbstractDataContentHandler
implements DataContentHandler {
    private ActivationDataFlavor fieldDataFlavor;

    protected void updateDataFlavor() {
        this.setDataFlavor(this.computeDataFlavor());
    }

    protected abstract ActivationDataFlavor computeDataFlavor();

    protected void setDataFlavor(ActivationDataFlavor activationDataFlavor) {
        this.fieldDataFlavor = activationDataFlavor;
    }

    public Object getContent(DataSource dataSource) throws IOException {
        Object object = null;
        try {
            object = this.computeContent(dataSource);
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return object;
    }

    protected abstract Object computeContent(DataSource var1) throws MessagingException;

    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws UnsupportedFlavorException, IOException {
        Object object = null;
        if (this.getDataFlavor().equals(dataFlavor)) {
            object = this.getContent(dataSource);
        }
        return object;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.getDataFlavor()};
    }

    protected ActivationDataFlavor getDataFlavor() {
        ActivationDataFlavor activationDataFlavor = this.getDataFlavorBasic();
        if (null == activationDataFlavor) {
            this.updateDataFlavor();
            return this.getDataFlavor();
        }
        return activationDataFlavor;
    }

    private ActivationDataFlavor getDataFlavorBasic() {
        return this.fieldDataFlavor;
    }
}

