-- -----------------------------------------------------
-- Mail-Addon for OpenEstate-ImmoTool
-- update 7 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Fix update of owners in 'save_immotool_mails_accounts'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Fix update of owners in 'save_immotool_mails_accounts'
-- -----------------------------------------------------
\.
ALTER SPECIFIC ROUTINE save_immotool_mails_accounts
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Neues Mailkonto erzeugen
    IF val_account_id < 1 THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Mailkonto speichern
      INSERT INTO immotool_mails_accounts (
        account_name,
        account_type,
        account_notes,
        account_enabled,
        account_auto_retrieval,
        account_auto_retrieval_interval,
        account_auto_retrieval_at,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_account_name,
        val_account_type,
        val_account_notes,
        val_account_enabled,
        val_account_auto_retrieval,
        val_account_auto_retrieval_interval,
        val_account_auto_retrieval_at,
        owner_uid,
        owner_gid,
        permissions );

      -- ID zurückliefern
      SET val_account_id = IDENTITY();

    -- Bestehendes Mailkonto bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_mails_accounts
        WHERE account_id = val_account_id;

      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>0 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>0 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>=0 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Mailkonto bearbeiten
      UPDATE immotool_mails_accounts
        SET
          account_name = val_account_name,
          account_type = val_account_type,
          account_notes = val_account_notes,
          account_enabled = val_account_enabled,
          account_auto_retrieval = val_account_auto_retrieval,
          account_auto_retrieval_interval = val_account_auto_retrieval_interval,
          account_auto_retrieval_at = val_account_auto_retrieval_at,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions,
          modified_at = NOW()
        WHERE
          account_id = val_account_id;

    END IF;

  END;
.;
