/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons.calendar;

import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarEntry;
import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarExtension;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import java.awt.Color;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsBirthdayCalendarEntry
extends VirtualCalendarEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsBirthdayCalendarEntry.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsBirthdayCalendarEntry.class);
    private final DbContactsEntry contact;
    private final int year;

    public ContactsBirthdayCalendarEntry(DbContactsEntry dbContactsEntry, VirtualCalendarExtension virtualCalendarExtension) {
        this(dbContactsEntry, 0, virtualCalendarExtension);
    }

    public ContactsBirthdayCalendarEntry(DbContactsEntry dbContactsEntry, int n, VirtualCalendarExtension virtualCalendarExtension) {
        super(virtualCalendarExtension);
        this.contact = dbContactsEntry;
        this.year = n;
    }

    public Date getBegin() {
        Date date = DateUtils.round((Date)this.contact.birthDay, (int)5);
        if (this.year > 0) {
            date = DateUtils.setYears((Date)date, (int)this.year);
        }
        return date;
    }

    public Color getColor() {
        return Color.YELLOW;
    }

    public DbContactsEntry getContact() {
        return this.contact;
    }

    public Date getEnd() {
        Date date = DateUtils.round((Date)this.contact.birthDay, (int)5);
        if (this.year > 0) {
            date = DateUtils.setYears((Date)date, (int)this.year);
        }
        return DateUtils.addSeconds((Date)DateUtils.addDays((Date)date, (int)1), (int)-1);
    }

    public ImageIcon getIcon() {
        return new ImageIcon(ContactsPlugin.getResourceImage((String)"birthday.png", (int)16));
    }

    public String getInfo() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.contact.birthDay);
        int n = calendar.get(1);
        int n2 = this.year - n;
        calendar.set(1, this.year);
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        return I18N.tr("{0} ages {1} years at {2}.", (Object)this.contact.address.writePersonFullName(), (Object)n2, (Object)dateFormat.format(calendar.getTime()));
    }

    public String getSubTitle() {
        return this.contact.address.writePersonFullName();
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("birthday"));
    }
}

