/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons.calendar.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.contacts.addons.calendar.db.DbContactsCalendarExtension;
import com.openindex.openestate.tool.contacts.addons.calendar.db.DbContactsCalendarHandler;
import com.openindex.openestate.tool.contacts.addons.calendar.db.DbContactsCalendarUpdateListener;
import com.openindex.openestate.tool.contacts.addons.calendar.db.hsql.HSqlDbContactsCalendarHandler;
import com.openindex.openestate.tool.db.AbstractDbUpdateListener;
import com.openindex.openestate.tool.db.DbUpdateHandler;
import com.openindex.openestate.tool.db.DbUpdateHandlerImpl;
import com.openindex.openestate.tool.db.hsql.HSqlDbUpdateHandler;
import com.openindex.openestate.tool.db.hsql.HSqlUtils;
import com.openindex.openestate.tool.extensions.DbExtension;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbContactsCalendarExtension
extends DbContactsCalendarExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbContactsCalendarExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbContactsCalendarExtension.class);
    private static final String RESOURCE_PATH = "/com/openindex/openestate/tool/contacts/addons/calendar/db/hsql/resources/";
    private static final DbContactsCalendarHandler HANDLER = new HSqlDbContactsCalendarHandler();

    @Override
    public DbContactsCalendarHandler getHandler() {
        return HANDLER;
    }

    public final String[] getRequiredProcedures() {
        return new String[]{"remove_immotool_contacts_entries_calendar_entries", "save_immotool_contacts_entries_calendar_entries"};
    }

    public final String[] getRequiredViews() {
        return new String[]{"view_immotool_contacts_entries_calendar_entries"};
    }

    public String[] getSupportedDrivers() {
        return new String[]{"HSQL.local", "HSQL.remote"};
    }

    public String getUninstallQuery() throws IOException {
        return HSqlDbContactsCalendarExtension.readHsqlQuery("uninstall.sql");
    }

    public DbUpdateHandler getUpdateHandler() {
        String string = null;
        try {
            string = this.getUninstallQuery();
        }
        catch (IOException iOException) {
            LOGGER.warn("Can't load uninstall query!");
            LOGGER.warn("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        return new HSqlDbUpdateHandler("OpenEstate-Contacts-Calendar", DbUpdateHandlerImpl.Type.PLUGIN_RELATION, 5L, string, RESOURCE_PATH, ((Object)((Object)this)).getClass().getClassLoader(), (AbstractDbUpdateListener)new DbContactsCalendarUpdateListener());
    }

    public void install(Connection connection, DbExtension dbExtension) throws IOException, SQLException {
        super.install(connection, dbExtension);
        Statement statement = null;
        SqlFile sqlFile = null;
        try {
            statement = connection.createStatement();
            sqlFile = HSqlDbContactsCalendarExtension.readHsqlFile("schema.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            sqlFile = HSqlDbContactsCalendarExtension.readHsqlFile("routines.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            statement.execute("CHECKPOINT;");
        }
        catch (SqlToolError sqlToolError) {
            if (sqlFile != null) {
                sqlFile.closeReader();
            }
            connection.rollback();
            LOGGER.error("Can't execute schema!");
            LOGGER.error("> " + sqlToolError.getLocalizedMessage(), (Throwable)sqlToolError);
            throw new SQLException("Can't execute schema!");
        }
        catch (SQLException sQLException) {
            if (sqlFile != null) {
                sqlFile.closeReader();
            }
            connection.rollback();
            throw sQLException;
        }
        finally {
            JdbcUtils.closeQuietly((Statement)statement);
        }
    }

    private static SqlFile readHsqlFile(String string) throws IOException {
        return HSqlUtils.readHSqlFile((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbContactsCalendarExtension.class.getClassLoader());
    }

    private static String readHsqlQuery(String string) throws IOException {
        return HSqlUtils.readHSqlQuery((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbContactsCalendarExtension.class.getClassLoader());
    }
}

