/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.extensions.LanguageExtension;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public enum ContactsBulkLetterField implements Translatable
{
    ID,
    NR,
    LETTER_ADDRESS,
    MAIL,
    PHONE,
    MOBILEPHONE,
    FAX,
    ADDRESS_LINE1,
    ADDRESS_LINE2,
    ADDRESS_LINE3,
    ADDRESS_STREET,
    ADDRESS_STREET_NR,
    ADDRESS_POSTALCODE,
    ADDRESS_CITY,
    ADDRESS_DISTRICT,
    ADDRESS_COUNTRY,
    ADDRESS_REGION,
    PERSON_FULLNAME,
    PERSON_LASTNAME,
    PERSON_MIDDLENAME,
    PERSON_FIRSTNAME,
    PERSON_TITLE,
    PERSON_MAIL,
    PERSON_PHONE,
    PERSON_MOBILEPHONE,
    PERSON_FAX,
    PERSON_DAY_OF_BIRTH,
    COMPANY_NAME,
    COMPANY_NAME_ADDITION,
    COMPANY_LEGAL_FORM,
    COMPANY_DEPARTMENT,
    COMPANY_POSITION,
    COMPANY_MAIL,
    COMPANY_PHONE,
    COMPANY_MOBILEPHONE,
    COMPANY_FAX,
    COMPANY_WEBSITE,
    COMPANY_BUSINESS,
    BANK_ACCOUNT_OWNER,
    BANK_ACCOUNT_INSTITUTE,
    BANK_ACCOUNT_NR,
    BANK_ACCOUNT_BLZ,
    BANK_ACCOUNT_IBAN,
    BANK_ACCOUNT_BIC;

    private static final Logger LOGGER;
    private static final I18n I18N;

    public String getCurrentLanguageName() {
        return this.getTranslation();
    }

    public String[] getLanguageNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.name());
        for (LanguageExtension languageExtension : ImmoToolEnvironment.getLanguageExtensions()) {
            String string = this.getTranslation(languageExtension.getLocale());
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public String getTranslation() {
        return this.getTranslation(Locale.getDefault());
    }

    public String getTranslation(Locale locale) {
        I18n i18n = I18nFactory.getI18n(ContactsBulkLetterField.class, (Locale)locale);
        switch (this) {
            case ID: {
                return i18n.tr("address") + "-" + i18n.tr("ID");
            }
            case NR: {
                return i18n.tr("address") + "-" + i18n.tr("nr");
            }
            case LETTER_ADDRESS: {
                return i18n.tr("letter address");
            }
            case MAIL: {
                return i18n.tr("e-mail");
            }
            case PHONE: {
                return i18n.tr("phone");
            }
            case MOBILEPHONE: {
                return i18n.tr("mobile");
            }
            case FAX: {
                return i18n.tr("fax");
            }
            case ADDRESS_LINE1: {
                return i18n.tr("address") + "-1";
            }
            case ADDRESS_LINE2: {
                return i18n.tr("address") + "-2";
            }
            case ADDRESS_LINE3: {
                return i18n.tr("address") + "-3";
            }
            case ADDRESS_STREET: {
                return i18n.tr("address") + "-" + i18n.tr("street");
            }
            case ADDRESS_STREET_NR: {
                return i18n.tr("address") + "-" + i18n.tr("street nr");
            }
            case ADDRESS_POSTALCODE: {
                return i18n.tr("address") + "-" + i18n.tr("postcode");
            }
            case ADDRESS_CITY: {
                return i18n.tr("address") + "-" + i18n.tr("place");
            }
            case ADDRESS_DISTRICT: {
                return i18n.tr("address") + "-" + i18n.tr("district");
            }
            case ADDRESS_COUNTRY: {
                return i18n.tr("address") + "-" + i18n.tr("country");
            }
            case ADDRESS_REGION: {
                return i18n.tr("address") + "-" + i18n.tr("region");
            }
            case PERSON_FULLNAME: {
                return i18n.tr("person") + "-" + i18n.tr("full name");
            }
            case PERSON_LASTNAME: {
                return i18n.tr("person") + "-" + i18n.tr("last name");
            }
            case PERSON_MIDDLENAME: {
                return i18n.tr("person") + "-" + i18n.tr("middle name");
            }
            case PERSON_FIRSTNAME: {
                return i18n.tr("person") + "-" + i18n.tr("first name");
            }
            case PERSON_TITLE: {
                return i18n.tr("person") + "-" + i18n.tr("title");
            }
            case PERSON_MAIL: {
                return i18n.tr("person") + "-" + i18n.tr("e-mail");
            }
            case PERSON_PHONE: {
                return i18n.tr("person") + "-" + i18n.tr("phone");
            }
            case PERSON_MOBILEPHONE: {
                return i18n.tr("person") + "-" + i18n.tr("mobile");
            }
            case PERSON_FAX: {
                return i18n.tr("person") + "-" + i18n.tr("fax");
            }
            case PERSON_DAY_OF_BIRTH: {
                return i18n.tr("person") + "-" + i18n.tr("birthday");
            }
            case COMPANY_NAME: {
                return i18n.tr("company") + "-" + i18n.tr("name");
            }
            case COMPANY_NAME_ADDITION: {
                return i18n.tr("company") + "-" + i18n.tr("addition");
            }
            case COMPANY_LEGAL_FORM: {
                return i18n.tr("company") + "-" + i18n.tr("legal form");
            }
            case COMPANY_DEPARTMENT: {
                return i18n.tr("company") + "-" + i18n.tr("department");
            }
            case COMPANY_POSITION: {
                return i18n.tr("company") + "-" + i18n.tr("position");
            }
            case COMPANY_MAIL: {
                return i18n.tr("company") + "-" + i18n.tr("e-mail");
            }
            case COMPANY_PHONE: {
                return i18n.tr("company") + "-" + i18n.tr("phone");
            }
            case COMPANY_MOBILEPHONE: {
                return i18n.tr("company") + "-" + i18n.tr("mobile");
            }
            case COMPANY_FAX: {
                return i18n.tr("company") + "-" + i18n.tr("fax");
            }
            case COMPANY_WEBSITE: {
                return i18n.tr("company") + "-" + i18n.tr("website");
            }
            case COMPANY_BUSINESS: {
                return i18n.tr("company") + "-" + i18n.tr("branch");
            }
            case BANK_ACCOUNT_OWNER: {
                return i18n.tr("bank") + "-" + i18n.tr("account owner");
            }
            case BANK_ACCOUNT_INSTITUTE: {
                return i18n.tr("bank") + "-" + i18n.tr("institute");
            }
            case BANK_ACCOUNT_NR: {
                return i18n.tr("bank") + "-" + i18n.tr("account nr");
            }
            case BANK_ACCOUNT_BLZ: {
                return i18n.tr("bank") + "-" + i18n.tr("bank code nr");
            }
            case BANK_ACCOUNT_IBAN: {
                return i18n.tr("bank") + "-" + i18n.tr("IBAN");
            }
            case BANK_ACCOUNT_BIC: {
                return i18n.tr("bank") + "-" + i18n.tr("BIC");
            }
        }
        return null;
    }

    public String getValue(DbContactsEntry dbContactsEntry) {
        if (dbContactsEntry == null || dbContactsEntry.address == null) {
            return null;
        }
        switch (this) {
            case ID: {
                return String.valueOf(dbContactsEntry.id);
            }
            case NR: {
                return dbContactsEntry.publicId;
            }
            case LETTER_ADDRESS: {
                return dbContactsEntry.writeLetterAddress();
            }
            case MAIL: {
                return dbContactsEntry.getAddressMail();
            }
            case PHONE: {
                return dbContactsEntry.getAddressPhone();
            }
            case MOBILEPHONE: {
                return dbContactsEntry.getAddressMobilePhone();
            }
            case FAX: {
                return dbContactsEntry.getAddressFax();
            }
            case ADDRESS_LINE1: {
                return dbContactsEntry.address.writeStreet();
            }
            case ADDRESS_LINE2: {
                return dbContactsEntry.address.writePostal();
            }
            case ADDRESS_LINE3: {
                return dbContactsEntry.address.writeCountry();
            }
            case ADDRESS_STREET: {
                return dbContactsEntry.address.getStreet();
            }
            case ADDRESS_STREET_NR: {
                return dbContactsEntry.address.getStreetNr();
            }
            case ADDRESS_POSTALCODE: {
                return dbContactsEntry.address.getPostalCode();
            }
            case ADDRESS_CITY: {
                return dbContactsEntry.address.getCity();
            }
            case ADDRESS_DISTRICT: {
                return dbContactsEntry.address.getDistrict();
            }
            case ADDRESS_COUNTRY: {
                return dbContactsEntry.address.writeCountry();
            }
            case ADDRESS_REGION: {
                return dbContactsEntry.address.getRegion();
            }
            case PERSON_FULLNAME: {
                return dbContactsEntry.address.writePersonFullName();
            }
            case PERSON_LASTNAME: {
                return dbContactsEntry.address.getPersonLastName();
            }
            case PERSON_MIDDLENAME: {
                return dbContactsEntry.address.getPersonMiddleName();
            }
            case PERSON_FIRSTNAME: {
                return dbContactsEntry.address.getPersonFirstName();
            }
            case PERSON_TITLE: {
                return dbContactsEntry.address.getPersonTitle();
            }
            case PERSON_MAIL: {
                return dbContactsEntry.address.getPersonMail();
            }
            case PERSON_PHONE: {
                return dbContactsEntry.address.getPersonPhone();
            }
            case PERSON_MOBILEPHONE: {
                return dbContactsEntry.address.getPersonMobilePhone();
            }
            case PERSON_FAX: {
                return dbContactsEntry.address.getPersonFax();
            }
            case PERSON_DAY_OF_BIRTH: {
                return dbContactsEntry.address.getPersonDateOfBirth() != null ? DateFormat.getDateInstance(3).format(dbContactsEntry.address.getPersonDateOfBirth()) : null;
            }
            case COMPANY_NAME: {
                return dbContactsEntry.address.getCompanyName();
            }
            case COMPANY_NAME_ADDITION: {
                return dbContactsEntry.address.getCompanyNameAddition();
            }
            case COMPANY_LEGAL_FORM: {
                return dbContactsEntry.address.getCompanyLegalForm();
            }
            case COMPANY_DEPARTMENT: {
                return dbContactsEntry.address.getCompanyDepartment();
            }
            case COMPANY_POSITION: {
                return dbContactsEntry.address.getCompanyPosition();
            }
            case COMPANY_MAIL: {
                return dbContactsEntry.address.getCompanyMail();
            }
            case COMPANY_PHONE: {
                return dbContactsEntry.address.getCompanyPhone();
            }
            case COMPANY_MOBILEPHONE: {
                return dbContactsEntry.address.getCompanyMobilePhone();
            }
            case COMPANY_FAX: {
                return dbContactsEntry.address.getCompanyFax();
            }
            case COMPANY_WEBSITE: {
                return dbContactsEntry.address.getCompanyWebsite() != null && !StringUtils.isBlank((CharSequence)dbContactsEntry.address.getCompanyWebsite().getHost()) ? dbContactsEntry.address.getCompanyWebsite().toString() : null;
            }
            case COMPANY_BUSINESS: {
                return dbContactsEntry.address.getCompanyBusiness();
            }
            case BANK_ACCOUNT_OWNER: {
                return dbContactsEntry.getBankAccountOwner();
            }
            case BANK_ACCOUNT_INSTITUTE: {
                return dbContactsEntry.getBankAccountInstitute();
            }
            case BANK_ACCOUNT_NR: {
                return dbContactsEntry.getBankAccountNr();
            }
            case BANK_ACCOUNT_BLZ: {
                return dbContactsEntry.getBankAccountBankCodeNr();
            }
            case BANK_ACCOUNT_IBAN: {
                return dbContactsEntry.getBankAccountIBAN();
            }
            case BANK_ACCOUNT_BIC: {
                return dbContactsEntry.getBankAccountBIC();
            }
        }
        return null;
    }

    static {
        LOGGER = LoggerFactory.getLogger(ContactsBulkLetterField.class);
        I18N = I18nFactory.getI18n(ContactsBulkLetterField.class);
    }
}

