/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.extensions.FrameSidebarAdapter;
import com.openindex.openestate.tool.extensions.FrameSidebarAddonExtension;
import com.openindex.openestate.tool.gui.DefaultMenu;
import com.openindex.openestate.tool.utils.SidebarTree;
import com.openindex.openestate.tool.utils.SidebarTreeCellRenderer;
import com.openindex.openestate.tool.utils.SidebarTreeNode;
import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsFrameSidebarExtension
extends FrameSidebarAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsFrameSidebarExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsFrameSidebarExtension.class);
    public static final int MENU_BEGIN = 0;
    public static final int MENU_REFRESH = 1;
    public static final int MENU_ADD = 2;
    public static final int MENU_ADD_BEGIN = 3;
    public static final int MENU_ADD_ENTRY = 4;
    public static final int MENU_ADD_GROUP = 5;
    public static final int MENU_ADD_END = 6;
    public static final int MENU_SELECTION = 7;
    public static final int MENU_ELSE = 8;
    public static final int MENU_ELSE_BEGIN = 9;
    public static final int MENU_ELSE_IMPORT = 10;
    public static final int MENU_ELSE_EXPORT = 11;
    public static final int MENU_ELSE_BULK = 12;
    public static final int MENU_ELSE_END = 13;
    public static final int MENU_END = 14;
    private static AbstractButton currentSidebarButton = null;
    private static Tree currentSidebarTree = null;

    private static JPopupMenu createActionMenu(TreeNode treeNode) {
        String string;
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        long l = treeNode != null && treeNode.getGroup() != null ? treeNode.getGroup().id : 0L;
        Collection collection = ContactsFrameSidebarExtension.getAddons((ImmoToolProject)immoToolProject, ContactsFrameSidebarExtension.class);
        JPopupMenu jPopupMenu = new JPopupMenu();
        ContactsFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)0, (SidebarTreeNode)treeNode, (Collection)collection);
        jPopupMenu.add(new JMenuItem((Action)((Object)new ContactsPlugin.SidebarRefreshAction())));
        ContactsFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)1, (SidebarTreeNode)treeNode, (Collection)collection);
        DefaultMenu defaultMenu = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(StringUtils.capitalize((String)I18N.tr("new entry")));
                this.setToolTipText(I18N.tr("Create a new entry in the addressbook addon."));
            }
        };
        defaultMenu.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
        ContactsFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)3, (SidebarTreeNode)treeNode, (Collection)collection);
        if (ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EDIT)) {
            defaultMenu.add(new JMenuItem((Action)((Object)new ContactsPlugin.EntryFormAction())));
        }
        ContactsFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)4, (SidebarTreeNode)treeNode, (Collection)collection);
        if (ContactsPlugin.isUserAllowedTo(ContactsPermission.GROUPS_EDIT)) {
            if (defaultMenu.getItemCount() > 0) {
                defaultMenu.addSeparator();
            }
            defaultMenu.add(new JMenuItem((Action)((Object)new ContactsPlugin.GroupDialogAction())));
        }
        ContactsFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)5, (SidebarTreeNode)treeNode, (Collection)collection);
        ContactsFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)6, (SidebarTreeNode)treeNode, (Collection)collection);
        if (defaultMenu.getItemCount() > 0) {
            jPopupMenu.add((JMenuItem)defaultMenu);
        }
        ContactsFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)2, (SidebarTreeNode)treeNode, (Collection)collection);
        if (treeNode != null && treeNode.getType() == 10) {
            string = treeNode.getGroup() != null ? StringUtils.trimToEmpty((String)treeNode.getGroup().name) : StringUtils.capitalize((String)I18N.tr("addresses"));
            jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)StringUtils.abbreviate((String)string, (int)35)));
            jPopupMenu.add(new JMenuItem((Action)((Object)new ContactsPlugin.EntryTableAction(l, true))));
            if (l > 0L) {
                if (ContactsPlugin.isUserAllowedTo(ContactsPermission.GROUPS_EDIT)) {
                    jPopupMenu.add(new JMenuItem((Action)((Object)new ContactsPlugin.GroupDialogAction(l))));
                }
                if (ContactsPlugin.isUserAllowedTo(ContactsPermission.GROUPS_REMOVE)) {
                    jPopupMenu.add(new JMenuItem((Action)((Object)new ContactsPlugin.GroupRemoveAction(l))));
                }
            }
        }
        ContactsFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)7, (SidebarTreeNode)treeNode, (Collection)collection);
        jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)"", (int)5));
        string = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")));
                this.setToolTipText(I18N.tr("Further actions in the addressbook addon."));
            }
        };
        ContactsFrameSidebarExtension.loadMenu((JMenu)((Object)string), (int)9, (SidebarTreeNode)treeNode, (Collection)collection);
        if (ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_IMPORT)) {
            DefaultMenu defaultMenu2 = new DefaultMenu(){

                protected void updateLocalization() {
                    this.setText(StringUtils.capitalize((String)I18N.tr("import addresses")));
                    this.setToolTipText(I18N.tr("Import addresses from an external file."));
                }
            };
            defaultMenu2.setIcon(ImmoToolEnvironment.getResourceIcon((String)"file_import.png", (int)16));
            defaultMenu2.add(new JMenuItem((Action)((Object)new ContactsPlugin.EntryImportFromCsvAction())));
            defaultMenu2.add(new JMenuItem((Action)((Object)new ContactsPlugin.EntryImportFromVcardAction())));
            string.add((JMenuItem)defaultMenu2);
            ContactsFrameSidebarExtension.loadMenu((JMenu)((Object)string), (int)10, (SidebarTreeNode)treeNode, (Collection)collection);
        }
        if (ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EXPORT)) {
            string.add(new JMenuItem((Action)((Object)new ContactsPlugin.EntryExportAction())));
        }
        ContactsFrameSidebarExtension.loadMenu((JMenu)((Object)string), (int)11, (SidebarTreeNode)treeNode, (Collection)collection);
        string.add(new JMenuItem((Action)((Object)new ContactsPlugin.BulkLetterDialogAction())));
        ContactsFrameSidebarExtension.loadMenu((JMenu)((Object)string), (int)12, (SidebarTreeNode)treeNode, (Collection)collection);
        ContactsFrameSidebarExtension.loadMenu((JMenu)((Object)string), (int)13, (SidebarTreeNode)treeNode, (Collection)collection);
        if (string.getItemCount() > 0) {
            jPopupMenu.add((JMenuItem)((Object)string));
        }
        ContactsFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)8, (SidebarTreeNode)treeNode, (Collection)collection);
        ContactsFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)14, (SidebarTreeNode)treeNode, (Collection)collection);
        return jPopupMenu;
    }

    public JComponent createComponent() {
        Tree tree = new Tree();
        tree.installDefaultListeners(true, true);
        tree.setRootVisible(false);
        tree.setCellRenderer((TreeCellRenderer)new SidebarTreeCellRenderer());
        tree.setModel(new DefaultTreeModel((javax.swing.tree.TreeNode)((Object)new TreeNode(0))));
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeModel createTreeModel() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            TreeModel treeModel = ContactsFrameSidebarExtension.createTreeModel(immoToolProject, connection, dbContactsHandler);
            return treeModel;
        }
        catch (Exception exception) {
            LOGGER.error("Can't load export interfaces!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            TreeModel treeModel = null;
            return treeModel;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public static TreeModel createTreeModel(ImmoToolProject immoToolProject, Connection connection, DbContactsHandler dbContactsHandler) throws SQLException {
        TreeNode treeNode = new TreeNode(10);
        for (DbContactsGroup dbContactsGroup : dbContactsHandler.getGroups(connection)) {
            treeNode.add((MutableTreeNode)((Object)new TreeNode(dbContactsGroup)));
        }
        TreeNode treeNode2 = new TreeNode(0);
        treeNode2.add((MutableTreeNode)((Object)treeNode));
        for (FrameSidebarAddonExtension frameSidebarAddonExtension : ContactsFrameSidebarExtension.getAddons((ImmoToolProject)immoToolProject, ContactsFrameSidebarExtension.class)) {
            frameSidebarAddonExtension.initTree(connection, (SidebarTreeNode)treeNode2);
        }
        return new DefaultTreeModel((javax.swing.tree.TreeNode)((Object)treeNode2));
    }

    public static AbstractButton getCurrentSidebarButton() {
        return currentSidebarButton;
    }

    public static Tree getCurrentSidebarTree() {
        return currentSidebarTree;
    }

    public Icon getIcon() {
        return ContactsPlugin.getResourceIcon("vcard.png", 32);
    }

    public JPopupMenu getMenu() {
        return ContactsFrameSidebarExtension.createActionMenu(null);
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("addresses"));
    }

    public String getTooltipText() {
        return I18N.tr("Manage your addressbooks.");
    }

    public void loadComponent(final JComponent jComponent) {
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<TreeModel, Void>(){

            protected TreeModel doInBackground() throws Exception {
                return ContactsFrameSidebarExtension.this.createTreeModel();
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                LOGGER.error("Can't load sidebar component!");
                LOGGER.error("> " + throwable.getLocalizedMessage(), throwable);
            }

            protected void succeeded(TreeModel treeModel) {
                super.succeeded((Object)treeModel);
                ((Tree)((Object)jComponent)).setModel(treeModel);
                ((Tree)((Object)jComponent)).expandAll();
            }
        });
    }

    public void register(JComponent jComponent, AbstractButton abstractButton) {
        if (jComponent instanceof Tree) {
            ContactsFrameSidebarExtension.setCurrentSidebar((Tree)((Object)jComponent), abstractButton);
        } else {
            LOGGER.warn("An invalid agency-tree was registered!");
            ContactsFrameSidebarExtension.setCurrentSidebar(null, null);
        }
    }

    private static synchronized void setCurrentSidebar(Tree tree, AbstractButton abstractButton) {
        currentSidebarTree = tree;
        currentSidebarButton = abstractButton;
    }

    public void unregister() {
        ContactsFrameSidebarExtension.setCurrentSidebar(null, null);
    }

    public static class TreeNode
    extends SidebarTreeNode {
        private static final Icon contactIconSmall = ContactsPlugin.getResourceIcon("edit_group.png", 16);
        private static final int TYPE_ROOT = 0;
        private static final int TYPE_CONTACTS = 10;
        private final int type;
        private DbContactsGroup group;

        public TreeNode(int n) {
            this.type = n;
            this.group = null;
        }

        public TreeNode(DbContactsGroup dbContactsGroup) {
            this.type = 10;
            this.group = dbContactsGroup;
        }

        public void doShow(boolean bl) {
            switch (this.getType()) {
                case 10: {
                    new ContactsPlugin.EntryTableAction(this.group != null ? this.group.id : 0L, bl).actionPerformed(null);
                    break;
                }
            }
        }

        public DbContactsGroup getGroup() {
            return this.group;
        }

        public JPopupMenu getMenu() {
            return ContactsFrameSidebarExtension.createActionMenu(this);
        }

        public Icon getNodeIcon() {
            switch (this.type) {
                case 10: {
                    return this.group != null ? contactIconSmall : null;
                }
            }
            return null;
        }

        public String getNodeText() {
            switch (this.type) {
                case 0: {
                    return "";
                }
                case 10: {
                    return this.group != null ? this.group.name : this.title(StringUtils.capitalize((String)I18N.tr("addressbook")));
                }
            }
            return "???";
        }

        public String getNodeTooltip() {
            switch (this.getType()) {
                case 10: {
                    return this.group != null ? "<b>" + I18N.tr("group") + " #" + this.group.id + "</b><br>" + StringEscapeUtils.escapeXml11((String)this.group.notes) : I18N.tr("Show addresses of all groups.");
                }
            }
            return null;
        }

        public int getType() {
            return this.type;
        }

        public void setGroup(DbContactsGroup dbContactsGroup) {
            this.group = dbContactsGroup;
        }
    }

    public static class Tree
    extends SidebarTree {
        public TreeNode getAllContactsNode() {
            TreeNode treeNode = this.getRootNode();
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                TreeNode treeNode2;
                javax.swing.tree.TreeNode treeNode3 = treeNode.getChildAt(i);
                if (!(treeNode3 instanceof TreeNode) || 10 != (treeNode2 = (TreeNode)((Object)treeNode3)).getType()) continue;
                return treeNode2;
            }
            return null;
        }

        public TreeNode getRootNode() {
            return (TreeNode)((Object)this.getModel().getRoot());
        }

        public void putGroup(DbContactsGroup dbContactsGroup) {
            if (dbContactsGroup == null) {
                throw new IllegalArgumentException("No group was provided!");
            }
            if (dbContactsGroup.id < 1L) {
                throw new IllegalArgumentException("An unsaved group was provided!");
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            TreeNode treeNode = this.getAllContactsNode();
            if (treeNode == null) {
                return;
            }
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DbContactsGroup dbContactsGroup2;
                TreeNode treeNode2;
                javax.swing.tree.TreeNode treeNode3 = treeNode.getChildAt(i);
                if (!(treeNode3 instanceof TreeNode) || (treeNode2 = (TreeNode)((Object)treeNode3)).getType() != 10 || (dbContactsGroup2 = treeNode2.getGroup()) == null || dbContactsGroup2.id != dbContactsGroup.id) continue;
                treeNode2.setGroup(dbContactsGroup);
                defaultTreeModel.nodeChanged((javax.swing.tree.TreeNode)((Object)treeNode2));
                return;
            }
            defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)new TreeNode(dbContactsGroup)), (MutableTreeNode)((Object)treeNode), treeNode.getChildCount());
        }

        public boolean removeGroup(long l) {
            if (l < 1L) {
                throw new IllegalArgumentException("An invalid group-id was provided!");
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            TreeNode treeNode = this.getAllContactsNode();
            if (treeNode == null) {
                return false;
            }
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DbContactsGroup dbContactsGroup;
                TreeNode treeNode2;
                javax.swing.tree.TreeNode treeNode3 = treeNode.getChildAt(i);
                if (!(treeNode3 instanceof TreeNode) || (treeNode2 = (TreeNode)((Object)treeNode3)).getType() != 10 || (dbContactsGroup = treeNode2.getGroup()) == null || dbContactsGroup.id != l) continue;
                defaultTreeModel.removeNodeFromParent((MutableTreeNode)((Object)treeNode2));
                return true;
            }
            return false;
        }
    }
}

