/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.contacts.extensions.BulkLetterExtension;
import com.openindex.openestate.tool.contacts.extensions.DbContactsExtension;
import com.openindex.openestate.tool.contacts.extensions.EntryTableExtension;
import com.openindex.openestate.tool.contacts.extensions.EntryViewExtension;
import com.openindex.openestate.tool.contacts.extensions.GroupViewExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsPluginUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsPluginUtils.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsPluginUtils.class);

    private ContactsPluginUtils() {
    }

    public static Collection<BulkLetterExtension> getBulkLetterExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<BulkLetterExtension> arrayList = new ArrayList<BulkLetterExtension>();
        for (Object object : ContactsPluginUtils.getExtensionHandlers("BulkLetterExtension", BulkLetterExtension.class, immoToolProject, null)) {
            arrayList.add((BulkLetterExtension)object);
        }
        return arrayList;
    }

    public static DbContactsExtension getDbContactsExtension(ImmoToolProject immoToolProject) {
        return immoToolProject != null ? ContactsPluginUtils.getDbContactsExtension(immoToolProject.getDbDriver()) : null;
    }

    public static DbContactsExtension getDbContactsExtension(AbstractDbDriver abstractDbDriver) {
        return abstractDbDriver != null ? ContactsPluginUtils.getDbContactsExtension(abstractDbDriver.getName()) : null;
    }

    public static DbContactsExtension getDbContactsExtension(String string) {
        for (Object object : ContactsPluginUtils.getExtensionHandlers("DbContactsExtension", DbContactsExtension.class, null, null)) {
            DbContactsExtension dbContactsExtension = (DbContactsExtension)object;
            if (!dbContactsExtension.isSupportedDriver(string)) continue;
            return dbContactsExtension;
        }
        return null;
    }

    public static Collection<DbContactsExtension> getDbContactsExtensions() {
        ArrayList<DbContactsExtension> arrayList = new ArrayList<DbContactsExtension>();
        for (Object object : ContactsPluginUtils.getExtensionHandlers("DbContactsExtension", DbContactsExtension.class, null, null)) {
            arrayList.add((DbContactsExtension)object);
        }
        return arrayList;
    }

    public static Collection<EntryTableExtension> getEntryTableExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<EntryTableExtension> arrayList = new ArrayList<EntryTableExtension>();
        for (Object object : ContactsPluginUtils.getExtensionHandlers("EntryTableExtension", EntryTableExtension.class, immoToolProject, null)) {
            arrayList.add((EntryTableExtension)object);
        }
        return arrayList;
    }

    public static Collection<EntryViewExtension> getEntryViewExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<EntryViewExtension> arrayList = new ArrayList<EntryViewExtension>();
        for (Object object : ContactsPluginUtils.getExtensionHandlers("EntryViewExtension", EntryViewExtension.class, immoToolProject, null)) {
            arrayList.add((EntryViewExtension)object);
        }
        return arrayList;
    }

    private static Collection<Object> getExtensionHandlers(String string, Class clazz, ImmoToolProject immoToolProject, String[] stringArray) {
        return ImmoToolEnvironment.getExtensionHandlers((String)"OpenEstate-Tool-Contacts", (String)string, (Class)clazz, (ImmoToolProject)immoToolProject, (String[])stringArray);
    }

    public static Collection<GroupViewExtension> getGroupViewExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<GroupViewExtension> arrayList = new ArrayList<GroupViewExtension>();
        for (Object object : ContactsPluginUtils.getExtensionHandlers("GroupViewExtension", GroupViewExtension.class, immoToolProject, null)) {
            arrayList.add((GroupViewExtension)object);
        }
        return arrayList;
    }
}

