/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.CustomValueImpl;
import com.openindex.openestate.impl.CustomValuesImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.extensions.DbContactsExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUpgradeHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.extensions.UpgradeAdapter;
import com.openindex.openestate.tool.utils.Relation;
import com.openindex.openestate.tool.utils.RelationObject;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsUpgradeExtension
extends UpgradeAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsUpgradeExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsUpgradeExtension.class);
    public static final String UPGRADE_ENTRIES = "OpenEstate-Tool-Contacts.entries";
    public static final String UPGRADE_GROUPS = "OpenEstate-Tool-Contacts.groups";

    private static DbContactsEntry createEntry(Reader reader) throws DocumentException {
        Object object;
        Object object2;
        DbContactsEntry dbContactsEntry = new DbContactsEntry();
        dbContactsEntry.address = CompanyAddressImpl.parseCompanyAddress((Document)OpenEstateUtils.loadDocument((Reader)reader));
        for (String string : new String[]{"status", "entry.status"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if ("active".equalsIgnoreCase((String)object2)) {
                dbContactsEntry.isActive = true;
                break;
            }
            if (!"inactive".equalsIgnoreCase((String)object2)) continue;
            dbContactsEntry.isActive = false;
            break;
        }
        for (String string : new String[]{"text", "notes", "entry.notes"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getText());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.notes = object2;
            break;
        }
        for (String string : new String[]{"sprachen", "extra.sprachen"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            object = new ArrayList<Locale>();
            for (String string2 : ((String)object2).split(",")) {
                if ((string2 = StringUtils.trim((String)string2)) == null) continue;
                object.add(new Locale(string2));
            }
            if (object.isEmpty()) continue;
            dbContactsEntry.setLanguages(object.toArray(new Locale[0]));
            break;
        }
        for (String string : new String[]{"ausweis_art", "extra.ausweis_art"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.setIdentificationType((String)object2);
            break;
        }
        for (String string : new String[]{"ausweis_behoerde", "extra.ausweis_behoerde"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.setIdentificationIssuer((String)object2);
            break;
        }
        for (String string : new String[]{"ausweis_nr", "extra.ausweis_nr"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.setIdentificationNr((String)object2);
            break;
        }
        for (String string : new String[]{"citizenship", "extra.citizenship"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.setCitizenship((String)object2);
            break;
        }
        for (String string : new String[]{"contact_allowed", "entry.contact_allowed", "extra.contact_allowed"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = dbContactsEntry.address.getCustomValues().getCustomValue(string).getBoolean();
            object = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null && object == null) continue;
            dbContactsEntry.setContactAllowed(object2 != null ? ((Boolean)object2).booleanValue() : Boolean.TRUE.toString().equalsIgnoreCase((String)object));
            break;
        }
        for (String string : new String[]{"day_of_birth", "entry.day_of_birth", "extra.day_of_birth"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = dbContactsEntry.address.getCustomValues().getCustomValue(string).getDate();
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.birthDay = object2;
            break;
        }
        for (String string : new String[]{"konto_bic", "extra.konto_bic"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.setBankAccountBIC((String)object2);
            break;
        }
        for (String string : new String[]{"konto_blz", "extra.konto_blz"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.setBankAccountBankCodeNr((String)object2);
            break;
        }
        for (String string : new String[]{"konto_iban", "extra.konto_iban"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.setBankAccountIBAN((String)object2);
            break;
        }
        for (String string : new String[]{"konto_iban", "extra.konto_iban"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.setBankAccountOwner((String)object2);
            break;
        }
        for (String string : new String[]{"konto_institut", "extra.konto_institut"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.setBankAccountInstitute((String)object2);
            break;
        }
        for (String string : new String[]{"konto_nr", "extra.konto_nr"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.setBankAccountNr((String)object2);
            break;
        }
        for (String string : new String[]{"place_of_birth", "extra.place_of_birth"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.setPlaceOfBirth((String)object2);
            break;
        }
        for (String string : new String[]{"steuer_idnr", "extra.steuer_idnr"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue("steuer_idnr")) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.setTaxIdNr((String)object2);
            break;
        }
        for (String string : new String[]{"steuer_nr", "extra.steuer_nr"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.setTaxNr((String)object2);
            break;
        }
        for (String string : new String[]{"steuer_umsatz_idnr", "extra.steuer_umsatz_idnr"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.setTaxUID((String)object2);
            break;
        }
        for (String string : new String[]{"wirtschaft_idnr", "extra.wirtschaft_idnr"}) {
            if (!dbContactsEntry.address.getCustomValues().hasCustomValue(string)) continue;
            object2 = StringUtils.trimToNull((String)dbContactsEntry.address.getCustomValues().getCustomValue(string).getString());
            dbContactsEntry.address.getCustomValues().getValueMap().remove(string);
            if (object2 == null) continue;
            dbContactsEntry.setTaxWirtschaftIdNr((String)object2);
            break;
        }
        return dbContactsEntry;
    }

    private static DbContactsGroup createGroup(Properties properties) {
        DbContactsGroup dbContactsGroup = new DbContactsGroup();
        dbContactsGroup.id = ImmoToolUtils.getPropertyAsLong((String)"id", (Long)0L, (Properties)properties);
        dbContactsGroup.name = properties.getProperty("name", "");
        dbContactsGroup.notes = properties.getProperty("description", "").replaceAll("<br/>", System.lineSeparator());
        return dbContactsGroup;
    }

    private static List<Relation> getContactCalendarRelations(long l, DbContactsEntry dbContactsEntry) {
        ArrayList<Relation> arrayList = new ArrayList<Relation>();
        CustomValuesImpl customValuesImpl = dbContactsEntry.address.getCustomValues();
        for (Map.Entry entry : customValuesImpl.getValueMap().entrySet()) {
            String string = (String)entry.getKey();
            if (!string.startsWith("calendar.id.")) continue;
            String string2 = "calendar.uid." + string.substring("calendar.id.".length());
            String string3 = "calendar.text." + string.substring("calendar.id.".length());
            Long l2 = ((CustomValueImpl)entry.getValue()).getInteger().longValue();
            String string4 = customValuesImpl.getCustomValue(string2).getString();
            String string5 = customValuesImpl.hasCustomValue(string3) ? (customValuesImpl.getCustomValue(string3).isText() ? customValuesImpl.getCustomValue(string3).getText() : customValuesImpl.getCustomValue(string3).getString()) : "";
            Relation relation = new Relation();
            relation.setNotes(string5);
            relation.getObjects().add(new RelationObject(relation, String.valueOf(l), "com.openindex.openestate.tool.contacts.ContactsEntry"));
            relation.getObjects().add(new RelationObject(relation, l2 + "/" + string4, "com.openindex.openestate.tool.calendar.CalendarEntry"));
            arrayList.add(relation);
        }
        return arrayList;
    }

    private static List<Relation> getContactEstateRelations(long l, DbContactsEntry dbContactsEntry) {
        ArrayList<Relation> arrayList = new ArrayList<Relation>();
        CustomValuesImpl customValuesImpl = dbContactsEntry.address.getCustomValues();
        for (Map.Entry entry : customValuesImpl.getValueMap().entrySet()) {
            String string;
            String string2 = (String)entry.getKey();
            if (!string2.startsWith("estate.id.")) continue;
            String string3 = "estate.text." + string2.substring("estate.id.".length());
            String string4 = "estate.type." + string2.substring("estate.id.".length());
            Long l2 = ((CustomValueImpl)entry.getValue()).getInteger().longValue();
            String string5 = customValuesImpl.hasCustomValue(string3) ? (customValuesImpl.getCustomValue(string3).isText() ? customValuesImpl.getCustomValue(string3).getText() : customValuesImpl.getCustomValue(string3).getString()) : (string = "");
            String string6 = customValuesImpl.hasCustomValue(string4) ? (customValuesImpl.getCustomValue(string4).isText() ? customValuesImpl.getCustomValue(string4).getText() : customValuesImpl.getCustomValue(string4).getString()) : "";
            Relation relation = new Relation();
            relation.setNotes(string);
            relation.getParams().put("estate.contact.type", string6);
            relation.getObjects().add(new RelationObject(relation, String.valueOf(l), "com.openindex.openestate.tool.contacts.ContactsEntry"));
            relation.getObjects().add(new RelationObject(relation, String.valueOf(l2), "com.openindex.openestate.tool.agency.AgencyEstate"));
            arrayList.add(relation);
        }
        return arrayList;
    }

    public String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Contacts"};
    }

    public void upgrade(Connection connection, AbstractDbDriver abstractDbDriver, DbExtension dbExtension, DbUser dbUser, File file, Properties properties, ImmoToolTask.Callback callback) throws SQLException, IOException {
        Object[] objectArray;
        Serializable serializable;
        Serializable serializable2;
        Object object;
        Serializable serializable3;
        this.setMessage("Upgrade contacts...", callback);
        DbContactsExtension dbContactsExtension = ContactsPluginUtils.getDbContactsExtension(abstractDbDriver);
        DbContactsHandler dbContactsHandler = dbContactsExtension.getContactsHandler();
        DbUpgradeHandler dbUpgradeHandler = dbExtension.getUpgradeHandler();
        SuffixFileFilter suffixFileFilter = new SuffixFileFilter(".xml", IOCase.INSENSITIVE);
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        File file2 = new File(file.getAbsolutePath() + File.separator + "groups");
        if (file2.isDirectory()) {
            serializable3 = new TreeMap();
            object = file2.listFiles((FileFilter)suffixFileFilter);
            if (ArrayUtils.isNotEmpty((Object[])object)) {
                for (Object object2 : object) {
                    try {
                        serializable3.put(Long.valueOf(((File)object2).getName().split("\\.")[0]), object2);
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't read group-id!");
                        LOGGER.warn("> from " + ((File)object2).getAbsolutePath());
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        this.setMessage("WARNING: Can't read group-id!", callback);
                        this.setMessage("> " + exception.getLocalizedMessage(), callback);
                    }
                }
            }
            for (Map.Entry entry : serializable3.entrySet()) {
                Object object2;
                Long l = (Long)entry.getKey();
                this.setMessage("> Import contact-group #" + l, callback);
                object2 = (File)entry.getValue();
                try {
                    FileInputStream fileInputStream = new FileInputStream((File)object2);
                    Object object3 = null;
                    try {
                        serializable2 = new Properties();
                        serializable2.loadFromXML(fileInputStream);
                        serializable = ContactsUpgradeExtension.createGroup(serializable2);
                        ((DbContactsGroup)serializable).id = 0L;
                        dbContactsHandler.saveGroup(connection, (DbContactsGroup)serializable);
                        hashMap.put(l, ((DbContactsGroup)serializable).id);
                        dbUpgradeHandler.save(connection, UPGRADE_GROUPS, String.valueOf(l), ((DbContactsGroup)serializable).id);
                    }
                    catch (Throwable throwable) {
                        object3 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (fileInputStream == null) continue;
                        if (object3 != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object3).addSuppressed(throwable);
                            }
                            continue;
                        }
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't import contact-group!");
                    LOGGER.warn("> from " + ((File)object2).getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't import contact-group!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
            }
        }
        serializable3 = new File(file.getAbsolutePath() + File.separator + "entries");
        object = new File(file.getAbsolutePath() + File.separator + "entry_calendars");
        File file3 = new File(file.getAbsolutePath() + File.separator + "entry_estates");
        if (((File)serializable3).isDirectory() && ArrayUtils.isNotEmpty((Object[])(objectArray = ((File)serializable3).listFiles()))) {
            for (Object object3 : objectArray) {
                block66: {
                    if (!((File)object3).isDirectory()) continue;
                    try {
                        serializable2 = Long.valueOf(((File)object3).getName());
                        if (!hashMap.containsKey(serializable2)) {
                        }
                        break block66;
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't extract group-id!");
                        LOGGER.warn("> from " + ((File)object3).getAbsolutePath());
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                    continue;
                }
                serializable = new TreeMap();
                Object[] objectArray2 = ((File)object3).listFiles((FileFilter)suffixFileFilter);
                if (ArrayUtils.isNotEmpty((Object[])objectArray2)) {
                    for (Object object4 : objectArray2) {
                        try {
                            serializable.put(Long.valueOf(((File)object4).getName().split("\\.")[0]), object4);
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Can't read entry-id!");
                            LOGGER.warn("> from " + ((File)object4).getAbsolutePath());
                            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                            this.setMessage("WARNING: Can't read entry-id!", callback);
                            this.setMessage("> " + exception.getLocalizedMessage(), callback);
                        }
                    }
                }
                for (Map.Entry entry : serializable.entrySet()) {
                    Object object4;
                    Long l = (Long)entry.getKey();
                    this.setMessage("> Import contact-entry #" + l, callback);
                    object4 = (File)entry.getValue();
                    try {
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream((File)object4), "UTF-8");
                        Throwable throwable = null;
                        try {
                            Throwable throwable2;
                            FileWriterWithEncoding fileWriterWithEncoding;
                            File file4;
                            DbContactsEntry dbContactsEntry = ContactsUpgradeExtension.createEntry(inputStreamReader);
                            dbContactsEntry.id = 0L;
                            dbContactsEntry.groupId = (Long)hashMap.get(serializable2);
                            dbContactsHandler.saveEntry(connection, dbContactsEntry);
                            dbUpgradeHandler.save(connection, UPGRADE_ENTRIES, String.valueOf(l), dbContactsEntry.id);
                            for (Relation relation : ContactsUpgradeExtension.getContactCalendarRelations(l, dbContactsEntry)) {
                                if (!((File)object).isDirectory() && !((File)object).mkdir()) {
                                    LOGGER.warn("Can't create directory: " + ((File)object).getAbsolutePath());
                                }
                                file4 = new File(object + File.separator + System.currentTimeMillis() + ".xml");
                                while (file4.isFile()) {
                                    Thread.sleep(100L);
                                    file4 = new File(object + File.separator + System.currentTimeMillis() + ".xml");
                                }
                                fileWriterWithEncoding = new FileWriterWithEncoding(file4, "UTF-8");
                                throwable2 = null;
                                try {
                                    relation.write((Writer)fileWriterWithEncoding);
                                    fileWriterWithEncoding.flush();
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (fileWriterWithEncoding == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            fileWriterWithEncoding.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    fileWriterWithEncoding.close();
                                }
                            }
                            for (Relation relation : ContactsUpgradeExtension.getContactEstateRelations(l, dbContactsEntry)) {
                                if (!file3.isDirectory() && !file3.mkdir()) {
                                    LOGGER.warn("Can't create directory: " + file3.getAbsolutePath());
                                }
                                file4 = new File(file3 + File.separator + System.currentTimeMillis() + ".xml");
                                while (file4.isFile()) {
                                    Thread.sleep(100L);
                                    file4 = new File(file3 + File.separator + System.currentTimeMillis() + ".xml");
                                }
                                fileWriterWithEncoding = new FileWriterWithEncoding(file4, "UTF-8");
                                throwable2 = null;
                                try {
                                    relation.write((Writer)fileWriterWithEncoding);
                                    fileWriterWithEncoding.flush();
                                }
                                catch (Throwable throwable5) {
                                    throwable2 = throwable5;
                                    throw throwable5;
                                }
                                finally {
                                    if (fileWriterWithEncoding == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            fileWriterWithEncoding.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable2.addSuppressed(throwable6);
                                        }
                                        continue;
                                    }
                                    fileWriterWithEncoding.close();
                                }
                            }
                        }
                        catch (Throwable throwable7) {
                            throwable = throwable7;
                            throw throwable7;
                        }
                        finally {
                            if (inputStreamReader == null) continue;
                            if (throwable != null) {
                                try {
                                    ((Reader)inputStreamReader).close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                                continue;
                            }
                            ((Reader)inputStreamReader).close();
                        }
                    }
                    catch (Throwable throwable) {
                        LOGGER.warn("Can't import contact-entry!");
                        LOGGER.warn("> from " + ((File)object4).getAbsolutePath());
                        LOGGER.warn("> " + throwable.getLocalizedMessage(), throwable);
                        this.setMessage("WARNING: Can't import contact-entry!", callback);
                        this.setMessage("> " + throwable.getLocalizedMessage(), callback);
                    }
                }
            }
        }
    }
}

