/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.db;

import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.Gender;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbContactsEntry
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbContactsEntry.class);
    private static final I18n I18N = I18nFactory.getI18n(DbContactsEntry.class);
    public static final String VALUE_BANK_ACCOUNT_BANK_CODE_NR = "value.bank_account.bank_code_nr";
    public static final String VALUE_BANK_ACCOUNT_BIC = "value.bank_account.bic";
    public static final String VALUE_BANK_ACCOUNT_IBAN = "value.bank_account.iban";
    public static final String VALUE_BANK_ACCOUNT_INSTITUTE = "value.bank_account.institute";
    public static final String VALUE_BANK_ACCOUNT_NR = "value.bank_account.nr";
    public static final String VALUE_BANK_ACCOUNT_OWNER = "value.bank_account.owner";
    public static final String VALUE_CITIZENSHIP = "value.citizenship";
    public static final String VALUE_CONTACT_ALLOWED = "value.contact_allowed";
    public static final String VALUE_IDENTIFICATION_ISSUER = "value.identification.issuer";
    public static final String VALUE_IDENTIFICATION_NR = "value.identification_nr";
    public static final String VALUE_IDENTIFICATION_TYPE = "value.identification.type";
    public static final String VALUE_LANGUAGES = "value.languages";
    public static final String VALUE_LETTER_ADDRESS = "value.letter_address";
    public static final String VALUE_PLACE_OF_BIRTH = "value.place_of_birth";
    public static final String VALUE_TAX_IDNR = "value.tax.idnr";
    public static final String VALUE_TAX_NR = "value.tax.nr";
    public static final String VALUE_TAX_UID = "value.tax.uid";
    public static final String VALUE_TAX_WIRTSCHAFT_IDNR = "value.tax.wirtschaft_idnr";
    public long id = 0L;
    public long groupId = 0L;
    public String publicId = null;
    public String notes = null;
    public Date birthDay = null;
    public boolean isActive = true;
    public Date createdAt = null;
    public Date modifiedAt = null;
    public Map<String, String> values = null;
    public CompanyAddressImpl address = null;

    public static ObjectToStringConverter createObjectToStringConverter() {
        return new ObjectToStringConverter(){

            public String getPreferredStringForItem(Object object) {
                if (object instanceof DbContactsEntry) {
                    return ((DbContactsEntry)object).print();
                }
                return "-";
            }

            public String[] getPossibleStringsForItem(Object object) {
                if (object instanceof DbContactsEntry) {
                    String string;
                    String string2;
                    DbContactsEntry dbContactsEntry = (DbContactsEntry)object;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(this.getPreferredStringForItem(object));
                    arrayList.add("#" + dbContactsEntry.id);
                    String string3 = dbContactsEntry.address.getPersonFirstName();
                    if (string3 != null && string3.trim().length() > 0) {
                        arrayList.add(string3);
                    }
                    if ((string2 = dbContactsEntry.address.getPersonLastName()) != null && string2.trim().length() > 0) {
                        arrayList.add(string2);
                    }
                    if ((string = dbContactsEntry.address.getCompanyName()) != null && string.trim().length() > 0) {
                        arrayList.add(string);
                    }
                    return arrayList.toArray(new String[0]);
                }
                return super.getPossibleStringsForItem(object);
            }
        };
    }

    private String get(String string) {
        return this.values != null && this.values.containsKey(string) ? this.values.get(string) : "";
    }

    public String getAddressFax() {
        if (this.address == null) {
            return null;
        }
        String string = this.address.getPersonFax();
        if (StringUtils.isBlank((CharSequence)string)) {
            string = this.address.getCompanyFax();
        }
        return !StringUtils.isBlank((CharSequence)string) ? string.trim() : null;
    }

    public String getAddressMail() {
        if (this.address == null) {
            return null;
        }
        String string = this.address.getPersonMail();
        if (StringUtils.isBlank((CharSequence)string)) {
            string = this.address.getCompanyMail();
        }
        return !StringUtils.isBlank((CharSequence)string) ? string.trim() : null;
    }

    public String getAddressMobilePhone() {
        if (this.address == null) {
            return null;
        }
        String string = this.address.getPersonMobilePhone();
        if (StringUtils.isBlank((CharSequence)string)) {
            string = this.address.getCompanyMobilePhone();
        }
        return !StringUtils.isBlank((CharSequence)string) ? string.trim() : null;
    }

    public String getAddressPhone() {
        if (this.address == null) {
            return null;
        }
        String string = this.address.getPersonPhone();
        if (StringUtils.isBlank((CharSequence)string)) {
            string = this.address.getCompanyPhone();
        }
        return !StringUtils.isBlank((CharSequence)string) ? string.trim() : null;
    }

    public String getBankAccountBankCodeNr() {
        return this.get(VALUE_BANK_ACCOUNT_BANK_CODE_NR);
    }

    public String getBankAccountBIC() {
        return this.get(VALUE_BANK_ACCOUNT_BIC);
    }

    public String getBankAccountIBAN() {
        return this.get(VALUE_BANK_ACCOUNT_IBAN);
    }

    public String getBankAccountInstitute() {
        return this.get(VALUE_BANK_ACCOUNT_INSTITUTE);
    }

    public String getBankAccountOwner() {
        return this.get(VALUE_BANK_ACCOUNT_OWNER);
    }

    public String getBankAccountNr() {
        return this.get(VALUE_BANK_ACCOUNT_NR);
    }

    public String getCitizenship() {
        return this.get(VALUE_CITIZENSHIP);
    }

    public String getIdentificationIssuer() {
        return this.get(VALUE_IDENTIFICATION_ISSUER);
    }

    public String getIdentificationNr() {
        return this.get(VALUE_IDENTIFICATION_NR);
    }

    public String getIdentificationType() {
        return this.get(VALUE_IDENTIFICATION_TYPE);
    }

    public InternetAddress getInternetAddress() {
        if (this.address == null) {
            return null;
        }
        String string = StringUtils.trimToNull((String)this.address.getPersonMail());
        if (string == null) {
            string = StringUtils.trimToNull((String)this.address.getCompanyMail());
        }
        String string2 = string = string != null && ImmoToolUtils.isValidMailAddress((String)string) ? ImmoToolUtils.toIdnMailAddress((String)string) : null;
        if (string == null) {
            return null;
        }
        String string3 = null;
        String string4 = StringUtils.trimToNull((String)this.address.writePersonFullName());
        String string5 = StringUtils.trimToNull((String)this.address.getCompanyName());
        if (string4 != null && string5 != null) {
            string3 = string4 + " (" + string5 + ")";
        } else if (string4 != null) {
            string3 = string4;
        } else if (string5 != null) {
            string3 = string5;
        }
        try {
            return new InternetAddress(string, StringUtils.trimToNull((String)string3));
        }
        catch (Exception exception) {
            LOGGER.warn("Can't create internet address for contacts entry #" + this.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public Locale[] getLanguages() {
        if (this.values == null || !this.values.containsKey(VALUE_LANGUAGES)) {
            return new Locale[0];
        }
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        for (String string : this.values.get(VALUE_LANGUAGES).split(",")) {
            arrayList.add(new Locale(string));
        }
        return arrayList.toArray(new Locale[0]);
    }

    public String getLetterAddress() {
        return this.get(VALUE_LETTER_ADDRESS);
    }

    public String getPlaceOfBirth() {
        return this.get(VALUE_PLACE_OF_BIRTH);
    }

    public String getTaxIdNr() {
        return this.get(VALUE_TAX_IDNR);
    }

    public String getTaxNr() {
        return this.get(VALUE_TAX_NR);
    }

    public String getTaxUID() {
        return this.get(VALUE_TAX_UID);
    }

    public String getTaxWirtschaftIdNr() {
        return this.get(VALUE_TAX_WIRTSCHAFT_IDNR);
    }

    public boolean isContactAllowed() {
        return Boolean.TRUE.toString().equalsIgnoreCase(this.get(VALUE_CONTACT_ALLOWED));
    }

    public String print() {
        String string = "";
        if (this.address != null) {
            String string2;
            String string3 = this.address.writePersonFullName();
            if (string3 != null && string3.trim().length() > 0) {
                if (string.length() > 0) {
                    string = string + " / ";
                }
                string = string + string3.trim();
            }
            if ((string2 = this.address.getCompanyName()) != null && string2.trim().length() > 0) {
                if (string.length() > 0) {
                    string = string + " / ";
                }
                string = string + string2.trim();
            }
        }
        return "#" + this.id + " | " + string;
    }

    private void set(String string, String string2) {
        if (this.values == null) {
            return;
        }
        if ((string2 = StringUtils.trimToNull((String)string2)) == null) {
            this.values.remove(string);
        } else {
            this.values.put(string, string2);
        }
    }

    public void setBankAccountBankCodeNr(String string) {
        this.set(VALUE_BANK_ACCOUNT_BANK_CODE_NR, string);
    }

    public void setBankAccountBIC(String string) {
        this.set(VALUE_BANK_ACCOUNT_BIC, string);
    }

    public void setBankAccountIBAN(String string) {
        this.set(VALUE_BANK_ACCOUNT_IBAN, string);
    }

    public void setBankAccountInstitute(String string) {
        this.set(VALUE_BANK_ACCOUNT_INSTITUTE, string);
    }

    public void setBankAccountNr(String string) {
        this.set(VALUE_BANK_ACCOUNT_NR, string);
    }

    public void setBankAccountOwner(String string) {
        this.set(VALUE_BANK_ACCOUNT_OWNER, string);
    }

    public void setCitizenship(String string) {
        this.set(VALUE_CITIZENSHIP, string);
    }

    public void setContactAllowed(boolean bl) {
        this.set(VALUE_CONTACT_ALLOWED, String.valueOf(bl));
    }

    public void setIdentificationIssuer(String string) {
        this.set(VALUE_IDENTIFICATION_ISSUER, string);
    }

    public void setIdentificationNr(String string) {
        this.set(VALUE_IDENTIFICATION_NR, string);
    }

    public void setIdentificationType(String string) {
        IdentificationType identificationType = IdentificationType.fromValue(string);
        if (identificationType != null) {
            this.setIdentificationType(identificationType);
        } else {
            this.set(VALUE_IDENTIFICATION_TYPE, StringUtils.trimToNull((String)string));
        }
    }

    public void setIdentificationType(IdentificationType identificationType) {
        this.set(VALUE_IDENTIFICATION_TYPE, identificationType != null ? identificationType.name() : null);
    }

    public void setLanguages(Locale[] localeArray) {
        if (localeArray == null || localeArray.length <= 0) {
            this.set(VALUE_LANGUAGES, null);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (Locale locale : localeArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(locale.getLanguage());
            }
            this.set(VALUE_LANGUAGES, stringBuilder.toString());
        }
    }

    public void setLetterAddress(DefaultLetterAddress defaultLetterAddress) {
        this.set(VALUE_LETTER_ADDRESS, defaultLetterAddress != null ? defaultLetterAddress.name() : null);
    }

    public void setLetterAddress(String string) {
        DefaultLetterAddress defaultLetterAddress;
        if (StringUtils.isBlank((CharSequence)string)) {
            this.set(VALUE_LETTER_ADDRESS, null);
            return;
        }
        DefaultLetterAddress defaultLetterAddress2 = defaultLetterAddress = this.address != null ? DefaultLetterAddress.lookup(string, this.address.getPersonLastName(), this.address.getPersonTitle(), this.address.getPersonGender()) : null;
        if (defaultLetterAddress != null) {
            this.setLetterAddress(defaultLetterAddress);
        } else {
            this.set(VALUE_LETTER_ADDRESS, string);
        }
    }

    public void setPlaceOfBirth(String string) {
        this.set(VALUE_PLACE_OF_BIRTH, string);
    }

    public void setTaxIdNr(String string) {
        this.set(VALUE_TAX_IDNR, string);
    }

    public void setTaxNr(String string) {
        this.set(VALUE_TAX_NR, string);
    }

    public void setTaxUID(String string) {
        this.set(VALUE_TAX_UID, string);
    }

    public void setTaxWirtschaftIdNr(String string) {
        this.set(VALUE_TAX_WIRTSCHAFT_IDNR, string);
    }

    public String writeActive() {
        return DbContactsEntry.writeActive(this.isActive);
    }

    public static String writeActive(boolean bl) {
        return bl ? I18N.tr("active") : I18N.tr("inactive");
    }

    public String writeLetterAddress() {
        return DbContactsEntry.writeLetterAddress(this.getLetterAddress(), this.address.getPersonLastName(), this.address.getPersonTitle(), this.address.getPersonGender());
    }

    public static String writeLetterAddress(String string, String string2, String string3, Gender gender) {
        String string4;
        if (!StringUtils.isBlank((CharSequence)(string = StringUtils.trimToEmpty((String)string))) && !StringUtils.isBlank((CharSequence)(string4 = DefaultLetterAddress.lookupAndWrite(string, string2, string3, gender)))) {
            return string4;
        }
        return string;
    }

    public String writeMails() {
        return this.writeMails(", ");
    }

    public String writeMails(String string) {
        if (this.address == null) {
            return "";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.address.getPersonMail() != null && this.address.getPersonMail().trim().length() > 0) {
            arrayList.add(this.address.getPersonMail());
        }
        if (this.address.getCompanyMail() != null && this.address.getCompanyMail().trim().length() > 0) {
            arrayList.add(this.address.getCompanyMail());
        }
        return !arrayList.isEmpty() ? StringUtils.join((Object[])arrayList.toArray(new String[0]), (String)string) : "";
    }

    public String writeMobilePhones() {
        return this.writeMobilePhones(", ");
    }

    public String writeMobilePhones(String string) {
        if (this.address == null) {
            return "";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.address.getPersonMobilePhone() != null && this.address.getPersonMobilePhone().trim().length() > 0) {
            arrayList.add(this.address.getPersonMobilePhone());
        }
        if (this.address.getCompanyMobilePhone() != null && this.address.getCompanyMobilePhone().trim().length() > 0) {
            arrayList.add(this.address.getCompanyMobilePhone());
        }
        return !arrayList.isEmpty() ? StringUtils.join((Object[])arrayList.toArray(new String[0]), (String)string) : "";
    }

    public String writePhones() {
        return this.writePhones(", ");
    }

    public String writePhones(String string) {
        if (this.address == null) {
            return "";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.address.getPersonPhone() != null && this.address.getPersonPhone().trim().length() > 0) {
            arrayList.add(this.address.getPersonPhone());
        }
        if (this.address.getCompanyPhone() != null && this.address.getCompanyPhone().trim().length() > 0) {
            arrayList.add(this.address.getCompanyPhone());
        }
        return !arrayList.isEmpty() ? StringUtils.join((Object[])arrayList.toArray(new String[0]), (String)string) : "";
    }

    public String writeToolTip() {
        String string = this.address.getCompanyName();
        return "<html><div style=\"margin:5px;\"><h2 style=\"margin:0;\">" + StringUtils.capitalize((String)I18N.tr("address")) + " #" + this.id + "</h2><hr>" + StringEscapeUtils.escapeXml11((String)this.address.writePersonFullName()) + (!StringUtils.isBlank((CharSequence)string) ? "<br>" + StringEscapeUtils.escapeXml11((String)string) : "") + "<hr>" + this.address.writeFullAddress("<br>") + "<hr>" + I18N.tr("e-mail") + ": " + StringEscapeUtils.escapeXml11((String)this.writeMails()) + "<br>" + I18N.tr("phone") + ": " + StringEscapeUtils.escapeXml11((String)this.writePhones()) + "</div></html>";
    }

    public static enum IdentificationType implements Translatable
    {
        ID_CARD(I18n.marktr((String)"identification card")),
        PASSPORT(I18n.marktr((String)"passport")),
        DRIVING_LICENSE(I18n.marktr((String)"driving license"));

        private final String i18nKey;

        private IdentificationType(String string2) {
            this.i18nKey = string2;
        }

        public static IdentificationType fromValue(String string) {
            if (StringUtils.isBlank((CharSequence)string)) {
                return null;
            }
            for (IdentificationType identificationType : IdentificationType.values()) {
                if (!identificationType.name().equalsIgnoreCase(string) && !identificationType.getTranslation().equalsIgnoreCase(string)) continue;
                return identificationType;
            }
            return null;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(DbContactsEntry.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(DbContactsEntry.class, (String)this.i18nKey, (Locale)locale);
        }
    }

    public static enum DefaultLetterAddress {
        GENERAL,
        FORMAL,
        FORMAL_FAMILY,
        INFORMAL,
        INFORMAL_FAMILY;


        public static DefaultLetterAddress lookup(String string, String string2, String string3, Gender gender) {
            string = StringUtils.trimToEmpty((String)string);
            try {
                return DefaultLetterAddress.valueOf(string.toUpperCase());
            }
            catch (Exception exception) {
                String string4 = string.replace(".", "_");
                try {
                    return DefaultLetterAddress.valueOf(string4.toUpperCase());
                }
                catch (Exception exception2) {
                    if (!StringUtils.isBlank((CharSequence)string)) {
                        String string5 = string.toLowerCase().replace(" ", "");
                        ArrayList<DefaultLetterAddress> arrayList = new ArrayList<DefaultLetterAddress>();
                        for (Object object : DefaultLetterAddress.values()) {
                            if (GENERAL.equals(object)) continue;
                            arrayList.add((DefaultLetterAddress)((Object)object));
                        }
                        arrayList.add(GENERAL);
                        for (DefaultLetterAddress defaultLetterAddress : arrayList) {
                            Object object;
                            String string6 = StringUtils.trimToEmpty((String)defaultLetterAddress.write(string2, string3, gender));
                            object = string6.toLowerCase().replace(" ", "");
                            if (defaultLetterAddress.name().equalsIgnoreCase(string)) {
                                return defaultLetterAddress;
                            }
                            if (defaultLetterAddress.name().equalsIgnoreCase(string4)) {
                                return defaultLetterAddress;
                            }
                            if (!((String)object).equals(string5)) continue;
                            return defaultLetterAddress;
                        }
                    }
                    return null;
                }
            }
        }

        public static String lookupAndWrite(String string, String string2, String string3, Gender gender) {
            DefaultLetterAddress defaultLetterAddress = DefaultLetterAddress.lookup(string, string2, string3, gender);
            return defaultLetterAddress != null ? defaultLetterAddress.write(string2, string3, gender) : null;
        }

        public String write(String string, String string2, Gender gender) {
            String string3 = "";
            switch (this) {
                case GENERAL: {
                    return I18N.tr("Dear Sir or Madam");
                }
                case FORMAL_FAMILY: {
                    if (!StringUtils.isBlank((CharSequence)string)) {
                        string3 = string3 + " " + string;
                    }
                    string3 = StringUtils.trimToEmpty((String)string3);
                    return I18N.tr("Dear Family {0}", (Object)string3);
                }
                case INFORMAL_FAMILY: {
                    if (!StringUtils.isBlank((CharSequence)string)) {
                        string3 = string3 + " " + string;
                    }
                    string3 = StringUtils.trimToEmpty((String)string3);
                    return I18N.tr("Hello Family {0}", (Object)string3);
                }
                case FORMAL: {
                    if (!StringUtils.isBlank((CharSequence)string2)) {
                        string3 = string3 + " " + string2;
                    }
                    if (!StringUtils.isBlank((CharSequence)string)) {
                        string3 = string3 + " " + string;
                    }
                    string3 = StringUtils.trimToEmpty((String)string3);
                    if (Gender.FEMALE.equals((Object)gender)) {
                        return I18N.tr("Dear Ms {0}", (Object)string3);
                    }
                    if (Gender.MALE.equals((Object)gender)) {
                        return I18N.tr("Dear Mr {0}", (Object)string3);
                    }
                    return I18N.tr("Dear Sir or Madam");
                }
                case INFORMAL: {
                    if (!StringUtils.isBlank((CharSequence)string2)) {
                        string3 = string3 + " " + string2;
                    }
                    if (!StringUtils.isBlank((CharSequence)string)) {
                        string3 = string3 + " " + string;
                    }
                    string3 = StringUtils.trimToEmpty((String)string3);
                    if (Gender.FEMALE.equals((Object)gender)) {
                        return I18N.tr("Hello Ms {0}", (Object)string3);
                    }
                    if (Gender.MALE.equals((Object)gender)) {
                        return I18N.tr("Hello Mr {0}", (Object)string3);
                    }
                    return I18N.tr("Hello");
                }
            }
            return null;
        }
    }
}

