/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.db.hsql;

import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandlerImpl;
import com.openindex.openestate.tool.utils.Permission;
import com.openindex.openestate.tool.utils.StatusNotification;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbContactsHandler
extends DbContactsHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbContactsHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbContactsHandler.class);
    public static final String PROC_REMOVE_GROUPS = "remove_immotool_contacts_groups";
    public static final String PROC_REMOVE_ENTRIES = "remove_immotool_contacts_entries";
    public static final String PROC_REMOVE_ENTRIES_ADDRESS = "remove_immotool_contacts_entries_address";
    public static final String PROC_REMOVE_ENTRIES_SETTINGS = "remove_immotool_contacts_entries_settings";
    public static final String PROC_GET_ENTRY_ID = "get_immotool_contacts_entry_id";
    public static final String PROC_SAVE_GROUPS = "save_immotool_contacts_groups";
    public static final String PROC_SAVE_ENTRIES = "save_immotool_contacts_entries";
    public static final String PROC_SAVE_ENTRIES_SETTINGS = "save_immotool_contacts_entries_settings";
    public static final String PROC_SET_ENTRIES_ACTIVE = "set_immotool_contacts_entries_active";
    public static final String PROC_SET_ENTRIES_GROUP = "set_immotool_contacts_entries_group";
    public static final String VIEW_GROUPS = "view_immotool_contacts_groups";
    public static final String VIEW_ENTRIES = "view_immotool_contacts_entries";
    public static final String VIEW_ENTRIES_FILES = "view_immotool_contacts_entries_files";
    public static final String VIEW_ENTRIES_FILES_CONTENT = "view_immotool_contacts_entries_files_content";
    public static final String VIEW_ENTRIES_SETTINGS = "view_immotool_contacts_entries_settings";
    public static final String TABLE_GROUPS = "immotool_contacts_groups";
    public static final String FIELD_GROUP_ID = "group_id";
    public static final String FIELD_GROUP_NAME = "group_name";
    public static final String FIELD_GROUP_NOTES = "group_notes";
    public static final String TABLE_ENTRIES = "immotool_contacts_entries";
    public static final String FIELD_ENTRY_ID = "entry_id";
    public static final String FIELD_ENTRY_NOTES = "entry_notes";
    public static final String FIELD_ENTRY_ACTIVE = "entry_active";
    public static final String FIELD_ENTRY_BIRTHDAY = "entry_birthday";
    public static final String FIELD_ENTRY_PUBLIC_ID = "entry_public_id";
    public static final String TABLE_ENTRIES_SETTINGS = "immotool_contacts_entries_settings";
    public static final String FIELD_SETTING_KEY = "setting_key";
    public static final String FIELD_SETTING_VALUE = "setting_value";
    public static final String TABLE_ENTRIES_FILES = "immotool_contacts_entries_files";
    public static final String FIELD_FILE_ID = "file_id";
    public static final String FIELD_FILE_NAME = "file_name";
    public static final String FIELD_FILE_MIMETYPE = "file_mimetype";
    public static final String FIELD_FILE_CONTENT = "file_content";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";
    private static final String FIELD_ACCESS_OWNER_ID = "access_owner_id";
    private static final String FIELD_ACCESS_GROUP_ID = "access_group_id";
    private static final String FIELD_ACCESS_PERMISSIONS = "access_permissions";

    private static DbContactsEntry createEntry(ResultSet resultSet) throws SQLException {
        DbContactsEntry dbContactsEntry = new DbContactsEntry();
        dbContactsEntry.id = resultSet.getLong(FIELD_ENTRY_ID);
        dbContactsEntry.groupId = resultSet.getLong(FIELD_GROUP_ID);
        dbContactsEntry.isActive = resultSet.getBoolean(FIELD_ENTRY_ACTIVE);
        dbContactsEntry.publicId = resultSet.getString(FIELD_ENTRY_PUBLIC_ID);
        dbContactsEntry.notes = resultSet.getString(FIELD_ENTRY_NOTES);
        dbContactsEntry.birthDay = resultSet.getDate(FIELD_ENTRY_BIRTHDAY);
        dbContactsEntry.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbContactsEntry.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        return dbContactsEntry;
    }

    private static DbContactsGroup createGroup(ResultSet resultSet) throws SQLException {
        DbContactsGroup dbContactsGroup = new DbContactsGroup();
        dbContactsGroup.id = resultSet.getLong(FIELD_GROUP_ID);
        dbContactsGroup.name = resultSet.getString(FIELD_GROUP_NAME);
        dbContactsGroup.notes = resultSet.getString(FIELD_GROUP_NOTES);
        dbContactsGroup.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbContactsGroup.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        dbContactsGroup.ownerUserId = resultSet.getLong(FIELD_ACCESS_OWNER_ID);
        dbContactsGroup.ownerGroupId = resultSet.getLong(FIELD_ACCESS_GROUP_ID);
        dbContactsGroup.permission = new Permission(resultSet.getInt(FIELD_ACCESS_PERMISSIONS));
        return dbContactsGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbContactsEntry[] getEntries(Connection connection, long[] lArray) throws SQLException {
        DbContactsEntry[] dbContactsEntryArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbContactsEntry[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_contacts_entries ORDER BY entry_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_contacts_entries WHERE entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_ENTRY_ID + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbContactsEntry> arrayList = new ArrayList<DbContactsEntry>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbContactsHandler.createEntry(resultSet));
            }
            dbContactsEntryArray = arrayList.toArray(new DbContactsEntry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbContactsEntryArray;
    }

    @Override
    @Deprecated
    public DbContactsEntry[] getEntriesByAddress(Connection connection, String string, String string2, boolean bl) throws SQLException {
        if (string == null || string2 == null) {
            return this.getEntriesBySetting(connection, null, null, bl);
        }
        return this.getEntriesBySetting(connection, "entry." + string, string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbContactsEntry[] getEntriesByBirthday(Connection connection, java.util.Date date, java.util.Date date2, Boolean bl) throws SQLException {
        DbContactsEntry[] dbContactsEntryArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n;
            int n2;
            int n3;
            Cloneable cloneable;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("entry_birthday IS NOT NULL");
            if (bl != null) {
                arrayList.add("entry_active = ?");
            }
            if (date != null) {
                arrayList.add("YEAR(entry_birthday) <= ?");
                arrayList.add("((MONTH(entry_birthday) > ?) OR (MONTH(entry_birthday) = ? AND DAYOFMONTH(entry_birthday) >= ?))");
            }
            if (date2 != null) {
                arrayList.add("YEAR(entry_birthday) <= ?");
                arrayList.add("((MONTH(entry_birthday) < ?) OR (MONTH(entry_birthday) = ? AND DAYOFMONTH(entry_birthday) <= ?))");
            }
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_contacts_entries WHERE " + StringUtils.join(arrayList, (String)" AND ") + " ORDER BY " + FIELD_ENTRY_ID + " ASC;");
            int n4 = 0;
            if (bl != null) {
                preparedStatement.setBoolean(++n4, bl);
            }
            if (date != null) {
                cloneable = Calendar.getInstance();
                ((Calendar)cloneable).setTime(date);
                n3 = ((Calendar)cloneable).get(1);
                n2 = ((Calendar)cloneable).get(2) + 1;
                n = ((Calendar)cloneable).get(5);
                preparedStatement.setInt(++n4, n3);
                preparedStatement.setInt(++n4, n2);
                preparedStatement.setInt(++n4, n2);
                preparedStatement.setInt(++n4, n);
            }
            if (date2 != null) {
                cloneable = Calendar.getInstance();
                ((Calendar)cloneable).setTime(date2);
                n3 = ((Calendar)cloneable).get(1);
                n2 = ((Calendar)cloneable).get(2) + 1;
                n = ((Calendar)cloneable).get(5);
                preparedStatement.setInt(++n4, n3);
                preparedStatement.setInt(++n4, n2);
                preparedStatement.setInt(++n4, n2);
                preparedStatement.setInt(++n4, n);
            }
            resultSet = preparedStatement.executeQuery();
            cloneable = new ArrayList();
            while (resultSet.next()) {
                cloneable.add(HSqlDbContactsHandler.createEntry(resultSet));
            }
            dbContactsEntryArray = cloneable.toArray(new DbContactsEntry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbContactsEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbContactsEntry[] getEntriesByInternetAddress(Connection connection, InternetAddress internetAddress, int n) throws SQLException {
        DbContactsEntry[] dbContactsEntryArray;
        String string;
        String string2 = string = internetAddress != null ? internetAddress.getAddress() : null;
        if (StringUtils.isBlank((CharSequence)string)) {
            return new DbContactsEntry[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (!StringUtils.isBlank((CharSequence)string)) {
                arrayList.add("entry_id IN ( SELECT entry_id FROM view_immotool_contacts_entries_settings WHERE setting_key = ? AND LOWER(setting_value) = ? ) OR entry_id IN ( SELECT entry_id FROM view_immotool_contacts_entries_settings WHERE setting_key = ? AND LOWER(setting_value) = ? )");
                arrayList2.add("entry.person.mail");
                arrayList2.add(string.trim().toLowerCase());
                arrayList2.add("entry.company.mail");
                arrayList2.add(string.trim().toLowerCase());
            }
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_contacts_entries WHERE (" + StringUtils.join(arrayList, (String)") AND (") + ") ORDER BY " + FIELD_ENTRY_ID + " ASC " + (n > 0 ? "LIMIT " + n : "") + ";");
            int n2 = 0;
            for (String dbContactsEntryArray2 : arrayList2) {
                preparedStatement.setString(++n2, dbContactsEntryArray2);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList arrayList3 = new ArrayList();
            while (resultSet.next()) {
                arrayList3.add(HSqlDbContactsHandler.createEntry(resultSet));
            }
            dbContactsEntryArray = arrayList3.toArray(new DbContactsEntry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbContactsEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbContactsEntry[] getEntriesByKeyword(Connection connection, String string, long[] lArray, int n) throws SQLException {
        DbContactsEntry[] dbContactsEntryArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((string = StringUtils.trimToNull((String)StringUtils.lowerCase((String)string))) != null) {
            arrayList.add("entry_id IN ( SELECT entry_id FROM view_immotool_contacts_entries_settings WHERE setting_key IN (?,?,?,?,?) AND LOWER(setting_value) LIKE ? )");
        }
        if (lArray != null) {
            arrayList.add("group_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ")");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = "SELECT * FROM view_immotool_contacts_entries";
            if (!arrayList.isEmpty()) {
                string2 = string2 + " WHERE " + StringUtils.join((Object[])arrayList.toArray(new String[0]), (String)" AND ");
            }
            string2 = string2 + "ORDER BY entry_id ASC ";
            string2 = string2 + (n > 0 ? "LIMIT " + n : "");
            preparedStatement = connection.prepareStatement(string2);
            int n2 = 0;
            if (string != null) {
                preparedStatement.setString(++n2, "entry.person.lastName");
                preparedStatement.setString(++n2, "entry.person.firstName");
                preparedStatement.setString(++n2, "entry.person.mail");
                preparedStatement.setString(++n2, "entry.company.name");
                preparedStatement.setString(++n2, "entry.company.mail");
                preparedStatement.setString(++n2, "%" + string + "%");
            }
            if (lArray != null) {
                for (long l : lArray) {
                    preparedStatement.setLong(++n2, l);
                }
            }
            resultSet = preparedStatement.executeQuery();
            Object object = new ArrayList();
            while (resultSet.next()) {
                object.add(HSqlDbContactsHandler.createEntry(resultSet));
            }
            dbContactsEntryArray = object.toArray(new DbContactsEntry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbContactsEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public DbContactsEntry[] getEntriesBySetting(Connection connection, String string, String string2, boolean bl) throws SQLException {
        DbContactsEntry[] dbContactsEntryArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            Object object;
            if (string == null || string2 == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_contacts_entries ORDER BY entry_id ASC;");
            } else {
                object = bl ? "LOWER(setting_value) = ?" : "setting_value = ?";
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_contacts_entries WHERE entry_id IN (SELECT entry_id FROM view_immotool_contacts_entries_settings WHERE setting_key = ? AND " + (String)object + ") ORDER BY " + FIELD_ENTRY_ID + " ASC;");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, bl ? string2.toLowerCase() : string2);
            }
            resultSet = preparedStatement.executeQuery();
            object = new ArrayList();
            while (resultSet.next()) {
                object.add(HSqlDbContactsHandler.createEntry(resultSet));
            }
            dbContactsEntryArray = object.toArray(new DbContactsEntry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbContactsEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEntryId(Connection connection, String string) throws SQLException {
        long l;
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return 0L;
        }
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = connection.prepareCall("CALL get_immotool_contacts_entry_id(?);");
            callableStatement.setString(1, string);
            resultSet = callableStatement.executeQuery();
            l = resultSet.next() ? resultSet.getLong(1) : 0L;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)callableStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)callableStatement);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getEntryIds(Connection connection) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT entry_id FROM view_immotool_contacts_entries ORDER BY entry_id ASC;");
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_ENTRY_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbContactsGroup[] getGroups(Connection connection, long[] lArray) throws SQLException {
        DbContactsGroup[] dbContactsGroupArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbContactsGroup[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_contacts_groups ORDER BY group_name ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_contacts_groups WHERE group_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_GROUP_NAME + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbContactsGroup> arrayList = new ArrayList<DbContactsGroup>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbContactsHandler.createGroup(resultSet));
            }
            dbContactsGroupArray = arrayList.toArray(new DbContactsGroup[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbContactsGroupArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbContactsGroup[] getGroups(Connection connection, String string) throws SQLException {
        DbContactsGroup[] dbContactsGroupArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (string == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_contacts_groups ORDER BY group_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_contacts_groups WHERE group_name = ? ORDER BY group_id ASC;");
                preparedStatement.setString(1, string);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbContactsGroup> arrayList = new ArrayList<DbContactsGroup>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbContactsHandler.createGroup(resultSet));
            }
            dbContactsGroupArray = arrayList.toArray(new DbContactsGroup[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbContactsGroupArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getGroupIds(Connection connection) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT group_id FROM view_immotool_contacts_groups ORDER BY group_id ASC;");
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_GROUP_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbContactsEntry[] getGroupEntries(Connection connection, long[] lArray) throws SQLException {
        DbContactsEntry[] dbContactsEntryArray;
        if (lArray == null || lArray.length <= 0) {
            return new DbContactsEntry[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_contacts_entries WHERE group_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_ENTRY_ID + " ASC;");
            for (int i = 0; i < lArray.length; ++i) {
                preparedStatement.setLong(i + 1, lArray[i]);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbContactsEntry> arrayList = new ArrayList<DbContactsEntry>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbContactsHandler.createEntry(resultSet));
            }
            dbContactsEntryArray = arrayList.toArray(new DbContactsEntry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbContactsEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadEntrySettings(Connection connection, DbContactsEntry[] dbContactsEntryArray) throws SQLException {
        HashMap<Long, DbContactsEntry> hashMap = new HashMap<Long, DbContactsEntry>();
        for (DbContactsEntry dbContactsEntry : dbContactsEntryArray) {
            if (dbContactsEntry.id <= 0L || hashMap.containsKey(dbContactsEntry.id)) continue;
            hashMap.put(dbContactsEntry.id, dbContactsEntry);
            dbContactsEntry.address = new CompanyAddressImpl();
            if (dbContactsEntry.values != null) {
                dbContactsEntry.values.clear();
                continue;
            }
            dbContactsEntry.values = new HashMap<String, String>();
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_contacts_entries_settings WHERE entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_ENTRY_ID + " ASC, " + FIELD_SETTING_KEY + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            long l = 0L;
            HashMap<String, String> hashMap2 = null;
            while (resultSet.next()) {
                long l2 = resultSet.getLong(FIELD_ENTRY_ID);
                if (l != l2) {
                    if (l > 0L && hashMap2 != null) {
                        ((DbContactsEntry)hashMap.get((Object)Long.valueOf((long)l))).address.readFromMap(hashMap2, "entry.");
                    }
                    l = l2;
                    hashMap2 = new HashMap<String, String>();
                }
                String string = resultSet.getString(FIELD_SETTING_KEY);
                String string2 = resultSet.getString(FIELD_SETTING_VALUE);
                if (!hashMap.containsKey(l2)) continue;
                DbContactsEntry dbContactsEntry = (DbContactsEntry)hashMap.get(l2);
                if (string.startsWith("entry.")) {
                    if (string2 == null || hashMap2 == null) continue;
                    hashMap2.put(string, string2);
                    continue;
                }
                if (string2 == null) continue;
                dbContactsEntry.values.put(string, string2);
            }
            if (l > 0L && hashMap2 != null) {
                ((DbContactsEntry)hashMap.get((Object)Long.valueOf((long)l))).address.readFromMap(hashMap2, "entry.");
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    @Override
    public void removeEntries(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_contacts_entries(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void removeGroups(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_contacts_groups(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveEntry(Connection connection, DbContactsEntry dbContactsEntry) throws SQLException {
        ArrayList<CallableStatement> arrayList;
        NamedCallableStatement namedCallableStatement;
        boolean bl;
        block14: {
            long l;
            bl = connection.getAutoCommit();
            dbContactsEntry.publicId = StringUtils.trimToNull((String)dbContactsEntry.publicId);
            if (dbContactsEntry.publicId != null && (l = this.getEntryId(connection, dbContactsEntry.publicId)) > 0L && dbContactsEntry.id != l) {
                LOGGER.warn("The public id '" + dbContactsEntry.publicId + "' is already used by address #" + l + "!");
                ImmoToolEnvironment.showStatusNotification((StatusNotification)new StatusNotification.Warning("<html><b>" + StringEscapeUtils.escapeXml11((String)I18N.tr("The address nr {0} is already in use!", (Object)('\"' + dbContactsEntry.publicId + '\"'))) + "</b><br>" + StringEscapeUtils.escapeXml11((String)I18N.tr("Therefore the address was saved without a number.")) + "</html>"));
                dbContactsEntry.publicId = null;
            }
            namedCallableStatement = null;
            arrayList = new ArrayList<CallableStatement>();
            try {
                NamedCallableStatement namedCallableStatement2;
                long l2;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_contacts_entries(:entry_id, :group_id, :entry_public_id, :entry_notes, :entry_active, :entry_birthday);");
                namedCallableStatement.setLong(FIELD_ENTRY_ID, dbContactsEntry.id);
                namedCallableStatement.setLong(FIELD_GROUP_ID, dbContactsEntry.groupId);
                namedCallableStatement.setString(FIELD_ENTRY_PUBLIC_ID, dbContactsEntry.publicId);
                namedCallableStatement.setString(FIELD_ENTRY_NOTES, dbContactsEntry.notes);
                namedCallableStatement.setBoolean(FIELD_ENTRY_ACTIVE, dbContactsEntry.isActive);
                namedCallableStatement.setDate(FIELD_ENTRY_BIRTHDAY, dbContactsEntry.birthDay != null ? new Date(dbContactsEntry.birthDay.getTime()) : null);
                namedCallableStatement.execute();
                long l3 = l2 = dbContactsEntry.id < 1L ? namedCallableStatement.getLong(FIELD_ENTRY_ID) : dbContactsEntry.id;
                if (l2 < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                if (dbContactsEntry.address != null) {
                    if (dbContactsEntry.id > 0L) {
                        namedCallableStatement2 = new NamedCallableStatement(connection, "CALL remove_immotool_contacts_entries_address(:entry_id, :setting_key);");
                        namedCallableStatement2.setLong(FIELD_ENTRY_ID, dbContactsEntry.id);
                        namedCallableStatement2.setNull(FIELD_SETTING_KEY, 12);
                        namedCallableStatement2.execute();
                        arrayList.add(namedCallableStatement2.getStatement());
                    }
                    namedCallableStatement2 = new HashMap();
                    dbContactsEntry.address.serializeToMap((Map)namedCallableStatement2, "entry.");
                    NamedCallableStatement namedCallableStatement3 = new NamedCallableStatement(connection, "CALL save_immotool_contacts_entries_settings(:entry_id, :setting_key, :setting_value);");
                    for (Map.Entry entry : namedCallableStatement2.entrySet()) {
                        String string = (String)entry.getKey();
                        String string2 = (String)entry.getValue();
                        if (string2 == null || string2.trim().length() == 0) continue;
                        namedCallableStatement3.clearParameters();
                        namedCallableStatement3.setLong(FIELD_ENTRY_ID, l2);
                        namedCallableStatement3.setString(FIELD_SETTING_KEY, StringUtils.abbreviate((String)string, (int)255));
                        namedCallableStatement3.setString(FIELD_SETTING_VALUE, string2);
                        namedCallableStatement3.executeUpdate();
                        arrayList.add(namedCallableStatement3.getStatement());
                    }
                }
                if (dbContactsEntry.values != null) {
                    if (dbContactsEntry.id > 0L) {
                        namedCallableStatement2 = new NamedCallableStatement(connection, "CALL remove_immotool_contacts_entries_settings(:entry_id, :setting_key);");
                        namedCallableStatement2.setLong(FIELD_ENTRY_ID, dbContactsEntry.id);
                        namedCallableStatement2.setNull(FIELD_SETTING_KEY, 12);
                        namedCallableStatement2.execute();
                        arrayList.add(namedCallableStatement2.getStatement());
                    }
                    namedCallableStatement2 = new NamedCallableStatement(connection, "CALL save_immotool_contacts_entries_settings(:entry_id, :setting_key, :setting_value);");
                    for (String string : dbContactsEntry.values.keySet()) {
                        String string3 = dbContactsEntry.values.get(string);
                        if (string3 == null || string3.trim().length() == 0) continue;
                        namedCallableStatement2.clearParameters();
                        namedCallableStatement2.setLong(FIELD_ENTRY_ID, l2);
                        namedCallableStatement2.setString(FIELD_SETTING_KEY, StringUtils.abbreviate((String)string, (int)255));
                        namedCallableStatement2.setString(FIELD_SETTING_VALUE, string3);
                        namedCallableStatement2.executeUpdate();
                        arrayList.add(namedCallableStatement2.getStatement());
                    }
                }
                connection.commit();
                if (dbContactsEntry.id >= 1L) break block14;
                dbContactsEntry.id = l2;
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    for (Statement statement : arrayList) {
                        JdbcUtils.closeQuietly((Statement)statement);
                    }
                    connection.setAutoCommit(bl);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        for (Statement statement : arrayList) {
            JdbcUtils.closeQuietly((Statement)statement);
        }
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveGroup(Connection connection, DbContactsGroup dbContactsGroup) throws SQLException {
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            long l;
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_contacts_groups(:group_id, :group_name, :group_notes, :access_owner_id, :access_group_id, :access_permissions);");
            namedCallableStatement.setLong(FIELD_GROUP_ID, dbContactsGroup.id);
            namedCallableStatement.setString(FIELD_GROUP_NAME, StringUtils.abbreviate((String)dbContactsGroup.name, (int)100));
            namedCallableStatement.setString(FIELD_GROUP_NOTES, dbContactsGroup.notes);
            namedCallableStatement.setLong(FIELD_ACCESS_OWNER_ID, dbContactsGroup.ownerUserId);
            namedCallableStatement.setLong(FIELD_ACCESS_GROUP_ID, dbContactsGroup.ownerGroupId);
            namedCallableStatement.setInt(FIELD_ACCESS_PERMISSIONS, dbContactsGroup.permission != null ? dbContactsGroup.permission.getValue() : -1);
            namedCallableStatement.execute();
            long l2 = l = dbContactsGroup.id < 1L ? namedCallableStatement.getLong(FIELD_GROUP_ID) : dbContactsGroup.id;
            if (l < 1L) {
                throw new SQLException("Can't determine ID of the saved object!");
            }
            connection.commit();
            if (dbContactsGroup.id <= 0L) {
                dbContactsGroup.id = l;
            }
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void setEntriesActive(Connection connection, long[] lArray, boolean bl) throws SQLException {
        if (lArray == null || lArray.length < 1) {
            return;
        }
        boolean bl2 = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL set_immotool_contacts_entries_active(:entry_id, :entry_active);");
            for (long l : lArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_ENTRY_ID, l);
                namedCallableStatement.setBoolean(FIELD_ENTRY_ACTIVE, bl);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl2);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl2);
    }

    @Override
    public void setEntriesGroup(Connection connection, long[] lArray, long l) throws SQLException {
        if (lArray == null || lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL set_immotool_contacts_entries_group(:entry_id, :group_id);");
            for (long l2 : lArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_ENTRY_ID, l2);
                namedCallableStatement.setLong(FIELD_GROUP_ID, l);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

