/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardOutputter;
import net.fortuna.ical4j.vcard.parameter.Encoding;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.property.Address;
import net.fortuna.ical4j.vcard.property.BDay;
import net.fortuna.ical4j.vcard.property.Email;
import net.fortuna.ical4j.vcard.property.Fn;
import net.fortuna.ical4j.vcard.property.Gender;
import net.fortuna.ical4j.vcard.property.Geo;
import net.fortuna.ical4j.vcard.property.Lang;
import net.fortuna.ical4j.vcard.property.N;
import net.fortuna.ical4j.vcard.property.Name;
import net.fortuna.ical4j.vcard.property.Note;
import net.fortuna.ical4j.vcard.property.Org;
import net.fortuna.ical4j.vcard.property.Role;
import net.fortuna.ical4j.vcard.property.Telephone;
import net.fortuna.ical4j.vcard.property.Title;
import net.fortuna.ical4j.vcard.property.Url;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsEntryExportVcardTask
extends ImmoToolTask<Long, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryExportVcardTask.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryExportVcardTask.class);
    private final File exportFile;
    private final Charset exportCharset;
    private final Long exportGroupId;
    private final AbstractDbDriver dbDriver;
    private final DbContactsHandler contactsHandler;
    private Connection dbConnection = null;

    public ContactsEntryExportVcardTask(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, File file, Charset charset) {
        this(abstractDbDriver, dbContactsHandler, file, charset, null);
    }

    public ContactsEntryExportVcardTask(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, File file, Charset charset, Long l) {
        super(I18N.tr("Export addresses into a vCard file."));
        this.dbDriver = abstractDbDriver;
        this.contactsHandler = dbContactsHandler;
        this.exportFile = file;
        this.exportCharset = charset;
        this.exportGroupId = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long doInBackground() throws Exception {
        long l = 0L;
        this.dbConnection = null;
        try {
            this.dbConnection = this.getDbDriver().getConnection();
            VCardOutputter vCardOutputter = new VCardOutputter();
            vCardOutputter.setValidating(false);
            for (DbContactsEntry dbContactsEntry : this.loadContacts()) {
                try (FileOutputStream fileOutputStream = new FileOutputStream(this.exportFile, l > 0L);
                     OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.exportCharset);){
                    VCard vCard = new VCard();
                    this.writeContactToVcard(dbContactsEntry, vCard);
                    vCardOutputter.output(vCard, (Writer)outputStreamWriter);
                    ++l;
                }
            }
            Long l2 = l;
            return l2;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)this.dbConnection);
        }
    }

    protected DbContactsHandler getContactsHandler() {
        return this.contactsHandler;
    }

    protected AbstractDbDriver getDbDriver() {
        return this.dbDriver;
    }

    protected DbContactsEntry[] loadContacts() throws SQLException {
        this.setMessage(I18N.tr("Looking up addresses."));
        DbContactsEntry[] dbContactsEntryArray = this.loadContacts(this.dbConnection, this.getContactsHandler());
        this.getContactsHandler().loadEntrySettings(this.dbConnection, dbContactsEntryArray);
        return dbContactsEntryArray;
    }

    protected DbContactsEntry[] loadContacts(Connection connection, DbContactsHandler dbContactsHandler) throws SQLException {
        if (this.exportGroupId != null && this.exportGroupId > 0L) {
            return dbContactsHandler.getGroupEntries(connection, this.exportGroupId);
        }
        return dbContactsHandler.getEntries(connection);
    }

    protected void writeContactToVcard(DbContactsEntry dbContactsEntry, VCard vCard) {
        URI uRI;
        Object object;
        String string;
        Locale[] localeArray;
        String string2 = null;
        String string3 = null;
        String string4 = dbContactsEntry.address.writeStreet();
        String string5 = dbContactsEntry.address.getCity() + " " + dbContactsEntry.address.getDistrict();
        String string6 = dbContactsEntry.address.getRegion();
        String string7 = dbContactsEntry.address.getPostalCode();
        String string8 = dbContactsEntry.address.getCountry();
        vCard.getProperties().add(this.writePropertyParams((Property)new Address(StringUtils.trimToEmpty(string2), StringUtils.trimToEmpty(string3), StringUtils.trimToEmpty((String)string4), StringUtils.trimToEmpty((String)string5), StringUtils.trimToEmpty((String)string6), StringUtils.trimToEmpty((String)string7), StringUtils.trimToEmpty((String)string8), new Type[0])));
        if (dbContactsEntry.birthDay != null) {
            vCard.getProperties().add(this.writePropertyParams((Property)new BDay(new Date(dbContactsEntry.birthDay))));
        }
        String string9 = dbContactsEntry.address.getPersonMail();
        String string10 = dbContactsEntry.address.getCompanyMail();
        if (string9 != null && string9.trim().length() > 0) {
            vCard.getProperties().add(this.writePropertyParams((Property)new Email(Group.HOME, string9)));
        }
        if (string10 != null && string10.trim().length() > 0) {
            vCard.getProperties().add(this.writePropertyParams((Property)new Email(Group.WORK, string10)));
        }
        vCard.getProperties().add(this.writePropertyParams((Property)new Fn(dbContactsEntry.address.writePersonFullName())));
        if (dbContactsEntry.address.isFemale()) {
            vCard.getProperties().add(Gender.FEMALE);
        } else if (dbContactsEntry.address.isMale()) {
            vCard.getProperties().add(Gender.MALE);
        }
        if (dbContactsEntry.address.getLatitude() != null && dbContactsEntry.address.getLongitude() != null) {
            vCard.getProperties().add(this.writePropertyParams((Property)new Geo(dbContactsEntry.address.getLatitude(), dbContactsEntry.address.getLongitude())));
        }
        if ((localeArray = dbContactsEntry.getLanguages()) != null && localeArray.length > 0) {
            vCard.getProperties().add(this.writePropertyParams((Property)new Lang(localeArray)));
        }
        String string11 = dbContactsEntry.address.getPersonLastName();
        String string12 = dbContactsEntry.address.getPersonFirstName() + " " + dbContactsEntry.address.getPersonMiddleName();
        String[] stringArray = null;
        String[] stringArray2 = new String[]{};
        String[] stringArray3 = new String[]{};
        vCard.getProperties().add(this.writePropertyParams((Property)new N(StringUtils.trimToEmpty((String)string11), StringUtils.trimToEmpty((String)string12), stringArray, stringArray2, stringArray3)));
        vCard.getProperties().add(this.writePropertyParams((Property)new Name(dbContactsEntry.address.writePersonFullName())));
        String string13 = dbContactsEntry.notes;
        if (string13 != null && string13.trim().length() > 0) {
            vCard.getProperties().add(this.writePropertyParams((Property)new Note(string13.trim())));
        }
        String string14 = dbContactsEntry.address.getCompanyName();
        String string15 = dbContactsEntry.address.getCompanyNameAddition();
        vCard.getProperties().add(this.writePropertyParams((Property)new Org(Group.WORK, new String[]{StringUtils.trimToEmpty((String)string14), StringUtils.trimToEmpty((String)string15)})));
        String string16 = dbContactsEntry.address.getCompanyPosition();
        if (string16 != null && string16.trim().length() > 0) {
            vCard.getProperties().add(this.writePropertyParams((Property)new Role(string16.trim())));
        }
        if ((string = dbContactsEntry.address.getPersonPhone()) != null && string.trim().length() > 0) {
            try {
                object = new Telephone(Group.HOME, new ArrayList(), string);
                object.getParameters().add(Type.PREF);
                vCard.getProperties().add(this.writePropertyParams((Property)object));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't write phone-nr");
                LOGGER.warn("> " + string);
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if ((string = dbContactsEntry.address.getPersonMobilePhone()) != null && string.trim().length() > 0) {
            try {
                object = new Telephone(Group.HOME, new ArrayList(), string);
                object.getParameters().add(new Type("CELL"));
                vCard.getProperties().add(this.writePropertyParams((Property)object));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't write phone-nr");
                LOGGER.warn("> " + string);
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if ((string = dbContactsEntry.address.getPersonFax()) != null && string.trim().length() > 0) {
            try {
                object = new Telephone(Group.HOME, new ArrayList(), string);
                object.getParameters().add(new Type("FAX"));
                vCard.getProperties().add(this.writePropertyParams((Property)object));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't write phone-nr");
                LOGGER.warn("> " + string);
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if ((string = dbContactsEntry.address.getCompanyPhone()) != null && string.trim().length() > 0) {
            try {
                object = new Telephone(Group.WORK, new ArrayList(), string);
                object.getParameters().add(Type.PREF);
                vCard.getProperties().add(this.writePropertyParams((Property)object));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't write phone-nr");
                LOGGER.warn("> " + string);
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if ((string = dbContactsEntry.address.getCompanyMobilePhone()) != null && string.trim().length() > 0) {
            try {
                object = new Telephone(Group.WORK, new ArrayList(), string);
                object.getParameters().add(new Type("CELL"));
                vCard.getProperties().add(this.writePropertyParams((Property)object));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't write phone-nr");
                LOGGER.warn("> " + string);
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if ((string = dbContactsEntry.address.getCompanyFax()) != null && string.trim().length() > 0) {
            try {
                object = new Telephone(Group.WORK, new ArrayList(), string);
                object.getParameters().add(new Type("FAX"));
                vCard.getProperties().add(this.writePropertyParams((Property)object));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't write phone-nr");
                LOGGER.warn("> " + string);
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if ((object = dbContactsEntry.address.getPersonTitle()) != null && ((String)object).trim().length() > 0) {
            vCard.getProperties().add(this.writePropertyParams((Property)new Title(((String)object).trim())));
        }
        if ((uRI = dbContactsEntry.address.getCompanyWebsite()) != null && StringUtils.isNotBlank((CharSequence)uRI.getHost())) {
            vCard.getProperties().add(this.writePropertyParams((Property)new Url(uRI)));
        }
    }

    private Property writePropertyParams(Property property) {
        property.getParameters().add(new Encoding(this.exportCharset.name()));
        return property;
    }
}

