/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolFrame;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolProjectPlugin;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsBulkLetterDialog;
import com.openindex.openestate.tool.contacts.ContactsEntryExportCsvTask;
import com.openindex.openestate.tool.contacts.ContactsEntryExportDialog;
import com.openindex.openestate.tool.contacts.ContactsEntryExportVcardTask;
import com.openindex.openestate.tool.contacts.ContactsEntryExportXlsTask;
import com.openindex.openestate.tool.contacts.ContactsEntryImportCsvTask;
import com.openindex.openestate.tool.contacts.ContactsEntryImportVCardTask;
import com.openindex.openestate.tool.contacts.ContactsEntryTablePanel;
import com.openindex.openestate.tool.contacts.ContactsEntryViewPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryViewTask;
import com.openindex.openestate.tool.contacts.ContactsFrameSidebarExtension;
import com.openindex.openestate.tool.contacts.ContactsGroupDialog;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.extensions.DbContactsExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUpdateHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.utils.CsvImportDialog;
import com.openindex.openestate.tool.utils.CsvImportTask;
import com.openindex.openestate.tool.utils.ProjectPermission;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class ContactsPlugin
extends ImmoToolProjectPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsPlugin.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsPlugin.class);
    public static final String ID = "OpenEstate-Tool-Contacts";
    public static final String RESOURCE_PATH = "/com/openindex/openestate/tool/contacts/resources/";
    private static File lastExportLocation = null;
    private static DbContactsExtension dbContactsExtension = null;

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public static DbContactsExtension getDbContactsExtension() {
        return dbContactsExtension;
    }

    public String getDescription() {
        return I18N.tr("Management of contacts within an addressbook.");
    }

    public ImageIcon getIcon() {
        return new ImageIcon(ContactsPlugin.getResourceImage("vcard.png", 32));
    }

    public String getId() {
        return ID;
    }

    public static ContactsPlugin getInstance() {
        return (ContactsPlugin)ImmoToolEnvironment.getPlugin((String)ID);
    }

    public static File getLastExportLocation() {
        return lastExportLocation;
    }

    public String getLicense() {
        return "Freeware";
    }

    public ProjectPermission[] getPermissions() {
        return ContactsPermission.values();
    }

    public String[] getRequiredProcedures() {
        return dbContactsExtension != null ? dbContactsExtension.getRequiredProcedures() : null;
    }

    public String[] getRequiredViews() {
        return dbContactsExtension != null ? dbContactsExtension.getRequiredViews() : null;
    }

    public static Icon getResourceIcon(String string, int n) {
        return ImmoToolUtils.getResourceIcon((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)ContactsPlugin.class.getClassLoader());
    }

    public static Image getResourceImage(String string, int n) {
        return ImmoToolUtils.getResourceImage((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)ContactsPlugin.class.getClassLoader());
    }

    public static URL getResourceImageURL(String string, int n) {
        return ImmoToolUtils.getResourceImageURL((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)ContactsPlugin.class.getClassLoader());
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("addressbook"));
    }

    public String getUninstallQuery(String string) throws IOException {
        DbContactsExtension dbContactsExtension = ContactsPluginUtils.getDbContactsExtension(string);
        if (dbContactsExtension == null) {
            throw new IOException("Can't find a DbContactsExtension for driver '" + string + "'!");
        }
        return dbContactsExtension.getUninstallQuery();
    }

    public DbUpdateHandler getUpdateHandler(String string) {
        DbContactsExtension dbContactsExtension = ContactsPluginUtils.getDbContactsExtension(string);
        if (dbContactsExtension == null) {
            LOGGER.warn("Can't find a DbContactsExtension for driver '" + string + "'!");
            return null;
        }
        return dbContactsExtension.getUpdateHandler();
    }

    public void install(Connection connection, DbExtension dbExtension, String string, boolean bl) throws SQLException, IOException {
        DbContactsExtension dbContactsExtension = ContactsPluginUtils.getDbContactsExtension(string);
        if (dbContactsExtension == null) {
            throw new SQLException("Can't find a DbContactsExtension for driver '" + string + "'!");
        }
        dbContactsExtension.install(connection);
        super.install(connection, dbExtension, string, bl);
        if (bl) {
            DbContactsGroup dbContactsGroup = new DbContactsGroup();
            dbContactsGroup.name = I18N.tr("private");
            dbContactsExtension.getContactsHandler().saveGroup(connection, dbContactsGroup);
            dbContactsGroup = new DbContactsGroup();
            dbContactsGroup.name = I18N.tr("business");
            dbContactsExtension.getContactsHandler().saveGroup(connection, dbContactsGroup);
        }
    }

    public boolean isAllowed(ImmoToolProject immoToolProject) {
        return ContactsPlugin.isUserAllowedTo(ContactsPermission.USE_PLUGIN, immoToolProject);
    }

    public boolean isUsable(ImmoToolProject immoToolProject) {
        return super.isUsable(immoToolProject) && this.isAllowed(immoToolProject);
    }

    public static boolean isUserAllowedTo(ContactsPermission contactsPermission) {
        return ContactsPlugin.isUserAllowedTo(contactsPermission, ImmoToolProject.getAppInstance());
    }

    public static boolean isUserAllowedTo(ContactsPermission contactsPermission, ImmoToolProject immoToolProject) {
        if (immoToolProject == null) {
            return false;
        }
        DbUser dbUser = immoToolProject.getUser();
        return dbUser != null ? dbUser.isAllowedTo(ID, (ProjectPermission)contactsPermission) : false;
    }

    public static void loadSettings(ImmoToolProject immoToolProject) throws SQLException, IOException {
    }

    public static void loadSettings(ImmoToolProject immoToolProject, Connection connection) throws SQLException, IOException {
    }

    public void repair(Connection connection, AbstractDbDriver abstractDbDriver) throws SQLException {
        ContactsPlugin.getDbContactsExtension().repair(connection, abstractDbDriver);
    }

    public static void saveSettings(ImmoToolProject immoToolProject) throws SQLException, IOException {
    }

    public static void saveSettings(ImmoToolProject immoToolProject, Connection connection) throws SQLException, IOException {
    }

    public static void setDbContactsExtension(DbContactsExtension dbContactsExtension) {
        ContactsPlugin.dbContactsExtension = dbContactsExtension;
    }

    public static synchronized void setLastExportLocation(File file) {
        lastExportLocation = file;
    }

    public static void unloadSettings() {
    }

    public static final class SidebarSelectAction
    extends AbstractI18nAction {
        public SidebarSelectAction() {
            this.setSmallIcon(ContactsPlugin.getResourceIcon("vcard.png", 16));
            this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolFrame immoToolFrame = (ImmoToolFrame)ImmoToolApp.getInstance().getFrame();
            if (immoToolFrame != null) {
                immoToolFrame.selectSidebar(ContactsFrameSidebarExtension.class);
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show address view")));
            this.setShortDescription(I18N.tr("Show address view in the sidebar."));
        }
    }

    private static final class SidebarRefreshTask
    extends ImmoToolTask<TreeModel, Void> {
        private final ContactsFrameSidebarExtension.Tree tree;

        public SidebarRefreshTask(ContactsFrameSidebarExtension.Tree tree) {
            this.tree = tree;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TreeModel doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                TreeModel treeModel = ContactsFrameSidebarExtension.createTreeModel(immoToolProject, connection, dbContactsHandler);
                return treeModel;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't refresh sidebar!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(TreeModel treeModel) {
            super.succeeded((Object)treeModel);
            if (treeModel == null) {
                return;
            }
            this.tree.setModel(treeModel);
            this.tree.expandAll();
        }
    }

    public static final class SidebarRefreshAction
    extends AbstractI18nAction {
        public SidebarRefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsFrameSidebarExtension.Tree tree = ContactsFrameSidebarExtension.getCurrentSidebarTree();
            if (tree != null) {
                ImmoToolUtils.executeTask((ImmoToolTask)new SidebarRefreshTask(tree));
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Refresh contacts view in the sidebar."));
        }
    }

    private static final class GroupRemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long groupId;

        public GroupRemoveTask(long l) {
            this.groupId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                DbContactsGroup dbContactsGroup = dbContactsHandler.getGroup(connection, this.groupId);
                if (dbContactsGroup == null) {
                    throw new Exception("Can't find group #" + this.groupId);
                }
                dbContactsExtension.getContactsHandler().removeGroup(connection, dbContactsGroup.id);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't remove address group!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            ContactsFrameSidebarExtension.Tree tree = ContactsFrameSidebarExtension.getCurrentSidebarTree();
            if (tree != null) {
                tree.removeGroup(this.groupId);
            }
        }
    }

    public static final class GroupRemoveAction
    extends AbstractI18nAction {
        private final long groupId;

        public GroupRemoveAction(long l) {
            this.groupId = l;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.GROUPS_REMOVE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.groupId < 1L) {
                return;
            }
            boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove address group {0}?", (Object)("#" + this.groupId)), (Component)ImmoToolEnvironment.getFrame());
            if (bl) {
                ImmoToolUtils.executeTask((ImmoToolTask)new GroupRemoveTask(this.groupId));
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove group")));
            this.setShortDescription(I18N.tr("Remove the selected address group."));
        }
    }

    private static final class GroupDialogTask
    extends ImmoToolTask<Boolean, Void> {
        private final long groupId;
        private DbContactsGroup group = null;

        public GroupDialogTask(long l) {
            this.groupId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            this.group = ContactsGroupDialog.showDialog(this.groupId, immoToolProject, (Window)ImmoToolEnvironment.getFrame());
            if (this.group == null) {
                return false;
            }
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbContactsExtension.getContactsHandler().saveGroup(connection, this.group);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load form for address group!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            ContactsFrameSidebarExtension.Tree tree = ContactsFrameSidebarExtension.getCurrentSidebarTree();
            if (this.group != null && tree != null) {
                tree.putGroup(this.group);
            }
        }
    }

    public static final class GroupDialogAction
    extends AbstractI18nAction {
        private final long groupId;

        public GroupDialogAction() {
            this(0L);
        }

        public GroupDialogAction(long l) {
            this.groupId = l;
            if (l < 1L) {
                this.setSmallIcon(ContactsPlugin.getResourceIcon("edit_group.png", 16));
                this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.GROUPS_EDIT));
            } else {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
                this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.GROUPS_EDIT));
            }
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new GroupDialogTask(this.groupId));
        }

        protected final void updateLocalization() {
            if (this.groupId < 1L) {
                this.setName(StringUtils.capitalize((String)I18N.tr("add group")));
                this.setShortDescription(I18N.tr("Add a new group."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("edit group")));
                this.setShortDescription(I18N.tr("Show details about the address group."));
            }
        }
    }

    private static final class EntryTableTask
    extends ImmoToolTask<ContactsEntryTablePanel, Void> {
        private final long groupId;
        private final boolean asNewTab;

        public EntryTableTask(long l, boolean bl) {
            this.groupId = l;
            this.asNewTab = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ContactsEntryTablePanel doInBackground() throws Exception {
            DbContactsGroup dbContactsGroup;
            Connection connection;
            block5: {
                ContactsEntryTablePanel contactsEntryTablePanel;
                ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
                DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
                connection = null;
                try {
                    AbstractMainTab abstractMainTab;
                    dbContactsGroup = null;
                    if (this.groupId > 0L && (dbContactsGroup = dbContactsHandler.getGroup(connection = immoToolProject.getDbConnection(), this.groupId)) == null) {
                        throw new Exception("Can't find group #" + this.groupId + "!");
                    }
                    AbstractMainTab abstractMainTab2 = abstractMainTab = !this.asNewTab ? ImmoToolAppUtils.getMatchingTab(ContactsEntryTablePanel.class) : null;
                    if (abstractMainTab == null || !ContactsEntryTablePanel.class.isInstance(abstractMainTab)) break block5;
                    ContactsEntryTablePanel contactsEntryTablePanel2 = (ContactsEntryTablePanel)abstractMainTab;
                    if (dbContactsGroup == null && contactsEntryTablePanel2.getCurrentGroupId() > 0L || dbContactsGroup != null && contactsEntryTablePanel2.getCurrentGroupId() != dbContactsGroup.id) {
                        contactsEntryTablePanel2.setGroup(dbContactsGroup);
                        contactsEntryTablePanel2.loadInBackground(immoToolProject.getDbDriver());
                    }
                    ImmoToolAppUtils.selectTab((Component)((Object)contactsEntryTablePanel2));
                    contactsEntryTablePanel = null;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(connection);
                    throw throwable;
                }
                JdbcUtils.closeQuietly((Connection)connection);
                return contactsEntryTablePanel;
            }
            ContactsEntryTablePanel contactsEntryTablePanel = ContactsEntryTablePanel.createTab(dbContactsGroup);
            JdbcUtils.closeQuietly((Connection)connection);
            return contactsEntryTablePanel;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load table!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(ContactsEntryTablePanel contactsEntryTablePanel) {
            super.succeeded((Object)contactsEntryTablePanel);
            if (contactsEntryTablePanel != null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)contactsEntryTablePanel);
                contactsEntryTablePanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
            }
        }
    }

    public static final class EntryTableAction
    extends AbstractI18nAction {
        private final long groupId;
        private final boolean asNewTab;

        public EntryTableAction() {
            this(0L, false);
        }

        public EntryTableAction(long l) {
            this(l, false);
        }

        public EntryTableAction(boolean bl) {
            this(0L, bl);
        }

        public EntryTableAction(long l, boolean bl) {
            this.groupId = l;
            this.asNewTab = bl;
            this.setSmallIcon(ContactsPlugin.getResourceIcon("edit_user.png", 16));
            this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new EntryTableTask(this.groupId, this.asNewTab));
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show addresses")));
            this.setShortDescription(I18N.tr("Show a table of addressbook entries."));
        }
    }

    public static final class EntryImportFromVcardAction
    extends AbstractI18nAction {
        public EntryImportFromVcardAction() {
            this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_IMPORT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(I18N.tr("Please select a vCard file for import."));
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".vcf") || file.getName().toLowerCase().endsWith(".vcard");
                }

                @Override
                public String getDescription() {
                    return I18N.tr("vCard file") + " (*.vcf, *.vcard)";
                }
            });
            int n = jFileChooser.showOpenDialog((Component)ImmoToolEnvironment.getFrame());
            if (n != 0) {
                return;
            }
            ContactsEntryImportVCardTask contactsEntryImportVCardTask = new ContactsEntryImportVCardTask(immoToolProject.getDbDriver(), ContactsPlugin.getDbContactsExtension().getContactsHandler(), jFileChooser.getSelectedFile());
            ImmoToolTaskDialog.showDialog((ImmoToolTask)contactsEntryImportVCardTask, (Window)ImmoToolEnvironment.getFrame());
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("import from vCard")));
            this.setShortDescription(I18N.tr("Import addresses from a vCard file."));
        }
    }

    public static final class EntryImportFromCsvAction
    extends AbstractI18nAction {
        public EntryImportFromCsvAction() {
            this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_IMPORT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(I18N.tr("Please select a CSV file for import."));
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".csv") || file.getName().toLowerCase().endsWith(".txt");
                }

                @Override
                public String getDescription() {
                    return I18N.tr("CSV table") + " (*.csv, *.txt)";
                }
            });
            int n = jFileChooser.showOpenDialog((Component)ImmoToolEnvironment.getFrame());
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            ContactsEntryImportCsvTask contactsEntryImportCsvTask = new ContactsEntryImportCsvTask(immoToolProject.getDbDriver(), ContactsPlugin.getDbContactsExtension().getContactsHandler(), file);
            try {
                if (!CsvImportDialog.showDialog((File)file, (CsvImportTask)contactsEntryImportCsvTask, (Window)ImmoToolEnvironment.getFrame())) {
                    return;
                }
            }
            catch (Exception exception) {
                LOGGER.error("Can't read CSV file!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't read CSV file!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
                return;
            }
            ImmoToolTaskDialog.showDialog((ImmoToolTask)contactsEntryImportCsvTask, (Window)ImmoToolEnvironment.getFrame());
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("import from CSV")));
            this.setShortDescription(I18N.tr("Import addresses from a CSV table."));
        }
    }

    public static final class EntryFormAction
    extends AbstractI18nAction {
        private final long entryId;

        public EntryFormAction() {
            this(0L);
        }

        public EntryFormAction(long l) {
            this.entryId = l;
            if (l < 1L) {
                this.setSmallIcon(ContactsPlugin.getResourceIcon("edit_user.png", 16));
                this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EDIT));
            } else {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
                this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.USE_PLUGIN));
            }
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractMainTab[] abstractMainTabArray;
            for (AbstractMainTab abstractMainTab : abstractMainTabArray = ImmoToolAppUtils.getTabs(ContactsEntryViewPanel.class)) {
                ContactsEntryViewPanel contactsEntryViewPanel = (ContactsEntryViewPanel)abstractMainTab;
                if (this.entryId < 1L && contactsEntryViewPanel.getCurrentEntryId() < 1L) {
                    ImmoToolAppUtils.selectTab((Component)((Object)contactsEntryViewPanel));
                    return;
                }
                if (this.entryId <= 0L || contactsEntryViewPanel.getCurrentEntryId() != this.entryId) continue;
                ImmoToolAppUtils.selectTab((Component)((Object)contactsEntryViewPanel));
                return;
            }
            ImmoToolUtils.executeTask((ImmoToolTask)new ContactsEntryViewTask(ImmoToolProject.getAppInstance().getDbDriver(), this.entryId));
        }

        protected final void updateLocalization() {
            if (this.entryId < 1L) {
                this.setName(StringUtils.capitalize((String)I18N.tr("add address")));
                this.setShortDescription(I18N.tr("Add a new addressbook entry."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("show address")));
                this.setShortDescription(I18N.tr("Show details about the addressbook entry."));
            }
        }
    }

    private static final class EntryExportToXlsTask
    extends ContactsEntryExportXlsTask {
        public EntryExportToXlsTask(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, File file, ContactsEntryExportDialog.ExportSettings exportSettings) {
            super(abstractDbDriver, dbContactsHandler, file, exportSettings.charset, exportSettings.getGroupId());
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't export addresses!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Long l) {
            super.succeeded((Object)l);
            ImmoToolUtils.showMessageInfoDialog((String)I18N.tr("The addresses were successfully exported."), (Component)ImmoToolEnvironment.getFrame());
        }
    }

    private static final class EntryExportToVcardTask
    extends ContactsEntryExportVcardTask {
        public EntryExportToVcardTask(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, File file, ContactsEntryExportDialog.ExportSettings exportSettings) {
            super(abstractDbDriver, dbContactsHandler, file, exportSettings.charset, exportSettings.getGroupId());
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't export addresses!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Long l) {
            super.succeeded((Object)l);
            ImmoToolUtils.showMessageInfoDialog((String)I18N.tr("The addresses were successfully exported."), (Component)ImmoToolEnvironment.getFrame());
        }
    }

    private static final class EntryExportToCsvTask
    extends ContactsEntryExportCsvTask {
        public EntryExportToCsvTask(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, File file, ContactsEntryExportDialog.ExportSettings exportSettings) {
            super(abstractDbDriver, dbContactsHandler, file, exportSettings.charset, exportSettings.getGroupId());
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't export addresses!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Long l) {
            super.succeeded((Object)l);
            ImmoToolUtils.showMessageInfoDialog((String)I18N.tr("The addresses were successfully exported."), (Component)ImmoToolEnvironment.getFrame());
        }
    }

    private static final class EntryExportTask
    extends ImmoToolTask<ContactsEntryExportDialog.ExportSettings, Void> {
        private final ImmoToolProject project = ImmoToolProject.getAppInstance();
        private final DbContactsHandler contactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();

        protected ContactsEntryExportDialog.ExportSettings doInBackground() throws Exception {
            return ContactsEntryExportDialog.showDialog(this.project.getDbDriver(), this.contactsHandler, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load export dialog!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(ContactsEntryExportDialog.ExportSettings exportSettings) {
            Object object;
            super.succeeded((Object)exportSettings);
            if (exportSettings == null) {
                return;
            }
            if (exportSettings.format == null) {
                LOGGER.error("Empty export format!");
                return;
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(I18N.tr("Where do you want to save the exported file?"));
            if (lastExportLocation == null) {
                jFileChooser.setSelectedFile(new File(exportSettings.getDefaultFileName()));
            } else {
                jFileChooser.setSelectedFile(new File(lastExportLocation, exportSettings.getDefaultFileName()));
            }
            jFileChooser.setFileFilter(exportSettings.getFileFilter());
            int n = jFileChooser.showSaveDialog((Component)ImmoToolEnvironment.getFrame());
            if (n != 0) {
                return;
            }
            if (ContactsEntryExportDialog.Format.CSV.equals((Object)exportSettings.format)) {
                object = new EntryExportToCsvTask(this.project.getDbDriver(), this.contactsHandler, jFileChooser.getSelectedFile(), exportSettings);
            } else if (ContactsEntryExportDialog.Format.XLS.equals((Object)exportSettings.format)) {
                object = new EntryExportToXlsTask(this.project.getDbDriver(), this.contactsHandler, jFileChooser.getSelectedFile(), exportSettings);
            } else if (ContactsEntryExportDialog.Format.VCARD.equals((Object)exportSettings.format)) {
                object = new EntryExportToVcardTask(this.project.getDbDriver(), this.contactsHandler, jFileChooser.getSelectedFile(), exportSettings);
            } else {
                LOGGER.warn("Unknown format '" + (Object)((Object)exportSettings.format) + "' for address export!");
                ImmoToolUtils.showMessageErrorDialog((String)("Unknown format '" + (Object)((Object)exportSettings.format) + "' for address export!"), (Component)ImmoToolEnvironment.getFrame());
                return;
            }
            ImmoToolUtils.executeTask((ImmoToolTask)object);
        }
    }

    public static final class EntryExportAction
    extends AbstractI18nAction {
        public EntryExportAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16));
            this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EXPORT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new EntryExportTask());
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("save addresses")));
            this.setShortDescription(I18N.tr("Save addressbook entries to harddisk."));
        }
    }

    public static final class BulkLetterDialogAction
    extends AbstractI18nAction {
        public BulkLetterDialogAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"wizard.png", (int)16));
            this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsBulkLetterDialog.showDialog((Window)ImmoToolEnvironment.getFrame());
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("create bulk letter")));
            this.setShortDescription(I18N.tr("Start the wizard to create a new bulk letter."));
        }
    }
}

