/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntryLogHandler;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.db.DbContactsUpdateListener;
import com.openindex.openestate.tool.contacts.db.hsql.HSqlDbContactsEntryLogHandler;
import com.openindex.openestate.tool.contacts.db.hsql.HSqlDbContactsHandler;
import com.openindex.openestate.tool.contacts.extensions.DbContactsAdapter;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.AbstractDbUpdateListener;
import com.openindex.openestate.tool.db.DbUpdateHandler;
import com.openindex.openestate.tool.db.DbUpdateHandlerImpl;
import com.openindex.openestate.tool.db.hsql.HSqlDbUpdateHandler;
import com.openindex.openestate.tool.db.hsql.HSqlUtils;
import com.openindex.openestate.tool.extensions.DbExtension;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbContactsExtension
extends DbContactsAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbContactsExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbContactsExtension.class);
    public static final String RESOURCE_PATH = "/com/openindex/openestate/tool/contacts/db/hsql/resources/";
    private static final DbContactsEntryLogHandler CONTACTS_ENTRY_LOG_HANDLER = new HSqlDbContactsEntryLogHandler();
    private static final DbContactsHandler CONTACTS_HANDLER = new HSqlDbContactsHandler();

    @Override
    public DbContactsEntryLogHandler getContactsEntryLogHandler() {
        return CONTACTS_ENTRY_LOG_HANDLER;
    }

    @Override
    public DbContactsHandler getContactsHandler() {
        return CONTACTS_HANDLER;
    }

    @Override
    public final String[] getRequiredProcedures() {
        return new String[]{"remove_immotool_logs", "remove_immotool_logs_changes", "save_immotool_contacts_entries_logs", "save_immotool_logs", "save_immotool_logs_changes", "remove_immotool_contacts_entries", "remove_immotool_contacts_entries_address", "remove_immotool_contacts_entries_settings", "remove_immotool_contacts_groups", "save_immotool_contacts_entries", "save_immotool_contacts_entries_settings", "save_immotool_contacts_groups", "set_immotool_contacts_entries_active", "set_immotool_contacts_entries_group"};
    }

    @Override
    public final String[] getRequiredViews() {
        return new String[]{"view_immotool_contacts_entries_logs", "view_immotool_logs_changes", "view_immotool_contacts_entries", "view_immotool_contacts_entries_files", "view_immotool_contacts_entries_files_content", "view_immotool_contacts_entries_settings", "view_immotool_contacts_groups"};
    }

    @Override
    public String[] getSupportedDrivers() {
        return new String[]{"HSQL.local", "HSQL.remote"};
    }

    @Override
    public String getUninstallQuery() throws IOException {
        return HSqlDbContactsExtension.readHsqlQuery("uninstall.sql");
    }

    @Override
    public DbUpdateHandler getUpdateHandler() {
        String string = null;
        try {
            string = this.getUninstallQuery();
        }
        catch (IOException iOException) {
            LOGGER.warn("Can't load uninstall query!");
            LOGGER.warn("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        return new ContactsUpdateHandler(string, new DbContactsUpdateListener());
    }

    @Override
    public void install(Connection connection) throws IOException, SQLException {
        Statement statement = null;
        SqlFile sqlFile = null;
        try {
            statement = connection.createStatement();
            sqlFile = HSqlDbContactsExtension.readHsqlFile("schema.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            sqlFile = HSqlDbContactsExtension.readHsqlFile("routines.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            statement.execute("CHECKPOINT;");
        }
        catch (SqlToolError sqlToolError) {
            sqlFile.closeReader();
            connection.rollback();
            LOGGER.error("Can't execute schema!");
            LOGGER.error("> " + sqlToolError.getLocalizedMessage(), (Throwable)sqlToolError);
            throw new SQLException("Can't execute schema!");
        }
        catch (SQLException sQLException) {
            if (sqlFile != null) {
                sqlFile.closeReader();
            }
            connection.rollback();
            throw sQLException;
        }
        finally {
            JdbcUtils.closeQuietly((Statement)statement);
        }
    }

    private static SqlFile readHsqlFile(String string) throws IOException {
        return HSqlUtils.readHSqlFile((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbContactsExtension.class.getClassLoader());
    }

    private static String readHsqlQuery(String string) throws IOException {
        return HSqlUtils.readHSqlQuery((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbContactsExtension.class.getClassLoader());
    }

    @Override
    public void repair(Connection connection, AbstractDbDriver abstractDbDriver) throws SQLException {
        super.repair(connection, abstractDbDriver);
        HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_contacts_groups");
        HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_contacts_groups");
    }

    private static final class ContactsUpdateHandler
    extends HSqlDbUpdateHandler {
        public ContactsUpdateHandler(String string, AbstractDbUpdateListener abstractDbUpdateListener) {
            super("OpenEstate-Tool-Contacts", DbUpdateHandlerImpl.Type.PLUGIN, ContactsPlugin.getInstance().getApiVersion(), string, HSqlDbContactsExtension.RESOURCE_PATH, ContactsPlugin.class.getClassLoader(), abstractDbUpdateListener);
        }

        public void updateFinished(Connection connection, AbstractDbDriver abstractDbDriver, DbExtension dbExtension, long l, long l2) throws SQLException, IOException {
            super.updateFinished(connection, abstractDbDriver, dbExtension, l, l2);
            if (l < 8L) {
                HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_contacts_groups");
            }
            if (l < 8L) {
                HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_contacts_groups");
            }
        }
    }
}

