/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolLogTablePanel;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntryAddressPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryExportVcardTask;
import com.openindex.openestate.tool.contacts.ContactsEntryViewDetailsPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryViewTask;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsEntryLog;
import com.openindex.openestate.tool.contacts.db.DbContactsEntryLogHandler;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.extensions.EntryViewExtension;
import com.openindex.openestate.tool.contacts.gui.GroupRenderer;
import com.openindex.openestate.tool.contacts.gui.StatusRenderer;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbLogHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainView;
import com.openindex.openestate.tool.gui.AbstractMainViewTab;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.gui.FlowPanel;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.utils.StatusNotification;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class ContactsEntryViewPanel
extends AbstractMainView {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryViewPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryViewPanel.class);
    private DbContactsEntry currentEntry = null;
    private long nextEntryId = 0L;
    private long prevEntryId = 0L;
    private boolean mayEditEntry = false;
    private boolean mayRemoveEntry = false;
    private List<EntryViewExtension> addons;
    private AddressPanel addressPanel;
    private ContactsEntryViewDetailsPanel detailsPanel;
    private ProtocolPanel protocolPanel;
    private NotesPanel notesPanel;
    private AbstractI18nAction submitAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;
    private AbstractI18nAction viewNextAction;
    private AbstractI18nAction viewPrevAction;

    private ContactsEntryViewPanel() {
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = this.createDefaultSubmitAction(ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EDIT));
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.viewNextAction = this.createDefaultViewNextAction();
        this.viewPrevAction = this.createDefaultViewPreviousAction();
        this.showActionsAction = this.createDefaultShowActionsAction(ContactsPlugin.getResourceIcon("edit_user.png", 16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewPrevAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewNextAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.submitAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected void buildMainComponentTabs(JTabbedPane jTabbedPane) {
        this.addressPanel = (AddressPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new AddressPanel(), (JTabbedPane)jTabbedPane);
        this.detailsPanel = (ContactsEntryViewDetailsPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new ContactsEntryViewDetailsPanel(this.addressPanel.addressPanel), (JTabbedPane)jTabbedPane);
        try {
            for (EntryViewExtension entryViewExtension : this.addons) {
                AbstractTab[] abstractTabArray = entryViewExtension.createTabs();
                if (ArrayUtils.isEmpty((Object[])abstractTabArray)) continue;
                for (AbstractTab abstractTab : abstractTabArray) {
                    ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)abstractTab, (JTabbedPane)jTabbedPane);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load addon-panels!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        this.protocolPanel = (ProtocolPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new ProtocolPanel(this.addons), (JTabbedPane)jTabbedPane);
        this.notesPanel = (NotesPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new NotesPanel(), (JTabbedPane)jTabbedPane);
    }

    public static ContactsEntryViewPanel createTab() {
        return ContactsEntryViewPanel.createTab(new DbContactsEntry());
    }

    public static ContactsEntryViewPanel createTab(DbContactsEntry dbContactsEntry) {
        ContactsEntryViewPanel contactsEntryViewPanel = new ContactsEntryViewPanel();
        contactsEntryViewPanel.setEntry(dbContactsEntry);
        return contactsEntryViewPanel;
    }

    protected void doCopy() {
        if (!this.mayEditEntry) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), true));
    }

    protected void doHelp() {
        ImmoToolAppUtils.showManual((String)"contacts.entries.form", null);
    }

    protected void doLoadInBackground(Connection connection) throws Exception {
        Object object;
        DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        DbContactsGroup dbContactsGroup = dbContactsHandler.getGroup(connection, this.currentEntry.groupId);
        if (dbContactsGroup == null) {
            LOGGER.warn("Can't find address group for entry #" + this.currentEntry.id + "!");
        } else if (dbContactsGroup.permission != null) {
            object = ImmoToolProject.getAppUser();
            this.mayEditEntry = this.mayEditEntry && dbContactsGroup.permission.canWrite(object, dbContactsGroup.ownerUserId, dbContactsGroup.ownerGroupId);
            this.mayRemoveEntry = this.mayRemoveEntry && dbContactsGroup.permission.canWrite(object, dbContactsGroup.ownerUserId, dbContactsGroup.ownerGroupId);
        }
        this.nextEntryId = 0L;
        this.prevEntryId = 0L;
        try {
            object = dbContactsHandler.getEntryIds(connection);
            int n = ArrayUtils.indexOf((long[])object, (long)this.currentEntry.id);
            if (n > 0) {
                this.prevEntryId = (long)object[n - 1];
            }
            if (n + 1 < ((DbUser)object).length) {
                this.nextEntryId = (long)object[n + 1];
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load previous & next dataset!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private void doEntrySaveVcard() {
        if (this.currentEntry == null || this.currentEntry.id < 1L) {
            return;
        }
        File file = ContactsPlugin.getLastExportLocation();
        JFileChooser jFileChooser = new JFileChooser();
        String string = I18N.tr("address") + "-" + System.currentTimeMillis() + ".vcf";
        jFileChooser.setSelectedFile(new File(file == null ? string : file.getAbsolutePath() + File.separator + string));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".vcf") || file.getName().toLowerCase().endsWith(".vcard");
            }

            @Override
            public String getDescription() {
                return I18N.tr("vCard files") + " (*.vcf, *.vcard)";
            }
        });
        int n = jFileChooser.showSaveDialog((Component)((Object)this));
        if (n != 0) {
            return;
        }
        File file2 = jFileChooser.getSelectedFile();
        ContactsPlugin.setLastExportLocation(file2.getAbsoluteFile().getParentFile());
        DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        ImmoToolUtils.executeTask((ImmoToolTask)new EntrySaveVcardTask(ImmoToolProject.getAppDbDriver(), dbContactsHandler, file2));
    }

    public void doRefresh() {
        if (this.currentEntry != null && this.currentEntry.id > 0L) {
            this.setEntry(this.currentEntry);
            this.loadInBackground(ImmoToolProject.getAppDbDriver());
        }
    }

    protected void doRemove() {
        if (this.currentEntry == null || this.currentEntry.id < 1L) {
            return;
        }
        if (!this.mayRemoveEntry) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove address {0}?", (Object)("#" + this.currentEntry.id)), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new RemoveTask(this.currentEntry.id));
    }

    protected void doShowActions(Component component, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)this.createDefaultCopyAction(this.currentEntry != null && this.currentEntry.id > 0L && ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EDIT)));
        jPopupMenu.add((Action)this.createDefaultRemoveAction(this.currentEntry != null && this.currentEntry.id > 0L && this.mayRemoveEntry));
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)((Object)new EntrySaveVcardAction()));
        for (EntryViewExtension entryViewExtension : this.addons) {
            Object[] objectArray = entryViewExtension.createActionMenuItems(ImmoToolProject.getAppInstance(), this.currentEntry);
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                jPopupMenu.add((JMenuItem)object);
            }
        }
        jPopupMenu.add((Action)this.notesPanel.notesField.getPrintAction());
        jPopupMenu.show(component, n, n2);
    }

    protected void doSubmit() {
        if (!this.mayEditEntry) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), false));
    }

    protected void doViewNext() {
        if (this.nextEntryId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new ContactsEntryViewTask(ImmoToolProject.getAppDbDriver(), this.nextEntryId, this));
        }
    }

    protected void doViewPrevious() {
        if (this.prevEntryId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new ContactsEntryViewTask(ImmoToolProject.getAppDbDriver(), this.prevEntryId, this));
        }
    }

    public long getCurrentEntryId() {
        return this.currentEntry != null ? this.currentEntry.id : 0L;
    }

    protected Icon getHeaderIcon() {
        return ContactsPlugin.getResourceIcon("edit_user.png", 32);
    }

    protected String getHeaderTitle() {
        if (this.currentEntry == null || this.currentEntry.id < 1L) {
            return StringUtils.capitalize((String)I18N.tr("new address"));
        }
        return StringUtils.capitalize((String)I18N.tr("address")) + " #" + this.currentEntry.id;
    }

    public String getTabTitle() {
        if (this.currentEntry == null || this.currentEntry.id < 1L) {
            return StringUtils.capitalize((String)I18N.tr("new address"));
        }
        return StringUtils.capitalize((String)I18N.tr("address")) + " #" + this.currentEntry.id;
    }

    public String getTabToolTipText() {
        if (this.currentEntry == null || this.currentEntry.id < 1L) {
            return I18N.tr("Create a new addressbook entry.");
        }
        return I18N.tr("Edit address {0}.", (Object)("#" + this.currentEntry.id));
    }

    protected void init() {
        super.init();
        this.addons = new ArrayList<EntryViewExtension>();
        try {
            this.addons.addAll(ContactsPluginUtils.getEntryViewExtensions());
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load addons!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    protected boolean isLoadedInBackground() {
        return this.currentEntry != null && this.currentEntry.id > 0L;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.submitAction.setEnabled(bl && this.mayEditEntry);
        this.closeAction.setEnabled(bl);
        this.helpAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl);
        this.viewNextAction.setEnabled(bl && this.nextEntryId > 0L);
        this.viewPrevAction.setEnabled(bl && this.prevEntryId > 0L);
    }

    public synchronized void setEntry(DbContactsEntry dbContactsEntry) {
        this.currentEntry = dbContactsEntry;
        this.nextEntryId = 0L;
        this.prevEntryId = 0L;
        this.mayEditEntry = ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EDIT);
        this.mayRemoveEntry = ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_REMOVE);
        for (AbstractMainViewTab abstractMainViewTab : this.getTabs()) {
            int n = this.indexOf(abstractMainViewTab);
            if (n < 0) continue;
            this.getTabbedPane().setEnabledAt(n, false);
            try {
                ((AbstractTab)abstractMainViewTab).load(this.currentEntry);
            }
            catch (Exception exception) {
                LOGGER.error("Can't load tab '" + abstractMainViewTab.getTabTitle() + "'!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.updateLocalization();
    }

    protected void tabComponentAdded(ContainerEvent containerEvent) {
        super.tabComponentAdded(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(this);
        }
    }

    protected void tabComponentRemoved(ContainerEvent containerEvent) {
        super.tabComponentRemoved(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(null);
        }
    }

    private class SubmitTask
    extends ImmoToolTask<DbContactsEntry, Void> {
        private final AbstractMainViewTab[] tabs;
        private final boolean saveAsCopy;
        private final List<String> warnings = new ArrayList<String>();

        private SubmitTask(AbstractMainViewTab[] abstractMainViewTabArray, boolean bl) {
            this.tabs = abstractMainViewTabArray;
            this.saveAsCopy = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbContactsEntry doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            DbContactsEntryLogHandler dbContactsEntryLogHandler = ContactsPlugin.getDbContactsExtension().getContactsEntryLogHandler();
            if (immoToolProject == null) {
                throw new Exception("No project was opened!");
            }
            this.warnings.clear();
            Connection connection = null;
            try {
                DbContactsEntry dbContactsEntry;
                String string;
                long l;
                connection = immoToolProject.getDbConnection();
                long l2 = l = ContactsEntryViewPanel.this.currentEntry != null ? ((ContactsEntryViewPanel)ContactsEntryViewPanel.this).currentEntry.id : 0L;
                if (l < 1L || this.saveAsCopy) {
                    string = "ADD";
                    dbContactsEntry = new DbContactsEntry();
                    dbContactsEntry.address = new CompanyAddressImpl();
                    dbContactsEntry.values = new HashMap<String, String>();
                } else {
                    string = "EDIT";
                    dbContactsEntry = dbContactsHandler.getEntry(connection, l);
                    if (dbContactsEntry == null) {
                        throw new Exception("Can't load contact-entry #" + l + "!");
                    }
                    dbContactsHandler.loadEntrySettings(connection, dbContactsEntry);
                }
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    ((AbstractTab)abstractMainViewTab).saveWarnings.clear();
                    ((AbstractTab)abstractMainViewTab).save(dbContactsEntry);
                }
                dbContactsHandler.saveEntry(connection, dbContactsEntry);
                DbContactsEntryLog dbContactsEntryLog = DbContactsEntryLog.create(dbContactsEntry.id, string, immoToolProject.getUser());
                if ("EDIT".equals(string)) {
                    dbContactsEntryLog.initChanges(ContactsEntryViewPanel.this.currentEntry, dbContactsEntry);
                }
                dbContactsEntryLogHandler.saveLog(connection, dbContactsEntryLog);
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    AbstractTab abstractTab = (AbstractTab)abstractMainViewTab;
                    abstractTab.saveFinished(connection, immoToolProject, dbContactsEntry);
                    if (abstractTab.saveWarnings.isEmpty()) continue;
                    this.warnings.addAll(abstractTab.saveWarnings);
                }
                DbContactsEntry dbContactsEntry2 = dbContactsEntry;
                return dbContactsEntry2;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't save address!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            ContactsEntryViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(DbContactsEntry dbContactsEntry) {
            super.succeeded((Object)dbContactsEntry);
            if (!this.warnings.isEmpty()) {
                for (String string : this.warnings) {
                    ImmoToolEnvironment.showStatusNotification((StatusNotification)new StatusNotification.Warning(string));
                }
            }
            if (dbContactsEntry != null) {
                ContactsEntryViewPanel.this.setEntry(dbContactsEntry);
                ContactsEntryViewPanel.this.loadInBackground(ImmoToolProject.getAppDbDriver());
            }
        }
    }

    private class RemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long entryId;

        private RemoveTask(long l) {
            this.entryId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppDbConnection();
                dbContactsHandler.removeEntry(connection, this.entryId);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't delete address!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            ContactsEntryViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            ImmoToolAppUtils.removeTab((Component)((Object)ContactsEntryViewPanel.this), (boolean)true);
        }
    }

    private class EntrySaveVcardTask
    extends ContactsEntryExportVcardTask {
        private final File destinationFile;

        private EntrySaveVcardTask(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, File file) {
            super(abstractDbDriver, dbContactsHandler, file, Charset.defaultCharset());
            this.destinationFile = file;
        }

        @Override
        protected DbContactsEntry[] loadContacts() {
            return new DbContactsEntry[]{ContactsEntryViewPanel.this.currentEntry};
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't save address into vCard file!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Long l) {
            super.succeeded((Object)l);
            String string = this.destinationFile.getAbsolutePath();
            String string2 = "<html>" + I18N.tr("The address was saved.") + "<br>" + I18N.tr("into file: {0}", (Object)StringUtils.abbreviateMiddle((String)string, (String)"...", (int)75)) + "</html>";
            ImmoToolUtils.showMessageInfoDialog((String)string2, (Component)((Object)ContactsEntryViewPanel.this));
        }
    }

    private class EntrySaveVcardAction
    extends AbstractI18nAction {
        private EntrySaveVcardAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryViewPanel.this.doEntrySaveVcard();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("save as vCard file")));
            this.setShortDescription(I18N.tr("Save the address into a vCard file."));
        }
    }

    private static class ProtocolTablePanel
    extends ImmoToolLogTablePanel {
        private ProtocolTablePanel() {
            super((DbLogHandler)ContactsPlugin.getDbContactsExtension().getContactsEntryLogHandler());
            this.setBorder((Border)Paddings.DIALOG);
        }

        protected String getActionTranslation(String string) {
            String string2 = DbContactsEntryLog.writeAction(string);
            return string2 != null ? string2 : string;
        }
    }

    private final class ProtocolPanel
    extends AbstractTab {
        private JXTitledSeparator title;
        private JTabbedPane protocolTabPanel;
        private List<AbstractTab> addonTabs;
        private ProtocolTablePanel logTablePanel;

        private ProtocolPanel(List<EntryViewExtension> list) {
            this.build(list);
            this.updateLocalization();
        }

        private void build(List<EntryViewExtension> list) {
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.addonTabs = new ArrayList<AbstractTab>();
            this.protocolTabPanel = new JTabbedPane();
            this.protocolTabPanel.addContainerListener(new ContainerListener(){

                @Override
                public void componentAdded(ContainerEvent containerEvent) {
                    ContactsEntryViewPanel.this.tabComponentAdded(containerEvent);
                }

                @Override
                public void componentRemoved(ContainerEvent containerEvent) {
                    ContactsEntryViewPanel.this.tabComponentRemoved(containerEvent);
                }
            });
            for (EntryViewExtension entryViewExtension : list) {
                try {
                    AbstractTab[] abstractTabArray = entryViewExtension.createActionTabs();
                    if (ArrayUtils.isEmpty((Object[])abstractTabArray)) continue;
                    for (AbstractTab abstractTab : abstractTabArray) {
                        ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)abstractTab, (JTabbedPane)this.protocolTabPanel);
                        this.addonTabs.add(abstractTab);
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load addon-tabs");
                    LOGGER.warn("> for " + entryViewExtension.getClass().getName());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            this.logTablePanel = new ProtocolTablePanel();
            this.protocolTabPanel.addTab(this.logTablePanel.getTitle(), (Component)((Object)this.logTablePanel));
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.title, "North");
            this.add(this.protocolTabPanel, "Center");
        }

        public void doLoadInBackground(Connection connection) throws Exception {
            this.logTablePanel.doLoadInBackground(connection);
            for (AbstractTab abstractTab : this.addonTabs) {
                if (!abstractTab.isLoadedInBackground()) continue;
                abstractTab.doLoadInBackground(connection);
            }
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("actions"));
        }

        public boolean isTabEnabled() {
            return this.logTablePanel.isLoaded();
        }

        public boolean isTabUsable() {
            return this.protocolTabPanel.getTabCount() > 0;
        }

        public boolean isTabValid() {
            for (AbstractTab abstractTab : this.addonTabs) {
                if (abstractTab.isTabValid()) continue;
                return false;
            }
            return true;
        }

        public boolean isLoadedInBackground() {
            return true;
        }

        @Override
        public void load(DbContactsEntry dbContactsEntry) throws Exception {
            this.logTablePanel.setLogEntryId(dbContactsEntry != null ? dbContactsEntry.id : 0L);
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.load(dbContactsEntry);
            }
        }

        @Override
        public void save(DbContactsEntry dbContactsEntry) throws Exception {
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.save(dbContactsEntry);
            }
        }

        @Override
        public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbContactsEntry dbContactsEntry) throws SQLException, IOException {
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.saveFinished(connection, immoToolProject, dbContactsEntry);
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("actions for the address")));
        }
    }

    private final class NotesPanel
    extends AbstractTab {
        private ModificationHandler modificationHandler;
        private JXTitledSeparator title;
        private DefaultTextArea notesField;

        private NotesPanel() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.modificationHandler = ImmoToolUtils.createModificationHandler();
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.notesField = new DefaultTextArea();
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.title, "North");
            this.add(this.notesField.createScrollPane(), "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("notes"));
        }

        public boolean isTabModified() {
            return this.modificationHandler.isModified();
        }

        @Override
        public void load(DbContactsEntry dbContactsEntry) {
            this.notesField.setText(dbContactsEntry != null ? StringUtils.trimToEmpty((String)dbContactsEntry.notes) : "");
            this.notesField.setCaretPosition(0);
            this.modificationHandler.clear();
            this.modificationHandler.putValue((JComponent)this.notesField);
        }

        @Override
        public void save(DbContactsEntry dbContactsEntry) {
            dbContactsEntry.notes = this.notesField.getText().trim();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("notes about the address")));
        }
    }

    private final class AddressPanel
    extends AbstractTab {
        private ValidationHandler validationHandler;
        private ModificationHandler modificationHandler;
        private JXTitledSeparator title;
        private JLabel groupLabel;
        private JComboBox<DbContactsGroup> groupBox;
        private JLabel statusLabel;
        private JComboBox<Boolean> statusBox;
        private JLabel addressNrLabel;
        private JTextField addressNrField;
        private JCheckBox contactAllowedBox;
        private ContactsEntryAddressPanel addressPanel;

        private AddressPanel() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.validationHandler = ImmoToolUtils.createValidationHandler();
            this.modificationHandler = ImmoToolUtils.createModificationHandler();
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.groupLabel = new JLabel();
            this.groupBox = new JComboBox();
            this.groupBox.setRenderer((ListCellRenderer<DbContactsGroup>)new DefaultListCellRenderer((Renderer)new GroupRenderer()));
            this.groupBox.addItem(null);
            this.statusLabel = new JLabel();
            this.statusBox = new JComboBox();
            this.statusBox.setRenderer((ListCellRenderer<Boolean>)new DefaultListCellRenderer((Renderer)new StatusRenderer(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("select status") + " ]";
                }
            }));
            this.statusBox.addItem(null);
            this.statusBox.addItem(Boolean.TRUE);
            this.statusBox.addItem(Boolean.FALSE);
            this.addressNrLabel = new JLabel();
            this.addressNrField = new JTextField();
            this.addressNrField.setName("addressNrField");
            this.contactAllowedBox = new JCheckBox();
            this.addressPanel = new ContactsEntryAddressPanel();
            this.validationHandler.putRule(this.groupBox, (ValidationRule)new NonEmptyComboBoxRule(this.groupBox));
            this.validationHandler.putRule(this.statusBox, (ValidationRule)new NonEmptyComboBoxRule(this.statusBox));
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 20dlu:grow, 3dlu, right:pref, 3dlu, pref");
            defaultFormBuilder.add((Component)this.title).xyw(1, defaultFormBuilder.nextRow(), 7);
            defaultFormBuilder.add((Component)this.groupLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.groupBox).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.addressNrLabel).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.addressNrField).xy(7, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)FlowPanel.create((JComponent[])new JComponent[]{this.contactAllowedBox})).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.statusLabel).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add(this.statusBox).xy(7, defaultFormBuilder.row());
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            jPanel.setBorder((Border)Paddings.DIALOG);
            jPanel.add((Component)defaultFormBuilder.getPanel(), "North");
            jPanel.add((Component)((Object)this.addressPanel), "Center");
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(Paddings.EMPTY);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            this.setLayout(new BorderLayout());
            this.setBorder(Paddings.EMPTY);
            this.add(jScrollPane, "Center");
        }

        public void doLoadInBackground(Connection connection) throws Exception {
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            DbUser dbUser = ImmoToolProject.getAppUser();
            final long l = ((ContactsEntryViewPanel)ContactsEntryViewPanel.this).currentEntry.groupId;
            final DefaultComboBoxModel<DbContactsGroup> defaultComboBoxModel = new DefaultComboBoxModel<DbContactsGroup>();
            defaultComboBoxModel.addElement(null);
            for (DbContactsGroup dbContactsGroup : dbContactsHandler.getGroups(connection)) {
                boolean bl = dbContactsGroup.permission.canWrite(dbUser, dbContactsGroup.ownerUserId, dbContactsGroup.ownerGroupId);
                if ((l <= 0L || dbContactsGroup.id != l) && !bl) continue;
                defaultComboBoxModel.addElement(dbContactsGroup);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        AddressPanel.this.groupBox.setModel(defaultComboBoxModel);
                        AddressPanel.this.setContactGroup(l);
                    }
                    catch (Throwable throwable) {
                        AddressPanel.this.groupBox.setEnabled(ContactsEntryViewPanel.this.currentEntry == null || ((ContactsEntryViewPanel)ContactsEntryViewPanel.this).currentEntry.id < 1L || ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EDIT_GROUP));
                        AddressPanel.this.modificationHandler.putValue((JComponent)AddressPanel.this.groupBox);
                        AddressPanel.this.validationHandler.validate();
                        throw throwable;
                    }
                    AddressPanel.this.groupBox.setEnabled(ContactsEntryViewPanel.this.currentEntry == null || ((ContactsEntryViewPanel)ContactsEntryViewPanel.this).currentEntry.id < 1L || ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EDIT_GROUP));
                    AddressPanel.this.modificationHandler.putValue((JComponent)AddressPanel.this.groupBox);
                    AddressPanel.this.validationHandler.validate();
                }
            });
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("address"));
        }

        public boolean isTabModified() {
            return this.modificationHandler.isModified() || this.addressPanel.isModifiedInput();
        }

        public boolean isTabValid() {
            this.validationHandler.validate();
            this.addressPanel.validateInputs();
            return this.validationHandler.isValid() && this.addressPanel.isValidInput();
        }

        public boolean isLoadedInBackground() {
            return true;
        }

        @Override
        public void load(DbContactsEntry dbContactsEntry) {
            this.groupBox.setEnabled(false);
            this.groupBox.setSelectedIndex(-1);
            this.groupBox.removeAllItems();
            this.statusBox.setSelectedItem(dbContactsEntry != null ? Boolean.valueOf(dbContactsEntry.isActive) : null);
            this.addressNrField.setText(dbContactsEntry != null ? StringUtils.trimToEmpty((String)dbContactsEntry.publicId) : "");
            this.contactAllowedBox.setSelected(dbContactsEntry != null && dbContactsEntry.isContactAllowed());
            if (dbContactsEntry != null) {
                this.addressPanel.load(dbContactsEntry);
            }
            this.modificationHandler.clear();
            this.modificationHandler.putValue(this.statusBox);
            this.modificationHandler.putValue((JComponent)this.addressNrField);
            this.modificationHandler.putValue((JComponent)this.contactAllowedBox);
            this.validationHandler.init();
        }

        @Override
        public void save(DbContactsEntry dbContactsEntry) {
            DbContactsGroup dbContactsGroup = (DbContactsGroup)this.groupBox.getSelectedItem();
            dbContactsEntry.groupId = dbContactsGroup != null ? dbContactsGroup.id : 0L;
            dbContactsEntry.isActive = Boolean.TRUE.equals(this.statusBox.getSelectedItem());
            dbContactsEntry.publicId = StringUtils.trimToNull((String)this.addressNrField.getText());
            dbContactsEntry.setContactAllowed(this.contactAllowedBox.isSelected());
            this.addressPanel.save(dbContactsEntry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void setContactGroup(long l) {
            block6: {
                boolean bl = this.groupBox.isEnabled();
                if (bl) {
                    this.groupBox.setEnabled(false);
                }
                try {
                    this.groupBox.setSelectedIndex(0);
                    if (l <= 0L) break block6;
                    for (int i = 1; i < this.groupBox.getItemCount(); ++i) {
                        DbContactsGroup dbContactsGroup = this.groupBox.getItemAt(i);
                        if (dbContactsGroup.id != l) continue;
                        this.groupBox.setSelectedIndex(i);
                        break;
                    }
                }
                finally {
                    if (bl) {
                        this.groupBox.setEnabled(true);
                    }
                }
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("general settings")));
            this.groupLabel.setText(StringUtils.capitalize((String)I18N.tr("group")) + ":");
            this.groupBox.setToolTipText(I18N.tr("Select a group for the address."));
            this.statusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
            this.statusBox.setToolTipText(I18N.tr("Select a status for the address."));
            this.addressNrLabel.setText(StringUtils.capitalize((String)I18N.tr("nr")) + ":");
            this.addressNrField.setToolTipText(I18N.tr("Enter a unique number for the address."));
            this.contactAllowedBox.setText(I18N.tr("Agreement for contacting is available."));
            this.contactAllowedBox.setToolTipText(StringUtils.capitalize((String)I18N.tr("Enable this option, if you are allowed to contact this person.")));
        }
    }

    public static abstract class AbstractTab
    extends AbstractMainViewTab {
        private WeakReference<ContactsEntryViewPanel> viewPanel = null;
        private final List<String> saveWarnings = new ArrayList<String>();

        protected final void addSaveWarning(String string) {
            this.saveWarnings.add(string);
        }

        public ContactsEntryViewPanel getViewPanel() {
            return this.viewPanel != null ? (ContactsEntryViewPanel)((Object)this.viewPanel.get()) : null;
        }

        public abstract void load(DbContactsEntry var1) throws Exception;

        public abstract void save(DbContactsEntry var1) throws Exception;

        public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbContactsEntry dbContactsEntry) throws SQLException, IOException {
        }

        public void setViewPanel(ContactsEntryViewPanel contactsEntryViewPanel) {
            this.viewPanel = contactsEntryViewPanel != null ? new WeakReference<ContactsEntryViewPanel>(contactsEntryViewPanel) : null;
        }
    }
}

