/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons.calendar.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.contacts.addons.calendar.db.DbContactsCalendarHandlerImpl;
import com.openindex.openestate.tool.contacts.addons.calendar.db.DbContactsEntryCalendarEntry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbContactsCalendarHandler
extends DbContactsCalendarHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbContactsCalendarHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbContactsCalendarHandler.class);
    public static final String VIEW_CONTACTS_ENTRIES_CALENDAR_ENTRIES = "view_immotool_contacts_entries_calendar_entries";
    public static final String PROC_REMOVE_CONTACTS_ENTRIES_CALENDAR_ENTRIES = "remove_immotool_contacts_entries_calendar_entries";
    public static final String PROC_SAVE_CONTACTS_ENTRIES_CALENDAR_ENTRIES = "save_immotool_contacts_entries_calendar_entries";
    private static final String FIELD_CONTACTS_ENTRY_ID = "contacts_entry_id";
    private static final String FIELD_CALENDAR_ENTRY_ID = "calendar_entry_id";
    private static final String FIELD_RELATION_TYPE = "relation_type";
    private static final String FIELD_RELATION_NOTES = "relation_notes";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";

    private static DbContactsEntryCalendarEntry createContactsEntryCalendarEntry(ResultSet resultSet) throws SQLException {
        DbContactsEntryCalendarEntry dbContactsEntryCalendarEntry = new DbContactsEntryCalendarEntry();
        dbContactsEntryCalendarEntry.contactsEntryId = resultSet.getLong(FIELD_CONTACTS_ENTRY_ID);
        dbContactsEntryCalendarEntry.calendarEntryId = resultSet.getLong(FIELD_CALENDAR_ENTRY_ID);
        dbContactsEntryCalendarEntry.relationType = resultSet.getString(FIELD_RELATION_TYPE);
        dbContactsEntryCalendarEntry.relationNotes = resultSet.getString(FIELD_RELATION_NOTES);
        dbContactsEntryCalendarEntry.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbContactsEntryCalendarEntry.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        return dbContactsEntryCalendarEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbContactsEntryCalendarEntry[] getEntryCalendarEntries(Connection connection, long[] lArray, long[] lArray2) throws SQLException {
        DbContactsEntryCalendarEntry[] dbContactsEntryCalendarEntryArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (lArray != null) {
                arrayList.add("contacts_entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ")");
            }
            if (lArray2 != null) {
                arrayList.add("calendar_entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray2.length) + ")");
            }
            String string = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)" ) AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_contacts_entries_calendar_entries " + string + " ORDER BY " + FIELD_CREATED_AT + " ASC;");
            int n = 0;
            if (lArray != null) {
                for (long l : lArray) {
                    preparedStatement.setLong(++n, l);
                }
            }
            if (lArray2 != null) {
                for (long l : lArray2) {
                    preparedStatement.setLong(++n, l);
                }
            }
            resultSet = preparedStatement.executeQuery();
            Object object = new ArrayList();
            while (resultSet.next()) {
                object.add(HSqlDbContactsCalendarHandler.createContactsEntryCalendarEntry(resultSet));
            }
            dbContactsEntryCalendarEntryArray = object.toArray(new DbContactsEntryCalendarEntry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbContactsEntryCalendarEntryArray;
    }

    @Override
    public void removeEntryCalendarEntries(Connection connection, DbContactsEntryCalendarEntry[] dbContactsEntryCalendarEntryArray) throws SQLException {
        if (dbContactsEntryCalendarEntryArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL remove_immotool_contacts_entries_calendar_entries(:contacts_entry_id, :calendar_entry_id);");
            for (DbContactsEntryCalendarEntry dbContactsEntryCalendarEntry : dbContactsEntryCalendarEntryArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_CONTACTS_ENTRY_ID, dbContactsEntryCalendarEntry.contactsEntryId);
                namedCallableStatement.setLong(FIELD_CALENDAR_ENTRY_ID, dbContactsEntryCalendarEntry.calendarEntryId);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveEntryCalendarEntry(Connection connection, DbContactsEntryCalendarEntry dbContactsEntryCalendarEntry) throws SQLException {
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_contacts_entries_calendar_entries(:contacts_entry_id, :calendar_entry_id, :relation_type, :relation_notes);");
            namedCallableStatement.setLong(FIELD_CONTACTS_ENTRY_ID, dbContactsEntryCalendarEntry.contactsEntryId);
            namedCallableStatement.setLong(FIELD_CALENDAR_ENTRY_ID, dbContactsEntryCalendarEntry.calendarEntryId);
            namedCallableStatement.setString(FIELD_RELATION_TYPE, StringUtils.abbreviate((String)dbContactsEntryCalendarEntry.relationType, (int)100));
            namedCallableStatement.setString(FIELD_RELATION_NOTES, dbContactsEntryCalendarEntry.relationNotes != null && dbContactsEntryCalendarEntry.relationNotes.trim().length() > 0 ? dbContactsEntryCalendarEntry.relationNotes.trim() : null);
            namedCallableStatement.execute();
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

