/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons.mail;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.addons.mail.MailEditorContactsExtension;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.extensions.EntryViewAdapter;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.mail.MailEditor;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.MailWritePanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsEntryViewMailExtension
extends EntryViewAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryViewMailExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryViewMailExtension.class);

    public JMenuItem[] createActionMenuItems(final ImmoToolProject immoToolProject, final DbContactsEntry dbContactsEntry) {
        if (dbContactsEntry == null) {
            return null;
        }
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        try {
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.setEnabled(dbContactsEntry.id > 0L);
            jMenuItem.setText(StringUtils.capitalize((String)I18N.tr("compose e-mail")));
            jMenuItem.setIcon(MailPlugin.getResourceIcon((String)"mail_generic.png", (int)16));
            arrayList.add(jMenuItem);
            if (dbContactsEntry.id > 0L) {
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ContactsEntryViewMailExtension.this.doSendMailTo(dbContactsEntry, immoToolProject);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            LOGGER.error("Can't load contacts menu!");
            LOGGER.error("> " + throwable.getLocalizedMessage(), throwable);
        }
        return !arrayList.isEmpty() ? arrayList.toArray(new JMenuItem[0]) : null;
    }

    private void doSendMailTo(final DbContactsEntry dbContactsEntry, final ImmoToolProject immoToolProject) {
        final DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        ImmoToolTask<MailWritePanel, Void> immoToolTask = new ImmoToolTask<MailWritePanel, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected MailWritePanel doInBackground() throws Exception {
                MailWritePanel mailWritePanel = MailWritePanel.createTab();
                Connection connection = null;
                try {
                    String string;
                    connection = immoToolProject.getDbConnection();
                    if (dbContactsEntry.values == null) {
                        dbContactsHandler.loadEntrySettings(connection, dbContactsEntry);
                    }
                    if (StringUtils.isBlank((CharSequence)(string = dbContactsEntry.getAddressMail()))) {
                        LOGGER.warn("Can't find mail address for contact entry #" + dbContactsEntry.id + "!");
                        MailWritePanel mailWritePanel2 = null;
                        return mailWritePanel2;
                    }
                    mailWritePanel.addRecipient(MailEditor.RecipientType.TO, (MailEditor.Address)new MailEditorContactsExtension.ContactsAddress(dbContactsEntry));
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
                return mailWritePanel;
            }

            protected void succeeded(MailWritePanel mailWritePanel) {
                super.succeeded((Object)mailWritePanel);
                if (mailWritePanel == null) {
                    return;
                }
                ImmoToolAppUtils.showTab((AbstractMainTab)mailWritePanel);
                mailWritePanel.loadInBackground(immoToolProject.getDbDriver());
            }
        };
        ImmoToolUtils.executeTask((ImmoToolTask)immoToolTask);
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Contacts", "OpenEstate-Tool-Mail"};
    }
}

