/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons.mail;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.addons.mail.ContactsMailUtils;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import com.openindex.openestate.tool.gui.DefaultAutoCompleteField;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.mail.MailEditor;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailPart;
import com.openindex.openestate.tool.mail.extensions.MailEditorAdapter;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailEditorContactsExtension
extends MailEditorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailEditorContactsExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(MailEditorContactsExtension.class);
    private ContactsAddressHandler addressHandler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailEditor.AddressHandler getAddressHandler() {
        if (this.addressHandler == null) {
            MailEditorContactsExtension mailEditorContactsExtension = this;
            synchronized (mailEditorContactsExtension) {
                this.addressHandler = new ContactsAddressHandler();
            }
        }
        return this.addressHandler;
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Contacts", "OpenEstate-Tool-Mail"};
    }

    public void loadMessage(Connection connection, DbMailMessage dbMailMessage, DbMailPart dbMailPart, Map<Long, String> map, MailEditor.ViewMode viewMode) throws SQLException {
        long[] lArray;
        super.loadMessage(connection, dbMailMessage, dbMailPart, map, viewMode);
        ContactsAddressHandler contactsAddressHandler = (ContactsAddressHandler)this.getAddressHandler();
        contactsAddressHandler.recipientContacts.clear();
        contactsAddressHandler.recipientHashes.clear();
        if (map == null || map.isEmpty()) {
            return;
        }
        DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        Object[] objectArray = dbContactsHandler.getEntries(connection, lArray = ArrayUtils.toPrimitive((Long[])map.keySet().toArray(new Long[0])));
        if (ArrayUtils.isEmpty((Object[])objectArray)) {
            return;
        }
        dbContactsHandler.loadEntrySettings(connection, (DbContactsEntry[])objectArray);
        for (Object object : objectArray) {
            String string = map.get(((DbContactsEntry)object).id);
            if (StringUtils.isBlank((CharSequence)string)) continue;
            contactsAddressHandler.recipientContacts.put(((DbContactsEntry)object).id, object);
            contactsAddressHandler.recipientHashes.put(string, ((DbContactsEntry)object).id);
        }
    }

    private static class ContactsAutoCompleteRenderer
    extends AbstractRenderer<DbContactsEntry> {
        private final Icon icon = ContactsPlugin.getResourceIcon((String)"edit_user.png", (int)32);

        private ContactsAutoCompleteRenderer() {
        }

        public void render(DbContactsEntry dbContactsEntry, JLabel jLabel) {
            if (dbContactsEntry != null) {
                String string;
                InternetAddress internetAddress = dbContactsEntry.getInternetAddress();
                if (internetAddress == null) {
                    jLabel.setIcon(this.icon);
                    jLabel.setText("#" + dbContactsEntry.id);
                    return;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                String string2 = internetAddress.getPersonal();
                if (!StringUtils.isBlank((CharSequence)string2)) {
                    arrayList.add("<b>" + StringEscapeUtils.escapeXml11((String)string2.trim()) + "</b>");
                }
                if (!StringUtils.isBlank((CharSequence)(string = internetAddress.getAddress()))) {
                    arrayList.add(StringEscapeUtils.escapeXml11((String)string.trim()));
                }
                if (arrayList.isEmpty()) {
                    jLabel.setIcon(this.icon);
                    jLabel.setText("#" + dbContactsEntry.id);
                    return;
                }
                jLabel.setIcon(this.icon);
                jLabel.setText("<html><div style=\"padding:2px;\">" + StringUtils.join(arrayList, (String)"<br>") + "</div></html>");
            } else {
                jLabel.setIcon(null);
                jLabel.setText("???");
            }
        }
    }

    private static class ContactsAutoCompleteHandler
    implements DefaultAutoCompleteField.AutoCompleteHandler<DbContactsEntry> {
        private final Dimension optionIconSize = new Dimension(16, 16);
        private final URL optionIconUrl = ImmoToolUtils.getResourceImageURL((String)"/com/openindex/openestate/tool/contacts/resources/", (int)16, (String)"edit_user.png", (ClassLoader)ContactsPlugin.class.getClassLoader());

        private ContactsAutoCompleteHandler() {
        }

        public Dimension getOptionIconSize() {
            return this.optionIconSize;
        }

        public URL getOptionIconUrl(DbContactsEntry dbContactsEntry) {
            return this.optionIconUrl;
        }

        public String getOptionText(DbContactsEntry dbContactsEntry) {
            if (dbContactsEntry != null) {
                InternetAddress internetAddress = dbContactsEntry.getInternetAddress();
                if (internetAddress == null) {
                    LOGGER.warn("Can't create internet address for contacts entry #" + dbContactsEntry.id + "!");
                    return null;
                }
                return internetAddress.toUnicodeString();
            }
            LOGGER.warn("Empty option!");
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<DbContactsEntry> search(String string) throws Exception {
            if (StringUtils.isBlank((CharSequence)string)) {
                return new ArrayList<DbContactsEntry>();
            }
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            ArrayList<DbContactsEntry> arrayList = new ArrayList<DbContactsEntry>();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                DbContactsEntry[] dbContactsEntryArray = dbContactsHandler.getEntriesByKeyword(connection, string, 100);
                dbContactsHandler.loadEntrySettings(connection, dbContactsEntryArray);
                for (DbContactsEntry dbContactsEntry : dbContactsEntryArray) {
                    String string2 = dbContactsEntry.getAddressMail();
                    if (string2 == null) continue;
                    arrayList.add(dbContactsEntry);
                }
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            return arrayList;
        }
    }

    private static class ContactsAddressHandler
    implements MailEditor.AddressHandler {
        private final Map<String, Long> recipientHashes = new HashMap<String, Long>();
        private final Map<Long, DbContactsEntry> recipientContacts = new HashMap<Long, DbContactsEntry>();
        private final ContactsAutoCompleteHandler autoCompleteHandler = new ContactsAutoCompleteHandler();
        private final ContactsAutoCompleteRenderer autoCompleteRenderer = new ContactsAutoCompleteRenderer();

        private ContactsAddressHandler() {
        }

        public void addRecipient(MailEditor.Address address, MailEditor.RecipientType recipientType, Email email, Map<Long, String> map) {
            Object object;
            if (address == null || recipientType == null || email == null) {
                return;
            }
            ArrayList<DbContactsEntry> arrayList = new ArrayList<DbContactsEntry>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            if (address instanceof ContactsAddress) {
                object = (Object[])address;
                if (!ArrayUtils.isEmpty((Object[])((ContactsAddress)object).addresses)) {
                    for (String string : ((ContactsAddress)object).addresses) {
                        Object[] objectArray;
                        String string2 = StringUtils.trimToNull((String)string);
                        if (string2 == null) continue;
                        if (ImmoToolUtils.isValidMailAddress((String)string2)) {
                            try {
                                objectArray = ImmoToolUtils.toIdnMailAddress((String)string2);
                                arrayList2.add(new InternetAddress((String)objectArray, null));
                            }
                            catch (Exception exception) {
                                LOGGER.warn("Can't parse internet address!");
                                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                            }
                            continue;
                        }
                        try {
                            objectArray = InternetAddress.parse((String)string2, (boolean)false);
                            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
                            for (Object object2 : objectArray) {
                                if (!ImmoToolUtils.isValidMailAddress((String)object2.getAddress())) continue;
                                arrayList2.add(ImmoToolUtils.toIdnInternetAddress((InternetAddress)object2));
                            }
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Can't parse internet address!");
                            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        }
                    }
                }
                if (!ArrayUtils.isEmpty((Object[])((ContactsAddress)object).contactEntries)) {
                    arrayList.addAll(Arrays.asList(((ContactsAddress)object).contactEntries));
                }
            } else {
                object = address.getInternetAddresses();
                if (!ArrayUtils.isEmpty((Object[])object)) {
                    arrayList2.addAll(Arrays.asList(object));
                }
            }
            for (DbContactsEntry dbContactsEntry : arrayList) {
                String string;
                InternetAddress internetAddress = dbContactsEntry.getInternetAddress();
                arrayList2.add(internetAddress);
                if (map.containsKey(dbContactsEntry.id) || StringUtils.isBlank((CharSequence)(string = ContactsMailUtils.getHash(internetAddress)))) continue;
                map.put(dbContactsEntry.id, string);
            }
            for (InternetAddress internetAddress : arrayList2) {
                if (internetAddress == null) continue;
                try {
                    String string = internetAddress.getAddress();
                    String string3 = internetAddress.getPersonal();
                    switch (recipientType) {
                        case TO: {
                            email.addTo(string, string3);
                            break;
                        }
                        case CC: {
                            email.addCc(string, string3);
                            break;
                        }
                        case BCC: {
                            email.addBcc(string, string3);
                            break;
                        }
                        case REPLY_TO: {
                            email.addReplyTo(string, string3);
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't add recipient: " + internetAddress.toUnicodeString());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }

        public MailEditor.Address createAddress(InternetAddress internetAddress) {
            return new ContactsAddress(internetAddress != null ? internetAddress.toUnicodeString() : "");
        }

        public MailEditor.AddressField createAddressField(MailEditor.Address address) {
            ContactsAddressField contactsAddressField = new ContactsAddressField(this.autoCompleteHandler, this.autoCompleteRenderer);
            contactsAddressField.setAddress(address);
            return contactsAddressField;
        }

        public MailEditor.Address loadAddress(InternetAddress internetAddress) {
            Long l;
            DbContactsEntry dbContactsEntry;
            String string;
            String string2 = string = internetAddress != null ? ContactsMailUtils.getHash(internetAddress) : null;
            if (!StringUtils.isBlank((CharSequence)string) && this.recipientHashes.containsKey(string) && (dbContactsEntry = this.recipientContacts.get(l = this.recipientHashes.get(string))) != null) {
                return new ContactsAddress(dbContactsEntry);
            }
            return this.createAddress(internetAddress);
        }
    }

    private static class ContactsAddressField
    implements MailEditor.AddressField {
        private final DefaultAutoCompleteField<DbContactsEntry> field;

        private ContactsAddressField(DefaultAutoCompleteField.AutoCompleteHandler<DbContactsEntry> autoCompleteHandler, ContactsAutoCompleteRenderer contactsAutoCompleteRenderer) {
            this.field = new DefaultAutoCompleteField(autoCompleteHandler);
            this.field.setAutoCompleteItemRenderer((ListCellRenderer)new DefaultListCellRenderer((Renderer)contactsAutoCompleteRenderer));
            this.field.setCustomValueAllowed(true);
            this.field.setMultipleSelectionAllowed(false);
            this.field.setPopupHeight(125);
            this.field.setPopupDelay(1000);
        }

        public void addKeyListener(KeyListener keyListener) {
            this.field.getField().addKeyListener(keyListener);
        }

        public MailEditor.Address getAddress() {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<DbContactsEntry> arrayList2 = new ArrayList<DbContactsEntry>();
            for (Object object : this.field.getValues()) {
                if (object instanceof String) {
                    arrayList.add((String)object);
                    continue;
                }
                if (!(object instanceof DbContactsEntry)) continue;
                arrayList2.add((DbContactsEntry)object);
            }
            return new ContactsAddress(arrayList.toArray(new String[0]), arrayList2.toArray(new DbContactsEntry[0]));
        }

        public JComponent getComponent() {
            return this.field;
        }

        public void removeKeyListener(KeyListener keyListener) {
            this.field.getField().removeKeyListener(keyListener);
        }

        public void requestFocus() {
            this.field.getField().requestFocusInWindow();
        }

        public void setAddress(MailEditor.Address address) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (address instanceof ContactsAddress) {
                ContactsAddress contactsAddress = (ContactsAddress)address;
                if (!ArrayUtils.isEmpty((Object[])contactsAddress.contactEntries)) {
                    arrayList.addAll(Arrays.asList(contactsAddress.contactEntries));
                }
                if (!ArrayUtils.isEmpty((Object[])contactsAddress.addresses)) {
                    arrayList.addAll(Arrays.asList(contactsAddress.addresses));
                }
            }
            this.field.setValues(arrayList.toArray(new Object[0]));
        }
    }

    public static class ContactsAddress
    implements MailEditor.Address {
        private String[] addresses;
        private DbContactsEntry[] contactEntries;

        public ContactsAddress() {
            this(null, (DbContactsEntry[])null);
        }

        public ContactsAddress(String string) {
            String[] stringArray;
            if (!StringUtils.isBlank((CharSequence)string)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string.trim();
            } else {
                stringArray = null;
            }
            this(stringArray, null);
        }

        public ContactsAddress(String[] stringArray) {
            this(stringArray, null);
        }

        public ContactsAddress(DbContactsEntry dbContactsEntry) {
            DbContactsEntry[] dbContactsEntryArray;
            if (dbContactsEntry != null) {
                DbContactsEntry[] dbContactsEntryArray2 = new DbContactsEntry[1];
                dbContactsEntryArray = dbContactsEntryArray2;
                dbContactsEntryArray2[0] = dbContactsEntry;
            } else {
                dbContactsEntryArray = null;
            }
            this(null, dbContactsEntryArray);
        }

        public ContactsAddress(DbContactsEntry[] dbContactsEntryArray) {
            this(null, dbContactsEntryArray);
        }

        public ContactsAddress(String string, DbContactsEntry dbContactsEntry) {
            DbContactsEntry[] dbContactsEntryArray;
            String[] stringArray;
            if (!StringUtils.isBlank((CharSequence)string)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string.trim();
            } else {
                stringArray = null;
            }
            if (dbContactsEntry != null) {
                DbContactsEntry[] dbContactsEntryArray2 = new DbContactsEntry[1];
                dbContactsEntryArray = dbContactsEntryArray2;
                dbContactsEntryArray2[0] = dbContactsEntry;
            } else {
                dbContactsEntryArray = null;
            }
            this(stringArray, dbContactsEntryArray);
        }

        public ContactsAddress(String[] stringArray, DbContactsEntry[] dbContactsEntryArray) {
            this.addresses = !ArrayUtils.isEmpty((Object[])stringArray) ? stringArray : null;
            this.contactEntries = !ArrayUtils.isEmpty((Object[])dbContactsEntryArray) ? dbContactsEntryArray : null;
        }

        public boolean equals(Object object) {
            if (object instanceof ContactsAddress) {
                return this.hashCode() == object.hashCode();
            }
            return false;
        }

        public long[] getContactsEntryIds() {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            if (!ArrayUtils.isEmpty((Object[])this.contactEntries)) {
                for (DbContactsEntry dbContactsEntry : this.contactEntries) {
                    Long l = dbContactsEntry.id;
                    if (arrayList.contains(l)) continue;
                    arrayList.add(l);
                }
            }
            return ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }

        public InternetAddress[] getInternetAddresses() {
            InternetAddress internetAddress;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (!ArrayUtils.isEmpty((Object[])this.addresses)) {
                for (String string : this.addresses) {
                    String string2 = StringUtils.trimToNull((String)string);
                    if (string2 == null) continue;
                    if (ImmoToolUtils.isValidMailAddress((String)string2)) {
                        try {
                            internetAddress = ImmoToolUtils.toIdnMailAddress((String)string2);
                            arrayList.add(new InternetAddress((String)internetAddress, null));
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Can't parse internet address!");
                            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        }
                        continue;
                    }
                    try {
                        internetAddress = InternetAddress.parse((String)string2, (boolean)false);
                        if (ArrayUtils.isEmpty((Object[])internetAddress)) continue;
                        for (Object object : internetAddress) {
                            if (!ImmoToolUtils.isValidMailAddress((String)object.getAddress())) continue;
                            arrayList.add(ImmoToolUtils.toIdnInternetAddress((InternetAddress)object));
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't parse internet address!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
            }
            if (!ArrayUtils.isEmpty((Object[])this.contactEntries)) {
                for (String string : this.contactEntries) {
                    internetAddress = string.getInternetAddress();
                    if (internetAddress == null || !ImmoToolUtils.isValidMailAddress((String)internetAddress.getAddress())) continue;
                    arrayList.add(internetAddress);
                }
            }
            return arrayList.toArray(new InternetAddress[0]);
        }

        public int hashCode() {
            int n = 0;
            if (!ArrayUtils.isEmpty((Object[])this.addresses)) {
                for (String string : this.addresses) {
                    n += !StringUtils.isBlank((CharSequence)string) ? string.hashCode() : 0;
                }
            }
            if (!ArrayUtils.isEmpty((Object[])this.contactEntries)) {
                for (String string : this.contactEntries) {
                    n += string != null ? Long.valueOf(((DbContactsEntry)string).id).hashCode() : 0;
                }
            }
            return n;
        }

        public boolean isBlank() {
            return ArrayUtils.isEmpty((Object[])this.getInternetAddresses());
        }
    }
}

