-- -----------------------------------------------------
-- Contacts-Addon for OpenEstate-ImmoTool
-- update 9 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Add function 'get_immotool_contacts_entry_id'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Add function 'get_immotool_contacts_entry_id'
-- -----------------------------------------------------
DROP FUNCTION IF EXISTS get_immotool_contacts_entry_id;
\.
CREATE FUNCTION get_immotool_contacts_entry_id( val_public_id VARCHAR(255) )
  RETURNS BIGINT
  SPECIFIC get_immotool_contacts_entry_id
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE entry_id BIGINT;

    -- Adress-ID aus Adress-Nr ermitteln
    SELECT entry_id
      INTO entry_id
      FROM immotool_contacts_entries
      WHERE entry_public_id IS NOT NULL AND entry_public_id = val_public_id;

    -- ID der ermittelten Adresse zurückliefern
    RETURN entry_id;
  END;
.;
GRANT EXECUTE
  ON FUNCTION get_immotool_contacts_entry_id
  TO "IMMOTOOL";
