/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import bizcal.common.CalendarModel;
import bizcal.common.CalendarViewConfig;
import bizcal.common.DayViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarListener;
import bizcal.swing.PopupMenuCallback;
import bizcal.util.DateInterval;
import bizcal.util.DateUtil;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEntryTable;
import com.openindex.openestate.tool.calendar.CalendarPermission;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarEventEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarGroup;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.calendar.db.DbCalendarTodoEntry;
import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarEntry;
import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarExtension;
import com.openindex.openestate.tool.calendar.gui.StatusRenderer;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.fortuna.ical4j.model.property.Status;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class CalendarViewPanel
extends AbstractMainTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarViewPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarViewPanel.class);
    private static final String TABLE_ID = "CalendarViewPanel.TableViewTable";
    private static final String TABLE_VIEW = "TABLE";
    private static final String MONTH_VIEW = "MONTH";
    private static final String WEEK_VIEW = "WEEK";
    private static final String DAY_VIEW = "DAY";
    private Date currentDate;
    private String currentView;
    private DbCalendarGroup currentLocalCalendar = null;
    private VirtualCalendarExtension currentVirtualCalendar = null;
    private Map<Class, VirtualCalendarExtension> virtualCalendars;
    private PopupMenuCallback popupMenuCallback;
    private CalendarListener calendarListener;
    private boolean fullDayView = false;
    private JLabel searchEntryLabel;
    private JComboBox<DbCalendarEntry.Type> searchEntryBox;
    private JLabel searchStatusLabel;
    private JComboBox<Status> searchStatusBox;
    private JLabel searchTimeLabel;
    private JSpinner searchTimeField;
    private CalendarViewModel model;
    private JPanel mainPanel;
    private DayView dayView;
    private JToggleButton dayViewButton;
    private MonthView monthView;
    private JToggleButton monthViewButton;
    private TableView tableView;
    private JToggleButton tableViewButton;
    private WeekView weekView;
    private JToggleButton weekViewButton;

    private CalendarViewPanel() {
        this.updateLocalization();
        this.doSwitchView(DAY_VIEW);
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.dayViewButton = new JToggleButton((Action)((Object)new DayViewAction()));
        this.monthViewButton = new JToggleButton((Action)((Object)new MonthViewAction()));
        this.tableViewButton = new JToggleButton((Action)((Object)new TableViewAction()));
        this.weekViewButton = new JToggleButton((Action)((Object)new WeekViewAction()));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)this.dayViewButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)this.weekViewButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)this.monthViewButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)this.tableViewButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.createDefaultRefreshAction()));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)((Object)new EntryAddAction())));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.createDefaultHelpAction()));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.createDefaultCloseAction()));
    }

    protected JComponent buildHeaderComponentForm() {
        this.searchTimeLabel = new JLabel();
        this.searchTimeField = new JSpinner(new SpinnerDateModel());
        this.searchTimeField.setValue(this.currentDate);
        this.searchTimeField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!CalendarViewPanel.this.searchTimeField.isEnabled()) {
                    return;
                }
                Date date = (Date)CalendarViewPanel.this.searchTimeField.getValue();
                CalendarViewPanel.this.doSwitchDate(date, false);
            }
        });
        this.searchEntryLabel = new JLabel();
        this.searchEntryBox = new JComboBox();
        this.searchEntryBox.setRenderer((ListCellRenderer<DbCalendarEntry.Type>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<DbCalendarEntry.Type>(){

            public String getEmptyText() {
                return "[ " + I18N.tr("search by type") + " ]";
            }
        }));
        this.searchEntryBox.addItem(null);
        for (DbCalendarEntry.Type type : DbCalendarEntry.Type.values()) {
            this.searchEntryBox.addItem(type);
        }
        this.searchEntryBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CalendarViewPanel.this.searchEntryBox.isEnabled()) {
                    return;
                }
                int n = CalendarViewPanel.this.searchEntryBox.getSelectedIndex();
                CalendarViewPanel.this.searchStatusBox.setEnabled(false);
                CalendarViewPanel.this.searchStatusBox.removeAllItems();
                CalendarViewPanel.this.searchStatusBox.addItem(null);
                if (n > 0) {
                    DbCalendarEntry.Type type = (DbCalendarEntry.Type)((Object)CalendarViewPanel.this.searchEntryBox.getItemAt(n));
                    Status[] statusArray = DbCalendarEntry.Type.VEVENT.equals((Object)type) ? DbCalendarEventEntry.getStatusOptions() : (DbCalendarEntry.Type.VTODO.equals((Object)type) ? DbCalendarTodoEntry.getStatusOptions() : new Status[]{});
                    for (Status status : statusArray) {
                        CalendarViewPanel.this.searchStatusBox.addItem(status);
                    }
                    CalendarViewPanel.this.searchStatusBox.setSelectedIndex(0);
                }
                CalendarViewPanel.this.searchStatusBox.setEnabled(n > 0);
                CalendarViewPanel.this.doUpdateView();
            }
        });
        this.searchStatusLabel = new JLabel();
        this.searchStatusBox = new JComboBox();
        this.searchStatusBox.setRenderer((ListCellRenderer<Status>)new DefaultListCellRenderer((Renderer)new StatusRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("search by status") + " ]";
            }

            @Override
            protected DbCalendarEntry.Type getType() {
                return (DbCalendarEntry.Type)((Object)CalendarViewPanel.this.searchEntryBox.getSelectedItem());
            }
        }));
        this.searchStatusBox.addItem(null);
        this.searchStatusBox.setEnabled(false);
        this.searchStatusBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CalendarViewPanel.this.searchStatusBox.isEnabled()) {
                    return;
                }
                CalendarViewPanel.this.doUpdateView();
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 30dlu:grow");
        defaultFormBuilder.add((Component)this.searchTimeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.searchTimeField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.searchEntryLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add(this.searchEntryBox).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.searchStatusLabel).xy(9, defaultFormBuilder.row());
        defaultFormBuilder.add(this.searchStatusBox).xy(11, defaultFormBuilder.row());
        return defaultFormBuilder.getPanel();
    }

    protected JComponent buildMainComponent() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new CardLayout());
        this.dayView = new DayView();
        this.mainPanel.add((Component)((Object)this.dayView), DAY_VIEW);
        this.weekView = new WeekView();
        this.mainPanel.add((Component)((Object)this.weekView), WEEK_VIEW);
        this.monthView = new MonthView();
        this.mainPanel.add((Component)((Object)this.monthView), MONTH_VIEW);
        this.tableView = new TableView();
        this.mainPanel.add((Component)((Object)this.tableView), TABLE_VIEW);
        return this.mainPanel;
    }

    private JPopupMenu createPopup(CalendarViewEntry calendarViewEntry) {
        VirtualCalendarEntry virtualCalendarEntry;
        List<Action> list;
        if (calendarViewEntry == null) {
            return null;
        }
        CalendarEntry calendarEntry = calendarViewEntry.getEntry();
        JLabel jLabel = new JLabel("<html><b style=\"font-size:1.2em;\">" + StringEscapeUtils.escapeXml11((String)calendarEntry.getTitle()) + "</b><br>" + StringEscapeUtils.escapeXml11((String)StringUtils.abbreviate((String)calendarEntry.getSubTitle(), (int)35)) + "</html>");
        jLabel.setOpaque(true);
        jLabel.setBackground(Color.WHITE);
        if (calendarEntry instanceof DbCalendarEntry) {
            DbCalendarEntry dbCalendarEntry = (DbCalendarEntry)calendarEntry;
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(jLabel);
            jPopupMenu.addSeparator();
            jPopupMenu.add((Action)((Object)new CalendarPlugin.EntryFormAction(dbCalendarEntry.id)));
            if (dbCalendarEntry.groupId > 0L && this.isAllowedToEditEntries()) {
                jPopupMenu.add((Action)((Object)new CalendarViewRemoveAction(dbCalendarEntry.id)));
            }
            return jPopupMenu;
        }
        if (calendarEntry instanceof VirtualCalendarEntry && (list = (virtualCalendarEntry = (VirtualCalendarEntry)calendarEntry).getExtension().getActions(ImmoToolProject.getAppInstance(), virtualCalendarEntry)) != null && !list.isEmpty()) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(jLabel);
            jPopupMenu.addSeparator();
            for (Action action : list) {
                jPopupMenu.add(action);
            }
            return jPopupMenu;
        }
        return null;
    }

    private JPopupMenu createPopup(Date date) {
        long l;
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = MONTH_VIEW.equals(this.currentView) ? DateFormat.getDateInstance(1) : DateFormat.getDateTimeInstance(1, 3);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE");
        long l2 = l = this.currentLocalCalendar != null ? this.currentLocalCalendar.id : 0L;
        if (MONTH_VIEW.equals(this.currentView) && !DateUtils.isSameDay((Date)date, (Date)new Date())) {
            date = DateUtils.setHours((Date)DateUtils.round((Date)date, (int)11), (int)12);
        }
        JLabel jLabel = new JLabel("<html><b style=\"font-size:1.2em;\">" + simpleDateFormat.format(date) + "</b><br>" + dateFormat.format(date) + "</html>");
        jLabel.setOpaque(true);
        jLabel.setBackground(Color.WHITE);
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(jLabel);
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)((Object)new CalendarPlugin.EntryFormAction(l, date, DateUtils.addMinutes((Date)date, (int)30), DbCalendarEntry.Type.VEVENT)));
        jPopupMenu.add((Action)((Object)new CalendarPlugin.EntryFormAction(l, date, DateUtils.addMinutes((Date)date, (int)30), DbCalendarEntry.Type.VTODO)));
        return jPopupMenu;
    }

    public static CalendarViewPanel createTab() {
        return new CalendarViewPanel();
    }

    public static CalendarViewPanel createTab(DbCalendarGroup dbCalendarGroup) {
        CalendarViewPanel calendarViewPanel = new CalendarViewPanel();
        if (dbCalendarGroup != null) {
            calendarViewPanel.setCalendar(dbCalendarGroup);
        }
        return calendarViewPanel;
    }

    public static CalendarViewPanel createTab(VirtualCalendarExtension virtualCalendarExtension) {
        CalendarViewPanel calendarViewPanel = new CalendarViewPanel();
        if (virtualCalendarExtension != null) {
            calendarViewPanel.setCalendar(virtualCalendarExtension);
        }
        return calendarViewPanel;
    }

    private void doCreate(Date date, Date date2) {
        Point point = this.mainPanel.getMousePosition();
        this.doCreate(date, date2, this.mainPanel, point.x, point.y);
    }

    private void doCreate(Date date, Date date2, JComponent jComponent, int n, int n2) {
        if (!this.isAllowedToEditEntries()) {
            return;
        }
        if (MONTH_VIEW.equals(this.currentView) && !DateUtils.isSameDay((Date)date, (Date)new Date())) {
            date = DateUtils.setHours((Date)DateUtils.round((Date)date, (int)11), (int)12);
        }
        if (date2 == null) {
            date2 = DateUtils.addMinutes((Date)date, (int)30);
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        long l = this.currentLocalCalendar != null ? this.currentLocalCalendar.id : 0L;
        JLabel jLabel = new JLabel("<html><b style=\"font-size:1.2em;\">" + StringUtils.capitalize((String)I18N.tr("new calendar entry")) + "</b><br>" + dateFormat.format(date) + " " + I18N.tr("until") + " " + dateFormat.format(date2) + "</html>");
        jLabel.setOpaque(true);
        jLabel.setBackground(Color.WHITE);
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(jLabel);
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)((Object)new CalendarPlugin.EntryFormAction(l, date, date2, DbCalendarEntry.Type.VEVENT)));
        jPopupMenu.add((Action)((Object)new CalendarPlugin.EntryFormAction(l, date, date2, DbCalendarEntry.Type.VTODO)));
        jPopupMenu.show(jComponent, n, n2);
    }

    protected void doLoadInBackground(Connection connection) throws Exception {
        VirtualCalendarExtension[] virtualCalendarExtensionArray;
        Object object;
        this.model.clear();
        final ArrayList<Long> arrayList = new ArrayList<Long>();
        final HashMap<Long, CharSequence> hashMap = new HashMap<Long, CharSequence>();
        final TreeMap treeMap = new TreeMap();
        Date date = DateUtils.setDays((Date)DateUtils.round((Date)this.currentDate, (int)5), (int)1);
        Date date2 = DateUtils.addMilliseconds((Date)DateUtils.addMonths((Date)date, (int)1), (int)-1);
        DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
        if (this.currentLocalCalendar != null) {
            long[] lArray = new long[1];
            object = lArray;
            lArray[0] = this.currentLocalCalendar.id;
        } else {
            object = this.currentVirtualCalendar != null ? new long[]{} : null;
        }
        long[] lArray = object;
        Object[] objectArray = CalendarPluginUtils.searchForDbEntries(connection, dbCalendarHandler, lArray, null, null, date, date2);
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            for (Object object2 : objectArray) {
                long l;
                long l2 = l = ((DbCalendarEntry)object2).begin != null ? ((DbCalendarEntry)object2).begin.getTime() : 0L;
                if (!treeMap.containsKey(l)) {
                    treeMap.put(l, new ArrayList());
                }
                ((List)treeMap.get(l)).add(object2);
            }
        }
        if (this.currentVirtualCalendar != null) {
            VirtualCalendarExtension[] virtualCalendarExtensionArray2 = new VirtualCalendarExtension[1];
            virtualCalendarExtensionArray = virtualCalendarExtensionArray2;
            virtualCalendarExtensionArray2[0] = this.currentVirtualCalendar;
        } else {
            virtualCalendarExtensionArray = this.currentLocalCalendar != null ? new VirtualCalendarExtension[]{} : this.virtualCalendars.values().toArray(new VirtualCalendarExtension[0]);
        }
        Object[] objectArray2 = virtualCalendarExtensionArray;
        Object[] objectArray3 = CalendarPluginUtils.searchForVirtualEntries(connection, dbCalendarHandler, (VirtualCalendarExtension[])objectArray2, date, date2);
        if (!ArrayUtils.isEmpty((Object[])objectArray3)) {
            for (Object object3 : objectArray3) {
                long l = ((VirtualCalendarEntry)object3).getBegin().getTime();
                if (!treeMap.containsKey(l)) {
                    treeMap.put(l, new ArrayList());
                }
                ((List)treeMap.get(l)).add(object3);
            }
        }
        for (DbCalendarGroup dbCalendarGroup : dbCalendarHandler.getGroups(connection)) {
            hashMap.put(dbCalendarGroup.id, StringUtils.defaultIfBlank((CharSequence)StringUtils.trimToEmpty((String)dbCalendarGroup.name), (CharSequence)("#" + dbCalendarGroup.id)));
            if (!CalendarViewPanel.isAllowedToEditEntries(dbCalendarGroup)) continue;
            arrayList.add(dbCalendarGroup.id);
        }
        if (treeMap.isEmpty()) {
            this.doUpdateView();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CalendarViewModel calendarViewModel = CalendarViewPanel.this.model;
                    calendarViewModel.clear();
                    for (List list : treeMap.values()) {
                        for (CalendarEntry calendarEntry : list) {
                            String string = calendarEntry instanceof DbCalendarEntry ? (String)hashMap.get(((DbCalendarEntry)calendarEntry).groupId) : null;
                            CalendarViewEntry calendarViewEntry = new CalendarViewEntry(calendarEntry, string);
                            if (calendarEntry instanceof DbCalendarEntry) {
                                DbCalendarEntry dbCalendarEntry = (DbCalendarEntry)calendarEntry;
                                calendarViewEntry.setEditable(dbCalendarEntry.groupId > 0L && arrayList.contains(dbCalendarEntry.groupId));
                            } else {
                                calendarViewEntry.setEditable(false);
                            }
                            calendarViewModel.add(calendarViewEntry);
                        }
                    }
                    CalendarViewPanel.this.doUpdateView();
                }
            });
        }
    }

    private void doMove(final CalendarViewEntry calendarViewEntry, final Date date) {
        if (!(calendarViewEntry.getEntry() instanceof DbCalendarEntry)) {
            return;
        }
        final DbCalendarEntry dbCalendarEntry = (DbCalendarEntry)calendarViewEntry.getEntry();
        final Date date2 = calendarViewEntry.getStart();
        final Date date3 = calendarViewEntry.getEnd();
        final Date date4 = new Date(date3.getTime() + new DateInterval(date2, date).getDuration());
        calendarViewEntry.setStart(date);
        calendarViewEntry.setEnd(date4);
        this.doRefreshView();
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean doInBackground() throws Exception {
                Boolean bl;
                ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
                DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
                Connection connection = null;
                try {
                    dbCalendarEntry.setBeginTime(date);
                    dbCalendarEntry.setEndTime(date4);
                    dbCalendarEntry.updateIcalFieldFromComponent();
                    connection = immoToolProject.getDbConnection();
                    dbCalendarHandler.saveEntry(connection, dbCalendarEntry);
                    bl = true;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(connection);
                    throw throwable;
                }
                JdbcUtils.closeQuietly((Connection)connection);
                return bl;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                LOGGER.warn("Can't update calendar entry!");
                LOGGER.warn("> " + throwable.getLocalizedMessage(), throwable);
                calendarViewEntry.setStart(date2);
                calendarViewEntry.setEnd(date3);
                dbCalendarEntry.setBeginTime(date2);
                dbCalendarEntry.setEndTime(date3);
                dbCalendarEntry.updateIcalFieldFromComponent();
                CalendarViewPanel.this.doRefreshView();
            }
        });
    }

    public void doRefresh() {
        this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
    }

    private void doRefreshView() {
        try {
            switch (this.currentView) {
                case "DAY": {
                    this.dayView.view.refresh();
                    break;
                }
                case "MONTH": {
                    this.monthView.view.refresh();
                    break;
                }
                case "TABLE": {
                    this.tableView.table.getModel().fireTableDataChanged();
                    break;
                }
                case "WEEK": {
                    this.weekView.view.refresh();
                    break;
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't repaint calendar view!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private void doResize(final CalendarViewEntry calendarViewEntry, final Date date) {
        if (!(calendarViewEntry.getEntry() instanceof DbCalendarEntry)) {
            return;
        }
        final DbCalendarEntry dbCalendarEntry = (DbCalendarEntry)calendarViewEntry.getEntry();
        final Date date2 = calendarViewEntry.getEnd();
        calendarViewEntry.setEnd(date);
        this.doRefreshView();
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean doInBackground() throws Exception {
                Boolean bl;
                ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
                DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
                Connection connection = null;
                try {
                    dbCalendarEntry.setEndTime(date);
                    dbCalendarEntry.updateIcalFieldFromComponent();
                    connection = immoToolProject.getDbConnection();
                    dbCalendarHandler.saveEntry(connection, dbCalendarEntry);
                    bl = true;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(connection);
                    throw throwable;
                }
                JdbcUtils.closeQuietly((Connection)connection);
                return bl;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                LOGGER.warn("Can't update calendar entry!");
                LOGGER.warn("> " + throwable.getLocalizedMessage(), throwable);
                calendarViewEntry.setEnd(date2);
                dbCalendarEntry.setEndTime(date2);
                dbCalendarEntry.updateIcalFieldFromComponent();
                CalendarViewPanel.this.doRefreshView();
            }
        });
    }

    private void doSwitchDate(Date date) {
        this.doSwitchDate(date, true);
    }

    private void doSwitchDate(Date date, boolean bl) {
        boolean bl2;
        if (this.currentDate != null && this.currentDate.equals(date)) {
            return;
        }
        if (this.currentDate == null) {
            bl2 = false;
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.currentDate);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date);
            bl2 = calendar.get(1) == calendar2.get(1) && calendar.get(2) == calendar2.get(2);
        }
        this.currentDate = date;
        if (bl) {
            this.searchTimeField.setEnabled(false);
            this.searchTimeField.setValue(this.currentDate);
            this.searchTimeField.setEnabled(true);
        }
        if (bl2) {
            this.doUpdateView();
        } else {
            this.doRefresh();
        }
    }

    private void doSwitchFullDay() {
        this.fullDayView = !this.fullDayView;
        this.doUpdateView();
    }

    private void doSwitchView(String string) {
        boolean bl = this.currentView == null || !this.currentView.equals(string);
        CardLayout cardLayout = (CardLayout)this.mainPanel.getLayout();
        cardLayout.show(this.mainPanel, string);
        this.currentView = string;
        this.dayViewButton.setSelected(DAY_VIEW.equals(string));
        this.monthViewButton.setSelected(MONTH_VIEW.equals(string));
        this.tableViewButton.setSelected(TABLE_VIEW.equals(string));
        this.weekViewButton.setSelected(WEEK_VIEW.equals(string));
        this.model.filterType = (DbCalendarEntry.Type)((Object)this.searchEntryBox.getSelectedItem());
        this.model.filterStatus = (Status)this.searchStatusBox.getSelectedItem();
        try {
            switch (string) {
                case "DAY": {
                    this.dayView.update(this.currentDate);
                    if (bl) {
                        ((SpinnerDateModel)this.searchTimeField.getModel()).setCalendarField(6);
                        this.searchTimeField.setEditor(new JSpinner.DateEditor(this.searchTimeField, "dd. MMMMM yyyy"));
                    }
                    break;
                }
                case "MONTH": {
                    this.monthView.update(this.currentDate);
                    if (bl) {
                        ((SpinnerDateModel)this.searchTimeField.getModel()).setCalendarField(2);
                        this.searchTimeField.setEditor(new JSpinner.DateEditor(this.searchTimeField, "MMMMM yyyy"));
                    }
                    break;
                }
                case "TABLE": {
                    this.tableView.update(this.currentDate);
                    if (bl) {
                        ((SpinnerDateModel)this.searchTimeField.getModel()).setCalendarField(2);
                        this.searchTimeField.setEditor(new JSpinner.DateEditor(this.searchTimeField, "MMMMM yyyy"));
                    }
                    break;
                }
                case "WEEK": {
                    this.weekView.update(this.currentDate);
                    if (bl) {
                        ((SpinnerDateModel)this.searchTimeField.getModel()).setCalendarField(4);
                        this.searchTimeField.setEditor(new JSpinner.DateEditor(this.searchTimeField, "w yyyy"));
                    }
                    break;
                }
                default: {
                    LOGGER.warn("Unsupported calendar view '" + string + "'!");
                    break;
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't refresh calendar view.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't refresh calendar view."), (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
        this.updateLocalization();
    }

    private void doUpdateView() {
        this.doSwitchView(this.currentView);
    }

    private void doView(CalendarViewEntry calendarViewEntry) {
        if (calendarViewEntry != null) {
            this.doView(calendarViewEntry.getEntry());
        }
    }

    private void doView(CalendarEntry calendarEntry) {
        VirtualCalendarEntry virtualCalendarEntry;
        Action action;
        if (calendarEntry instanceof DbCalendarEntry) {
            DbCalendarEntry dbCalendarEntry = (DbCalendarEntry)calendarEntry;
            if (dbCalendarEntry.groupId > 0L) {
                new CalendarPlugin.EntryFormAction(dbCalendarEntry.id).actionPerformed(null);
            }
        } else if (calendarEntry instanceof VirtualCalendarEntry && (action = (virtualCalendarEntry = (VirtualCalendarEntry)calendarEntry).getExtension().getViewAction(ImmoToolProject.getAppInstance(), virtualCalendarEntry)) != null) {
            action.actionPerformed(null);
        }
    }

    public long getCurrentCalendarId() {
        return this.currentLocalCalendar != null ? this.currentLocalCalendar.id : 0L;
    }

    public Class getCurrentVirtualCalendarClass() {
        return this.currentVirtualCalendar != null ? this.currentVirtualCalendar.getClass() : null;
    }

    protected Icon getHeaderIcon() {
        return CalendarPlugin.getResourceIcon("vcalendar.png", 32);
    }

    protected String getHeaderTitle() {
        if (this.currentLocalCalendar != null) {
            String string = StringUtils.trimToNull((String)this.currentLocalCalendar.name);
            return StringUtils.capitalize((String)I18N.tr("calendar")) + " (" + (string != null ? StringUtils.abbreviate((String)string, (int)35) : "#" + this.currentLocalCalendar.id) + ")";
        }
        if (this.currentVirtualCalendar != null) {
            return StringUtils.capitalize((String)I18N.tr("calendar")) + " (" + StringUtils.trimToEmpty((String)StringUtils.abbreviate((String)this.currentVirtualCalendar.getTitle(), (int)35)) + ")";
        }
        return StringUtils.capitalize((String)I18N.tr("all calendars"));
    }

    public String getTabTitle() {
        if (this.currentLocalCalendar != null) {
            String string = StringUtils.trimToNull((String)this.currentLocalCalendar.name);
            return StringUtils.capitalize((String)I18N.tr("calendar")) + " (" + (string != null ? StringUtils.abbreviate((String)string, (int)20) : "#" + this.currentLocalCalendar.id) + ")";
        }
        if (this.currentVirtualCalendar != null) {
            return StringUtils.capitalize((String)I18N.tr("calendar")) + " (" + StringUtils.trimToEmpty((String)StringUtils.abbreviate((String)this.currentVirtualCalendar.getTitle(), (int)20)) + ")";
        }
        return StringUtils.capitalize((String)I18N.tr("all calendars"));
    }

    private static String getToolTip(CalendarEntry calendarEntry) {
        if (calendarEntry instanceof DbCalendarEntry) {
            DbCalendarEntry dbCalendarEntry = (DbCalendarEntry)calendarEntry;
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
            return "<html><strong>" + StringEscapeUtils.escapeXml11((String)StringUtils.abbreviate((String)dbCalendarEntry.title, (int)50)) + "</strong><br>" + dateFormat.format(dbCalendarEntry.begin) + " - " + dateFormat.format(dbCalendarEntry.end) + "<hr>" + StringEscapeUtils.escapeXml11((String)dbCalendarEntry.getInfo()) + "</html>";
        }
        if (calendarEntry instanceof VirtualCalendarEntry) {
            VirtualCalendarEntry virtualCalendarEntry = (VirtualCalendarEntry)calendarEntry;
            return "<html><strong>" + StringEscapeUtils.escapeXml11((String)StringUtils.abbreviate((String)virtualCalendarEntry.getTitle(), (int)50)) + "</strong><br>" + StringEscapeUtils.escapeXml11((String)StringUtils.abbreviate((String)virtualCalendarEntry.getSubTitle(), (int)50)) + "<hr>" + StringEscapeUtils.escapeXml11((String)virtualCalendarEntry.getInfo()) + "</html>";
        }
        return null;
    }

    protected void init() {
        this.currentDate = new Date();
        this.model = new CalendarViewModel();
        this.model.interval = new DateInterval(this.currentDate);
        this.calendarListener = new CalendarListener.BaseImpl(){

            public void eventDoubleClick(Object object, Event event, MouseEvent mouseEvent) {
                CalendarViewPanel.this.doView((CalendarViewEntry)event);
            }

            public void moved(Event event, Object object, Date date, Object object2, Date date2) {
                CalendarViewPanel.this.doMove((CalendarViewEntry)event, date2);
            }

            public void newEvent(Object object, Date date) {
                CalendarViewPanel.this.doCreate(date, null);
            }

            public void newEvent(Object object, DateInterval dateInterval) {
                CalendarViewPanel.this.doCreate(dateInterval.getStartDate(), dateInterval.getEndDate());
            }

            public void resized(Event event, Object object, Date date, Date date2) {
                CalendarViewPanel.this.doResize((CalendarViewEntry)event, date2);
            }

            public void showEvent(Object object, Event event) {
                CalendarViewPanel.this.doView((CalendarViewEntry)event);
            }
        };
        this.popupMenuCallback = new PopupMenuCallback.BaseImpl(){

            public JPopupMenu getEmptyPopupMenu(Object object, Date date) {
                return CalendarViewPanel.this.createPopup(date);
            }

            public JPopupMenu getEventPopupMenu(Object object, Event event) {
                return CalendarViewPanel.this.createPopup((CalendarViewEntry)event);
            }
        };
        super.init();
        this.virtualCalendars = new HashMap<Class, VirtualCalendarExtension>();
        try {
            for (VirtualCalendarExtension virtualCalendarExtension : CalendarPlugin.getVirtualCalendars()) {
                this.virtualCalendars.put(virtualCalendarExtension.getClass(), virtualCalendarExtension);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load virtual calendars!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private boolean isAllowedToEditEntries() {
        return CalendarViewPanel.isAllowedToEditEntries(this.currentLocalCalendar);
    }

    private static boolean isAllowedToEditEntries(DbCalendarGroup dbCalendarGroup) {
        DbUser dbUser;
        boolean bl;
        if (!CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_EDIT)) {
            return false;
        }
        return dbCalendarGroup == null || (bl = dbCalendarGroup.permission.canWrite(dbUser = ImmoToolProject.getAppInstance().getUser(), dbCalendarGroup.ownerUserId, dbCalendarGroup.ownerGroupId));
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    public void setCalendar(DbCalendarGroup dbCalendarGroup) {
        this.currentLocalCalendar = dbCalendarGroup;
        this.currentVirtualCalendar = null;
    }

    public void setCalendar(VirtualCalendarExtension virtualCalendarExtension) {
        this.currentVirtualCalendar = virtualCalendarExtension;
        this.currentLocalCalendar = null;
    }

    public void unsetCalendar() {
        this.currentLocalCalendar = null;
        this.currentVirtualCalendar = null;
    }

    protected void updateLocalization() {
        String string;
        super.updateLocalization();
        switch (string = (String)StringUtils.defaultIfBlank((CharSequence)this.currentView, (CharSequence)DAY_VIEW)) {
            case "MONTH": 
            case "TABLE": {
                this.searchTimeLabel.setText(StringUtils.capitalize((String)I18N.tr("month")) + ":");
                break;
            }
            case "WEEK": {
                this.searchTimeLabel.setText(StringUtils.capitalize((String)I18N.tr("week")) + ":");
                break;
            }
            default: {
                this.searchTimeLabel.setText(StringUtils.capitalize((String)I18N.tr("day")) + ":");
            }
        }
        this.searchEntryLabel.setText(StringUtils.capitalize((String)I18N.tr("type")) + ":");
        this.searchStatusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
    }

    private final class CalendarViewRemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long[] entryIds;

        private CalendarViewRemoveTask(long l) {
            this(new long[]{l});
        }

        private CalendarViewRemoveTask(long[] lArray) {
            this.entryIds = lArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                for (long l : this.entryIds) {
                    dbCalendarHandler.removeEntry(connection, l);
                }
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't remove calendar entry!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            CalendarViewPanel.this.doRefresh();
        }
    }

    private final class CalendarViewRemoveAction
    extends AbstractI18nAction {
        private final long entryId;

        private CalendarViewRemoveAction(long l) {
            this.entryId = l;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_REMOVE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new CalendarViewRemoveTask(this.entryId));
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove entry")));
            this.setShortDescription(I18N.tr("Remove the selected calendar entry."));
        }
    }

    private static class CalendarViewModel
    extends CalendarModel.BaseImpl {
        private final List<bizcal.common.Calendar> calendars = new ArrayList<bizcal.common.Calendar>();
        private final List<Event> entries = new ArrayList<Event>();
        private DbCalendarEntry.Type filterType = null;
        private Status filterStatus = null;
        private DateInterval interval;

        private CalendarViewModel() {
            bizcal.common.Calendar calendar = new bizcal.common.Calendar();
            calendar.setId((Object)0);
            this.calendars.add(calendar);
        }

        public void add(CalendarViewEntry calendarViewEntry) {
            this.entries.add(calendarViewEntry);
        }

        public void clear() {
            this.entries.clear();
        }

        public List<Event> getEvents(Object object) {
            ArrayList<Event> arrayList = new ArrayList<Event>();
            for (Event event : this.entries) {
                CalendarEntry calendarEntry = ((CalendarViewEntry)event).getEntry();
                if (this.filterType != null && (calendarEntry.isVirtual() || calendarEntry instanceof DbCalendarEventEntry && !DbCalendarEntry.Type.VEVENT.equals((Object)this.filterType) || calendarEntry instanceof DbCalendarTodoEntry && !DbCalendarEntry.Type.VTODO.equals((Object)this.filterType))) continue;
                if (this.filterStatus != null) {
                    if (!(calendarEntry instanceof DbCalendarEntry)) continue;
                    DbCalendarEntry dbCalendarEntry = (DbCalendarEntry)calendarEntry;
                    if (!this.filterStatus.equals((Object)dbCalendarEntry.status)) continue;
                }
                arrayList.add(event);
            }
            return arrayList;
        }

        public List getSelectedCalendars() {
            return this.calendars;
        }

        public DateInterval getInterval() {
            return this.interval;
        }
    }

    private static class CalendarViewEntry
    extends Event {
        private final CalendarEntry entry;
        private final String calendarName;

        private CalendarViewEntry(CalendarEntry calendarEntry, String string) {
            this.entry = calendarEntry;
            this.calendarName = string;
            this.setStart(calendarEntry.getBegin());
            this.setEnd(calendarEntry.getEnd());
            this.setShowTime(false);
        }

        public String getCalendarName() {
            return this.calendarName;
        }

        public Color getColor() {
            return this.entry.getColor();
        }

        public String getDescription() {
            return StringUtils.trimToEmpty((String)this.entry.getInfo());
        }

        public CalendarEntry getEntry() {
            return this.entry;
        }

        public ImageIcon getIcon() {
            return this.entry.getIcon();
        }

        public String getSummary() {
            return StringUtils.trimToEmpty((String)this.entry.getTitle());
        }

        public String getToolTip() {
            return CalendarViewPanel.getToolTip(this.entry);
        }
    }

    private class EntryAddAction
    extends AbstractI18nAction {
        private EntryAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.setEnabled(CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            CalendarViewPanel.this.doCreate(CalendarViewPanel.this.currentDate, null, jComponent, 0, jComponent.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new")));
            this.setShortDescription(I18N.tr("Create a new calendar entry."));
        }
    }

    private final class SwitchFullDayAction
    extends AbstractI18nAction {
        private SwitchFullDayAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarViewPanel.this.doSwitchFullDay();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("complete day")));
            this.setShortDescription(I18N.tr("Show calendar entries in full-time or in the specified work period."));
        }
    }

    private final class SwitchDateAction
    extends AbstractI18nAction {
        private final int field;
        private final int amount;

        private SwitchDateAction(int n, int n2) {
            this.field = n;
            this.amount = n2;
            if (this.amount > 0) {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_right.png", (int)16));
            } else if (this.amount < 0) {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_left.png", (int)16));
            }
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(CalendarViewPanel.this.currentDate);
            calendar.add(this.field, this.amount);
            CalendarViewPanel.this.doSwitchDate(calendar.getTime());
        }

        protected void updateLocalization() {
            if (this.amount > 0) {
                this.setShortDescription(I18N.tr("Show next page in the calendar view."));
            } else if (this.amount < 0) {
                this.setShortDescription(I18N.tr("Show previous page in the calendar view."));
            }
        }
    }

    private final class SwitchCurrentDateAction
    extends AbstractI18nAction {
        private SwitchCurrentDateAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarViewPanel.this.doSwitchDate(new Date());
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("today")));
            this.setShortDescription(I18N.tr("Show current day in the calendar view."));
        }
    }

    private final class WeekViewAction
    extends AbstractI18nAction {
        private WeekViewAction() {
            this.setSmallIcon(CalendarPlugin.getResourceIcon("week.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarViewPanel.this.doSwitchView(CalendarViewPanel.WEEK_VIEW);
        }

        protected void updateLocalization() {
            this.setShortDescription(I18N.tr("Show calendar in week view."));
        }
    }

    private final class WeekView
    extends AbstractPanel {
        private DayViewConfig config;
        private JXTitledSeparator title;
        private bizcal.swing.DayView view;
        private JToggleButton fullDayButton;

        private WeekView() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            try {
                this.config = new DayViewConfig();
                this.config.setShowTopHeader(false);
                this.view = new bizcal.swing.DayView(this.config);
                this.view.setPopupMenuCallback(CalendarViewPanel.this.popupMenuCallback);
                this.view.addListener(CalendarViewPanel.this.calendarListener);
                this.view.setModel((CalendarModel)CalendarViewPanel.this.model);
                this.view.setActiveCalendars((Collection)CalendarViewPanel.this.model.getSelectedCalendars());
            }
            catch (Exception exception) {
                throw new RuntimeException("Can't init calendar week view!", exception);
            }
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.fullDayButton = new JToggleButton((Action)((Object)new SwitchFullDayAction()));
            this.fullDayButton.setSelected(CalendarViewPanel.this.fullDayView);
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.title, (JComponent[])new JComponent[]{this.fullDayButton, new JButton((Action)((Object)new SwitchDateAction(6, -7))), new JButton((Action)((Object)new SwitchCurrentDateAction())), new JButton((Action)((Object)new SwitchDateAction(6, 7)))});
            this.setLayout(new BorderLayout(5, 5));
            this.add(jPanel, "North");
            this.add(this.view.getComponent(), "Center");
        }

        private void update(Date date) throws Exception {
            Object object;
            Comparable<Calendar> comparable;
            this.fullDayButton.setSelected(CalendarViewPanel.this.fullDayView);
            if (!CalendarViewPanel.this.fullDayView) {
                int n;
                comparable = CalendarPlugin.getWorktimeBegin();
                object = CalendarPlugin.getWorktimeEnd();
                int n2 = comparable != null ? comparable.get(11) : this.config.getDefaultDayStartHour();
                int n3 = n = object != null ? object.get(11) : this.config.getDefaultDayEndHour();
                if (object != null && object.get(12) > 0) {
                    ++n;
                }
                this.config.setDayStartHour(n2);
                this.config.setDayEndHour(n);
            } else {
                this.config.setDayStartHour(this.config.getDefaultDayStartHour());
                this.config.setDayEndHour(this.config.getDefaultDayEndHour());
            }
            comparable = DateUtil.setDayOfWeek((Date)date, (int)2);
            object = CalendarViewPanel.this.model;
            ((CalendarViewModel)((Object)object)).interval.setStartDate((Date)comparable);
            ((CalendarViewModel)((Object)object)).interval.setEndDate(DateUtils.addDays((Date)comparable, (int)7));
            this.view.refresh();
            this.updateLocalization();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            CalendarViewModel calendarViewModel = CalendarViewPanel.this.model;
            Date date = calendarViewModel.getInterval().getStartDate();
            String string = StringUtils.capitalize((String)I18N.tr("weekly view"));
            if (date != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("w yyyy");
                string = string + " / " + I18N.tr("week") + " " + simpleDateFormat.format(date);
            }
            this.title.setTitle(string);
        }
    }

    private static final class TableViewRow
    extends CalendarEntryTable.Row {
        private TableViewRow(VirtualCalendarEntry virtualCalendarEntry) {
            super(virtualCalendarEntry);
        }

        private TableViewRow(DbCalendarEntry dbCalendarEntry, String string) {
            super(dbCalendarEntry, string);
        }

        public String getToolTipText(AbstractTable.Column column) {
            return CalendarViewPanel.getToolTip(this.getEntry());
        }
    }

    private final class TableViewTable
    extends CalendarEntryTable<TableViewRow> {
        private TableViewTable() {
            super(CalendarViewPanel.TABLE_ID);
        }

        protected void doRemove() {
            int[] nArray = this.getSelectedRows();
            if (ArrayUtils.isEmpty((int[])nArray)) {
                return;
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int n : nArray) {
                CalendarEntry calendarEntry;
                int n2 = this.convertRowIndexToModel(n);
                CalendarEntryTable.Row row = (CalendarEntryTable.Row)this.getRow(n2);
                if (row == null || !((calendarEntry = row.getEntry()) instanceof DbCalendarEntry)) continue;
                arrayList.add(((DbCalendarEntry)calendarEntry).id);
            }
            if (arrayList.isEmpty()) {
                return;
            }
            boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to delete the selected calendar entries?"), (Component)((Object)this));
            if (!bl) {
                return;
            }
            ImmoToolUtils.executeTask((ImmoToolTask)new CalendarViewRemoveTask(ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]))));
        }

        protected void doShowActions(int n, int n2) {
            int[] nArray = this.getSelectedRows();
            if (ArrayUtils.isEmpty((int[])nArray)) {
                return;
            }
            boolean bl = false;
            for (int n3 : nArray) {
                CalendarEntry calendarEntry;
                int n4 = this.convertRowIndexToModel(n3);
                CalendarEntryTable.Row row = (CalendarEntryTable.Row)this.getRow(n4);
                if (row == null || !((calendarEntry = row.getEntry()) instanceof DbCalendarEntry)) continue;
                bl = true;
                break;
            }
            Object object = new JPopupMenu();
            ((JPopupMenu)object).add((Action)((Object)new TableViewOpenAction()));
            ((JPopupMenu)object).add((Action)((Object)new TableViewRemoveAction(bl)));
            ((JPopupMenu)object).show((Component)((Object)this), n, n2);
        }

        protected void doView() {
            int[] nArray = this.getSelectedRows();
            if (ArrayUtils.isEmpty((int[])nArray)) {
                return;
            }
            for (int n : nArray) {
                int n2 = this.convertRowIndexToModel(n);
                CalendarEntryTable.Row row = (CalendarEntryTable.Row)this.getRow(n2);
                if (row == null) continue;
                CalendarViewPanel.this.doView(row.getEntry());
            }
        }
    }

    private final class TableViewRemoveAction
    extends AbstractI18nAction {
        private TableViewRemoveAction(boolean bl) {
            this.setEnabled(bl);
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarViewPanel.this.tableView.table.doRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove calendar entries")));
            this.setShortDescription(I18N.tr("Remove the selected calendar entries."));
        }
    }

    private final class TableViewOpenAction
    extends AbstractI18nAction {
        private TableViewOpenAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarViewPanel.this.tableView.table.doView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show entry")));
            this.setShortDescription(I18N.tr("Open the selected entries."));
        }
    }

    private final class TableViewAction
    extends AbstractI18nAction {
        private TableViewAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"table.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarViewPanel.this.doSwitchView(CalendarViewPanel.TABLE_VIEW);
        }

        protected void updateLocalization() {
            this.setShortDescription(I18N.tr("Show calendar in tabular view."));
        }
    }

    private final class TableView
    extends AbstractPanel {
        private JXTitledSeparator title;
        private TableViewTable table;

        private TableView() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.table = new TableViewTable();
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.title, (JComponent[])new JComponent[]{new JButton((Action)((Object)new SwitchDateAction(2, -1))), new JButton((Action)((Object)new SwitchCurrentDateAction())), new JButton((Action)((Object)new SwitchDateAction(2, 1)))});
            this.setLayout(new BorderLayout(5, 5));
            this.add(jPanel, "North");
            this.add(this.table.createScrollPane(), "Center");
        }

        private void update(Date date) {
            Date date2 = DateUtils.setDays((Date)DateUtils.round((Date)date, (int)5), (int)1);
            CalendarViewModel calendarViewModel = CalendarViewPanel.this.model;
            calendarViewModel.interval.setStartDate(date2);
            calendarViewModel.interval.setEndDate(DateUtils.addMonths((Date)date2, (int)1));
            this.table.clearRows();
            for (Object e : calendarViewModel.getSelectedCalendars()) {
                for (Event event : calendarViewModel.getEvents(e)) {
                    CalendarEntry calendarEntry;
                    CalendarEntry calendarEntry2 = ((CalendarViewEntry)event).getEntry();
                    if (calendarEntry2 instanceof DbCalendarEntry) {
                        calendarEntry = (DbCalendarEntry)calendarEntry2;
                        String string = ((CalendarViewEntry)event).getCalendarName();
                        this.table.addRow(new TableViewRow((DbCalendarEntry)calendarEntry, string));
                        continue;
                    }
                    if (!(calendarEntry2 instanceof VirtualCalendarEntry)) continue;
                    calendarEntry = (VirtualCalendarEntry)calendarEntry2;
                    this.table.addRow(new TableViewRow((VirtualCalendarEntry)calendarEntry));
                }
            }
            this.updateLocalization();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            CalendarViewModel calendarViewModel = CalendarViewPanel.this.model;
            Date date = calendarViewModel.getInterval().getStartDate();
            Date date2 = DateUtils.addSeconds((Date)calendarViewModel.getInterval().getEndDate(), (int)-1);
            String string = StringUtils.capitalize((String)I18N.tr("tabular view"));
            if (date != null) {
                DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.getDefault());
                string = string + " / " + dateFormat.format(date) + " - " + dateFormat.format(date2);
            }
            this.title.setTitle(string);
        }
    }

    private final class MonthViewAction
    extends AbstractI18nAction {
        private MonthViewAction() {
            this.setSmallIcon(CalendarPlugin.getResourceIcon("month.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarViewPanel.this.doSwitchView(CalendarViewPanel.MONTH_VIEW);
        }

        protected void updateLocalization() {
            this.setShortDescription(I18N.tr("Show calendar in month view."));
        }
    }

    private final class MonthView
    extends AbstractPanel {
        private JXTitledSeparator title;
        private bizcal.swing.MonthView view;

        private MonthView() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            Object object;
            try {
                object = new CalendarViewConfig();
                this.view = new bizcal.swing.MonthView(object);
                this.view.setPopupMenuCallback(CalendarViewPanel.this.popupMenuCallback);
                this.view.addListener(CalendarViewPanel.this.calendarListener);
                this.view.setModel((CalendarModel)CalendarViewPanel.this.model);
                this.view.refresh();
            }
            catch (Exception exception) {
                throw new RuntimeException("Can't init calendar month view!", exception);
            }
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            object = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.title, (JComponent[])new JComponent[]{new JButton((Action)((Object)new SwitchDateAction(2, -1))), new JButton((Action)((Object)new SwitchCurrentDateAction())), new JButton((Action)((Object)new SwitchDateAction(2, 1)))});
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)object, "North");
            this.add(this.view.getComponent(), "Center");
        }

        private void update(Date date) throws Exception {
            Date date2 = DateUtils.setDays((Date)DateUtils.round((Date)date, (int)5), (int)1);
            CalendarViewModel calendarViewModel = CalendarViewPanel.this.model;
            calendarViewModel.interval.setStartDate(date2);
            calendarViewModel.interval.setEndDate(DateUtils.addMonths((Date)date2, (int)1));
            this.view.refresh();
            this.updateLocalization();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            CalendarViewModel calendarViewModel = CalendarViewPanel.this.model;
            Date date = calendarViewModel.getInterval().getStartDate();
            String string = StringUtils.capitalize((String)I18N.tr("monthly view"));
            if (date != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM yyyy");
                string = string + " / " + simpleDateFormat.format(date);
            }
            this.title.setTitle(string);
        }
    }

    private final class DayViewAction
    extends AbstractI18nAction {
        private DayViewAction() {
            this.setSmallIcon(CalendarPlugin.getResourceIcon("day.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarViewPanel.this.doSwitchView(CalendarViewPanel.DAY_VIEW);
        }

        protected void updateLocalization() {
            this.setShortDescription(I18N.tr("Show calendar in day view."));
        }
    }

    private final class DayView
    extends AbstractPanel {
        private DayViewConfig config;
        private JXTitledSeparator title;
        private bizcal.swing.DayView view;
        private JToggleButton fullDayButton;

        private DayView() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            try {
                this.config = new DayViewConfig();
                this.config.setShowTopHeader(false);
                this.view = new bizcal.swing.DayView(this.config);
                this.view.setPopupMenuCallback(CalendarViewPanel.this.popupMenuCallback);
                this.view.addListener(CalendarViewPanel.this.calendarListener);
                this.view.setModel((CalendarModel)CalendarViewPanel.this.model);
                this.view.setActiveCalendars((Collection)CalendarViewPanel.this.model.getSelectedCalendars());
                this.view.refresh();
            }
            catch (Exception exception) {
                throw new RuntimeException("Can't init calendar day view!", exception);
            }
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.fullDayButton = new JToggleButton((Action)((Object)new SwitchFullDayAction()));
            this.fullDayButton.setSelected(CalendarViewPanel.this.fullDayView);
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.title, (JComponent[])new JComponent[]{this.fullDayButton, new JButton((Action)((Object)new SwitchDateAction(6, -1))), new JButton((Action)((Object)new SwitchCurrentDateAction())), new JButton((Action)((Object)new SwitchDateAction(6, 1)))});
            this.setLayout(new BorderLayout(5, 5));
            this.add(jPanel, "North");
            this.add(this.view.getComponent(), "Center");
        }

        private void update(Date date) throws Exception {
            Object object;
            this.fullDayButton.setSelected(CalendarViewPanel.this.fullDayView);
            if (!CalendarViewPanel.this.fullDayView) {
                int n;
                object = CalendarPlugin.getWorktimeBegin();
                Calendar calendar = CalendarPlugin.getWorktimeEnd();
                int n2 = object != null ? object.get(11) : this.config.getDefaultDayStartHour();
                int n3 = n = calendar != null ? calendar.get(11) : this.config.getDefaultDayEndHour();
                if (calendar != null && calendar.get(12) > 0) {
                    ++n;
                }
                this.config.setDayStartHour(n2);
                this.config.setDayEndHour(n);
            } else {
                this.config.setDayStartHour(this.config.getDefaultDayStartHour());
                this.config.setDayEndHour(this.config.getDefaultDayEndHour());
            }
            object = CalendarViewPanel.this.model;
            ((CalendarViewModel)((Object)object)).interval.setStartDate(date);
            ((CalendarViewModel)((Object)object)).interval.setEndDate(DateUtils.addDays((Date)date, (int)1));
            this.view.refresh();
            this.updateLocalization();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            CalendarViewModel calendarViewModel = CalendarViewPanel.this.model;
            Date date = calendarViewModel.getInterval().getStartDate();
            String string = StringUtils.capitalize((String)I18N.tr("daily view"));
            if (date != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE, dd.MM.yyyy");
                string = string + " / " + simpleDateFormat.format(date);
            }
            this.title.setTitle(string);
        }
    }
}

