/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolLogTablePanel;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntryPanel;
import com.openindex.openestate.tool.calendar.CalendarEntryRemoveTask;
import com.openindex.openestate.tool.calendar.CalendarEntryViewTask;
import com.openindex.openestate.tool.calendar.CalendarPermission;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntryLog;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntryLogHandler;
import com.openindex.openestate.tool.calendar.db.DbCalendarGroup;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.calendar.extensions.EntryViewExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbLogHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainView;
import com.openindex.openestate.tool.gui.AbstractMainViewTab;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class CalendarEntryViewPanel
extends AbstractMainView {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarEntryViewPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarEntryViewPanel.class);
    private DbCalendarEntry currentEntry = null;
    private DbCalendarEntry.Type currentType = null;
    private long nextEntryId = 0L;
    private long prevEntryId = 0L;
    private boolean mayEditEntry = false;
    private boolean mayRemoveEntry = false;
    private Map<DbCalendarEntry.Type, CalendarEntryPanel> typePanels;
    private List<EntryViewExtension> addons;
    private ProtocolPanel protocolPanel;
    private NotesPanel notesPanel;
    private AbstractI18nAction submitAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;
    private AbstractI18nAction viewNextAction;
    private AbstractI18nAction viewPrevAction;

    private CalendarEntryViewPanel() {
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = this.createDefaultSubmitAction(CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_EDIT));
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.viewNextAction = this.createDefaultViewNextAction();
        this.viewPrevAction = this.createDefaultViewPreviousAction();
        this.showActionsAction = this.createDefaultShowActionsAction(CalendarPlugin.getResourceIcon("kalarm.png", 16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewPrevAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewNextAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.submitAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected void buildMainComponentTabs(JTabbedPane jTabbedPane) {
        this.typePanels = new EnumMap<DbCalendarEntry.Type, CalendarEntryPanel>(DbCalendarEntry.Type.class);
        for (DbCalendarEntry.Type abstractTabArray : DbCalendarEntry.Type.values()) {
            CalendarEntryPanel calendarEntryPanel = abstractTabArray.createEntryPanel(true);
            if (calendarEntryPanel == null) continue;
            this.typePanels.put(abstractTabArray, calendarEntryPanel);
        }
        try {
            for (EntryViewExtension entryViewExtension : this.addons) {
                AbstractTab[] abstractTabArray = entryViewExtension.createTabs();
                if (ArrayUtils.isEmpty((Object[])abstractTabArray)) continue;
                for (AbstractTab abstractTab : abstractTabArray) {
                    ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)abstractTab, (JTabbedPane)jTabbedPane);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load addon-panels!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        this.protocolPanel = (ProtocolPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new ProtocolPanel(this.addons), (JTabbedPane)jTabbedPane);
        this.notesPanel = (NotesPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new NotesPanel(), (JTabbedPane)jTabbedPane);
    }

    public static CalendarEntryViewPanel createTab() {
        return CalendarEntryViewPanel.createTab((DbCalendarEntry.Type)null);
    }

    public static CalendarEntryViewPanel createTab(DbCalendarEntry.Type type) {
        CalendarEntryViewPanel calendarEntryViewPanel = new CalendarEntryViewPanel();
        calendarEntryViewPanel.setEntry(type != null ? type : DbCalendarEntry.Type.VEVENT);
        return calendarEntryViewPanel;
    }

    public static CalendarEntryViewPanel createTab(DbCalendarEntry dbCalendarEntry) {
        CalendarEntryViewPanel calendarEntryViewPanel = new CalendarEntryViewPanel();
        calendarEntryViewPanel.setEntry(dbCalendarEntry);
        return calendarEntryViewPanel;
    }

    protected void doCopy() {
        if (this.currentEntry == null || this.currentEntry.id < 1L) {
            return;
        }
        if (!this.mayEditEntry) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), true));
    }

    protected void doHelp() {
        ImmoToolAppUtils.showManual((String)"calendar.entries.form", null);
    }

    protected void doLoadInBackground(Connection connection) throws Exception {
        Object object;
        DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
        DbCalendarGroup dbCalendarGroup = dbCalendarHandler.getGroup(connection, this.currentEntry.groupId);
        if (dbCalendarGroup == null) {
            LOGGER.warn("Can't find calendar group for entry #" + this.currentEntry.id + "!");
        } else if (dbCalendarGroup.permission != null) {
            object = ImmoToolProject.getAppInstance().getUser();
            this.mayEditEntry = this.mayEditEntry && dbCalendarGroup.permission.canWrite(object, dbCalendarGroup.ownerUserId, dbCalendarGroup.ownerGroupId);
            this.mayRemoveEntry = this.mayRemoveEntry && dbCalendarGroup.permission.canWrite(object, dbCalendarGroup.ownerUserId, dbCalendarGroup.ownerGroupId);
        }
        this.nextEntryId = 0L;
        this.prevEntryId = 0L;
        try {
            object = dbCalendarHandler.getEntryIds(connection);
            int n = ArrayUtils.indexOf((long[])object, (long)this.currentEntry.id);
            if (n > 0) {
                this.prevEntryId = (long)object[n - 1];
            }
            if (n + 1 < ((DbUser)object).length) {
                this.nextEntryId = (long)object[n + 1];
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load previous & next dataset!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void doRefresh() {
        if (this.currentEntry != null && this.currentEntry.id > 0L) {
            this.setEntry(this.currentEntry);
            this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
        }
    }

    protected void doRemove() {
        if (this.currentEntry == null || this.currentEntry.id < 1L) {
            return;
        }
        if (!this.mayRemoveEntry) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove calendar entry {0}?", (Object)("#" + this.currentEntry.id)), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new RemoveTask(ImmoToolProject.getAppInstance().getDbDriver(), CalendarPlugin.getDbCalendarExtension().getCalendarHandler(), this.currentEntry.id));
    }

    protected void doShowActions(Component component, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)this.createDefaultCopyAction(this.currentEntry != null && this.currentEntry.id > 0L && CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_EDIT)));
        jPopupMenu.add((Action)this.createDefaultRemoveAction(this.currentEntry != null && this.currentEntry.id > 0L && this.mayRemoveEntry));
        boolean bl = false;
        for (EntryViewExtension entryViewExtension : this.addons) {
            Object[] objectArray = entryViewExtension.createActionMenuItems(this.currentEntry);
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                if (!bl) {
                    bl = true;
                    jPopupMenu.addSeparator();
                }
                jPopupMenu.add((JMenuItem)object);
            }
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)this.notesPanel.notesField.getPrintAction());
        jPopupMenu.show(component, n, n2);
    }

    protected void doSubmit() {
        if (!this.mayEditEntry) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), false));
    }

    protected void doViewNext() {
        if (this.nextEntryId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new CalendarEntryViewTask(ImmoToolProject.getAppInstance().getDbDriver(), this.nextEntryId, this));
        }
    }

    protected void doViewPrevious() {
        if (this.prevEntryId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new CalendarEntryViewTask(ImmoToolProject.getAppInstance().getDbDriver(), this.prevEntryId, this));
        }
    }

    public long getCurrentEntryId() {
        return this.currentEntry != null ? this.currentEntry.id : 0L;
    }

    public DbCalendarEntry.Type getCurrentEntryType() {
        return this.currentType;
    }

    protected Icon getHeaderIcon() {
        return CalendarPlugin.getResourceIcon("kalarm.png", 32);
    }

    protected String getHeaderTitle() {
        if (this.currentEntry == null || this.currentEntry.id < 1L) {
            return StringUtils.capitalize((String)I18N.tr("new calendar entry"));
        }
        if (this.currentType != null) {
            return StringUtils.capitalize((String)this.currentType.getTranslation()) + " #" + this.currentEntry.id;
        }
        return StringUtils.capitalize((String)I18N.tr("calendar entry")) + " #" + this.currentEntry.id;
    }

    public String getTabTitle() {
        if (this.currentEntry == null || this.currentEntry.id < 1L) {
            if (DbCalendarEntry.Type.VEVENT.equals((Object)this.currentType)) {
                return StringUtils.capitalize((String)I18N.tr("new event"));
            }
            if (DbCalendarEntry.Type.VTODO.equals((Object)this.currentType)) {
                return StringUtils.capitalize((String)I18N.tr("new task"));
            }
            return StringUtils.capitalize((String)I18N.tr("new calendar entry"));
        }
        if (this.currentType != null) {
            return StringUtils.capitalize((String)this.currentType.getTranslation()) + " #" + this.currentEntry.id;
        }
        return StringUtils.capitalize((String)I18N.tr("calendar entry")) + " #" + this.currentEntry.id;
    }

    public String getTabToolTipText() {
        if (this.currentEntry == null || this.currentEntry.id < 1L) {
            return I18N.tr("Create a new calendar entry.");
        }
        return I18N.tr("Edit calendar entry {0}.", (Object)("#" + this.currentEntry.id));
    }

    protected void init() {
        super.init();
        this.addons = new ArrayList<EntryViewExtension>();
        try {
            for (EntryViewExtension entryViewExtension : CalendarPluginUtils.getEntryViewExtensions()) {
                this.addons.add(entryViewExtension);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load addons!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    protected boolean isLoadedInBackground() {
        return this.currentEntry != null && this.currentEntry.id > 0L;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.submitAction.setEnabled(bl && this.mayEditEntry);
        this.closeAction.setEnabled(bl);
        this.helpAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl);
        this.viewNextAction.setEnabled(bl && this.nextEntryId > 0L);
        this.viewPrevAction.setEnabled(bl && this.prevEntryId > 0L);
    }

    public void setCalendarId(Long l) {
        for (CalendarEntryPanel calendarEntryPanel : this.typePanels.values()) {
            calendarEntryPanel.setCalendarId(l);
        }
    }

    public void setDate(Date date) {
        for (CalendarEntryPanel calendarEntryPanel : this.typePanels.values()) {
            calendarEntryPanel.setDate(date);
        }
    }

    public void setDateInterval(Date date, Date date2) {
        for (CalendarEntryPanel calendarEntryPanel : this.typePanels.values()) {
            calendarEntryPanel.setDateInterval(date, date2);
        }
    }

    public void setEntry(DbCalendarEntry.Type type) {
        if (type == null) {
            throw new IllegalArgumentException("No calendar entry type was provided!");
        }
        this.setEntry(type.createEntry(), type);
    }

    public void setEntry(DbCalendarEntry dbCalendarEntry) {
        if (dbCalendarEntry == null) {
            throw new IllegalArgumentException("No calendar entry was provided!");
        }
        if (dbCalendarEntry.getType() == null) {
            throw new IllegalArgumentException("No calendar entry type was provided!");
        }
        this.setEntry(dbCalendarEntry, dbCalendarEntry.getType());
    }

    private void setEntry(DbCalendarEntry dbCalendarEntry, DbCalendarEntry.Type type) {
        this.setEntryType(type);
        this.currentEntry = dbCalendarEntry;
        this.nextEntryId = 0L;
        this.prevEntryId = 0L;
        if (this.currentEntry != null && this.currentEntry.getComponent() == null) {
            this.currentEntry.setEmptyComponent();
        }
        this.mayEditEntry = CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_EDIT);
        this.mayRemoveEntry = CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_REMOVE);
        for (AbstractMainViewTab abstractMainViewTab : this.getTabs()) {
            int n = this.indexOf(abstractMainViewTab);
            if (n < 0) continue;
            this.getTabbedPane().setEnabledAt(n, false);
            try {
                ((AbstractTab)abstractMainViewTab).load(this.currentEntry);
            }
            catch (Exception exception) {
                LOGGER.error("Can't load tab '" + abstractMainViewTab.getTabTitle() + "'!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.updateLocalization();
    }

    private void setEntryType(DbCalendarEntry.Type type) {
        if (type == null) {
            throw new IllegalArgumentException("No calendar entry type was provided!");
        }
        if (!this.typePanels.containsKey((Object)type)) {
            throw new IllegalArgumentException("The calendar entry type \"" + (Object)((Object)type) + "\" is not supported!");
        }
        if (type.equals((Object)this.currentType)) {
            return;
        }
        this.currentType = type;
        for (CalendarEntryPanel calendarEntryPanel : this.typePanels.values()) {
            int n = this.indexOf(calendarEntryPanel);
            if (n <= -1) continue;
            this.getTabbedPane().remove(n);
        }
        Object object = this.typePanels.get((Object)type);
        this.getTabbedPane().insertTab(object.getTabTitle(), object.getTabIcon(), (Component)object, object.getTabToolTipText(), 0);
        this.getTabbedPane().setSelectedIndex(0);
    }

    protected void tabComponentAdded(ContainerEvent containerEvent) {
        super.tabComponentAdded(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(this);
        }
    }

    protected void tabComponentRemoved(ContainerEvent containerEvent) {
        super.tabComponentRemoved(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(null);
        }
    }

    private class SubmitTask
    extends ImmoToolTask<DbCalendarEntry, Void> {
        private final AbstractMainViewTab[] tabs;
        private final boolean saveAsCopy;

        public SubmitTask(AbstractMainViewTab[] abstractMainViewTabArray, boolean bl) {
            this.tabs = abstractMainViewTabArray;
            this.saveAsCopy = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbCalendarEntry doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
            DbCalendarEntryLogHandler dbCalendarEntryLogHandler = CalendarPlugin.getDbCalendarExtension().getCalendarEntryLogHandler();
            Connection connection = null;
            try {
                DbCalendarEntry dbCalendarEntry;
                String string;
                connection = immoToolProject.getDbConnection();
                if (CalendarEntryViewPanel.this.currentEntry == null || ((CalendarEntryViewPanel)CalendarEntryViewPanel.this).currentEntry.id < 1L || this.saveAsCopy) {
                    string = "ADD";
                    dbCalendarEntry = CalendarEntryViewPanel.this.currentType.createEntry();
                } else {
                    string = "EDIT";
                    dbCalendarEntry = dbCalendarHandler.getEntry(connection, ((CalendarEntryViewPanel)CalendarEntryViewPanel.this).currentEntry.id);
                    if (dbCalendarEntry == null) {
                        throw new Exception("Can't load calendar entry #" + ((CalendarEntryViewPanel)CalendarEntryViewPanel.this).currentEntry.id + "!");
                    }
                }
                if (dbCalendarEntry.getComponent() == null) {
                    dbCalendarEntry.setEmptyComponent();
                }
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    ((AbstractTab)abstractMainViewTab).save(dbCalendarEntry);
                }
                dbCalendarEntry.updateIcalFieldFromComponent();
                dbCalendarHandler.saveEntry(connection, dbCalendarEntry);
                if (string != null) {
                    DbCalendarEntryLog dbCalendarEntryLog = DbCalendarEntryLog.create(dbCalendarEntry.id, string, immoToolProject.getUser());
                    if ("EDIT".equals(string)) {
                        dbCalendarEntryLog.initChanges(CalendarEntryViewPanel.this.currentEntry, dbCalendarEntry, dbCalendarEntry.getType());
                    }
                    dbCalendarEntryLogHandler.saveLog(connection, dbCalendarEntryLog);
                }
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    ((AbstractTab)abstractMainViewTab).saveFinished(connection, immoToolProject, dbCalendarEntry);
                }
                DbCalendarEntry dbCalendarEntry2 = dbCalendarEntry;
                return dbCalendarEntry2;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't save calendar entry!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            CalendarEntryViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(DbCalendarEntry dbCalendarEntry) {
            super.succeeded((Object)dbCalendarEntry);
            if (dbCalendarEntry == null) {
                return;
            }
            CalendarEntryViewPanel.this.setEntry(dbCalendarEntry);
            CalendarEntryViewPanel.this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
        }
    }

    private class RemoveTask
    extends CalendarEntryRemoveTask {
        public RemoveTask(AbstractDbDriver abstractDbDriver, DbCalendarHandler dbCalendarHandler, long l) {
            super(abstractDbDriver, dbCalendarHandler, l);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't delete calendar entry!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            CalendarEntryViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            ImmoToolAppUtils.removeTab((Component)((Object)CalendarEntryViewPanel.this), (boolean)true);
        }
    }

    private static class ProtocolTablePanel
    extends ImmoToolLogTablePanel {
        public ProtocolTablePanel() {
            super((DbLogHandler)CalendarPlugin.getDbCalendarExtension().getCalendarEntryLogHandler());
            this.setBorder((Border)Paddings.DIALOG);
        }

        protected String getActionTranslation(String string) {
            String string2 = DbCalendarEntryLog.writeAction(string);
            return string2 != null ? string2 : string;
        }
    }

    private final class ProtocolPanel
    extends AbstractTab {
        private JXTitledSeparator title;
        private JTabbedPane protocolTabPanel;
        private List<AbstractTab> addonTabs;
        private ProtocolTablePanel logTablePanel;

        public ProtocolPanel(List<EntryViewExtension> list) {
            this.build(list);
            this.updateLocalization();
        }

        private void build(List<EntryViewExtension> list) {
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.addonTabs = new ArrayList<AbstractTab>();
            this.protocolTabPanel = new JTabbedPane();
            this.protocolTabPanel.addContainerListener(new ContainerListener(){

                @Override
                public void componentAdded(ContainerEvent containerEvent) {
                    CalendarEntryViewPanel.this.tabComponentAdded(containerEvent);
                }

                @Override
                public void componentRemoved(ContainerEvent containerEvent) {
                    CalendarEntryViewPanel.this.tabComponentRemoved(containerEvent);
                }
            });
            for (EntryViewExtension entryViewExtension : list) {
                try {
                    AbstractTab[] abstractTabArray = entryViewExtension.createActionTabs();
                    if (ArrayUtils.isEmpty((Object[])abstractTabArray)) continue;
                    for (AbstractTab abstractTab : abstractTabArray) {
                        ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)abstractTab, (JTabbedPane)this.protocolTabPanel);
                        this.addonTabs.add(abstractTab);
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load addon-tabs");
                    LOGGER.warn("> for " + entryViewExtension.getClass().getName());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            this.logTablePanel = new ProtocolTablePanel();
            this.protocolTabPanel.addTab(this.logTablePanel.getTitle(), (Component)((Object)this.logTablePanel));
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.title, "North");
            this.add(this.protocolTabPanel, "Center");
        }

        public void doLoadInBackground(Connection connection) throws Exception {
            this.logTablePanel.doLoadInBackground(connection);
            for (AbstractTab abstractTab : this.addonTabs) {
                if (!abstractTab.isLoadedInBackground()) continue;
                abstractTab.doLoadInBackground(connection);
            }
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("actions"));
        }

        public boolean isTabEnabled() {
            return this.logTablePanel.isLoaded();
        }

        public boolean isTabUsable() {
            return this.protocolTabPanel.getTabCount() > 0;
        }

        public boolean isTabValid() {
            for (AbstractTab abstractTab : this.addonTabs) {
                if (abstractTab.isTabValid()) continue;
                return false;
            }
            return true;
        }

        public boolean isLoadedInBackground() {
            return true;
        }

        @Override
        public void load(DbCalendarEntry dbCalendarEntry) throws Exception {
            this.logTablePanel.setLogEntryId(dbCalendarEntry != null ? dbCalendarEntry.id : 0L);
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.load(dbCalendarEntry);
            }
        }

        @Override
        public void save(DbCalendarEntry dbCalendarEntry) throws Exception {
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.save(dbCalendarEntry);
            }
        }

        @Override
        public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbCalendarEntry dbCalendarEntry) throws SQLException, IOException {
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.saveFinished(connection, immoToolProject, dbCalendarEntry);
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("actions for the calendar entry")));
        }
    }

    private final class NotesPanel
    extends AbstractTab {
        private ModificationHandler modificationHandler;
        private JXTitledSeparator title;
        private DefaultTextArea notesField;

        private NotesPanel() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.modificationHandler = ImmoToolUtils.createModificationHandler();
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.notesField = new DefaultTextArea();
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.title, "North");
            this.add(this.notesField.createScrollPane(), "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("notes"));
        }

        public boolean isTabModified() {
            return this.modificationHandler.isModified();
        }

        @Override
        public void load(DbCalendarEntry dbCalendarEntry) throws Exception {
            this.notesField.setText(dbCalendarEntry != null ? StringUtils.trimToEmpty((String)dbCalendarEntry.notes) : "");
            this.notesField.setCaretPosition(0);
            this.modificationHandler.clear();
            this.modificationHandler.putValue((JComponent)this.notesField);
        }

        @Override
        public void save(DbCalendarEntry dbCalendarEntry) throws Exception {
            dbCalendarEntry.setNotes(this.notesField.getText().trim());
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("notes about the calendar entry")));
        }
    }

    public static abstract class AbstractTab
    extends AbstractMainViewTab {
        private WeakReference<CalendarEntryViewPanel> viewPanel = null;

        public CalendarEntryViewPanel getViewPanel() {
            return this.viewPanel != null ? (CalendarEntryViewPanel)((Object)this.viewPanel.get()) : null;
        }

        public abstract void load(DbCalendarEntry var1) throws Exception;

        public abstract void save(DbCalendarEntry var1) throws Exception;

        public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbCalendarEntry dbCalendarEntry) throws SQLException, IOException {
        }

        public void setViewPanel(CalendarEntryViewPanel calendarEntryViewPanel) {
            this.viewPanel = calendarEntryViewPanel != null ? new WeakReference<CalendarEntryViewPanel>(calendarEntryViewPanel) : null;
        }
    }
}

