/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolSettings;
import com.openindex.openestate.tool.ImmoToolSetupDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarExtension;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class CalendarSetupGeneralPanel
extends ImmoToolSetupDialog.AbstractForm {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarSetupGeneralPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarSetupGeneralPanel.class);
    private ValidationHandler validationHandler;
    private JXTitledSeparator worktimeTitleLabel;
    private JLabel worktimeInfoLabel;
    private JLabel worktimeBeginLabel;
    private JSpinner worktimeBeginField;
    private JLabel worktimeEndLabel;
    private JSpinner worktimeEndField;
    private JXTitledSeparator virtualCalendarTitleLabel;
    private JLabel virtualCalendarInfoLabel;
    private List<VirtualCalendarBox> virtualCalendarBoxes;

    public CalendarSetupGeneralPanel() {
        this.build();
        this.updateLocalization();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.worktimeTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.worktimeInfoLabel = new JLabel();
        this.worktimeBeginLabel = new JLabel();
        this.worktimeBeginField = new JSpinner();
        this.worktimeBeginField.setModel(new SpinnerDateModel(new Date(), null, null, 11));
        this.worktimeBeginField.setEditor(new JSpinner.DateEditor(this.worktimeBeginField, "HH:mm"));
        this.worktimeEndLabel = new JLabel();
        this.worktimeEndField = new JSpinner();
        this.worktimeEndField.setModel(new SpinnerDateModel(new Date(), null, null, 11));
        this.worktimeEndField.setEditor(new JSpinner.DateEditor(this.worktimeEndField, "HH:mm"));
        this.virtualCalendarTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.virtualCalendarInfoLabel = new JLabel();
        this.virtualCalendarBoxes = new ArrayList<VirtualCalendarBox>();
        for (VirtualCalendarExtension object : CalendarPluginUtils.getVirtualCalendarExtensions()) {
            VirtualCalendarBox virtualCalendarBox = new VirtualCalendarBox(object);
            this.virtualCalendarBoxes.add(virtualCalendarBox);
        }
        this.validationHandler.putRule((JComponent)this.worktimeBeginField, new ValidationRule(){

            public boolean isValid(Object object) {
                Date date = (Date)object;
                if (date == null) {
                    return false;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.set(1, 2000);
                calendar.set(6, 1);
                calendar.set(14, 0);
                Date date2 = (Date)CalendarSetupGeneralPanel.this.worktimeEndField.getValue();
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTime(date2);
                calendar2.set(1, 2000);
                calendar2.set(6, 1);
                calendar2.set(14, 0);
                return calendar.before(calendar2);
            }
        });
        this.validationHandler.putRule((JComponent)this.worktimeEndField, new ValidationRule(){

            public boolean isValid(Object object) {
                Date date = (Date)CalendarSetupGeneralPanel.this.worktimeBeginField.getValue();
                if (date == null) {
                    return false;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.set(1, 2000);
                calendar.set(6, 1);
                calendar.set(14, 0);
                Date date2 = (Date)object;
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTime(date2);
                calendar2.set(1, 2000);
                calendar2.set(6, 1);
                calendar2.set(14, 0);
                return calendar2.after(calendar);
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 30dlu:grow", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.worktimeTitleLabel).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.worktimeInfoLabel).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.worktimeBeginLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.worktimeBeginField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.worktimeEndLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.worktimeEndField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.virtualCalendarTitleLabel).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.virtualCalendarInfoLabel).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        for (VirtualCalendarBox virtualCalendarBox : this.virtualCalendarBoxes) {
            defaultFormBuilder.add((Component)virtualCalendarBox).xyw(1, defaultFormBuilder.nextRow(), 7);
        }
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("calendar"));
    }

    public boolean isFormValid() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    public boolean isProjectRequired() {
        return true;
    }

    public void load(ImmoToolSettings immoToolSettings, ImmoToolProject immoToolProject, Connection connection) throws SQLException, IOException {
        CalendarPlugin.loadSettings(immoToolProject, connection);
        this.worktimeBeginField.setValue(CalendarPlugin.getWorktimeBegin().getTime());
        this.worktimeEndField.setValue(CalendarPlugin.getWorktimeEnd().getTime());
        for (VirtualCalendarBox virtualCalendarBox : this.virtualCalendarBoxes) {
            virtualCalendarBox.setSelected(CalendarPlugin.isVirtualCalendarEnabled(virtualCalendarBox.getExtension()));
        }
        this.validationHandler.validate();
    }

    public void save(ImmoToolSettings immoToolSettings, ImmoToolProject immoToolProject, Connection connection) throws SQLException, IOException {
        CalendarPlugin.setWorktimeBegin((Date)this.worktimeBeginField.getValue());
        CalendarPlugin.setWorktimeEnd((Date)this.worktimeEndField.getValue());
        ArrayList<VirtualCalendarExtension> arrayList = new ArrayList<VirtualCalendarExtension>();
        for (VirtualCalendarBox virtualCalendarBox : this.virtualCalendarBoxes) {
            if (!virtualCalendarBox.isSelected()) continue;
            arrayList.add(virtualCalendarBox.getExtension());
        }
        CalendarPlugin.setVirtualCalendars(arrayList);
        CalendarPlugin.saveSettings(connection, immoToolProject.getUser(), immoToolProject.getDbExtension());
        new CalendarPlugin.SidebarRefreshAction().actionPerformed(null);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.worktimeTitleLabel.setTitle(StringUtils.capitalize((String)I18N.tr("time of work")));
        this.worktimeInfoLabel.setText("<html>" + I18N.tr("The calendar views are narrowed down to your time of work.") + "</html>");
        this.worktimeBeginLabel.setText(StringUtils.capitalize((String)I18N.tr("begin")) + ":");
        this.worktimeBeginField.setToolTipText(I18N.tr("Enter the beginning of your working time."));
        this.worktimeEndLabel.setText(StringUtils.capitalize((String)I18N.tr("end")) + ":");
        this.worktimeEndField.setToolTipText(I18N.tr("Enter the ending of your working time."));
        this.virtualCalendarTitleLabel.setTitle(StringUtils.capitalize((String)I18N.tr("virtual calendars")));
        this.virtualCalendarInfoLabel.setText("<html>" + I18N.tr("Other addons may provide additional calendars.") + " " + I18N.tr("These virtual calendars can be enabled when needed.") + "</html>");
        for (VirtualCalendarBox virtualCalendarBox : this.virtualCalendarBoxes) {
            virtualCalendarBox.updateLocalization();
        }
    }

    private static final class VirtualCalendarBox
    extends JCheckBox {
        private final VirtualCalendarExtension extension;

        public VirtualCalendarBox(VirtualCalendarExtension virtualCalendarExtension) {
            this.extension = virtualCalendarExtension;
            this.setVerticalTextPosition(1);
            this.setOpaque(false);
            this.setBackground(Color.WHITE);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    super.mouseEntered(mouseEvent);
                    VirtualCalendarBox.this.setOpaque(true);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    super.mouseExited(mouseEvent);
                    VirtualCalendarBox.this.setOpaque(false);
                }
            });
            this.updateLocalization();
        }

        public VirtualCalendarExtension getExtension() {
            return this.extension;
        }

        protected void updateLocalization() {
            String string = "<b>" + StringEscapeUtils.escapeXml11((String)((String)StringUtils.defaultIfBlank((CharSequence)StringUtils.trimToEmpty((String)this.extension.getTitle()), (CharSequence)ClassUtils.getShortClassName(this.extension.getClass())))) + "</b>";
            String string2 = StringUtils.trimToNull((String)this.extension.getToolTip());
            if (string2 != null) {
                string = string + "<br>" + StringEscapeUtils.escapeXml11((String)this.extension.getToolTip());
            }
            this.setText("<html>" + string + "</html>");
        }
    }
}

