/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarEventEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarGroup;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.calendar.db.DbCalendarTodoEntry;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.utils.HttpUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.sql.Connection;
import java.util.ArrayList;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Uid;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CalendarSyncTask
extends ImmoToolTask<Boolean, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarSyncTask.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarSyncTask.class);
    private final DbCalendarGroup calendarGroup;
    private final AbstractDbDriver dbDriver;
    private final DbCalendarHandler calendarHandler;

    public CalendarSyncTask(AbstractDbDriver abstractDbDriver, DbCalendarHandler dbCalendarHandler, DbCalendarGroup dbCalendarGroup) {
        super(I18N.tr("Synchronising calendar."));
        this.dbDriver = abstractDbDriver;
        this.calendarHandler = dbCalendarHandler;
        this.calendarGroup = dbCalendarGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    protected Boolean doInBackground() throws Exception {
        Uid uid;
        Object object;
        CalendarBuilder calendarBuilder;
        Object object2;
        Object object3;
        Object object4;
        if (this.calendarGroup == null) {
            throw new NullPointerException("No calendar-group defined!");
        }
        Calendar calendar = null;
        if (DbCalendarGroup.Type.FILE.equals((Object)this.calendarGroup.type)) {
            object4 = new File(this.calendarGroup.url);
            if (!((File)object4).isFile()) {
                throw new IllegalArgumentException("Can't find calendar file!");
            }
            this.setMessage(I18N.tr("Process file:") + " " + StringUtils.abbreviateMiddle((String)((File)object4).getAbsolutePath(), (String)"...", (int)50));
            object3 = new InputStreamReader((InputStream)new FileInputStream((File)object4), "UTF-8");
            object2 = null;
            try {
                calendarBuilder = new CalendarBuilder();
                calendar = calendarBuilder.build((Reader)object3);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object3 != null) {
                    if (object2 != null) {
                        try {
                            ((Reader)object3).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((Reader)object3).close();
                    }
                }
            }
        }
        if (DbCalendarGroup.Type.URL.equals((Object)this.calendarGroup.type)) {
            object4 = this.calendarGroup.url;
            if (object4 == null) {
                throw new IllegalArgumentException("No calendar URL provided!");
            }
            object4 = ImmoToolUtils.toIdnUrl((URI)object4);
            this.setMessage(I18N.tr("Process URL:") + " " + StringUtils.abbreviateMiddle((String)((URI)object4).toString(), (String)"...", (int)50));
            object3 = HttpUtils.builder();
            if (DbCalendarGroup.AuthMethod.HTTP_BASIC.equals((Object)this.calendarGroup.authMethod)) {
                object3.setDefaultCredentialsProvider(HttpUtils.createAuthentication((String)this.calendarGroup.authUser, (String)String.valueOf(this.calendarGroup.authPass)));
            }
            object2 = null;
            try {
                calendarBuilder = object3.build();
                object = null;
                try {
                    uid = calendarBuilder.execute((HttpUriRequest)new HttpGet((URI)object4));
                    object2 = uid.getEntity();
                    calendar = new CalendarBuilder().build(object2.getContent());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (calendarBuilder != null) {
                        if (object != null) {
                            try {
                                calendarBuilder.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            calendarBuilder.close();
                        }
                    }
                }
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)object2);
            }
        }
        if (calendar == null) {
            throw new RuntimeException("No external calendar was loaded!");
        }
        this.setMessage(I18N.tr("Merging calendars."));
        object4 = null;
        try {
            object4 = this.dbDriver.getConnection();
            object3 = new ArrayList();
            object2 = calendar.getComponents();
            for (int i = 0; i < object2.size(); ++i) {
                long l;
                object = (Component)object2.get(i);
                uid = (Uid)object.getProperty("UID");
                if (uid == null) {
                    LOGGER.debug("Remote component without uid!");
                    this.setMessage("Remote component without uid!");
                    continue;
                }
                DbCalendarEntry dbCalendarEntry = this.calendarHandler.getEntry((Connection)object4, this.calendarGroup.id, uid.getValue());
                long l2 = l = dbCalendarEntry != null ? dbCalendarEntry.id : 0L;
                if (object instanceof VEvent) {
                    if (dbCalendarEntry == null || !DbCalendarEntry.Type.VEVENT.equals((Object)dbCalendarEntry.getType())) {
                        dbCalendarEntry = new DbCalendarEventEntry();
                    }
                } else if (object instanceof VToDo) {
                    if (dbCalendarEntry == null || !DbCalendarEntry.Type.VTODO.equals((Object)dbCalendarEntry.getType())) {
                        dbCalendarEntry = new DbCalendarTodoEntry();
                    }
                } else {
                    LOGGER.debug("Remote component is not supported: " + object.getName());
                    this.setMessage("Remote component is not supported: " + object.getName());
                    continue;
                }
                dbCalendarEntry.setComponent((Component)object);
                dbCalendarEntry.updateFieldsFromComponent();
                dbCalendarEntry.groupId = this.calendarGroup.id;
                dbCalendarEntry.id = l;
                try {
                    this.calendarHandler.saveEntry((Connection)object4, dbCalendarEntry);
                    object3.add(dbCalendarEntry.id);
                    if (l > 0L) {
                        this.setMessage("Updated entry #" + dbCalendarEntry.id);
                        continue;
                    }
                    this.setMessage("Added entry #" + dbCalendarEntry.id);
                    continue;
                }
                catch (Exception exception) {
                    if (l > 0L) {
                        this.setMessage("Can't update calendar entry #" + l + ": " + exception.getLocalizedMessage());
                    } else {
                        this.setMessage("Can't add calendar entry: " + exception.getLocalizedMessage());
                    }
                    LOGGER.warn("Can't import calendar entry!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            for (long l : this.calendarHandler.getEntryIds((Connection)object4, new long[]{this.calendarGroup.id})) {
                if (object3.contains(l)) continue;
                this.setMessage("Remove entry #" + l);
                this.calendarHandler.removeEntry((Connection)object4, l);
            }
            Object object5 = true;
            return object5;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)object4);
        }
    }
}

