/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar.db;

import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarEventEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarTodoEntry;
import com.openindex.openestate.tool.db.DbLog;
import com.openindex.openestate.tool.db.DbUser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.DateFormat;
import java.util.HashMap;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.PercentComplete;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.Status;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbCalendarEntryLog
extends DbLog {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbCalendarEntryLog.class);
    private static final I18n I18N = I18nFactory.getI18n(DbCalendarEntryLog.class);
    public static final String TYPE = "Calendar.Entry";
    private static final String CHANGE_ENTY_BEGIN = "begin";
    private static final String CHANGE_ENTY_END = "end";
    private static final String CHANGE_ENTY_LATITUDE = "latitude";
    private static final String CHANGE_ENTY_LONGITUDE = "longitude";
    private static final String CHANGE_ENTY_LOCATION = "location";
    private static final String CHANGE_ENTY_NOTES = "notes";
    private static final String CHANGE_ENTY_PRIORITY = "priority";
    private static final String CHANGE_ENTY_STATUS = "status";
    private static final String CHANGE_ENTY_TITLE = "title";
    private static final String CHANGE_GROUP_ID = "groupId";
    public long entryId = 0L;

    public DbCalendarEntryLog() {
        this.entryType = TYPE;
    }

    public static DbCalendarEntryLog create(long l, String string, DbUser dbUser) {
        DbCalendarEntryLog dbCalendarEntryLog = new DbCalendarEntryLog();
        dbCalendarEntryLog.entryId = l;
        dbCalendarEntryLog.entryAction = string;
        dbCalendarEntryLog.createdBy = dbUser != null ? dbUser.writeName() : null;
        dbCalendarEntryLog.modifiedBy = dbUser != null ? dbUser.writeName() : null;
        return dbCalendarEntryLog;
    }

    public final String getPluginName() {
        return "OpenEstate-Tool-Calendar";
    }

    public void initChanges(DbCalendarEntry dbCalendarEntry, DbCalendarEntry dbCalendarEntry2, DbCalendarEntry.Type type) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
        this.changes = new HashMap();
        this.putChangedGroupId(dbCalendarEntry != null ? Long.valueOf(dbCalendarEntry.groupId) : null, dbCalendarEntry2 != null ? Long.valueOf(dbCalendarEntry2.groupId) : null);
        this.putChangedStatus(dbCalendarEntry != null ? dbCalendarEntry.status : null, dbCalendarEntry2 != null ? dbCalendarEntry2.status : null, type);
        String string = dbCalendarEntry != null ? String.valueOf(dbCalendarEntry.title) : null;
        String string2 = dbCalendarEntry2 != null ? String.valueOf(dbCalendarEntry2.title) : null;
        this.addChange(CHANGE_ENTY_TITLE, string, string2);
        string = dbCalendarEntry != null && dbCalendarEntry.begin != null ? dateFormat.format(dbCalendarEntry.begin) : null;
        string2 = dbCalendarEntry2 != null && dbCalendarEntry2.begin != null ? dateFormat.format(dbCalendarEntry2.begin) : null;
        this.addChange(CHANGE_ENTY_BEGIN, string, string2);
        string = dbCalendarEntry != null && dbCalendarEntry.end != null ? dateFormat.format(dbCalendarEntry.end) : null;
        string2 = dbCalendarEntry2 != null && dbCalendarEntry2.end != null ? dateFormat.format(dbCalendarEntry2.end) : null;
        this.addChange(CHANGE_ENTY_END, string, string2);
        string = dbCalendarEntry != null ? dbCalendarEntry.notes : null;
        string2 = dbCalendarEntry2 != null ? dbCalendarEntry2.notes : null;
        this.addChange(CHANGE_ENTY_NOTES, string, string2);
        if (dbCalendarEntry instanceof DbCalendarEventEntry || dbCalendarEntry2 instanceof DbCalendarEventEntry) {
            VEvent vEvent = dbCalendarEntry != null ? ((DbCalendarEventEntry)dbCalendarEntry).getComponent() : null;
            VEvent vEvent2 = dbCalendarEntry2 != null ? ((DbCalendarEventEntry)dbCalendarEntry2).getComponent() : null;
            this.putChangedPriority(vEvent != null ? vEvent.getPriority() : null, vEvent2 != null ? vEvent2.getPriority() : null);
            this.putChangedLocation(vEvent != null ? vEvent.getLocation() : null, vEvent2 != null ? vEvent2.getLocation() : null);
            this.putChangedGeo(vEvent != null ? vEvent.getGeographicPos() : null, vEvent2 != null ? vEvent2.getGeographicPos() : null);
        } else if (dbCalendarEntry instanceof DbCalendarTodoEntry || dbCalendarEntry2 instanceof DbCalendarTodoEntry) {
            VToDo vToDo = dbCalendarEntry != null ? ((DbCalendarTodoEntry)dbCalendarEntry).getComponent() : null;
            VToDo vToDo2 = dbCalendarEntry2 != null ? ((DbCalendarTodoEntry)dbCalendarEntry2).getComponent() : null;
            this.putChangedPercentComplete(vToDo != null ? vToDo.getPercentComplete() : null, vToDo2 != null ? vToDo2.getPercentComplete() : null);
            this.putChangedPriority(vToDo != null ? vToDo.getPriority() : null, vToDo2 != null ? vToDo2.getPriority() : null);
            this.putChangedLocation(vToDo != null ? vToDo.getLocation() : null, vToDo2 != null ? vToDo2.getLocation() : null);
            this.putChangedGeo(vToDo != null ? vToDo.getGeographicPos() : null, vToDo2 != null ? vToDo2.getGeographicPos() : null);
        }
    }

    public void putChangedGeo(Geo geo, Geo geo2) {
        String string = geo != null ? geo.getLatitude().toString() : null;
        String string2 = geo2 != null ? geo2.getLatitude().toString() : null;
        this.addChange(CHANGE_ENTY_LATITUDE, string, string2);
        string = geo != null ? geo.getLongitude().toString() : null;
        string2 = geo2 != null ? geo2.getLongitude().toString() : null;
        this.addChange(CHANGE_ENTY_LONGITUDE, string, string2);
    }

    public void putChangedGroupId(Long l, Long l2) {
        String string = l != null && l > 0L ? String.valueOf(l) : null;
        String string2 = l2 != null && l2 > 0L ? String.valueOf(l2) : null;
        this.addChange(CHANGE_GROUP_ID, string, string2);
    }

    public void putChangedLocation(Location location, Location location2) {
        String string = location != null ? location.getValue() : null;
        String string2 = location2 != null ? location2.getValue() : null;
        this.addChange(CHANGE_ENTY_LOCATION, string, string2);
    }

    public void putChangedPercentComplete(PercentComplete percentComplete, PercentComplete percentComplete2) {
        String string = percentComplete != null ? percentComplete.getValue() : null;
        String string2 = percentComplete2 != null ? percentComplete2.getValue() : null;
        this.addChange("percentComplete", string, string2);
    }

    public void putChangedPriority(Priority priority, Priority priority2) {
        String string = priority != null ? priority.getValue() : null;
        String string2 = priority2 != null ? priority2.getValue() : null;
        this.addChange(CHANGE_ENTY_PRIORITY, string, string2);
    }

    public void putChangedStatus(Status status, Status status2, DbCalendarEntry.Type type) {
        String string = status != null ? status.getValue() : null;
        String string2 = status2 != null ? status2.getValue() : null;
        this.addChange(CHANGE_ENTY_STATUS, string + "." + type.name(), string2 + "." + type.name());
    }

    public String writeAction() {
        return DbCalendarEntryLog.writeAction(this.entryAction);
    }

    public static String writeAction(String string) {
        if ("ADD".equalsIgnoreCase(string)) {
            return I18N.tr("calendar entry added");
        }
        if ("EDIT".equalsIgnoreCase(string)) {
            return I18N.tr("calendar entry modified");
        }
        return null;
    }

    public String writeChangeKey(String string) {
        if (CHANGE_ENTY_BEGIN.equalsIgnoreCase(string)) {
            return I18N.tr(CHANGE_ENTY_BEGIN);
        }
        if (CHANGE_ENTY_END.equalsIgnoreCase(string)) {
            return I18N.tr(CHANGE_ENTY_END);
        }
        if (CHANGE_ENTY_LATITUDE.equalsIgnoreCase(string)) {
            return I18N.tr(CHANGE_ENTY_LATITUDE);
        }
        if (CHANGE_ENTY_LONGITUDE.equalsIgnoreCase(string)) {
            return I18N.tr(CHANGE_ENTY_LONGITUDE);
        }
        if (CHANGE_ENTY_LOCATION.equalsIgnoreCase(string)) {
            return I18N.tr(CHANGE_ENTY_LOCATION) + "/" + I18N.tr("address");
        }
        if (CHANGE_ENTY_NOTES.equalsIgnoreCase(string)) {
            return I18N.tr(CHANGE_ENTY_NOTES);
        }
        if (CHANGE_ENTY_PRIORITY.equalsIgnoreCase(string)) {
            return I18N.tr(CHANGE_ENTY_PRIORITY);
        }
        if (CHANGE_ENTY_STATUS.equalsIgnoreCase(string)) {
            return I18N.tr(CHANGE_ENTY_STATUS);
        }
        if (CHANGE_ENTY_TITLE.equalsIgnoreCase(string)) {
            return I18N.tr(CHANGE_ENTY_TITLE);
        }
        if (CHANGE_GROUP_ID.equalsIgnoreCase(string)) {
            return I18N.tr("group");
        }
        return super.writeChangeKey(string);
    }

    public String writeChangeValue(String string, String string2) {
        if (CHANGE_ENTY_PRIORITY.equals(string) && !StringUtils.isEmpty((CharSequence)string2)) {
            if (Priority.HIGH.getValue().equalsIgnoreCase(string2)) {
                return DbCalendarEntry.writePriority(Priority.HIGH);
            }
            if (Priority.MEDIUM.getValue().equalsIgnoreCase(string2)) {
                return DbCalendarEntry.writePriority(Priority.MEDIUM);
            }
            if (Priority.LOW.getValue().equalsIgnoreCase(string2)) {
                return DbCalendarEntry.writePriority(Priority.LOW);
            }
            if (Priority.UNDEFINED.getValue().equalsIgnoreCase(string2)) {
                return DbCalendarEntry.writePriority(Priority.UNDEFINED);
            }
        } else if (CHANGE_ENTY_STATUS.equals(string) && !StringUtils.isEmpty((CharSequence)string2)) {
            String string3;
            String[] stringArray = string2.split("\\.");
            String string4 = stringArray[0].trim();
            String string5 = string3 = stringArray.length > 1 ? stringArray[1].trim() : null;
            if (DbCalendarEntry.Type.VEVENT.name().equalsIgnoreCase(string3)) {
                if (Status.VEVENT_CANCELLED.getValue().equalsIgnoreCase(string4)) {
                    return DbCalendarEntry.writeStatusForEvent(Status.VEVENT_CANCELLED);
                }
                if (Status.VEVENT_CONFIRMED.getValue().equalsIgnoreCase(string4)) {
                    return DbCalendarEntry.writeStatusForEvent(Status.VEVENT_CONFIRMED);
                }
                if (Status.VEVENT_TENTATIVE.getValue().equalsIgnoreCase(string4)) {
                    return DbCalendarEntry.writeStatusForEvent(Status.VEVENT_TENTATIVE);
                }
            } else if (DbCalendarEntry.Type.VTODO.name().equalsIgnoreCase(string3)) {
                if (Status.VTODO_CANCELLED.getValue().equalsIgnoreCase(string4)) {
                    return DbCalendarEntry.writeStatusForTodo(Status.VTODO_CANCELLED);
                }
                if (Status.VTODO_COMPLETED.getValue().equalsIgnoreCase(string4)) {
                    return DbCalendarEntry.writeStatusForTodo(Status.VTODO_COMPLETED);
                }
                if (Status.VTODO_IN_PROCESS.getValue().equalsIgnoreCase(string4)) {
                    return DbCalendarEntry.writeStatusForTodo(Status.VTODO_IN_PROCESS);
                }
                if (Status.VTODO_NEEDS_ACTION.getValue().equalsIgnoreCase(string4)) {
                    return DbCalendarEntry.writeStatusForTodo(Status.VTODO_NEEDS_ACTION);
                }
            }
        }
        return super.writeChangeValue(string, string2);
    }
}

