/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar.db;

import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.Permission;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbCalendarGroup
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbCalendarGroup.class);
    private static final I18n I18N = I18nFactory.getI18n(DbCalendarGroup.class);
    public long id = 0L;
    public String name = null;
    public String notes = null;
    public URI url = null;
    public Type type = Type.LOCAL;
    public AuthMethod authMethod = AuthMethod.ANONYMOUS;
    public String authUser = null;
    public char[] authPass = null;
    public Date createdAt = null;
    public Date modifiedAt = null;
    public long ownerUserId = 0L;
    public long ownerGroupId = 0L;
    public Permission permission = null;

    public static enum Type implements Translatable
    {
        LOCAL(I18n.marktr((String)"local")),
        FILE(I18n.marktr((String)"file")),
        URL(I18n.marktr((String)"URL"));

        private final String i18nKey;

        private Type(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(DbCalendarGroup.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(DbCalendarGroup.class, (String)this.i18nKey, (Locale)locale);
        }

        @Deprecated
        public String translate() {
            return this.getTranslation();
        }

        public String write() {
            return this.getTranslation();
        }
    }

    public static enum AuthMethod implements Translatable
    {
        ANONYMOUS(I18n.marktr((String)"no authentication")),
        HTTP_BASIC(I18n.marktr((String)"HTTP-Basic"));

        private final String i18nKey;

        private AuthMethod(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(DbCalendarGroup.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(DbCalendarGroup.class, (String)this.i18nKey, (Locale)locale);
        }

        @Deprecated
        public String translate() {
            return this.getTranslation();
        }

        public String write() {
            return this.getTranslation();
        }
    }
}

