/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar.db;

import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarGroup;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.calendar.extensions.DbCalendarExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.AbstractDbUpdateListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class DbCalendarUpdateListener
extends AbstractDbUpdateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbCalendarUpdateListener.class);
    private static final I18n I18N = I18nFactory.getI18n(DbCalendarUpdateListener.class);

    private static void checkForIncorrectTodoEntries(Connection connection, AbstractDbDriver abstractDbDriver) throws SQLException, ImmoToolException {
        DbCalendarExtension dbCalendarExtension = CalendarPluginUtils.getDbCalendarExtension(abstractDbDriver);
        if (dbCalendarExtension == null) {
            throw new ImmoToolException("Can't find an usable DbCalendarExtension!");
        }
        DbCalendarHandler dbCalendarHandler = dbCalendarExtension.getCalendarHandler();
        for (DbCalendarGroup dbCalendarGroup : dbCalendarHandler.getGroups(connection)) {
            DbCalendarEntry[] dbCalendarEntryArray;
            if (!DbCalendarGroup.Type.LOCAL.equals((Object)dbCalendarGroup.type)) continue;
            for (DbCalendarEntry dbCalendarEntry : dbCalendarEntryArray = dbCalendarHandler.getEntries(connection, null, new DbCalendarEntry.Type[]{DbCalendarEntry.Type.VTODO}, new long[]{dbCalendarGroup.id}, null, null)) {
                if (dbCalendarEntry.end == null) continue;
                LOGGER.info("> Fix end date for todo entry #" + dbCalendarEntry.id);
                dbCalendarEntry.setEndDate(dbCalendarEntry.end);
                dbCalendarEntry.updateIcalFieldFromComponent();
                dbCalendarHandler.saveEntry(connection, dbCalendarEntry);
            }
        }
    }

    public void updateFinished(Connection connection, AbstractDbDriver abstractDbDriver, long l, long l2) throws SQLException, IOException {
        if (l < 4L && l2 >= 4L) {
            try {
                LOGGER.info("Finish updates for OpenEstate-Tool-Calendar (4)");
                DbCalendarUpdateListener.checkForIncorrectTodoEntries(connection, abstractDbDriver);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't update incorrect todo entries!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }
}

