/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntryLog;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntryLogHandler;
import com.openindex.openestate.tool.db.DbLog;
import com.openindex.openestate.tool.db.hsql.HSqlDbLogHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbCalendarEntryLogHandler
extends HSqlDbLogHandler
implements DbCalendarEntryLogHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbCalendarEntryLogHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbCalendarEntryLogHandler.class);
    public static final String VIEW_ENTRY_LOGS = "view_immotool_calendar_entries_logs";
    public static final String PROC_SAVE_ENTRY_LOGS = "save_immotool_calendar_entries_logs";
    public static final String FIELD_ENTRY_ID = "entry_id";

    protected DbLog buildLog(ResultSet resultSet) throws SQLException {
        DbCalendarEntryLog dbCalendarEntryLog = (DbCalendarEntryLog)super.buildLog(resultSet);
        if (dbCalendarEntryLog != null) {
            dbCalendarEntryLog.entryId = resultSet.getLong(FIELD_ENTRY_ID);
        }
        return dbCalendarEntryLog;
    }

    protected DbLog createLog() {
        return new DbCalendarEntryLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbLog[] getLogs(Connection connection, long[] lArray) throws SQLException {
        DbLog[] dbLogArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbLog[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_calendar_entries_logs WHERE log_entry_type = ? ORDER BY log_id ASC;");
                preparedStatement.setString(1, "Calendar.Entry");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_calendar_entries_logs WHERE log_entry_type = ? AND log_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + "log_id" + " ASC LIMIT " + lArray.length + ";");
                preparedStatement.setString(1, "Calendar.Entry");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 2, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbLog> arrayList = new ArrayList<DbLog>();
            while (resultSet.next()) {
                arrayList.add(this.buildLog(resultSet));
            }
            dbLogArray = arrayList.toArray(new DbLog[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbLogArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbLog[] getLogs(Connection connection, long[] lArray, String string) throws SQLException {
        DbLog[] dbLogArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbLog[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("log_entry_type =  ?");
            if (string != null) {
                arrayList.add("log_entry_action = ?");
            }
            if (lArray != null) {
                arrayList.add("entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ")");
            }
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_calendar_entries_logs WHERE " + StringUtils.join(arrayList, (String)" AND ") + " ORDER BY " + "log_id" + " ASC;");
            int n = 0;
            preparedStatement.setString(++n, "Calendar.Entry");
            if (string != null) {
                preparedStatement.setString(++n, string);
            }
            if (lArray != null) {
                for (long l : lArray) {
                    preparedStatement.setLong(++n, l);
                }
            }
            resultSet = preparedStatement.executeQuery();
            Object object = new ArrayList();
            while (resultSet.next()) {
                object.add(this.buildLog(resultSet));
            }
            dbLogArray = object.toArray(new DbLog[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbLogArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getLogIds(Connection connection, long[] lArray, String string) throws SQLException {
        long[] lArray2;
        if (lArray != null && lArray.length <= 0) {
            return new long[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("log_entry_type =  ?");
            if (string != null) {
                arrayList.add("log_entry_action = ?");
            }
            if (lArray != null) {
                arrayList.add("entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ")");
            }
            preparedStatement = connection.prepareStatement("SELECT log_id FROM view_immotool_calendar_entries_logs WHERE " + StringUtils.join(arrayList, (String)" AND ") + " ORDER BY " + "log_id" + " ASC;");
            int n = 0;
            preparedStatement.setString(++n, "Calendar.Entry");
            if (string != null) {
                preparedStatement.setString(++n, string);
            }
            if (lArray != null) {
                for (long l : lArray) {
                    preparedStatement.setLong(++n, l);
                }
            }
            resultSet = preparedStatement.executeQuery();
            Object object = new ArrayList();
            while (resultSet.next()) {
                object.add(resultSet.getLong("log_id"));
            }
            lArray2 = ArrayUtils.toPrimitive((Long[])object.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray2;
    }

    protected void saveLogAdditionally(Connection connection, DbLog dbLog, long l, List<Statement> list) throws SQLException {
        if (!(dbLog instanceof DbCalendarEntryLog)) {
            LOGGER.warn("The log is not an instance of DbCalendarEntryLog!");
            LOGGER.warn("> " + dbLog.getClass().getName());
            return;
        }
        DbCalendarEntryLog dbCalendarEntryLog = (DbCalendarEntryLog)dbLog;
        NamedCallableStatement namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_calendar_entries_logs(:log_id, :entry_id);");
        namedCallableStatement.setLong("log_id", l);
        namedCallableStatement.setLong(FIELD_ENTRY_ID, dbCalendarEntryLog.entryId);
        namedCallableStatement.execute();
        list.add(namedCallableStatement.getStatement());
    }
}

