/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarEventEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarGroup;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandlerImpl;
import com.openindex.openestate.tool.calendar.db.DbCalendarTodoEntry;
import com.openindex.openestate.tool.utils.Permission;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import net.fortuna.ical4j.model.property.Status;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbCalendarHandler
extends DbCalendarHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbCalendarHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbCalendarHandler.class);
    public static final String PROC_REMOVE_GROUPS = "remove_immotool_calendar_groups";
    public static final String PROC_REMOVE_ENTRIES = "remove_immotool_calendar_entries";
    public static final String PROC_SAVE_GROUPS = "save_immotool_calendar_groups";
    public static final String PROC_SAVE_ENTRIES = "save_immotool_calendar_entries";
    public static final String VIEW_GROUPS = "view_immotool_calendar_groups";
    public static final String VIEW_ENTRIES = "view_immotool_calendar_entries";
    public static final String TABLE_GROUPS = "immotool_calendar_groups";
    public static final String FIELD_GROUP_ID = "group_id";
    public static final String FIELD_GROUP_NAME = "group_name";
    public static final String FIELD_GROUP_NOTES = "group_notes";
    public static final String FIELD_GROUP_URL = "group_url";
    public static final String FIELD_GROUP_TYPE = "group_type";
    public static final String FIELD_GROUP_AUTH_METHOD = "group_auth_method";
    public static final String FIELD_GROUP_AUTH_USER = "group_auth_user";
    public static final String FIELD_GROUP_AUTH_PASS = "group_auth_pass";
    public static final String TABLE_ENTRIES = "immotool_calendar_entries";
    public static final String FIELD_ENTRY_ID = "entry_id";
    public static final String FIELD_ENTRY_UID = "entry_uid";
    public static final String FIELD_ENTRY_TITLE = "entry_title";
    public static final String FIELD_ENTRY_TYPE = "entry_type";
    public static final String FIELD_ENTRY_STATUS = "entry_status";
    public static final String FIELD_ENTRY_BEGIN = "entry_begin";
    public static final String FIELD_ENTRY_END = "entry_end";
    public static final String FIELD_ENTRY_NOTES = "entry_notes";
    public static final String FIELD_ENTRY_ICAL = "entry_ical";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";
    private static final String FIELD_ACCESS_OWNER_ID = "access_owner_id";
    private static final String FIELD_ACCESS_GROUP_ID = "access_group_id";
    private static final String FIELD_ACCESS_PERMISSIONS = "access_permissions";

    private static DbCalendarEntry createEntry(ResultSet resultSet) throws SQLException {
        DbCalendarEntry dbCalendarEntry;
        DbCalendarEntry dbCalendarEntry2;
        String string = resultSet.getString(FIELD_ENTRY_TYPE);
        if (DbCalendarEntry.Type.VEVENT.toString().equalsIgnoreCase(string)) {
            dbCalendarEntry2 = new DbCalendarEventEntry();
            ((DbCalendarEventEntry)dbCalendarEntry2).event = null;
            String string2 = resultSet.getString(FIELD_ENTRY_STATUS);
            if (Status.VEVENT_CANCELLED.getValue().equalsIgnoreCase(string2)) {
                ((DbCalendarEventEntry)dbCalendarEntry2).status = Status.VEVENT_CANCELLED;
            } else if (Status.VEVENT_CONFIRMED.getValue().equalsIgnoreCase(string2)) {
                ((DbCalendarEventEntry)dbCalendarEntry2).status = Status.VEVENT_CONFIRMED;
            } else if (Status.VEVENT_TENTATIVE.getValue().equalsIgnoreCase(string2)) {
                ((DbCalendarEventEntry)dbCalendarEntry2).status = Status.VEVENT_TENTATIVE;
            }
            dbCalendarEntry = dbCalendarEntry2;
        } else if (DbCalendarEntry.Type.VTODO.toString().equalsIgnoreCase(string)) {
            dbCalendarEntry2 = new DbCalendarTodoEntry();
            ((DbCalendarTodoEntry)dbCalendarEntry2).todo = null;
            String string3 = resultSet.getString(FIELD_ENTRY_STATUS);
            if (Status.VTODO_CANCELLED.getValue().equalsIgnoreCase(string3)) {
                ((DbCalendarTodoEntry)dbCalendarEntry2).status = Status.VTODO_CANCELLED;
            } else if (Status.VTODO_COMPLETED.getValue().equalsIgnoreCase(string3)) {
                ((DbCalendarTodoEntry)dbCalendarEntry2).status = Status.VTODO_COMPLETED;
            } else if (Status.VTODO_IN_PROCESS.getValue().equalsIgnoreCase(string3)) {
                ((DbCalendarTodoEntry)dbCalendarEntry2).status = Status.VTODO_IN_PROCESS;
            } else if (Status.VTODO_NEEDS_ACTION.getValue().equalsIgnoreCase(string3)) {
                ((DbCalendarTodoEntry)dbCalendarEntry2).status = Status.VTODO_NEEDS_ACTION;
            }
            dbCalendarEntry = dbCalendarEntry2;
        } else {
            throw new SQLException("Unsupported calendar-entry: " + string);
        }
        dbCalendarEntry.id = resultSet.getLong(FIELD_ENTRY_ID);
        dbCalendarEntry.groupId = resultSet.getLong(FIELD_GROUP_ID);
        dbCalendarEntry.uid = resultSet.getString(FIELD_ENTRY_UID);
        dbCalendarEntry.title = resultSet.getString(FIELD_ENTRY_TITLE);
        dbCalendarEntry.notes = resultSet.getString(FIELD_ENTRY_NOTES);
        dbCalendarEntry.ical = resultSet.getString(FIELD_ENTRY_ICAL);
        dbCalendarEntry.begin = resultSet.getTimestamp(FIELD_ENTRY_BEGIN);
        dbCalendarEntry.end = resultSet.getTimestamp(FIELD_ENTRY_END);
        dbCalendarEntry.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbCalendarEntry.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        try {
            dbCalendarEntry.updateComponentFromIcal();
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read ical data from calendar entry #" + dbCalendarEntry.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return dbCalendarEntry;
    }

    private static DbCalendarGroup createGroup(ResultSet resultSet) throws SQLException {
        DbCalendarGroup dbCalendarGroup = new DbCalendarGroup();
        dbCalendarGroup.id = resultSet.getLong(FIELD_GROUP_ID);
        dbCalendarGroup.name = resultSet.getString(FIELD_GROUP_NAME);
        dbCalendarGroup.notes = resultSet.getString(FIELD_GROUP_NOTES);
        dbCalendarGroup.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbCalendarGroup.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        dbCalendarGroup.ownerUserId = resultSet.getLong(FIELD_ACCESS_OWNER_ID);
        dbCalendarGroup.ownerGroupId = resultSet.getLong(FIELD_ACCESS_GROUP_ID);
        dbCalendarGroup.permission = new Permission(resultSet.getInt(FIELD_ACCESS_PERMISSIONS));
        try {
            dbCalendarGroup.type = DbCalendarGroup.Type.valueOf(resultSet.getString(FIELD_GROUP_TYPE));
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load calendar-type!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            dbCalendarGroup.type = DbCalendarGroup.Type.LOCAL;
        }
        String string = resultSet.getString(FIELD_GROUP_URL);
        if (string != null && string.trim().length() > 0) {
            try {
                dbCalendarGroup.url = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Can't load calendar URL!");
                LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
            }
        }
        try {
            dbCalendarGroup.authMethod = DbCalendarGroup.AuthMethod.valueOf(resultSet.getString(FIELD_GROUP_AUTH_METHOD));
            dbCalendarGroup.authUser = resultSet.getString(FIELD_GROUP_AUTH_USER);
            String string2 = resultSet.getString(FIELD_GROUP_AUTH_PASS);
            if (string2 != null && string2.trim().length() > 0) {
                dbCalendarGroup.authPass = string2.toCharArray();
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load calendar authorization!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            dbCalendarGroup.authMethod = DbCalendarGroup.AuthMethod.ANONYMOUS;
            dbCalendarGroup.authUser = null;
            dbCalendarGroup.authPass = null;
        }
        return dbCalendarGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbCalendarEntry[] getEntries(Connection connection, long[] lArray) throws SQLException {
        DbCalendarEntry[] dbCalendarEntryArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbCalendarEntry[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_calendar_entries ORDER BY entry_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_calendar_entries WHERE entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_ENTRY_ID + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbCalendarEntry> arrayList = new ArrayList<DbCalendarEntry>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbCalendarHandler.createEntry(resultSet));
            }
            dbCalendarEntryArray = arrayList.toArray(new DbCalendarEntry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCalendarEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbCalendarEntry[] getEntries(Connection connection, long l, String[] stringArray) throws SQLException {
        DbCalendarEntry[] dbCalendarEntryArray;
        if (l < 1L) {
            return new DbCalendarEntry[0];
        }
        if (stringArray != null && stringArray.length <= 0) {
            return new DbCalendarEntry[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (stringArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_calendar_entries WHERE group_id = ? ORDER BY entry_id ASC;");
                preparedStatement.setLong(1, l);
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_calendar_entries WHERE group_id = ? AND entry_uid IN (" + JdbcUtils.writeQuestionMarkList((int)stringArray.length) + ") ORDER BY " + FIELD_ENTRY_ID + " ASC LIMIT " + stringArray.length + ";");
                preparedStatement.setLong(1, l);
                for (int i = 0; i < stringArray.length; ++i) {
                    preparedStatement.setString(i + 2, stringArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbCalendarEntry> arrayList = new ArrayList<DbCalendarEntry>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbCalendarHandler.createEntry(resultSet));
            }
            dbCalendarEntryArray = arrayList.toArray(new DbCalendarEntry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCalendarEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbCalendarEntry[] getEntries(Connection connection, Status[] statusArray, DbCalendarEntry.Type[] typeArray, long[] lArray, Date date, Date date2) throws SQLException {
        DbCalendarEntry[] dbCalendarEntryArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (statusArray != null) {
            arrayList.add("entry_status IN (" + JdbcUtils.writeQuestionMarkList((int)statusArray.length) + ")");
        }
        if (typeArray != null) {
            arrayList.add("entry_type IN (" + JdbcUtils.writeQuestionMarkList((int)typeArray.length) + ")");
        }
        if (lArray != null) {
            arrayList.add("group_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ")");
        }
        if (date != null && date2 != null) {
            arrayList.add("((entry_begin >= ? AND entry_begin <= ?) OR (entry_end >= ? AND entry_end <= ?))");
        } else if (date != null) {
            arrayList.add("entry_begin >= ? AND entry_end <= ?");
        } else if (date2 != null) {
            arrayList.add("entry_begin >= ? AND entry_end <= ?");
        }
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            String string = "SELECT * FROM view_immotool_calendar_entries";
            if (!arrayList.isEmpty()) {
                string = string + " WHERE " + StringUtils.join((Object[])arrayList.toArray(new String[0]), (String)" AND ");
            }
            string = string + " ORDER BY entry_id";
            preparedStatement = connection.prepareStatement(string);
            int n = 0;
            if (statusArray != null) {
                for (Status status : statusArray) {
                    preparedStatement.setString(++n, status.toString());
                }
            }
            if (typeArray != null) {
                for (Status status : typeArray) {
                    preparedStatement.setString(++n, status.toString());
                }
            }
            if (lArray != null) {
                for (Status status : (ArrayList)lArray) {
                    preparedStatement.setLong(++n, (long)status);
                }
            }
            if (date != null && date2 != null) {
                preparedStatement.setTimestamp(++n, new Timestamp(date.getTime()));
                preparedStatement.setTimestamp(++n, new Timestamp(date2.getTime()));
                preparedStatement.setTimestamp(++n, new Timestamp(date.getTime()));
                preparedStatement.setTimestamp(++n, new Timestamp(date2.getTime()));
            } else if (date != null) {
                preparedStatement.setTimestamp(++n, new Timestamp(date.getTime()));
                preparedStatement.setTimestamp(++n, new Timestamp(date.getTime()));
            } else if (date2 != null) {
                preparedStatement.setTimestamp(++n, new Timestamp(date2.getTime()));
                preparedStatement.setTimestamp(++n, new Timestamp(date2.getTime()));
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList arrayList2 = new ArrayList();
            while (resultSet.next()) {
                arrayList2.add(HSqlDbCalendarHandler.createEntry(resultSet));
            }
            dbCalendarEntryArray = arrayList2.toArray(new DbCalendarEntry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCalendarEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbCalendarEntry[] getEntries(Connection connection, String string, long[] lArray, int n) throws SQLException {
        DbCalendarEntry[] dbCalendarEntryArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((string = StringUtils.trimToNull((String)StringUtils.lowerCase((String)string))) != null) {
            arrayList.add("LOWER(entry_title) LIKE ?");
        }
        if (lArray != null) {
            arrayList.add("group_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ")");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = "SELECT * FROM view_immotool_calendar_entries";
            if (!arrayList.isEmpty()) {
                string2 = string2 + " WHERE " + StringUtils.join((Object[])arrayList.toArray(new String[0]), (String)" AND ");
            }
            string2 = string2 + " ORDER BY entry_begin DESC, entry_title ASC";
            string2 = string2 + (n > 0 ? " LIMIT " + n : "");
            preparedStatement = connection.prepareStatement(string2);
            int n2 = 0;
            if (string != null) {
                preparedStatement.setString(++n2, "%" + string + "%");
            }
            if (lArray != null) {
                for (long l : lArray) {
                    preparedStatement.setLong(++n2, l);
                }
            }
            resultSet = preparedStatement.executeQuery();
            Object object = new ArrayList();
            while (resultSet.next()) {
                object.add(HSqlDbCalendarHandler.createEntry(resultSet));
            }
            dbCalendarEntryArray = object.toArray(new DbCalendarEntry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCalendarEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getEntryIds(Connection connection, long[] lArray) throws SQLException {
        long[] lArray2;
        if (lArray != null && lArray.length <= 0) {
            return new long[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT entry_id FROM view_immotool_calendar_entries ORDER BY entry_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT entry_id FROM view_immotool_calendar_entries WHERE group_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_ENTRY_ID + " ASC;");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_ENTRY_ID));
            }
            lArray2 = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbCalendarGroup[] getGroups(Connection connection, long[] lArray) throws SQLException {
        DbCalendarGroup[] dbCalendarGroupArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbCalendarGroup[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_calendar_groups ORDER BY group_name ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_calendar_groups WHERE group_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_GROUP_NAME + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbCalendarGroup> arrayList = new ArrayList<DbCalendarGroup>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbCalendarHandler.createGroup(resultSet));
            }
            dbCalendarGroupArray = arrayList.toArray(new DbCalendarGroup[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCalendarGroupArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getGroupIds(Connection connection) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT group_id FROM view_immotool_calendar_groups ORDER BY group_id ASC;");
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_GROUP_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    @Override
    public void removeEntries(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_calendar_entries(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void removeGroups(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_calendar_groups(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveEntry(Connection connection, DbCalendarEntry dbCalendarEntry) throws SQLException {
        if (dbCalendarEntry.begin == null) {
            throw new SQLException("The calender entry does not contain a begin time!");
        }
        if (dbCalendarEntry.end == null) {
            LOGGER.warn("The calendar entry does not contain an end time! Using a default value, that depends on the begin time.");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dbCalendarEntry.begin);
            calendar.add(10, 1);
            dbCalendarEntry.end = calendar.getTime();
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            long l;
            dbCalendarEntry.prepareBeforeSave();
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_calendar_entries(:entry_id, :group_id, :entry_uid, :entry_type, :entry_status, :entry_title, :entry_begin, :entry_end, :entry_notes, :entry_ical);");
            namedCallableStatement.setLong(FIELD_ENTRY_ID, dbCalendarEntry.id);
            namedCallableStatement.setLong(FIELD_GROUP_ID, dbCalendarEntry.groupId);
            namedCallableStatement.setString(FIELD_ENTRY_ICAL, dbCalendarEntry.ical);
            namedCallableStatement.setString(FIELD_ENTRY_NOTES, dbCalendarEntry.notes);
            namedCallableStatement.setString(FIELD_ENTRY_UID, StringUtils.abbreviate((String)dbCalendarEntry.uid, (int)255));
            namedCallableStatement.setString(FIELD_ENTRY_TYPE, dbCalendarEntry.getType() != null ? StringUtils.abbreviate((String)dbCalendarEntry.getType().toString(), (int)45) : null);
            namedCallableStatement.setString(FIELD_ENTRY_STATUS, dbCalendarEntry.status != null ? StringUtils.abbreviate((String)dbCalendarEntry.status.getValue(), (int)45) : null);
            namedCallableStatement.setString(FIELD_ENTRY_TITLE, StringUtils.abbreviate((String)dbCalendarEntry.title, (int)255));
            namedCallableStatement.setTimestamp(FIELD_ENTRY_BEGIN, dbCalendarEntry.begin != null ? new Timestamp(dbCalendarEntry.begin.getTime()) : null);
            namedCallableStatement.setTimestamp(FIELD_ENTRY_END, dbCalendarEntry.end != null ? new Timestamp(dbCalendarEntry.end.getTime()) : null);
            namedCallableStatement.execute();
            long l2 = l = dbCalendarEntry.id < 1L ? namedCallableStatement.getLong(FIELD_ENTRY_ID) : dbCalendarEntry.id;
            if (l < 1L) {
                throw new SQLException("Can't determine ID of the saved object!");
            }
            connection.commit();
            if (dbCalendarEntry.id <= 0L) {
                dbCalendarEntry.id = l;
            }
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveGroup(Connection connection, DbCalendarGroup dbCalendarGroup) throws SQLException {
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            long l;
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_calendar_groups(:group_id, :group_name, :group_notes, :group_url, :group_type, :group_auth_method, :group_auth_user, :group_auth_pass, :access_owner_id, :access_group_id, :access_permissions);");
            namedCallableStatement.setLong(FIELD_GROUP_ID, dbCalendarGroup.id);
            namedCallableStatement.setString(FIELD_GROUP_NOTES, dbCalendarGroup.notes);
            namedCallableStatement.setString(FIELD_GROUP_NAME, StringUtils.abbreviate((String)dbCalendarGroup.name, (int)100));
            namedCallableStatement.setString(FIELD_GROUP_URL, dbCalendarGroup.url != null ? StringUtils.abbreviate((String)dbCalendarGroup.url.toString(), (int)255) : null);
            namedCallableStatement.setString(FIELD_GROUP_TYPE, dbCalendarGroup.type != null ? StringUtils.abbreviate((String)dbCalendarGroup.type.name(), (int)45) : DbCalendarGroup.Type.LOCAL.name());
            namedCallableStatement.setString(FIELD_GROUP_AUTH_METHOD, dbCalendarGroup.authMethod != null ? StringUtils.abbreviate((String)dbCalendarGroup.authMethod.name(), (int)45) : DbCalendarGroup.AuthMethod.ANONYMOUS.name());
            namedCallableStatement.setString(FIELD_GROUP_AUTH_USER, StringUtils.abbreviate((String)dbCalendarGroup.authUser, (int)100));
            namedCallableStatement.setString(FIELD_GROUP_AUTH_PASS, dbCalendarGroup.authPass != null ? StringUtils.abbreviate((String)String.valueOf(dbCalendarGroup.authPass), (int)255) : null);
            namedCallableStatement.setLong(FIELD_ACCESS_OWNER_ID, dbCalendarGroup.ownerUserId);
            namedCallableStatement.setLong(FIELD_ACCESS_GROUP_ID, dbCalendarGroup.ownerGroupId);
            namedCallableStatement.setInt(FIELD_ACCESS_PERMISSIONS, dbCalendarGroup.permission != null ? dbCalendarGroup.permission.getValue() : -1);
            namedCallableStatement.execute();
            long l2 = l = dbCalendarGroup.id < 1L ? namedCallableStatement.getLong(FIELD_GROUP_ID) : dbCalendarGroup.id;
            if (l < 1L) {
                throw new SQLException("Can't determine ID of the saved object!");
            }
            connection.commit();
            if (dbCalendarGroup.id <= 0L) {
                dbCalendarGroup.id = l;
            }
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

